//#define SQUARE_ONLY
//#define CLASSICAL_TESTING
#define FURTHER_APPROXIMATE_GINVERSE_DERIVATIVE
#define REMOVE_SELF_FORCE 1
//#define SHRINK_PERTURB_XK0 

#define DETAIL 1

#define DIFFSTEP 1.0E-06

#define WALK_FARTHER 4
#define WALK_FINER 64

#define SMALLNUMBER 1.0E-05
#define SMALLDIFFERENCE 1.0E-10

#define STRINGBUFFERSIZE 256
#define NAMELENGTH 8

#define MAXIMUM_NUMBER_ATOMS 100
#define MAXIMUM_NUMBER_INTERNAL_COORDINATE 600
// #define MAXIMUM_NUMBER_COORDINATES 3*MAXIMUM_NUMBER_ATOMS
// #define MAXIMUM_NUMBER_TRIANGULAR MAXIMUM_NUMBER_COORDINATES*(MAXIMUM_NUMBER_COORDINATES+1)/2
#define BASIS_LINES 5

// matrix storage = row-major = continuous row = column vector
// this program uses fortran convention (column vector) Aij=A(i,j)=A[j][i]
// upper triangular : a[t] = a[i,j] ; t=(j*(j+1)/2)+i ;  i<=j ; i=row, j=column
// rectangular      : a[r] = a[i,j] ; r=j*n+i ;         (m*n) ; i=row, j=column

//#define index(j,k)          ((j)*((j)+1)/2 + (k))
#define uindex(i,j)         (((j)*((j)+1))/2 + (i))	// j,i	i<=j
#define mindex(i,j)         (((j)*((j)-1))/2 + (i))	// j,i	i<j
#define rindex(i,j,m,n)     ((j)*(m)+(i))		// i,j
#define cindex(i,j,k,l,m,n) ((k)*(l)*(m)+(j)*(l)+(i))		// i,j,k

typedef struct {
	double Tr[3];	// temperature of rotational degrees of freedom
	double *Tv;	// temperature of vibrational degrees of freedom
} THERMAL;

typedef struct {
	char molecule[STRINGBUFFERSIZE];  	// molecule name
	int na;		// number of atoms
	int nc;		// number of cartesian coordinates
	int nv;		// number of vibrational modes
	int nf;		// number of trigonal force constant matrix
	double te;	// total energy
	int *an;	// atomic numbers
	double *m;	// mass vector, M
	double *rm;	// reciprocal square root of mass = M^-0.5
	double *cc;	// cartesian coordinates = Qx
	double *cg;	// cartesian gradients = Gx
	double *cf;	// cartesian force constants (packed storage)
	double *ff;	// cartesian force constants (full storage)
	double *mc;	// mass weighted cartesian coordinate = M^0.5 Qx
	double *mg;	// mass weighted cartesian gradients = rm Gx
	double *mf;	// mass weighted cartesian force constants = rm Gx rm
} CARTESIAN;

typedef struct {
	char name[NAMELENGTH];
	// int number;
	// double mass;
} NUCLEAR;

typedef struct {
	// char name[NAMELENGTH];
	int type;
	int indices;
	int id[4];
	double r;	// in input unit
	double a;	// anharmonicity coefficient in 1/length or 1/radian
	double f;	// unit conversion factor
} ZMT;

typedef struct {
	char molecule[STRINGBUFFERSIZE];
	ZMT *z;
	NUCLEAR *ai;	// atom name 
	int freeze;
	int na;		// number of atoms
	int nc;		// number of cartesian coordinates
	int nr;		// number of redundant coordinates
	int nf;
	int nz;		// number of zero frequency
	int nv;		// number of vibrational degrees of freedom
	int *an;
	double *cc;	// cartesian coordinate
	double *m;	// 3N vector of mass in amu
	double *mm;	// trigonal matrix of mass
	double *mi;	// trigonal inverse matrix of mass
	double *mibt;	// mibt = M^-1 B^T	(nc X nr)
	double *b;	// B = dr/dx, (nr X nc), ds = B dx, DGEMV(N,nr,nc,B,nr,dx,ds)  linear transformation between cartesian and redundant coordinates
	double *bt;	// transpose of B = B^T	(nc X nr) (row X column)
	double *bi;	// inverse of B = B^-1 = M^-1 B^T (B M^-1 B^T)^-1 = M^-1 B^T G^-1 = mibt G^-1
	double *bit;	// transpose of inverse of B = (B^-1)^T
	double *bi2;	// not correct assignment needs revision! --> dB^-1/dx [nc X nr X nc]	# differentiated row #
	double *c;	// C = dB/dx = d^2s/dx^2	(nr X nc X nc)
	double *ct;	// ct = C^T	(nc X nc X nr)	# differentiated row #
	double *lc;	// lc = f''/f'^2	linear correction term
//	double *nl;	// nl = f''		linear correction term
	double *g;	// G = B M^-1 B^T = B mibt	
	double *gs;	// sqrt(G) = L V^0.5 L^-1 after diagonalization
	double *gq;	// 1/sqrt(G) = L V^-0.5 L^-1 after diagonalization
	// double *gt;	// triangular store of G
	double *gi;	// inverse of G (= the kinetic energy matrix in internal coordinate basis)
	double *gi2;	// dGI/dr	(nr X nr X nr)	# differentiated row #
	double *r;	// value of internal coordinate in programming length and radian
	double *gr;	// (redundant) internal gradient, Gr = (B^-1)^T Gx
	double *fr;	// (redundant) internal hessian, Hr = (B^-1)^T Hx B^-1 - (B^-1)^T C Gr B^-1
	double *fi;	// inverse of internal hessian
	double *mr;	// mass-weighted internal coordinate
	double *mg;	// mass-weighted internal gradient
	double *mf;	// mass-weighted internal hessian
	double *uf;	// mass-weighted internal hessian
	double *ev;	// eigen value stored in ascending order
	double *vq;	// eigen vector in mass-weighted internal coordinate
	double *vr;	// eigen vector in internal coordinate;
	double *vx;	// eigen vector in cartesian coordinate;
	int curvature;
	int dginverse;
	double *fvt;
	double *frt;
} INTERNAL;

#define CURVATURE_DBTDX 1
#define CURVATURE_DBIDR 2
#define CURVATURE_DGIDR 3
#define CURVATURE_DGIDR_LINEAR 4

#define DGIDR_EXACT  0
#define DGIDR_LINEAR 1
#define DGIDR_SINGLE 2
#define DGIDR_DOUBLE 3

