#include <stdio.h>
#include <stdlib.h>
#include <string.h>
// #include <math.h>
// #include <clapack.h>

#include "constantunits.h"
#include "programming.h"

#include "errors.h"
#include "readfchk.h"

int checkfchk(FILE *fp)
{
	int na=0;
	char buffer[STRINGBUFFERSIZE];

	while(1)
	{
		if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
		if(!strncmp(buffer,"Number of atoms",15))
		{
			sscanf(buffer+44,"%d",&na);
			if(na>MAXIMUM_NUMBER_ATOMS) 
				ued3error("too many nuclei");
			else
				break;
		}
	}
	rewind(fp);
	return(na);
}

int readfchk(FILE *fp,CARTESIAN *f,int na)
{
	int i,j;
	char buffer[STRINGBUFFERSIZE];

	if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) return(0);
	sscanf(buffer,"%s",f->molecule);
	while(1)
	{
		if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
		if(!strncmp(buffer,"Number of atoms",15))
			sscanf(buffer+44,"%d",&(f->na));
		if(f->na>na) ued3error("too many nuclei");
		f->nc=3*f->na;
		if(!strncmp(buffer,"Total Energy",12))
			sscanf(buffer+44,"%lf",&(f->te));
		if(!strncmp(buffer,"Atomic numbers",14))
			for(i=0;i<f->na;i++)
				fscanf(fp,"%d",f->an+i);
		if(!strncmp(buffer,"Current cartesian coordinates",29))
			for(i=0;i<f->nc;i++)
				fscanf(fp,"%lf",f->cc+i);
		if(!strncmp(buffer,"Cartesian Gradient",18))
			for(i=0;i<f->nc;i++)
				fscanf(fp,"%lf",f->cg+i);
		if(!strncmp(buffer,"Cartesian Force Constants",25))
			for(j=0;j<f->nc;j++)
				for(i=0;i<=j;i++)
					fscanf(fp,"%lf",&(f->cf[uindex(i,j)]));
	}
	f->te*=DataUnitEnergy;
	for(i=0;i<f->nc;i++)
		f->cc[i]*=DataUnitLength;
	for(i=0;i<f->nc;i++)
		f->cg[i]*=DataUnitGradient;
	for(j=0;j<f->nc;j++)
		for(i=0;i<=j;i++)
		{
			f->cf[uindex(i,j)]*=DataUnitHessian;
			f->ff[rindex(i,j,f->nc,f->nc)]=f->cf[uindex(i,j)];
			f->ff[rindex(j,i,f->nc,f->nc)]=f->cf[uindex(i,j)];
		}
	return(f->na);
}

int writefchk(FILE* fp,CARTESIAN *f)
{
	int i,j,detail=1;

	if(f->na)
	{
		fprintf(fp,"molecule= %s\n",f->molecule);
		fprintf(fp,"number_of_atoms= %d\n",f->na);
		fprintf(fp,"total_energy= %16.8lf\n",f->te);
		fprintf(fp,"atomic_numbers[]:\n");
		for(i=0;i<f->na;i++)
			fprintf(fp," %4d",f->an[i]);
		fprintf(fp,"\n");
		fprintf(fp,"cartesian_coordinates[]:\n");
		for(i=0;i<f->na;i++)
		{
			for(j=0;j<3;j++)
				fprintf(fp,"%16.8lf",f->cc[i*3+j]);
			fprintf(fp,"\n");
		}
		fprintf(fp,"\n");
		fprintf(fp,"cartesian_gradients[]:\n");
		for(i=0;i<f->na;i++)
		{
			for(j=0;j<3;j++)
				fprintf(fp,"%16.8lf",f->cg[i*3+j]);
			fprintf(fp,"\n");
		}
		fprintf(fp,"\n");
		fprintf(fp,"cartesian_force_constant_matirx[][]:\n");
		for(j=0;j<f->nc;j++)
		{
			for(i=0;i<=j;i++)
				fprintf(fp,"%8.4lf",f->cf[uindex(i,j)]);
			fprintf(fp,"\n");
		}
		if(detail) 
		{
			fprintf(stderr,"cartesian coordinates in angstrom:\n");
			for(i=0;i<f->na;i++)
			{
				for(j=0;j<3;j++)
					fprintf(stderr,"%16.8lf",f->cc[i*3+j]/Angstrom);
				fprintf(stderr,"\n");
			}
			fprintf(stderr,"\n");
		}
	}
	return(f->na);
}

int checkfinp(FILE *fp)
{
	return(checkfchk(fp));
}

int readfinp(FILE *fp,CARTESIAN *f,int na)
{
	return(readfchk(fp,f,na));
}

int writefinp(FILE* fp,CARTESIAN *f)
{
	return(writefchk(fp,f));
}
