#include <stdio.h>
#include <stdlib.h>
#include <string.h>
// #include <math.h>
// #include <clapack.h>

#include "constantunits.h"
#include "programming.h"

#include "errors.h"
#include "readgdat.h"


// The following function checks the gamess output *.dat file and returns the number of atoms in the molecule

int checkgdat(FILE *fp)
{
	int j,iDATA=1,ns,na=0;
	char buffer[STRINGBUFFERSIZE];
	char nucleus[STRINGBUFFERSIZE];
	double charge,x,y,z;

	while(iDATA)
	{
		if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
		if(!strncmp(buffer," $DATA",6))
		{
			iDATA=0;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			// sscanf(buffer,"%s",f->molecule);
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			// sscanf(buffer,"%s",f->symmetry);
			for(j=0;j<BASIS_LINES*MAXIMUM_NUMBER_ATOMS;j++)
			{
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
				if(!strncmp(buffer," $END",5)) break;
				ns=sscanf(buffer,"%s%lf%lf%lf%lf",nucleus,&charge,&x,&y,&z);
				if(ns==5) na++;
			}
		}
	}
	if(na>MAXIMUM_NUMBER_ATOMS) 
		ued3error("too many nuclei");
	rewind(fp);
	return(na);
}


// The following function reads the gamess output *.dat file and assigns values of the 
// coordinates, gradient and hessian to the structure CARTESIAN defined in programming.h

int readgdat(FILE *fp,CARTESIAN *f,int na)
{
	int i,j,k,l,m,n,ns;
	char buffer[STRINGBUFFERSIZE];
	char nucleus[STRINGBUFFERSIZE];
	double charge,q[5];

	while(1)
	{
		if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
		if(!strncmp(buffer," $DATA",6))
		{
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			sscanf(buffer,"%s",f->molecule);
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			// sscanf(buffer,"%s",f->symmetry);
			f->na=0;
			for(j=0;j<BASIS_LINES*na;j++)
			{
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
				if(!strncmp(buffer," $END",5)) break;
				ns=sscanf(buffer,"%s%lf%lf%lf%lf",nucleus,&charge,q,q+1,q+2);
				if(ns==5) 
				{
					for(i=0;i<3;i++)
						f->cc[f->na*3+i]=q[i]/Bohr_Angstrom;		// convert from Angstroms to atomic units (Bohr)
					f->an[f->na++]=(int)(charge);
				}
			}
			f->nc=3*f->na;
		}
		// if(!strncmp(buffer," $ZMAT",6)) { }
		if(!strncmp(buffer," $GRAD",6))
		{
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			for(i=0;i<f->na;i++)
			{
				j=i*3;
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
				sscanf(buffer,"%s%lf%lf%lf%lf",nucleus,&charge,f->cg+j,f->cg+j+1,f->cg+j+2);
			}
		}
		if(!strncmp(buffer," $HESS",6))
		{
			n=(f->nc+4)/5;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			for(i=0;i<f->nc;i++)
			{
				for(j=0;j<n;j++)
				{
					if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
					ns=sscanf(buffer,"%2d%3d%15le%15le%15le%15le%15le"
					,&m,&l,q,q+1,q+2,q+3,q+4);
					k=5*j;
					double *hik=f->ff+rindex(k,i,f->nc,f->nc);	// rindex is defined in programming.h
					for(k=0;k<ns-2;k++)
						hik[k]=q[k];
				}
			}
		}
	}

	f->te=0;
	for(i=0;i<f->nc;i++)
		f->cc[i]*=DataUnitLength;
	for(i=0;i<f->nc;i++)
		f->cg[i]*=DataUnitGradient;
	for(j=0;j<f->nc;j++)
		for(i=0;i<f->nc;i++)
			f->ff[rindex(i,j,f->nc,h->nc)]*=DataUnitHessian;
	for(j=0;j<f->nc;j++)
		for(i=0;i<=j;i++)
			f->cf[uindex(i,j)]=0.5*(f->ff[rindex(i,j,f->nc,f->nc)]+f->ff[rindex(j,i,f->nc,f->nc)]);
	return(f->na);
}


// The follwing function prints the coordinates, gradient,and the Hessian to the fp

int writegdat(FILE* fp,CARTESIAN *f)
{
	int i,j,detail=1;

	if(f->na)
	{
		fprintf(fp,"molecule= %s\n",f->molecule);
		fprintf(fp,"number_of_atoms= %d\n",f->na);
		fprintf(fp,"total_energy= %16.8lf\n",f->te);
		fprintf(fp,"atomic_numbers[]:\n");
		for(i=0;i<f->na;i++)
			fprintf(fp," %4d",f->an[i]);
		fprintf(fp,"\n");
		fprintf(fp,"cartesian_coordinates[]:\n");
		for(i=0;i<f->na;i++)
		{
			for(j=0;j<3;j++)
				fprintf(fp,"%16.8lf",f->cc[i*3+j]);
			fprintf(fp,"\n");
		}
		fprintf(fp,"\n");
		fprintf(fp,"cartesian_gradients[]:\n");
		for(i=0;i<f->na;i++)
		{
			for(j=0;j<3;j++)
				fprintf(fp,"%16.8lf",f->cg[i*3+j]);
			fprintf(fp,"\n");
		}
		fprintf(fp,"\n");
		fprintf(fp,"cartesian_force_constant_matirx[][]:\n");
		for(j=0;j<f->nc;j++)
		{
			for(i=0;i<=j;i++)
				fprintf(fp,"%8.4lf",f->cf[uindex(i,j)]);
			fprintf(fp,"\n");
		}
		if(detail) 
		{
			fprintf(stderr,"cartesian coordinates in angstrom:\n");
			for(i=0;i<f->na;i++)
			{
				for(j=0;j<3;j++)
					fprintf(stderr,"%16.8lf",f->cc[i*3+j]/Angstrom);
				fprintf(stderr,"\n");
			}
			fprintf(stderr,"\n");
		}
	}
	return(f->na);
}


