#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
// #include <clapack.h>

#include "constantunits.h"
#include "programming.h"

#include "errors.h"
#include "readgdat.h"


// The following function checks the generic output *.out file and returns the number of atoms in the molecule
// the file formatting must be checked before running this module and the source code might have to be changed accordingly.

int checkgeneric(FILE *fp)
{
	int j,iDATA=1,ns,na=0;
	char buffer[STRINGBUFFERSIZE];
	char nucleus[STRINGBUFFERSIZE];
	double number,charge,mass,x,y,z;

	while(iDATA)
	{
		if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
		if(!strncmp(buffer," Molecule",9))
		{
			iDATA=0;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;

			for(j=0;j<BASIS_LINES*MAXIMUM_NUMBER_ATOMS;j++)
			{
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
		//		if(!strncmp(buffer," $END",5)) break;
				ns=sscanf(buffer,"%lf%s%lf%lf%lf%lf%lf",&number,nucleus,&charge,&mass,&x,&y,&z);
				if(ns==7) na++;
				else break;
			}
		}
	}
	if(na>MAXIMUM_NUMBER_ATOMS) 
		ued3error("too many nuclei");
	rewind(fp);
	return(na);
}


// The following function reads the generic output *.out file and assigns values of the 
// coordinates, (gradient) and hessian to the structure CARTESIAN defined in programming.h

int readgeneric(FILE *fp,CARTESIAN *f,int na)
{
	int i,j,k,l,m,n,ns,i_index[3],columns;
	char buffer[STRINGBUFFERSIZE];
	char nucleus[STRINGBUFFERSIZE];
	double number,charge,mass,q[5];

	while(1)
	{
		if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
		if(!strncmp(buffer," Molecule",9))
		{
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
		//	sscanf(buffer,"%s",f->molecule);
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			// sscanf(buffer,"%s",f->symmetry);
			f->na=0;
			for(j=0;j<BASIS_LINES*na;j++)
			{
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
		//		if(!strncmp(buffer," $END",5)) break;
				ns=sscanf(buffer,"%lf%s%lf%lf%lf%lf%lf",&number,nucleus,&charge,&mass,q,q+1,q+2);
				if(ns==7) 
				{
					for(i=0;i<3;i++)
						f->cc[f->na*3+i]=q[i];	// Cartesian coordinates need to be in atomic units (Bohr)
					f->an[f->na++]=(int)(charge);
				}
				else break;
			}
			f->nc=3*f->na;
		}

		// if(!strncmp(buffer," $ZMAT",6)) { }
		//if(!strncmp(buffer," $GRAD",6))
		//{
		//	if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			for(i=0;i<f->nc;i++)
			{
				f->cg[i]=0.0;
		//		j=i*3;
		//		if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
		//		sscanf(buffer,"%s%lf%lf%lf%lf",nucleus,&charge,f->cg+j,f->cg+j+1,f->cg+j+2);
			}
		//}
		if(!strncmp(buffer," Hessian symmetry",17))
		{
			columns=3;			
			n=floor((f->nc+(columns-1))/columns);
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;

			for(l=0;l<n;l++)
			{
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;				
				ns=sscanf(buffer,"%d%d%d"
				,i_index,i_index+1,i_index+2);	
				for(m=0;m<f->nc;m++)
				{
					if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
					ns=sscanf(buffer,"%d%*c%lf%lf%lf"
					,&j,q,q+1,q+2);
					
					for(k=0;k<ns-1;k++)
					{
					double *hij=f->ff+rindex(i_index[k]-1,j-1,f->nc,f->nc);	// rindex is defined in programming.h	
					*hij=q[k];
					}
				}
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			}
		}
	}
		
	f->te=0;
	for(i=0;i<f->nc;i++)
		f->cc[i]*=DataUnitLength;			// convert the length unit back to Angstrom
	for(i=0;i<f->nc;i++)
		f->cg[i]*=DataUnitGradient;
	for(j=0;j<f->nc;j++)
		for(i=0;i<f->nc;i++)
			f->ff[rindex(i,j,f->nc,h->nc)]*=DataUnitHessian;
	for(j=0;j<f->nc;j++)
		for(i=0;i<=j;i++)
			f->cf[uindex(i,j)]=0.5*(f->ff[rindex(i,j,f->nc,f->nc)]+f->ff[rindex(j,i,f->nc,f->nc)]);
	return(f->na);
}


// The follwing function prints the coordinates, gradient,and the Hessian to the fp

int writegeneric(FILE* fp,CARTESIAN *f)
{
	int i,j,detail=1;

	if(f->na)
	{
		fprintf(fp,"molecule= %s\n",f->molecule);
		fprintf(fp,"number_of_atoms= %d\n",f->na);
		fprintf(fp,"total_energy= %16.8lf\n",f->te);
		fprintf(fp,"atomic_numbers[]:\n");
		for(i=0;i<f->na;i++)
			fprintf(fp," %4d",f->an[i]);
		fprintf(fp,"\n");
		fprintf(fp,"cartesian_coordinates[]:\n");
		for(i=0;i<f->na;i++)
		{
			for(j=0;j<3;j++)
				fprintf(fp,"%16.8lf",f->cc[i*3+j]);
			fprintf(fp,"\n");
		}
		fprintf(fp,"\n");
		fprintf(fp,"cartesian_gradients[]:\n");
		for(i=0;i<f->na;i++)
		{
			for(j=0;j<3;j++)
				fprintf(fp,"%16.8lf",f->cg[i*3+j]);
			fprintf(fp,"\n");
		}
		fprintf(fp,"\n");
		fprintf(fp,"cartesian_force_constant_matirx[][]:\n");
		for(j=0;j<f->nc;j++)
		{
			for(i=0;i<=j;i++)
				fprintf(fp,"%8.4lf",f->cf[uindex(i,j)]);
			fprintf(fp,"\n");
		}
		if(detail) 
		{
			fprintf(stderr,"cartesian coordinates in angstrom:\n");
			for(i=0;i<f->na;i++)
			{
				for(j=0;j<3;j++)
					fprintf(stderr,"%16.8lf",f->cc[i*3+j]/Angstrom);
				fprintf(stderr,"\n");
			}
			fprintf(stderr,"\n");
		}
	}
	return(f->na);
}


