#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "constantunits.h"
#include "programming.h"

#include "errors.h"
#include "initialize.h"

int checktmo(FILE *fp)
{
	int na=0;
	char buffer[STRINGBUFFERSIZE];
	double x,y,z;

	while(1)
	{
		if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
		if(!strncmp(buffer,"              | Atomic coordinate, charge and isotop information |",66))
		{
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			for(na=0;na<MAXIMUM_NUMBER_ATOMS;na++)
			{
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
				if(3>sscanf(buffer,"%lf%lf%lf",&x,&y,&z)) break;
			}
			if(na>MAXIMUM_NUMBER_ATOMS) 
				ued3error("too many nuclei");
			else
				break;
		}
	}
	rewind(fp);
	return(na);
}

int readtmo(FILE *fp,CARTESIAN *f,int na)
{
	int i,j,k,ns;
	char buffer[STRINGBUFFERSIZE];
	char tmp[STRINGBUFFERSIZE];
	double nc;

	sprintf(f->molecule,"read from turbomol");
	while(1)
	{
		if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
		f->nc=3*f->na;
		if(!strncmp(buffer,"              | Atomic coordinate, charge and isotop information |",66))
		{
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			for(i=0;i<f->na;i++)
			{
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
				sscanf(buffer,"%lf%lf%lf%s%d%lf",f->cc+i*3,f->cc+i*3+1,f->cc+i*3+2,tmp,&ns,&nc);
				f->an[i]=nc;
			}
		}
		if(!strncmp(buffer,"            actual cartesian coordinates",40))
		{
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			for(i=0;i<f->na;i++)
			{
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
				sscanf(buffer,"%d%s%lf%lf%lf",&ns,tmp,f->cc+i*3,f->cc+i*3+1,f->cc+i*3+2);
			}
		}
		if(!strncmp(buffer,"              actual cartesian gradients",40))
		{
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			for(i=0;i<f->na;i++)
			{
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
				sscanf(buffer,"%d%s%lf%lf%lf",&ns,tmp,f->cg+i*3,f->cg+i*3+1,f->cg+i*3+2);
			}
		}
		if(!strncmp(buffer,"          CARTESIAN FORCE CONSTANT MATRIX (hartree/bohr**2)",59))
		{
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			ns=(f->nc)/6;
			for(k=0;k<ns;k++)
			{
				for(i=k*6;i<f->nc;i++)
				{
					if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
					j=uindex(i,k*6);
					sscanf(buffer+14,"%10lf%10lf%10lf%10lf%10lf%10lf"
					,&(f->cf[j]),&(f->cf[j])+1,&(f->cf[j])+2
					,&(f->cf[j])+3,&(f->cf[j])+4,&(f->cf[j])+5);
				}
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			}
			if(f->nc-ns*6>0)
			{
				for(i=ns*6;i<f->nc;i++)
				{
					if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
					j=uindex(i,k*6);
					sscanf(buffer+15,"%10lf%10lf%10lf"
					,&(f->cf[j]),&(f->cf[j])+1,&(f->cf[j])+2);
				}
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
				if(NULL==fgets(buffer,STRINGBUFFERSIZE,fp)) break;
			}
		}
	}
	return(f->na);
}

int writefchk(FILE* fp,CARTESIAN *f)
{
	int i,j,detail=1;

	if(f->na)
	{
		fprintf(fp,"molecule= %s\n",f->molecule);
		fprintf(fp,"number_of_atoms= %d\n",f->na);
		// fprintf(fp,"total_energy= %16.8lf\n",f->te);
		fprintf(fp,"atomic_numbers[]:\n");
		for(i=0;i<f->na;i++)
			fprintf(fp," %4d",f->an[i]);
		fprintf(fp,"\n");
		fprintf(fp,"cartesian_coordinates[]:\n");
		for(i=0;i<f->na;i++)
		{
			for(j=0;j<3;j++)
				fprintf(fp,"%16.8lf",f->cc[i*3+j]);
			fprintf(fp,"\n");
		}
		fprintf(fp,"\n");
		fprintf(fp,"cartesian_gradients[]:\n");
		for(i=0;i<f->na;i++)
		{
			for(j=0;j<3;j++)
				fprintf(fp,"%16.8lf",f->cg[i*3+j]);
			fprintf(fp,"\n");
		}
		fprintf(fp,"\n");
		fprintf(fp,"cartesian_force_constant_matirx[][]:\n");
		for(i=0;i<f->nc;i++)
		{
			for(j=0;j<=i;j++)
				fprintf(fp,"%16.8lf",f->cf[uindex(i,j)]);
			fprintf(fp,"\n");
		}
		if(detail) 
		{
			fprintf(stderr,"cartesian coordinates in angstrom:\n");
			for(i=0;i<f->na;i++)
			{
				for(j=0;j<3;j++)
					fprintf(stderr,"%16.8lf",f->cc[i*3+j]*Bohr_Angstrom);
				fprintf(stderr,"\n");
			}
			fprintf(stderr,"\n");
		}
	}
	return(f->na);
}

int min(int i,int j)
{
	return( (i<j)?i:j );
}

int max(int i,int j)
{
	return( (i>j)?i:j );
}

int savefchk(FILE* fp,CARTESIAN *f)
{
	int i,j,k,m,detail=1;

	if(f->na)
	{
		fprintf(fp,"molecule= %s\n",f->molecule);
		fprintf(fp,"Number of atoms                            I            %5d\n",f->na);
		// fprintf(fp,"total_energy= %16.8lf\n",f->te);
		fprintf(fp,"Atomic numbers                             I   N=       %5d\n",f->na);
		k=(f->na+5)/6;
		for(j=0;j<k;j++)
		{
			for(i=j*6;i<min((j+1)*6,f->na);i++)
				fprintf(fp,"%12d",f->an[i]);
			fprintf(fp,"\n");
		}
		fprintf(fp,"Current cartesian coordinates              R   N=       %5d\n",f->nc);
		k=(f->nc+4)/5;
		for(j=0;j<k;j++)
		{
			for(i=j*5;i<min((j+1)*5,f->nc);i++)
				fprintf(fp,"%16.8le",f->cc[i]);
			fprintf(fp,"\n");
		}
		fprintf(fp,"Cartesian Gradient                         R   N=       %5d\n",f->nc);
		k=(f->nc+4)/5;
		for(j=0;j<k;j++)
		{
			for(i=j*5;i<min((j+1)*5,f->nc);i++)
				fprintf(fp,"%16.8le",f->cg[i]);
			fprintf(fp,"\n");
		}
		m=uindex(f->nc,f->nc);
		fprintf(fp,"Cartesian Force Constants                  R   N=  %10d\n",m);
		k=(m+4)/5;
		for(j=0;j<k;j++)
		{
			for(i=j*5;i<min((j+1)*5,m);i++)
				fprintf(fp,"%16.8le",f->cf[i]);
			fprintf(fp,"\n");
		}
		if(detail) 
		{
			fprintf(stderr,"cartesian coordinates in angstrom:\n");
			for(i=0;i<f->na;i++)
			{
				for(j=0;j<3;j++)
					fprintf(stderr,"%16.8lf",f->cc[i*3+j]*Bohr_Angstrom);
				fprintf(stderr,"\n");
			}
			fprintf(stderr,"\n");
		}
	}
	return(f->na);
}

int main(int argc,char *argv[])
{
	FILE *fp;
	CARTESIAN f[1];
	if(NULL==(fp=fopen(argv[1],"rt"))) 
		fprintf(stderr," file doesn't exist: %s\n",argv[1]);
	else
	{
		f->na=checktmo(fp);
		memorycartesianallocate(f);
		readtmo(fp,f,f->na);
		fclose(fp);
		savefchk(stdout,f);
	}
	return(0);
}
