#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "atomictable.h"

#define BUFFERSIZE 256

void uerror(char *s)
{
	fprintf(stderr,"%% %s does not exist\n",s);
	return;
}

int atomicnumber(char *s)
{
	int i;
	for(i=1;i<NUM_ELEMENT_TABLE;i++)
	{
		if(!strcmp(s,tablesymbol[i])) return i;
	}
	return 0;
}

int columnize(int nc,int ns,double ds)
{
	int i,j,k,m,n,an=0;
	char buffer[BUFFERSIZE] = {0};
	char name[BUFFERSIZE];
	double **c,r[5];
	if(NULL==(c=(double **)calloc(nc,sizeof(double *)))) uerror("memory");
	for(i=0;i<nc;i++)
		if(NULL==(c[i]=(double *)calloc(ns,sizeof(double)))) uerror("memory");
	for(i=0;1;i++)
	{
		if(NULL==(fgets(buffer,BUFFERSIZE,stdin))) break;
		if(0<sscanf(buffer,"%s",name))
		{
			an = atomicnumber(name);
			fprintf(stderr,"%5d %5d %-5s\n",i+1,an,name);
		}
		for(j=0;j<nc;j++)
		{
			for(k=0;k<(ns+4)/5;k++)
			{
				if(NULL==(fgets(buffer,BUFFERSIZE,stdin))) break;
				n = sscanf(buffer,"%lf%lf%lf%lf%lf",r,r+1,r+2,r+3,r+4);
				for(m=0;m<n;m++)
					c[j][k*5+m]=r[m];
			}
		}
		for(k=0;k<ns;k++)
		{
			fprintf(stdout,"%-4s ",name);
			fprintf(stdout,"%4d ",an);
			fprintf(stdout,"%8.3lf",ds*k);
			for(j=0;j<nc;j++)
				fprintf(stdout,"%16.10lf",c[j][k]);
			fprintf(stdout,"\n");
		}
	}
	for(i=0;i<nc;i++) free(c[i]);
	free(c);
	return 0;
}

int main(int argc, char *argv[])
{
	if(argc>3)
	{
		int nc=atoi(argv[1]),ns=atoi(argv[2]);
		double ds=atof(argv[3]);
		columnize(nc,ns,ds);
	}
	return 0;
}

