#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "programming.h"
#include "instrumental.h"
#include "status.h"

#include "calculate.h"
#include "empirical.h"
#include "evaluate.h"
//#include "gaussjordan.h"
#include "jacobi.h"
#include "leastsquare.h"
#include "mathematical.h"
#include "numericalfit.h"
#include "fitinternal.h"
#include "radial.h"
#include "outputs.h"
#include "readdata.h"
#include "readpredata.h"
#include "readzmatrix.h"
#include "setzmatrix.h"
#include "writezmatrix.h"
#include "profile.h"
#include "errors.h"
#include "readinternal.h"
#include "transform.h"
#include "setstructure.h"
#include "commandstext.h"

#define MAX_WORDS 6


// This function

int commandstext(int detail,int debug,FILE *fpi,FILE *fp1,FILE *fp2
		,DIFFRACTION *data,MOLECULAR *molecule,int ne,ELEMENTAL *elemental,INSTRUMENTAL *instrument,FITTING *fit)
{
	int echo = 0;
	int i,n,m,nc;
	double chisqr,R;
	char *ef;
	char input[STRINGBUFFERSIZE];
	char output[STRINGBUFFERSIZE]=CURRENTSMSFILENAME;
	char c[MAX_WORDS][STRINGBUFFERSIZE];
	char f[][7]={"fixed","to fit"};
	char a[][10]={"empirical","amplitude"};

	while(1)
	{
//		fprintf(fp2," & current status = %d\n",data->preset);
//		fprintf(fp2,"\r%d/%d> ",molecule->i+1,molecule->n);
		fprintf(fp2,"\n%d/%d> ",molecule->i+1,molecule->n);				// report how many species are loaded
		if(NULL==(ef=fgets(input,STRINGBUFFERSIZE,fpi))) break;				// read the input command string
		for(i=0;i<MAX_WORDS;i++) sprintf(c[i],"%s","");					// initilize the c array with "nothing"
		if(6==MAX_WORDS)
			nc=sscanf(input,"%s%s%s%s%s%s",c[0],c[1],c[2],c[3],c[4],c[5]);		// parse the input command string
		else
			break;
		if(echo && c[0][0]!='#') fprintf(fp2,"%s %s %s %s %s %s\n",c[0],c[1],c[2],c[3],c[4],c[5]);
		if(!strcasecmp("quit",c[0]))
			return(1);
		else if(!strcasecmp("load",c[0])) 
		{
			if(nc<2) continue;
			else if(!strcasecmp("data",c[1])) 
			{
				n=readdata(detail,data,c[2]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_ALL);	// due to s range  ??UNCLEAR??
			}
			else if(!strcasecmp("olddata",c[1])) 
			{
				n=readexpdata(detail,data,c[2]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_ALL);	// due to s range
			}
			else if(!strcasecmp("mls" ,c[1])) 
			{
				if(0==molecule->n) molecule->i=molecule->n++;
				m=readmlsdata(detail,molecule,ne,elemental,c[2]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
			}
			else if(!strcasecmp("xyz" ,c[1])) 
			{
				if(0==molecule->n) molecule->i=molecule->n++;
				if((m=readxyz(detail,molecule,ne,elemental,c[2])))
				{
					if(nc>3) molecule->temperature[molecule->i]=atof(c[3]);
					// molecule->preset[molecule->i]=STATUS_ZMX_NEED_TO_MAKE_ALL;
					setmolecule(detail,1,molecule,ne,elemental);
					fprintf(fp2,"    temperature of %s is %lf K\n"
							,molecule->mls[molecule->i].molecule,molecule->temperature[molecule->i]);
				}
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
			}
			else if(!strcasecmp("zmx" ,c[1]))
			{
				if(0==molecule->n) molecule->i=molecule->n++;
				if((m=readzmx(detail,molecule,ne,elemental,c[2])))
				{
					assignzmxmass(detail,molecule,ne,elemental);
					if(nc>3) molecule->temperature[molecule->i]=atof(c[3]);
					// molecule->preset[molecule->i]=STATUS_ZMX_NEED_TO_MAKE_ALL;
					setmolecule(detail,1,molecule,ne,elemental);
					fprintf(fp2,"    temperature of %s is %lf K\n"
							,molecule->mls[molecule->i].molecule,molecule->temperature[molecule->i]);
				}
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
			}
			else if(!strcasecmp("ric" ,c[1]))
			{
				if(0<molecule->n)
				{
					if((INDEX_KIND_ZMX==molecule->kind[molecule->i])||(INDEX_KIND_XYZ==molecule->kind[molecule->i]))
					{
						if((m=readric(detail,molecule,ne,elemental,c[2])))
						{
							int i=molecule->i;
							INTERNAL *h=molecule->h+i;
							fprintf(fp2,"    read internal coordinates\n");
							allocatememoryinternal(molecule->h+molecule->i);
							h->cc=*(molecule->atomic[molecule->i].q);
							h->m =*(molecule->atomic[molecule->i].m);
							updatereference(molecule->h+i);
							instantaneousinternal(h->r,h);
							writeredundant(2,stderr,h);
						}
					}
				}
				else
				{
					uerror("commandstext.c","load zmx or xyz first");
				}
			}
			else if(!strcasecmp("amp" ,c[1]))
			{
				if((INDEX_KIND_ZMX==molecule->kind[molecule->i])||(INDEX_KIND_XYZ==molecule->kind[molecule->i]))
				{
					if((m=readampdata(detail,molecule,ne,elemental,c[2])))
					{
						if(nc>3) molecule->temperature[molecule->i]=atof(c[3]);
						setpreset(&(molecule->preset[molecule->i]),STATUS_ZMX_NEED_TO_MAKE_AMPLITUDE);
						setmolecule(detail,1,molecule,ne,elemental);
						fprintf(fp2,"    temperature of %s is %lf K\n"
							,molecule->mls[molecule->i].molecule,molecule->temperature[molecule->i]);
					}
				}
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
			}
		}
		else if(!strcasecmp("add",c[0])) 
		{
			if(nc<2) continue;
			else if(!strcasecmp("mls" ,c[1])) 
			{
				i=molecule->i;
				molecule->i=molecule->n;
				if(!(m=readmlsdata(detail,molecule,ne,elemental,c[2])))
					molecule->i=i;
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
			}
			else if(!strcasecmp("xyz" ,c[1]))
			{
				i=molecule->i;
				molecule->i=molecule->n;
				if((m=readxyz(detail,molecule,ne,elemental,c[2])))
				{
					if(nc>3) molecule->temperature[molecule->i]=atof(c[3]);
					// molecule->preset[molecule->i]=STATUS_ZMX_NEED_TO_MAKE_ALL;
					setmolecule(detail,1,molecule,ne,elemental);
					fprintf(fp2,"    temperature of %s is %lf K\n"
							,molecule->mls[molecule->i].molecule,molecule->temperature[molecule->i]);
				}
				else
					molecule->i=i;
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
			}
			else if(!strcasecmp("zmx" ,c[1]))
			{
				i=molecule->i;
				molecule->i=molecule->n;
				if((m=readzmx(detail,molecule,ne,elemental,c[2])))
				{
					assignzmxmass(detail,molecule,ne,elemental);
					if(nc>3) molecule->temperature[molecule->i]=atof(c[3]);
					// molecule->preset[molecule->i]=STATUS_ZMX_NEED_TO_MAKE_ALL;
					setmolecule(detail,1,molecule,ne,elemental);
					fprintf(fp2,"    temperature of %s is %lf K\n"
							,molecule->mls[molecule->i].molecule,molecule->temperature[molecule->i]);
				}
				else
					molecule->i=i;
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
			}
		}
		else if(!strcasecmp("remove",c[0])) 
		{
			if(nc<2) continue;
			else if(!strcasecmp("molecule",c[1]))
			{
				if(0<molecule->n) 
				{
					int n = (--molecule->n);
					if(molecule->amp[n]==INDEX_MLS_AMPLITUDE) molecule->amp[n]=INDEX_MLS_EMPIRICAL;
					if(molecule->ric[n]==INDEX_RIC_SUPPLIED) { deletememoryinternal(molecule->h+n); molecule->ric[n]=INDEX_RIC_NONE; }
				}
				if(molecule->i>=molecule->n) molecule->i=molecule->n-1;
				if(molecule->j>molecule->n) molecule->j=molecule->n;
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
			}
			else if(!strcasecmp("ric",c[1]))
			{
				deletememoryinternal(molecule->h+molecule->i);
				molecule->ric[molecule->i]=INDEX_RIC_NONE;
				fprintf(fp2,"    removed redundant internal coordinates\n");
			}
			else if(!strcasecmp("amp",c[1]))
			{
				if((INDEX_KIND_ZMX==molecule->kind[molecule->i])||(INDEX_KIND_XYZ==molecule->kind[molecule->i]))
				{
					molecule->amp[molecule->i]=INDEX_MLS_EMPIRICAL;
					setpreset(&(molecule->preset[molecule->i]),STATUS_ZMX_NEED_TO_MAKE_AMPLITUDE);
					setmolecule(detail,1,molecule,ne,elemental);
					setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
				}
			}
			else if(!strcasecmp("atomicbackground",c[1]))
			{
				fprintf(stderr,"    removed atomic background contribution from %le\n",data->atomicbackground);
				fit->atomicbackground=0;
				data->atomicbackground=0;
			}
		}
		else if(!strcasecmp("save",c[0])) 
		{
			if(3==nc) sprintf(output,"%s",c[2]);
			if(!strcasecmp("sms",c[1])) 
				updatesmscurves(detail,output,data);
			else if(!strcasecmp("smt",c[1])) 
				updatesmtcurves(detail,output,data,molecule);
			else if(!strcasecmp("raw",c[1])) 
				updaterawcurves(detail,output,data);
			else if(!strcasecmp("fld",c[1])) 
			{
				makefld(data,instrument);
				updatefrdcurves(detail,output,data);
			}
			else if(!strcasecmp("frd",c[1])) 
			{
				makefrd(data,instrument);
				updatefrdcurves(detail,output,data);
			}
                        else if(!strcasecmp("rfd",c[1]))
                        {
                                makefrd(data,instrument);
                                updaterfdcurves(detail,output,data);
                        }
			else if(!strcasecmp("zmx",c[1])) 
				savezmx(detail,molecule,output);
			else if(!strcasecmp("mls",c[1])) 
				printmls(fp1,molecule,ne,elemental);
			else if(!strcasecmp("molden",c[1])) 
				printmoldenfile(fp1,molecule,ne,elemental);
			else if(!strcasecmp("amplitudes",c[1])) 
				printamplitude(1+DETAIL_EMPIRICAL_AMPLITUDE,molecule,ne,elemental);
			else if(!strcasecmp("internal",c[1])) 
			{
				INTERNAL *h=molecule->h+molecule->i;
				//instantaneousinternal(h->r,h);
				writeredundant(2,stderr,h);
			}
			else if(!strcasecmp("elemental",c[1])) 
				printinterpolated(atoi(c[2]),elemental);
			sprintf(output,"%s",CURRENTSMSFILENAME);
		}
		else if(!strcasecmp("fit",c[0])) 
		{
			if(nc<2) continue;
			else if(molecule->n<1)
			{
				fprintf(fp2,"    no molecular information ....\n");
				continue;
			}
			else if(!strcasecmp("all",c[1])) 
			{
				chisqr=singlepoint(0,1,data,molecule,ne,elemental,instrument,fit);
				calculatenonlinears(detail,data,molecule,ne,elemental,instrument,fit);
				updatesmscurves(detail,output,data);
			}
			else if(!strcasecmp("cartesian",c[1])) 
			{
				chisqr=singlepoint(0,1,data,molecule,ne,elemental,instrument,fit);
				calculatecartesianinternal(detail,data,molecule,ne,elemental,instrument,fit);
				updatesmscurves(detail,output,data);
			}
			else if(!strcasecmp("difference",c[1])) 
			{
				int fb=fit->background;
				int fa=fit->atomicbackground;
				chisqr=singlepoint(0,1,data,molecule,ne,elemental,instrument,fit);
				fit->background=0;
				fit->atomicbackground=0;
				calculatedifferencefractions(detail,data,molecule,fit);
				fit->background=fb;
				fit->atomicbackground=fa;
				updatesmscurves(detail,output,data);
			}
			else if(!strcasecmp("linear",c[1])) 
			{
				i=fit->linears; fit->linears=1;
				if(!strcasecmp("again",c[2])) setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
				chisqr=singlepoint(detail,1,data,molecule,ne,elemental,instrument,fit);
				updatesmscurves(detail,output,data);
				fprintf(fp2,"    X2= %lf\n",data->chisqr);
				fit->linears=i;
			}
			else if(!strcasecmp("length",c[1])) 
			{
				i=fit->camera; fit->camera=1;
				chisqr=singlepoint(0,1,data,molecule,ne,elemental,instrument,fit);
				calculatenonlinears(detail,data,molecule,ne,elemental,instrument,fit);
				updatesmscurves(detail,output,data);
				fit->camera=i;
			}
			else if(!strcasecmp("camera",c[1])) 
			{
				chisqr=singlepoint(0,1,data,molecule,ne,elemental,instrument,fit);
				fitcamera(detail,data,molecule,ne,elemental,instrument,fit);
				updatesmscurves(detail,output,data);
			}
		}
		else if(!strcasecmp("set",c[0])) 
		{
			if(nc<2) sprintf(c[1],"structure");
			if(!strcasecmp("echo",c[1])) 
			{
				if(!strcasecmp("yes",c[2])) echo=1;
				if(!strcasecmp("no" ,c[2])) echo=0;
			}
			else if(!strcasecmp("range",c[1])) 
			{
				data->cs=atoi(c[2]);
				data->ce=atoi(c[3]);
				if(data->ce<data->cs) { data->cs=atoi(c[3]); data->ce=atoi(c[2]);}
				if(data->cs<data->ss) data->cs=data->ss;
				if(data->ce>data->se) data->ce=data->se;
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
				fprintf(fp2,"    current pixel range is from %d to %d\n",data->cs,data->ce);
			}
			else if(!strcasecmp("background",c[1])) 
			{
				data->np=atoi(c[2]);
				if(data->np<0) data->np=0;
				if(data->np>MAX_NUM_POLY) data->np=MAX_NUM_POLY;
				if(nc>3)
				{
					if(!strcasecmp(c[3],"POLYNOMIAL")) instrument->polynomials=POLYNOMIAL;
					if(!strcasecmp(c[3],"POLYNOMIALXE")) instrument->polynomials=POLYNOMIALXE;
					if(!strcasecmp(c[3],"RECIPROCAL")) instrument->polynomials=RECIPROCAL;
					if(!strcasecmp(c[3],"RECIPROCALXE")) instrument->polynomials=RECIPROCALXE;
					if(!strcasecmp(c[3],"RECIPROCAL2")) instrument->polynomials=RECIPROCAL2;
					fprintf(fp2,"    the kind of background is %d\n",instrument->polynomials);
					setpreset(&(data->preset),STATUS_NEED_TO_MAKE_S_DATA);
				}
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
				fprintf(fp2,"    the order of background is %d\n",data->np);
			}
			else if(!strcasecmp("atomicbackground",c[1])) 
			{
				data->atomicbackground=atof(c[2]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
				fprintf(fp2,"    current atomic background is %lf\n",data->atomicbackground);
			}
			else if(!strcasecmp("molecule",c[1])) 
			{
				molecule->i=atoi(c[2])-1;
				if(molecule->i>=molecule->n) molecule->i=molecule->n-1;
				if(molecule->i<0) molecule->i=0;
				fprintf(fp2,"    current molecule is %d out of %d\n",molecule->i+1,molecule->n);
			}
			else if(!strcasecmp("reactant",c[1])) 
			{
				molecule->j=atoi(c[2]);
				if(molecule->j>molecule->n) molecule->j=molecule->n;
				if(molecule->j<0) molecule->j=0;
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_CURVES);
				fprintf(fp2,"    the number of reactants is %d\n",molecule->j);
			}
			else if(!strcasecmp("temperature",c[1])) 
			{
				molecule->temperature[molecule->i]=atof(c[2]);
				setpreset(&(molecule->preset[molecule->i]),STATUS_ZMX_NEED_TO_MAKE_AMPLITUDE);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
				setmolecule(detail,1,molecule,ne,elemental);
				fprintf(fp2,"    temperature of %dth molecule is %lf\n",molecule->i+1,molecule->temperature[molecule->i]);
			}
			else if(!strcasecmp("voltage",c[1])) 
			{
				instrument->KineticEnergy=atof(c[2]);
				if(instrument->KineticEnergy<0) instrument->KineticEnergy=ElectronKineticEnergy;
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_PREDATA);
				fprintf(fp2,"    current gun voltage is %lf kV\n",instrument->KineticEnergy);
			}
			else if(!strcasecmp("pixel",c[1])) 
			{
				instrument->PixelSize=atof(c[2]);
				if(instrument->PixelSize<0) instrument->PixelSize=1;
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_ALL);
				fprintf(fp2,"    current pixel size is %lf um\n",instrument->PixelSize);
			}
			else if(!strcasecmp("camera",c[1])) 
			{
				instrument->CameraLength=atof(c[2]);
				if(instrument->CameraLength<0) instrument->CameraLength=1;
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_ALL);
				fprintf(fp2,"    current camera length is %lf cm\n",instrument->CameraLength);
			}
			else if(!strcasecmp("cameravariance",c[1])) 
			{
				instrument->CameraLengthVariance=atof(c[2]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_ALL);
				fprintf(fp2,"    current camera variance is %lf cm\n",instrument->CameraLengthVariance);
			}
			else if(!strcasecmp("noise",c[1])) 
			{
				instrument->noise=atof(c[2]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
				//setpreset(&(data->preset),STATUS_NEED_TO_MAKE_ALL);
				fprintf(fp2,"    current noise factor is %lf\n",instrument->noise);
			}
			else if(!strcasecmp("scalefactor",c[1])) 
			{
				data->scale=1/atof(c[2]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
				fprintf(fp2,"    current scale factor is %lf = 1/%lf\n",data->scale,1/data->scale);
			}
			else if(!strcasecmp("inversescalefactor",c[1])) 
			{
				data->scale=atof(c[2]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
				fprintf(fp2,"    current scale factor is %lf = 1/%lf\n",data->scale,1/data->scale);
			}
			else if(!strcasecmp("fraction",c[1])) 
			{
				molecule->fraction[molecule->i]=atof(c[2]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
				fprintf(fp2,"    set fraction(%d) to %lf\n",1+molecule->i,molecule->fraction[molecule->i]);
			}
			else if(!strcasecmp("reference",c[1])) 
			{
				if(-1<findnucleartype(c[2],ne,elemental)) strcpy(instrument->ReferenceAtom,c[2]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_REFERENCE);
				fprintf(fp2,"    current reference is %s\n"
						,instrument->ReferenceAtom);
			}
			else if(!strcasecmp("fifj",c[1])) 
			{
				if(-1<findnucleartype(c[2],ne,elemental)) strcpy(instrument->fi,c[2]);
				if(-1<findnucleartype(c[3],ne,elemental)) strcpy(instrument->fj,c[3]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_FIFJ);
				fprintf(fp2,"    current atoms for fifj leveling are %s and %s\n"
						,instrument->fi,instrument->fj);
			}
			else if(!strcasecmp("damping",c[1])) 
			{
				instrument->dampingk=atof(c[2]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
				fprintf(fp2,"    current damping factor is %lf\n",instrument->dampingk);
			}
			else if(!strcasecmp("fit",c[1])) 
			{
				if(!strcasecmp("linear",c[2])) { fit->linears=1; setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);}
				if(!strcasecmp("background",c[2])) { fit->background=1; setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);}
				if(!strcasecmp("atomicbackground",c[2])) { fit->atomicbackground=1; setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);}
				if(!strcasecmp("scalefactor",c[2])) { fit->scalefactor=1; setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);}
				if(!strcasecmp("d2yda2",c[2])) fit->d2yda2=1;
				if(!strcasecmp("camera",c[2])) fit->camera=1;
				if(!strcasecmp("cameravariance",c[2])) fit->cameravariance=1;
				if(!strcasecmp("temperature",c[2])) fit->temperature[molecule->i]=1;
				if(!strcasecmp("temperatures",c[2])) for(i=0;i<MAX_MIXTURE;i++) fit->temperature[i]=1;
				if(!strcasecmp("fraction",c[2])) { fit->fraction[molecule->i]=1; setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);}
				if(!strcasecmp("fractions",c[2])) { for(i=0;i<MAX_MIXTURE;i++) fit->fraction[i]=1; setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);}
				if(!strcasecmp("fractionsum",c[2])) { fit->fractions=1; setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);}
				if(!strcasecmp("coordinates",c[2])) fit->coordinates=1;
				if(!strcasecmp("structures",c[2])) fit->coordinates=2;
				if(!strcasecmp("internal" ,c[2]))
				{
					INTERNAL *h=molecule->h+molecule->i;
					int j1=atoi(c[3]),j2=atoi(c[4]);
					//h->r[0]+=0.1;
					//buildstructure(detail,molecule);
					for(i=j1;i<=j2;i++)
						fit->internal[molecule->i][i-1]=1;
				}
			}
			else if(!strcasecmp("fix",c[1])) 
			{
				if(!strcasecmp("linear",c[2])) fit->linears=0;
				if(!strcasecmp("background",c[2])) fit->background=0;
				if(!strcasecmp("atomicbackground",c[2])) fit->atomicbackground=0;
				if(!strcasecmp("scalefactor",c[2])) fit->scalefactor=0;
				if(!strcasecmp("d2yda2",c[2])) fit->d2yda2=0;
				if(!strcasecmp("camera",c[2])) fit->camera=0;
				if(!strcasecmp("cameravariance",c[2])) fit->cameravariance=0;
				if(!strcasecmp("temperature",c[2])) fit->temperature[molecule->i]=0;
				if(!strcasecmp("temperatures",c[2])) for(i=0;i<MAX_MIXTURE;i++) fit->temperature[i]=0;
				if(!strcasecmp("fraction",c[2])) { fit->fraction[molecule->i]=0; if(nc>3) { molecule->fraction[molecule->i]=atof(c[3]); setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR); } }
				if(!strcasecmp("fractions",c[2])) for(i=0;i<MAX_MIXTURE;i++) fit->fraction[i]=0;
				if(!strcasecmp("fractionsum",c[2])) { fit->fractions=0; if(nc>3) molecule->fsum=atof(c[3]); }
				if(!strcasecmp("coordinates",c[2])) fit->coordinates=0;
				if(!strcasecmp("structures",c[2])) fit->coordinates=0;
				if(!strcasecmp("internal" ,c[2]))
				{
					INTERNAL *h=molecule->h+molecule->i;
					int j1=atoi(c[3]),j2=atoi(c[4]);
					for(i=j1;i<=j2;i++)
						fit->internal[molecule->i][i-1]=0;
				}
			}
			else if(!strcasecmp("coordinate",c[1])) 
			{
				showcoordinate(detail,fpi,data,molecule,ne,elemental,instrument,fit);
				// {
				//	setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
				//	setmolecule(detail,1,molecule,ne,elemental);
				// }
			}
			else if(!strcasecmp("structure",c[1])) 
			{
				if(INDEX_RIC_SUPPLIED==molecule->ric[molecule->i])
					showstructure(detail,fpi,data,molecule,ne,elemental,instrument,fit);
				else
					showcoordinate(detail,fpi,data,molecule,ne,elemental,instrument,fit);
			}
			else if(!strcasecmp("difference",c[1])) 
			{
				if(!strcasecmp("yes",c[2])) molecule->fsum=0;
				if(!strcasecmp("no" ,c[2])) molecule->fsum=1;
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
				fprintf(fp2,"    current total fraction is %lf\n",(double)molecule->fsum);
			}
			else if(!strcasecmp("fractionsum",c[1])) 
			{
				molecule->fsum=atof(c[2]);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
				fprintf(fp2,"    current total fraction is %lf\n",(double)molecule->fsum);
			}
			else if(!strcasecmp("update",c[1])) 
			{
				if(!strcasecmp("yes",c[2])) fit->update=1;
				if(!strcasecmp("no" ,c[2])) fit->update=0;
				fprintf(fp2,"    current updating method is %d\n",fit->update);
			}
			else if(!strcasecmp("method",c[1])) 
			{
				if(!strcasecmp("marquardt",c[2])) fit->method=INDEX_FIT_MARQUARDT;
				if(!strcasecmp("jacobieigen",c[2])) fit->method=INDEX_FIT_JACOBIEIGEN;
				if(!strcasecmp("montecarlo",c[2])) fit->method=INDEX_FIT_MONTECARLO;
				if(!strcasecmp("search",c[2])) fit->method=INDEX_FIT_SEARCH;
				fprintf(fp2,"    current nonlinear fitting method is %d\n",fit->method);
			}
			// else if(!strcasecmp("iteration",c[1])) 
			// {
			//	fit->iteration=atoi(c[2]);
			//	fprintf(fp2,"    iteration limit in nonlinear fitting is %ld\n",fit->iteration);
			// }
			else if(!strcasecmp("detail",c[1])) 
			{
				if(!strcasecmp("yes",c[2])) detail=1;
				else if(!strcasecmp("no" ,c[2])) detail=0;
				else detail=atoi(c[2]);
				fprintf(fp2,"    current level of detailed information is %d\n",detail);
			}
			else if(!strcasecmp("coupled",c[1])) 
			{
				fit->coupled[0]=atoi(c[2])-1;
				fit->coupled[1]=atoi(c[3])-1;
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_LINEAR);
				fprintf(fp2,"    fractions of %d and %d are coupled\n",fit->coupled[0],fit->coupled[1]);
			}
			else if(!strcasecmp("profile",c[1])) 
			{
				instrument->e.width=atof(c[2]);
				buildeprofile(&(instrument->e));
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_ALL);
				fprintf(fp2,"    current electron width is %lf\n",instrument->e.width);
			}
			else if(!strcasecmp("limit",c[1])) 
			{
				molecule->mls[molecule->i].limit=atof(c[2]);
				setpreset(&(molecule->preset[molecule->i]),STATUS_ZMX_NEED_TO_MAKE_MLS);
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
				fprintf(fp2,"    set mls-limit(%d) to %lf\n",1+molecule->i,molecule->mls[molecule->i].limit);
			}
			else if(!strcasecmp("jacobi",c[1])) 
			{
				if(nc>2) JACOBI_METHOD=atoi(c[2]);
				if(nc>3) JACOBI_LINEAR_SMALL=atof(c[3]);
				if(nc>4) JACOBI_NONLINEAR_SMALL=atof(c[4]);
				if(nc>5) JACOBI_NONLINEARS=atoi(c[5]);
				fprintf(stderr,"    jacobi: method= %d linear= %lf nonlinear= %lf [%d]\n",JACOBI_METHOD,JACOBI_LINEAR_SMALL,JACOBI_NONLINEAR_SMALL,JACOBI_NONLINEARS);
			}
		}
		else if(!strcasecmp("get",c[0])) 
		{
			if(nc<2) continue;
			else if(!strcasecmp("range",c[1])) 
			{
				fprintf(fp2,"    current pixel range is from %d to %d\n",data->cs,data->ce);
			}
			else if(!strcasecmp("background",c[1])) 
			{
				fprintf(fp2,"    current order of background is %d\n",data->np);
				fprintf(fp2,"    the kind of background is %d\n",instrument->polynomials);
				if(fit->atomicbackground) fprintf(fp2,"    atomic background is added\n");
			}
			else if(!strcasecmp("atomicbackground",c[1])) 
			{
				fprintf(fp2,"    current atomic background is %lf\n",data->atomicbackground);
			}
			else if(!strcasecmp("voltage",c[1])) 
			{
				fprintf(fp2,"    current gun voltage is %lf kV\n",instrument->KineticEnergy);
			}
			else if(!strcasecmp("pixel",c[1])) 
			{
				fprintf(fp2,"    current pixel size is %lf um\n",instrument->PixelSize);
			}
			else if(!strcasecmp("camera",c[1])) 
			{
				fprintf(fp2,"    current camera length is %lf (%lf) cm\n",instrument->CameraLength,instrument->CameraLengthVariance);
			}
			else if(!strcasecmp("noise",c[1])) 
			{
				fprintf(fp2,"    current noise factor is %lf\n",instrument->noise);
			}
			else if(!strcasecmp("profile",c[1])) 
			{
				fprintf(fp2,"    current electron width is %lf\n",instrument->e.width);
			}
			else if(!strcasecmp("reference",c[1])) 
			{
				fprintf(fp2,"    current reference is %s\n"
						,instrument->ReferenceAtom);
			}
			else if(!strcasecmp("fifj",c[1])) 
			{
				fprintf(fp2,"    current atoms for fifj leveling are %s and %s\n"
						,instrument->fi,instrument->fj);
			}
			else if(!strcasecmp("damping",c[1])) 
			{
				fprintf(fp2,"    current damping factor is %lf\n",instrument->dampingk);
			}
			else if(!strcasecmp("temperatures",c[1])) 
			{
				for(i=0;i<molecule->n;i++)
					fprintf(fp2,"    T[%d]= %lf\n",1+i,molecule->temperature[i]);
			}
			else if(!strcasecmp("fits",c[1])) 
			{
				if(fit->linear) fprintf(fp2,"    linears are to fit\n");
				if(fit->camera) fprintf(fp2,"    camera is to fit\n");
				if(fit->cameravariance) fprintf(fp2,"    camera variance is to fit\n");
				if(fit->coordinates) fprintf(fp2,"    coordinates are to fit\n");
				for(i=0;i<molecule->n;i++)
					fprintf(fp2,"    fraction[%d] is %s (%lf)\n"
							,1+i,f[fit->fraction[i]],molecule->fraction[i]);
				for(i=0;i<molecule->n;i++)
					fprintf(fp2,"    temperature[%d] is %s (%lf)\n"
							,1+i,f[fit->temperature[i]],molecule->temperature[i]);
			}
			else if(!strcasecmp("difference",c[1])) 
			{
				fprintf(fp2,"    the sum of fractions is %lf\n",molecule->fsum);
			}
			else if(!strcasecmp("fractions",c[1])) 
			{
				fprintf(fp2,"    the sum of fractions is %lf\n",molecule->fsum);
				for(i=0;i<molecule->n;i++)
					fprintf(fp2,"    %-20s[%d] is %s (%lf)\n"
							,molecule->mls[i].molecule,1+i,f[fit->fraction[i]],molecule->fraction[i]);
			}
			else if(!strcasecmp("results",c[1])) 
			{
				double fsum=0;
				fprintf(fp2,"    current data file is %s\n",data->filename);
				fprintf(fp2,"    current pixel range is from %d to %d\n",data->cs,data->ce);
				fprintf(fp2,"    current camera length is %lf (%lf)\n",instrument->CameraLength,instrument->CameraLengthVariance);
				fprintf(fp2,"    current order of background is %d + %d[%le]\n",data->np,fit->atomicbackground,data->atomicbackground);
				fprintf(fp2,"    the scale factor is %16.12lf or 1/%16.12lf\n",data->scale,1/data->scale);
				fprintf(fp2,"    the chi square is %lf\n",data->chisqr/(data->scale*data->scale));
				for(i=0;i<molecule->n;i++)
					fsum+=molecule->fraction[i];
				fprintf(fp2,"    the sum of fractions is %lf\n",fsum);
				for(i=0;i<molecule->n;i++)
					fprintf(fp2,"    %5d: %-20s f= %12.8lf  T= %12.4lf %s\n"
							,1+i,molecule->mls[i].molecule
							,molecule->fraction[i],molecule->temperature[i]
							,a[molecule->amp[i]]);
				fprintf(fp2,"    result:");
				evaluaterawR(1,data,molecule);
			}
			else if(!strcasecmp("compact",c[1])) 
			{
				R=evaluateR(0,data,molecule);
				fprintf(fp1," [%d,%d] ",data->cs,data->ce);
				fprintf(fp1,"X2= %lf ",data->chisqr/(data->scale*data->scale));
				fprintf(fp1,"R= %lf ",R);
				fprintf(fp1,"f= ");
				for(i=0;i<molecule->n;i++)
					fprintf(fp1,"%11.8lf ",molecule->fraction[i]);
				fprintf(fp1,"T= ");
				for(i=0;i<molecule->n;i++)
					fprintf(fp1,"%4.0lf ",molecule->temperature[i]);
				for(i=0;i<molecule->n;i++)
					fprintf(fp1,"%s ",molecule->mls[i].molecule);
				fprintf(fp1,"%s ",data->filename);
				fprintf(fp1,"\n");
			}
			else if(!strcasecmp("amplitudes",c[1])) 
			{
				estimateamplitude(1+DETAIL_EMPIRICAL_AMPLITUDE,molecule,ne,elemental);
			}
			else if(!strcasecmp("xyz2zmx",c[1])) 
			{
				evaluatezmx4xyz(detail,molecule);
				showcoordinate(detail,fpi,data,molecule,ne,elemental,instrument,fit);
			}
			else if(!strcasecmp("ensemble",c[1])) 
			{
				rotationalweight(1,molecule);
			}
			else if(!strcasecmp("jacobi",c[1])) 
			{
				fprintf(stderr,"    jacobi: method= %d linear= %lf nonlinear= %lf [%d]\n",JACOBI_METHOD,JACOBI_LINEAR_SMALL,JACOBI_NONLINEAR_SMALL,JACOBI_NONLINEARS);
			}
		}
	}
	fprintf(fp2,"\n");
	return(0);
}
