#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "programming.h"
#include "instrumental.h"
#include "status.h"

#include "calculate.h"
#include "empirical.h"
#include "evaluate.h"
//#include "gaussjordan.h"
#include "leastsquare.h"
#include "mathematical.h"
//#include "outputs.h"
#include "readpredata.h"
#include "readzmatrix.h"
#include "setzmatrix.h"
#include "setstructure.h"


// WHAT IS THE PRESET???

int setpreset(int *preset,int option)
{
	if(option<*preset) *preset=option;
	return(*preset);
}

int setpresets(int n,int *preset1,int *mpreset1,int preset2,int *mpreset2)
{
	int i;
	*preset1=preset2;
	for(i=0;i<n;i++)
		mpreset1[i]=mpreset2[i];
	return(n);
}

void preparation(int detail,int update,DIFFRACTION *data,MOLECULAR *molecule,int ne,ELEMENTAL *elemental,INSTRUMENTAL *instrument,FITTING *fit)
{
	int i=molecule->i,n=molecule->n;
	//data->preset=STATUS_NEED_TO_MAKE_ALL;
	switch(data->preset) 
	{
		default:
		case STATUS_NEED_TO_MAKE_PREDATA :
			interpolateenergy(instrument->KineticEnergy,elemental);
		case STATUS_NEED_TO_MAKE_ALL :
			calculatespix(data,instrument);
			makecorrfactors(ne,elemental,data);
		//	getcorrfactors(ne,elemental,data);
		case STATUS_NEED_TO_MAKE_REFERENCE :
			makereference(data,ne,elemental,instrument);
		case STATUS_NEED_TO_MAKE_FIFJ :
			makefifj(data,ne,elemental,instrument);
		case STATUS_NEED_TO_MAKE_S_DATA :
			makesdata(data,instrument);
		case STATUS_NEED_TO_MAKE_ATOMIC :
			for(molecule->i=0;molecule->i<n;molecule->i++)
				makesatmolecule(data,molecule,ne,elemental,instrument);
			molecule->i=i;
		case STATUS_NEED_TO_MAKE_MOLECULAR :
			if(update) data->preset=STATUS_DONE_WITH_S_DATA;
	}
	return;
}

int setmolecule(int detail,int update,MOLECULAR *molecule,int ne,ELEMENTAL *elemental)
{
	int i=molecule->i;
	if((INDEX_KIND_ZMX==molecule->kind[molecule->i])&&(INDEX_MLS_AMPLITUDE==molecule->amp[molecule->i]))
		switch(molecule->preset[i])
		{
			case STATUS_ZMX_NEED_TO_READ_ZMX:
				return(0);
			default:
			case STATUS_ZMX_NEED_TO_MAKE_ALL:
				if(INDEX_RIC_SUPPLIED==molecule->ric[molecule->i])
					buildstructure(detail,molecule);
				else
					buildmolecule(detail,molecule);
			case STATUS_ZMX_NEED_TO_MAKE_MLS:
				updatemls(detail,molecule,ne,elemental);
			case STATUS_ZMX_NEED_TO_MAKE_RTA:
				//estimateamplitude(detail,molecule,ne,elemental);
			case STATUS_ZMX_NEED_TO_MAKE_AMPLITUDE:
				scaleamplitude(detail,molecule,ne,elemental);
			case STATUS_ZMX_NEED_TO_MAKE_ANHARMONIC:
				makediffractionlength(detail,molecule);
			case STATUS_ZMX_ALL_DONE: 
				if(update) molecule->preset[i]=STATUS_ZMX_ALL_DONE;
		}
	if((INDEX_KIND_ZMX==molecule->kind[molecule->i])&&(INDEX_MLS_EMPIRICAL==molecule->amp[molecule->i]))
		switch(molecule->preset[i])
		{
			case STATUS_ZMX_NEED_TO_READ_ZMX:
				return(0);
			default:
			case STATUS_ZMX_NEED_TO_MAKE_ALL:
				if(INDEX_RIC_SUPPLIED==molecule->ric[molecule->i])
					buildstructure(detail,molecule);
				else
					buildmolecule(detail,molecule);
			case STATUS_ZMX_NEED_TO_MAKE_MLS:
				buildmls(detail,molecule,ne,elemental);
			case STATUS_ZMX_NEED_TO_MAKE_RTA:
				estimateamplitude(detail,molecule,ne,elemental);
			case STATUS_ZMX_NEED_TO_MAKE_AMPLITUDE:
				scaleamplitude(detail,molecule,ne,elemental);
			case STATUS_ZMX_NEED_TO_MAKE_ANHARMONIC:
				makediffractionlength(detail,molecule);
			case STATUS_ZMX_ALL_DONE: 
				if(update) molecule->preset[i]=STATUS_ZMX_ALL_DONE;
		}
        if(INDEX_KIND_XYZ==molecule->kind[molecule->i])
                switch(molecule->preset[i])
                {
                        case STATUS_ZMX_NEED_TO_READ_ZMX:
                                return(0);
                        default:
                        case STATUS_ZMX_NEED_TO_MAKE_ALL:
				if(INDEX_RIC_SUPPLIED==molecule->ric[molecule->i])
					buildstructure(detail,molecule);
                        case STATUS_ZMX_NEED_TO_MAKE_MLS:
				if(INDEX_MLS_EMPIRICAL==molecule->amp[molecule->i])
                                	buildmls(detail,molecule,ne,elemental);
				else
					updatemls(detail,molecule,ne,elemental);
                        case STATUS_ZMX_NEED_TO_MAKE_RTA:
				if(INDEX_MLS_EMPIRICAL==molecule->amp[molecule->i])
                                	estimateamplitude(detail,molecule,ne,elemental);
                        case STATUS_ZMX_NEED_TO_MAKE_AMPLITUDE:
                                scaleamplitude(detail,molecule,ne,elemental);
                        case STATUS_ZMX_NEED_TO_MAKE_ANHARMONIC:
                                makediffractionlength(detail,molecule);
                        case STATUS_ZMX_ALL_DONE:
                                if(update) molecule->preset[i]=STATUS_ZMX_ALL_DONE;
                }
	if(INDEX_KIND_MLS==molecule->kind[molecule->i])
		switch(molecule->preset[i])
		{
			case STATUS_ZMX_NEED_TO_READ_ZMX:
				return(0);
			default:
			case STATUS_ZMX_NEED_TO_MAKE_ALL:
			case STATUS_ZMX_NEED_TO_MAKE_MLS:
			case STATUS_ZMX_NEED_TO_MAKE_RTA:
			case STATUS_ZMX_NEED_TO_MAKE_AMPLITUDE:
				scaleamplitude(detail,molecule,ne,elemental);
			case STATUS_ZMX_NEED_TO_MAKE_ANHARMONIC:
				makediffractionlength(detail,molecule);
			case STATUS_ZMX_ALL_DONE: 
				if(update) molecule->preset[i]=STATUS_ZMX_ALL_DONE;
		}
	return(i);
}

int setmoleculemakesmt(int detail,int update
		,DIFFRACTION *data,MOLECULAR *molecule
		,int ne,ELEMENTAL *elemental,INSTRUMENTAL *instrument)
{
	ZMAT *z;
	int j,mi=molecule->i,mn=molecule->n;
	int i[4];
	int n[4]={1,1,1,1};
	double w4,THRESHOLD=1.0E-6;
	for(molecule->i=0;molecule->i<mn;molecule->i++)
	{
		z=&(molecule->zmx[molecule->i]);
		z->nr=rotationalweight(0,molecule);
		if(detail) if(z->nr) fprintf(stderr,"* molecule %d has %d internal rotations\n"
					,1+molecule->i,z->nr);
		if(z->nr)
		{
			for(j=0;j<z->nr;j++) n[j]=NUM_BIN_INT_ROT;
			for(j=0;j<z->nz;j++) z->rf[j]=z->r[j];
			for(j=0;j<data->se;j++) z->sm[j]=0;
			for(i[3]=0;i[3]<n[3];i[3]++)
			{
			 for(i[2]=0;i[2]<n[2];i[2]++)
			 {
			  for(i[1]=0;i[1]<n[1];i[1]++)
			  {
			   for(i[0]=0;i[0]<n[0];i[0]++)
			   {
				w4=1;
				for(j=0;j<z->nr;j++) w4*=z->w[z->ir[j]][i[j]];
				if(w4>THRESHOLD) 
				{
				for(j=0;j<z->nz;j++) z->r[j]=z->rf[j];
				for(j=0;j<z->nr;j++)
					z->r[z->ir[j]]+=z->rs[z->ir[j]]+(z->re[z->ir[j]]-z->rs[z->ir[j]])/n[j]*i[j];
					//z->r[z->ir[j]]=z->re[z->ir[j]]+360/n[j]*i[j];
				evaluatecoordinates(z);
				molecule->preset[molecule->i]=STATUS_ZMX_NEED_TO_MAKE_ALL;
				setmolecule(0,0,molecule,ne,elemental);
				makesmtmolecule(data,molecule,ne,elemental,instrument);
				 for(j=1;j<data->se;j++) 
					z->sm[j]+=w4*data->smt[molecule->i][j];
				//if(1)
				// {
				//  fprintf(stderr,"%5d %5d %5d %5d %20.15lf",i[3],i[2],i[1],i[0],w4);
				//  for(j=0;j<z->nr;j++)
				//	fprintf(stderr,"%10.3lf",z->r[z->ir[j]]);
				//  fprintf(stderr,"\n");
				// }
				}
			   }
			  }
			 }
			}
			for(j=0;j<z->nz;j++) z->r[j]=z->rf[j];
			molecule->preset[molecule->i]=STATUS_ZMX_NEED_TO_MAKE_ALL;
			setmolecule(detail,update,molecule,ne,elemental);
			for(j=1;j<data->se;j++) 
				data->smt[molecule->i][j]=z->sm[j];
		}
		else
		{
			setmolecule(detail,update,molecule,ne,elemental);
			makesmtmolecule(data,molecule,ne,elemental,instrument);
		}
	}
	molecule->i=mi;
	return(mi);
}

double singlepoint(int detail,int update
		,DIFFRACTION *data,MOLECULAR *molecule
		,int ne,ELEMENTAL *elemental,INSTRUMENTAL *instrument,FITTING *fit)
{
	double chi2;
	switch(data->preset)
	{
		default:
			preparation(detail,update,data,molecule,ne,elemental,instrument,fit);
		case STATUS_NEED_TO_MAKE_MOLECULAR :
			setmoleculemakesmt(detail,update,data,molecule,ne,elemental,instrument);
		case STATUS_NEED_TO_MAKE_LINEAR :
			calculatelinears(detail,data,molecule,fit);
		case STATUS_NEED_TO_MAKE_CURVES :
			makescaledata(data,molecule);
			chi2=evaluatechisqr(detail,data,molecule);
			if(update) data->preset=STATUS_DONE_WITH_LINEAR;
	}
	return(data->chisqr);
}

void setcameralength(double length,DIFFRACTION *data,INSTRUMENTAL *instrument)
{
	data->preset=STATUS_NEED_TO_MAKE_ALL;
	instrument->CameraLength=length;
	return;
}

double fittingcamera(int detail,double step,DIFFRACTION *data,MOLECULAR *molecule,int ne,ELEMENTAL *elemental,INSTRUMENTAL *instrument,FITTING *fit)
{
	int i;
	double length,distance;
	double chi2,x[3],y[3];

	length=instrument->CameraLength;
	x[1]=instrument->CameraLength;
	y[1]=data->chisqr;
	setcameralength(length-step,data,instrument);
	x[0]=instrument->CameraLength;
	y[0]=singlepoint(detail,0,data,molecule,ne,elemental,instrument,fit);
	setcameralength(length+step,data,instrument);
	x[2]=instrument->CameraLength;
	y[2]=singlepoint(detail,0,data,molecule,ne,elemental,instrument,fit);
	distance=polyminima(3,x,y);
	instrument->CameraLength=distance;
	chi2=singlepoint(detail,0,data,molecule,ne,elemental,instrument,fit);
	
	if(detail) 
		for(i=0;i<3;i++)
			fprintf(stderr,"        %20s %20.16lf %20.16le \n","",x[i],y[i]);
	return(distance);
}

int fitcamera(int detail,DIFFRACTION *data,MOLECULAR *molecule,int ne,ELEMENTAL *elemental,INSTRUMENTAL *instrument,FITTING *fit)
{
	int i;
	double step=STEPCAMERA;
	double length,distance,jump,change,oldchi2=0,previous=0;
	for(i=0;i<MAX_ITERATION;i++)
	{
		length=instrument->CameraLength;
		oldchi2=data->chisqr;
		distance=fittingcamera(0,step,data,molecule,ne,elemental,instrument,fit);
		jump=distance-length;
		change=data->chisqr-oldchi2;
		if(fabs(jump+previous)<0.01*(fabs(jump)+fabs(previous))) step/=2;
		else previous=jump;
		if(detail)
			fprintf(stderr,"    %5d: camera= %20.16lf jump= %20.16lf chi2= %20.16le delta= %20.16le\n"
				,i,distance,jump,data->chisqr,change);
		jump=fabs(distance-length);
		if(jump*2<step) step/=2;
		if(jump<=TOLERANCE_CAMERA && jump<=0) break;
	}
	return(0);
}

