#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "instrumental.h"
#include "programming.h"
#include "status.h"

#include "calculate.h"
#include "evaluate.h"
#include "interface.h"
#include "setstructure.h"
#include "leastsquare.h"
#include "jacobi.h"
#include "fitmarquardt.h"
#include "montecarlo.h"
#include "outputs.h"
#include "errors.h"
#include "numericalfit.h"
#include "fitinternal.h"

int calculatecartesianinternal(int detail,DIFFRACTION *data,MOLECULAR *molecule,int ne,ELEMENTAL *elemental,INSTRUMENTAL *instrument,FITTING *fit)
{
	INTERNAL *h=molecule->h+molecule->i;
	int i,j,ng=0,update=0;
	int is=data->cs,ie=data->ce;
	int range=ie-is,mb=1;
	int np=0,nc=0,nt=0,nr=0,nz=0,nv=0;
	double chi2=data->chisqr;
	double *p,*q,**r,**s,*beta,**alpha,**dyda,*oneda,**covar,**b,*da,**d2yda2=NULL;
	double *gr,*hr,*u,*hc;

	if(NULL==(gr=(double *)calloc(h->nr,sizeof(double)))) uerror("calculatecartesianinternal","lack of memory");
	if(NULL==(hr=(double *)calloc(h->nr*h->nr,sizeof(double)))) uerror("calculatecartesianinternal","lack of memory");
	if(NULL==(hc=(double *)calloc(h->nc*h->nc,sizeof(double)))) uerror("calculatecartesianinternal","lack of memory");
	if(NULL==(u=(double *)calloc(h->nr*h->nc,sizeof(double)))) uerror("calculatecartesianinternal","lack of memory");

	if(NULL==(r=(double **)calloc(h->nc,sizeof(double*)))) uerror("calculatecartesianinternal","lack of memory");
	if(NULL==(beta=(double *)calloc(h->nc,sizeof(double)))) uerror("calculatecartesianinternal","lack of memory");
	if(NULL==(alpha=(double **)calloc(h->nc,sizeof(double*)))) uerror("calculatecartesianinternal","lack of memory");
	for(i=0;i<h->nc;i++)
		if(NULL==(alpha[i]=(double *)calloc(h->nc,sizeof(double)))) uerror("calculatecartesianinternal","lack of memory");
	if(NULL==(dyda=(double **)calloc(h->nc,sizeof(double*)))) uerror("calculatecartesianinternal","lack of memory");
	for(i=0;i<h->nc;i++)
		if(NULL==(dyda[i]=(double *)calloc(range,sizeof(double)))) uerror("calculatecartesianinternal","lack of memory");
	if(fit->d2yda2)
	{
		if(NULL==(d2yda2=(double **)calloc(h->nc,sizeof(double*)))) uerror("calculatecartesianinternal","lack of memory");
		for(i=0;i<h->nc;i++)
			if(NULL==(d2yda2[i]=(double *)calloc(range,sizeof(double)))) uerror("calculatecartesianinternal","lack of memory");
	}

	if(NULL==(covar=(double **)calloc(h->nr,sizeof(double*)))) uerror("calculatecartesianinternal","lack of memory");
	for(i=0;i<h->nr;i++)
		if(NULL==(covar[i]=(double *)calloc(h->nr,sizeof(double)))) uerror("calculatecartesianinternal","lack of memory");

	for(i=0;i<h->nc;i++)
	{
		fit->nonlinear[i]=INDEX_FIT_COORDINATE;
		r[i]=h->cc+i;
		setpreset(&(molecule->preset[molecule->i]),STATUS_ZMX_NEED_TO_MAKE_MLS);
	}
	setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);

	preparesearch(detail,h->nc,fit);

	differentiate(h->nc,STEPSCALE,r,dyda,beta,alpha,data,molecule,ne,elemental,instrument,fit);
	//differentiate2(h->nc,STEPSCALE,r,dyda,d2yda2,beta,alpha,data,molecule,ne,elemental,instrument,fit);
	for(i=0;i<h->nc;i++)
		for(j=0;j<h->nc;j++)
			hc[rindex(i,j,h->nc,h->nc)]=alpha[i][j];
	instantaneousinternal(h->r,h);
	fDGEMV('T',h->nc,h->nr,1.0,h->bi,h->nc,beta,1,0.0,gr,1);
	fDGEMM('T','N',h->nr,h->nc,h->nc,1.0,h->bi,h->nc,hc,h->nc,0.0,u,h->nr);
	fDGEMM('N','N',h->nr,h->nr,h->nc,1.0,u,h->nr,h->bi,h->nc,0.0,hr,h->nr);
	for(i=0;i<h->nr;i++)
		for(j=0;j<h->nr;j++)
			if(fit->internal[molecule->i][i]&&fit->internal[molecule->i][j])
				covar[i][j]=hr[rindex(i,j,h->nr,h->nr)];
			else
				covar[i][j]=0;
	cjacobisolve(covar,h->nr,&beta,0,JACOBI_NONLINEAR_SMALL,JACOBI_NONLINEARS);
	fprintf(stderr,"\n");
	for(i=0;i<h->nr;i++)
		fprintf(stderr,"r[%d]= %+lf +/- %lf\n",i,h->r[i],sqrt(fabs(covar[i][i])));
	fprintf(stderr,"\n");
	for(i=0;i<h->nc;i++)
		fprintf(stderr,"i= %d g= %+le\n",i+1,beta[i]);
	fprintf(stderr,"\n");
	if(h->nc<10)
	{
		for(i=0;i<h->nc;i++)
		{
			fprintf(stderr,"i= %d h=",i+1);
			for(j=0;j<h->nc;j++)
				fprintf(stderr," %+10.3le",hc[rindex(i,j,h->nc,h->nc)]);
				//fprintf(stderr," %+10.3le",alpha[i][j]);
			fprintf(stderr,"\n");
		}
	}
	fprintf(stderr,"\n");
	for(i=0;i<h->nr;i++)
		fprintf(stderr,"i= %d g= %+le\n",i+1,gr[i]);
	fprintf(stderr,"\n");
	for(i=0;i<h->nr;i++)
	{
		if(fit->internal[molecule->i][i])
		{
			fprintf(stderr,"i= %d h=",i+1);
			for(j=0;j<h->nr;j++)
				if(fit->internal[molecule->i][j])
					fprintf(stderr," %+10.3le",hr[rindex(i,j,h->nr,h->nr)]);
			fprintf(stderr,"\n");
		}
	}
	fprintf(stderr,"\n");

	if(fit->d2yda2)
	{
		for(i=0;i<h->nc;i++)
			free(d2yda2[i]);
		free(d2yda2);
	}
	for(i=0;i<h->nc;i++)
		free(dyda[i]);
	free(dyda);
	for(i=0;i<h->nc;i++)
		free(alpha[i]);
	free(alpha);
	free(beta);
	free(r);

	free(u);
	free(hc);
	free(hr);
	free(gr);

	return(np);
}

