#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "instrumental.h"
#include "programming.h"
#include "errors.h"
#include "jacobi.h"

#include "mathematical.h"

int profileadd(double *y, int i, double c,ELECTRONPROFILE e)
{
	int j,n;
	for(j=0;j<e.nprofile;j++) {
		n=abs(i+e.jprofile[j]);
		if(n<MAX_NUM_DATA) y[n]+=c*e.eprofile[j];
		else  y[MAX_NUM_DATA-1]+=c*e.eprofile[j];
	}
	return(e.nprofile);
}
int boxcaradd(double *y, int i, double c)
{
	int j,k;
	double size;
	static double shape[9]={
			0.0030044983343748,
			0.0218563743379420,
			0.0946550730524391,
			0.2278395382299989,
			0.3052890320904902,
			0.2278395382299989,
			0.0946550730524392,
			0.0218563743379420,
			0.0030044983343748 };

	int method=6;

	switch(method) {
		case 1:
			y[i]+=c;
			return(1);
			break;
		case 2: // 0 1 2 1 0
			if(i>0) y[i-1]+=c*0.25;
			y[i]+=c*0.5;
			if(i<MAX_NUM_DATA-1) y[i+1]+=c*0.25;
			return(2);
			break; 
		case 3:	// 0 1 2 3 2 1 0
			if(i>1) y[i-2]+=c*1.0/9.0;
			if(i>0) y[i-1]+=c*2.0/9.0;
			y[i]+=c*3.0/9.0;
			if(i<MAX_NUM_DATA-1) y[i+1]+=c*2.0/9.0;
			if(i<MAX_NUM_DATA-2) y[i+1]+=c*1.0/9.0;
			return(2);
			break; 
		case 4:
			size=1.0/3.0;
			for(j=-1;j<2;j++) {
				k=abs(i+j);
				if(k< MAX_NUM_DATA) y[k]+=size*c;
				else y[MAX_NUM_DATA-1]+=c*shape[j+4];
			}
			return(3);
			break;
		case 6:
			for(j=-4;j<=5;j++) {
				k=abs(i+j);
				if(k<MAX_NUM_DATA) y[k]+=c*shape[j+4];
				else y[MAX_NUM_DATA-1]+=c*shape[j+4];
			}
			return(3);
			break;
	}
	return(0);
}

double polybinminima(int n, double *x, double *y)
{
	double a,b,c,xm;
	c=y[1];
	b=0.5*(y[2]-y[0]);
	a=0.5*(y[2]+y[0])-c;
	if(a>0) xm=-0.5*b/a;
	else 
	{
		if(y[0]>y[2]) xm=1;
		else xm=-1;
	}
	return(xm);
}

double polyminima(int n, double *x, double *y)
{
	double xm,xi;
	xi=polybinminima(3,x,y);
	xm=(x[2]-x[1])*xi+x[1];
//	fprintf(stderr,"    new minimum is %lf\n",xm);
	return(xm);
}

int polynomialfit(int m,double *y,double *x,int n,double *p)
{
	int i,j,k,g;
	double **a,*b,*pc,t;
	if(NULL==(a=(double **)calloc(n,sizeof(double *)))) uerror("polynomialfit","lack of memory");
	for(i=0;i<n;i++)
		if(NULL==(a[i]=(double *)calloc(n,sizeof(double)))) uerror("polynomialfit","lack of memory");
	if(NULL==(b=(double *)calloc(n,sizeof(double)))) uerror("polynomialfit","lack of memory");
//	if(NULL==(pc=(double *)calloc(n,sizeof(double)))) uerror("polynomialfit","lack of memory");

	for(i=0;i<n;i++)
	{
		for(j=0;j<=i;j++)
		{
			t=0;
			for(k=0;k<m;k++)
				t+=pow(x[k],i)*pow(x[k],j);
			a[i][j] = a[j][i] = t;
		}
	}
	for(j=0;j<n;j++)
	{
		t=0;
		for(k=0;k<m;k++)
			t+=y[k]*pow(x[k],j);
		b[j]=t;
	}
	JACOBI_DEBUG=0;
	g = cjacobisolve(a,n,&b,1,13,0);
	JACOBI_DEBUG=1;
	for(j=0;j<n;j++)
		p[j]=b[j];

//	free(pc);
	free(b);
	for(i=0;i<n;i++) free(a[i]);
	free(a);
	return(g);
}

double polynomialvalue(double x,int n,double *p)
{
	int i;
	double y=0;
	for(i=0;i<n;i++)
		y+=p[i]*pow(x,i);
	return(y);
}

//	this interpolation is so simple. find a better one //

double loginterpolated(double *es,double s,double ds)
{
	double si,sd,its;
	int i;
	i=(int)floor(s/ds);
	si=i*ds;
	sd=(s-si)/ds;
	its=exp((1-sd)*log(es[i])+sd*log(es[i+1]));
	return(its);
}

double interpolated(double *es,double s,double ds)
{
	double si,sd,its;
	int i;
	i=(int)floor(s/ds);
	si=i*ds;
	sd=(s-si)/ds;
	its=(1-sd)*es[i]+sd*es[i+1];
	return(its);
}

double interpolatedslope(double *es,double s,double ds)
{
	double si,sd,its;
	int i;
	i=(int)floor(s/ds);
	si=i*ds;
	sd=(s-si)/ds;
	its=(es[i+1]-es[i])/(ds);
	return(its);
}

int getcorrfactors(int ne, ELEMENTAL *elemental, DIFFRACTION *data)
{
	int i,j;
	double s;
	for(i=0;i<MAX_NUM_DATA;i++) 
	{
		s=data->s[i];
		for(j=0;j<ne;j++)
		{
			elemental[j].si[i]=interpolated(elemental[j].S,s,INELASTICSCATTERINGBINNING);
			elemental[j].fi[i]=loginterpolated(elemental[j].fe,s,ELASTICSCATTERINGBINNING);
			elemental[j].ni[i]=interpolated(elemental[j].ne,s,ELASTICSCATTERINGBINNING);
		}
	}
	return(i);
}

int makecorrfactors(int ne, ELEMENTAL *elemental, DIFFRACTION *data)
{
	int i,j;
	double s,costheta;
	for(j=0;j<ne;j++)
	{
		for(i=0;i<MAX_NUM_DATA;i++) 
		{
			s=data->s[i]/ELASTICSCATTERINGBINNING;
			costheta=cos(data->theta[i]);
			elemental[j].fi[i]=FSIFN(uniformnaturalcubicsplint(ELASTICSCATTERINGPREDATA,elemental[j].logfe,elemental[j].f2,s));
			elemental[j].ni[i]=uniformnaturalcubicsplint(ELASTICSCATTERINGPREDATA,elemental[j].ne,elemental[j].n2,s);
		//	elemental[j].si[i]=uniformnaturalcubicsplint(INELASTICSCATTERINGPREDATA,elemental[j].S,elemental[j].S2,s);
			s=data->s[i]/INELASTICSCATTERINGBINNING;
			costheta=cos(data->theta[i]);
			elemental[j].si[i]=uniformnaturalcubicsplint(
				INELASTICSCATTERINGPREDATA,
				elemental[j].S,
				elemental[j].S2,
				s*costheta)*pow(costheta,-4)*cos(2*data->theta[i]);
			if(data->theta[i]>M_PI_4) elemental[j].si[i]=0;
		//	fprintf(stderr," j= %d i= %d sc= %le rc= %le\n",j,i,costheta,pow(costheta,-4)*cos(2*data->theta[i]));
		//	fprintf(stdout," j= %d i= %d s= %lf f= %lf n= %lf S= %lf\n",j,i,data->s[i],elemental[j].fi[i],elemental[j].ni[i],elemental[j].si[i]);
		
		}
	}
	return(i);
}

int checkfactors(int ne, ELEMENTAL *elemental, DIFFRACTION *data)
{
	int i,j;
	double s;
	for(i=0;i<MAX_NUM_DATA;i++) 
	{
		s=data->s[i];
		fprintf(stderr,"%5d%10.5lf",i,s);
		for(j=0;j<ne;j++)
		{
			fprintf(stderr,"%20.10le",elemental[j].fi[i]);
		}
		fprintf(stderr,"\n");
	}
	fprintf(stderr,"\n");

	return(i);
}

int smooth(int smo,int n,double *y)
{
	int i, j, smo2 = smo / 2;
	double  *coeff, tmpdata[14];
	static double s[11][14] = {
		{  35,  17, 12, -3,  0,  0,  0,  0,  0,  0,   0,   0,   0,   0 },
		{  21,   7,  6,  3, -2,  0,  0,  0,  0,  0,   0,   0,   0,   0 },
		{ 231,  59, 54, 39, 14,-21,  0,  0,  0,  0,   0,   0,   0,   0 },
		{ 429,  89, 84, 69, 44,  9,-36,  0,  0,  0,   0,   0,   0,   0 },
		{ 143,  25, 24, 21, 16,  9,  0,-11,  0,  0,   0,   0,   0,   0 },
		{1105, 167,162,147,122, 87, 42,-13,-78,  0,   0,   0,   0,   0 },
		{ 323,  43, 42, 39, 34, 27, 18,  7, -6,-21,   0,   0,   0,   0 },
		{2261, 269,264,249,224,189,144, 89, 24,-51,-136,   0,   0,   0 },
		{3059, 329,324,309,284,249,204,149, 84,  9, -76,-171,   0,   0 },
		{ 805,  79, 78, 75, 70, 63, 54, 43, 30, 15,  -2, -21, -42,   0 },
		{5175, 467,462,447,422,387,343,287,222,147,  62, -33,-138,-253 }
	};

	if (smo2 >= 2 && smo2 <= 12)
		coeff = s[smo2 - 2];
	else
	{
		fprintf(stderr,"    smoothing cannot be done with %d\n", smo2);
		return 0;
	}

	for (i = smo2; i < n - smo2 ; i++) 
	{
		if (i >= smo)
			y[i-smo2-1] = tmpdata[smo2];
		for (j = smo2; j > 0; j--)
			tmpdata[j] = tmpdata[j-1];
		tmpdata[0] = coeff[1] * y[i];
		for (j = smo2; j > 0; j--)
			tmpdata[0] += coeff[j+1] * (y[i-j]+y[i+j]);
		tmpdata[0] /= coeff[0];
	}
	for (i = 0; i <= smo2; i++)
	y[n-smo2-1-i] = tmpdata[i];
	return 1;
}

void uniformnaturalcubicspline(int n,double *y,double *y2)
{
	double *u,sig,p;
	if(NULL==(u=(double*)calloc(n,sizeof(double)))) uerror("uniformcubicspline","memory");
	int i,j;
	y2[0]=0;
	u[0]=0;
	for(i=1;i<n-1;i++)
	{
		sig=0.5;
		p=sig*y2[i-1]+2;
		y2[i]=(sig-1)/p;
		u[i]=(6*((y[i+1]-y[i])/(1)-(y[i]-y[i-1])/(1))/(2)-sig*u[i-1])/p;
	}
	y2[n-1]=0;
	for(i=n-2;i>=0;i--)
		y2[i]=y2[i]*y2[i+1]+u[i];
	free(u);
}

double uniformnaturalcubicsplint(int n,double *y,double *y2,double ix)
{
	int kl=(int)floor(ix);
	int kh=(int)ceil(ix);
	if(kl< 0) return 0;
	if(kh>=n) return 0;
	if(kl==kh) return y[kl];
	double h=kh-kl;
	double a=kh-ix;
	double b=ix-kl;
	double v=a*y[kl]+b*y[kh]+(a*(a*a-1)*y2[kl]+b*(b*b-1)*y2[kh])*h/6;
	return v;
}

