#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "programming.h"
#include "instrumental.h"

#include "readpredata.h"
#include "readzmatrix.h"
#include "errors.h"

#include "outputs.h"

int uedmessage(char *s)
{
	fprintf(stderr,"################################################################################\n");
	fprintf(stderr,"####  %s\n",s);
	fprintf(stderr,"################################################################################\n");
	return(1);
}

int updatesmscurves(int detail,char *fn,DIFFRACTION *data)
{
	FILE *fp;
	if(NULL==(fp=fopen(fn,"wt"))) ioerror(fn);
	else
	{
		printsmscurves(detail,fp,data);
		fclose(fp);
		if(detail) fprintf(stderr,"    sms curves saved in %s\n",fn);
	}
	return(1);
}

int updatesmtcurves(int detail,char *fn,DIFFRACTION *data,MOLECULAR *molecule)
{
	FILE *fp;
	if(NULL==(fp=fopen(fn,"wt"))) ioerror(fn);
	else
	{
		printsmtcurves(detail,fp,data,molecule);
		fclose(fp);
		if(detail) fprintf(stderr,"    smt curves saved in %s\n",fn);
	}
	return(1);
}

int updatefrdcurves(int detail,char *fn,DIFFRACTION *data)
{
	FILE *fp;
	if(NULL==(fp=fopen(fn,"wt"))) 
		ioerror(fn);
	else
	{
		printfrdcurves(detail,fp,data);
		fclose(fp);
		if(detail) fprintf(stderr,"    frd curves saved in %s\n",fn);
	}
	return(1);
}

int updaterfdcurves(int detail,char *fn,DIFFRACTION *data)
{
        FILE *fp;
        if(NULL==(fp=fopen(fn,"wt")))
                ioerror(fn);
        else
        {
                printrfdcurves(detail,fp,data);
                fclose(fp);
                if(detail) fprintf(stderr,"    frd curves saved in %s\n",fn);
        }
        return(1);
}

int updaterawcurves(int detail,char *fn,DIFFRACTION *data)
{
	FILE *fp;
	if(NULL==(fp=fopen(fn,"wt"))) 
		ioerror(fn);
	else
	{
		printrawcurves(detail,fp,data);
		fclose(fp);
		if(detail) fprintf(stderr,"    raw curves saved in %s\n",fn);
	}
	return(1);
}

int printsmscurves(int detail,FILE *fp,DIFFRACTION *data)
{
	int is;
	double s,x,t,d;
	for(is=data->ss;is<data->se;is++)
	{
		s=data->s[is];
		t=data->sMt[is];
		x=data->smc[is];
		fprintf(fp,"%5d%20.10lf",is,s);
		fprintf(fp,"%20.10lf",t);
		if(detail>1||(data->cs<=is && is<data->ce))
		{
			d=x-t;
			fprintf(fp,"%20.10lf",x);
			fprintf(fp,"%20.10lf",d);
			fprintf(fp,"%20.10lf",-data->bkg[is]);
			fprintf(fp,"%20.10lf",data->w[is]);
			fprintf(fp,"%20.10lf",data->wg[is]);
			// fprintf(fp,"%20.10lf",data->sAt[is]);
			// fprintf(fp,"%20.10lf",data->irt[is]);
		}
		fprintf(fp,"\n");
	}
	return(is);
}

int printsmtcurves(int detail,FILE *fp,DIFFRACTION *data,MOLECULAR *molecule)
{
	int is,i,n=molecule->n;
	double s;
	for(is=data->ss;is<data->se;is++)
	{
		s=data->s[is];
		fprintf(fp,"%5d%20.10lf",is,s);
		fprintf(fp,"%20.10lf",data->sMt[is]);
		for(i=0;i<n;i++)
		{
			fprintf(fp,"%20.10lf",data->smt[i][is]);
		}
		fprintf(fp,"\n");
	}
	return(is);
}

int printfrdcurves(int detail,FILE *fp,DIFFRACTION *data)
{
	int j;
	double r,x,t,d;
	double sd=data->s[1]-data->s[0],fse=data->s[data->ce-1];
	int ns=(int)(fse/sd);
	int nr=ns*FRD_FFT_BIN;
	double f=FRDR(ns,sd,FRD_FFT_BIN);
	if(nr>MAX_NUM_FRD) nr=MAX_NUM_FRD;

	for(j=0;j<nr;j++)
	{
		r=f*j;
		t=data->frt[j];
		x=data->frx[j];
		d=x-t;
		fprintf(fp,"%5d%20.10lf",j,r);
		fprintf(fp,"%20.10lf",t);
		fprintf(fp,"%20.10lf",x);
		fprintf(fp,"%20.10lf",d);
		fprintf(fp,"\n");

	}
	return(j);
}

int printrfdcurves(int detail,FILE *fp,DIFFRACTION *data)
{
	int j;
	double r,x,t,d;
	double sd=data->s[1]-data->s[0],fse=data->s[data->ce-1];
	int ns=(int)(fse/sd);
	int nr=ns*FRD_FFT_BIN;
	double f=FRDR(ns,sd,FRD_FFT_BIN);
	if(nr>MAX_NUM_FRD) nr=MAX_NUM_FRD;
	fprintf(stderr,"# Dr= %lf\n",2*M_PI/(ns*sd));
	fprintf(stderr,"# dr= %lf\n",f);
	fprintf(stderr,"# rm= %lf\n (%d)",f*nr,nr);

        for(j=0;j<nr;j++)
        {
                r=f*j;
                t=r*data->frt[j];
                x=r*data->frx[j];
                d=x-t;
                fprintf(fp,"%5d%20.10lf",j,r);
                fprintf(fp,"%20.10lf",t);
                fprintf(fp,"%20.10lf",x);
                fprintf(fp,"%20.10lf",d);
                fprintf(fp,"\n");

        }
        return(j);
}

int printrawcurves(int detail,FILE *fp,DIFFRACTION *data)
{
	int is;
	double s,sf,m,a,b,x,y;
	for(is=data->ss;is<data->se;is++)
	{
		s=data->s[is];
		// if(is) sf=1/(data->sf[is]*data->irt[is]); else sf=0;
		if(is) sf=1/(data->sf[is]); else sf=0;
		//sf=1/s;
		x=data->smc[is]*sf;
		y=data->smx[is]*sf;
		m=data->sMt[is]*sf;
		a=data->sAt[is]*sf;
		b=data->bkg[is]*sf;
		fprintf(fp,"%5d",is);
		fprintf(fp,"%20.10lf",(m+a)/data->irt[is]);
		fprintf(fp,"%20.10lf",(a)/data->irt[is]);
		fprintf(fp,"%20.10lf",y);
		fprintf(fp,"%20.10lf",s);
		fprintf(fp,"%20.10lf",a);
		fprintf(fp,"%20.10lf",m);
		fprintf(fp,"%20.10lf",m+a);
		fprintf(fp,"%20.10lf",x+a+b);
		fprintf(fp,"%20.10lf",b);
		//fprintf(fp,"%5d%20.10lf",is,s);
		//fprintf(fp,"%20.10lf",m+a);
		//fprintf(fp," lvf= %20.10lf",data->sf[is]);
		//fprintf(fp," irt= %20.10lf",data->irt[is]);
		//fprintf(fp," iat= %20.10lf",data->iat[0][is]);
		//fprintf(fp," imt= %20.10lf",data->imt[0][is]);
		//fprintf(fp,"  Ix= %20.10lf",data->smx[is]*sf);
		//fprintf(fp,"  Id= %20.10lf",data->sdx[is]*sf);
		//fprintf(fp,"  Rx= %20.10lf",data->imx[is]);
		//fprintf(fp,"  Rd= %20.10lf",data->snx[is]);
		fprintf(fp,"\n");
	}
	return(is);
}

int printrweights(FILE *fp,MOLECULAR *molecule)
{
	ZMAT *z=&(molecule->zmx[molecule->i]);
	int i,j,ir,n=NUM_BIN_INT_ROT;;
	for(j=0;j<n;j++)
	{
		fprintf(fp,"%4d: ",j*360/n);
		for(i=0;i<z->nr;i++)
		{
			ir=z->ir[i];
			fprintf(fp,"%8.4lf",z->w[ir][j]);
		}
		fprintf(fp,"\n");
	}
	return (z->nr);
}

int printmolecule(FILE *fp,MOLECULAR *molecule, int ne, ELEMENTAL *ele)
{
	ATOMIC *atom=&(molecule->atomic[molecule->i]);
	int i;
	for(i=0;i<atom->na;i++)
		fprintf(fp,"%-2s %20.10lf %20.10lf %20.10lf\n"
				,ele[atom->et[i]].symbol
				,atom->q[i][0],atom->q[i][1],atom->q[i][2]);
	return(atom->na);
}

int printpdbfile(FILE *fp,MOLECULAR *molecule, int ne, ELEMENTAL *ele)
{
	ATOMIC *atom=&(molecule->atomic[molecule->i]);
	int i;
	rotatemolecule(0,molecule);
	fprintf(fp,"REMARK   %s  PDB FILE\n","molecule");
	fprintf(fp,"REMARK   CREATED: Thu Dec 05 00:00:00 2002\n");
	for(i=0;i<atom->na;i++)
		fprintf(fp,"ATOM  %5d  %-2s   MOL %5d     %7.3lf %7.3lf %7.3lf %5.2lf %5.2lf\n"
				,i+1,ele[atom->et[i]].symbol,1
				,atom->q[i][0],atom->q[i][1],atom->q[i][2]
				,1.0,0.0);
	fprintf(fp,"TER\n");
	return(atom->na);
}

int printmoldenfile(FILE *fp,MOLECULAR *molecule, int ne, ELEMENTAL *ele)
{
	ATOMIC *atom=&(molecule->atomic[molecule->i]);
	int i;
	rotatemolecule(0,molecule);
	fprintf(fp,"[Molden Format]\n");
	fprintf(fp,"[GEOMETRIES] XYZ\n");
	fprintf(fp," %d\n",atom->na);
	fprintf(fp,"\n");
	for(i=0;i<atom->na;i++)
		fprintf(fp," %-2s %20.10lf %20.10lf %20.10lf\n"
				,ele[atom->et[i]].symbol
				,atom->q[i][0],atom->q[i][1],atom->q[i][2]);
	return(atom->na);
}
