#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "programming.h"


// This function calulates the probability that the random variable X 
// lies in an interval w centered at x

double probability(double x,double w)
{
	double p=0;
	// p=0.5*(1+erf(x+0.5*w))-0.5*(1+erf(x-0.5*w));
	p=0.5*(erf(x+0.5*w)-erf(x-0.5*w));
	return(p);
}


// This function constructs a gaussian electron beam profile based on a supplied FWHM value 

int buildeprofile(ELECTRONPROFILE *e)
{
	double p,q,r,fwhm=e->width;
	int i,j=0,range=(int)(0.5+1*fwhm);
	if(range>MAX_NUM_PROFILE) range=MAX_NUM_PROFILE;
	r=sqrt(2*log(2))/fwhm*sqrt(2);				// r = 1/(sqrt(2)*stdev) 
	for(i=-range;i<=range;i++)				// for all points i within the FWHM
	{
		p=probability(i*r,r);				
		q=1-0.5*(1-erf((i-0.5)*r));			// the probability that the random variable X is smaller than (i-0.5)*r
		e->jprofile[j]=i;				// bin number
		e->eprofile[j]=p;				// probability inside bin
		fprintf(stderr,"%5d: %20.16lf %20.16lf %20.16lf\n",i,i*r,p,q);	 
		j++;
	}
	e->nprofile=1+2*range;					// the total number of bins
	q=0.5*(1-erf((range-0.5)*r));				// the probability that the random variable X is larger than (range-0.5)*r
	e->eprofile[0]=(e->eprofile[e->nprofile-1]=q);		// correct the profile at both tails
	fprintf(stderr," nprofile= %d\n",e->nprofile);		// print the number of bins
	for(j=0;j<e->nprofile;j++)
		fprintf(stderr,"%5d: %20d %20.16lf\n",j,e->jprofile[j],e->eprofile[j]);
	return(e->nprofile);
}

