#define DEBUG 0
#define DETAIL 1
#define RESPONSE 1
#define FRAGMENTALMLS 1

#define NUMERICALBETA 0

#define STRINGBUFFERSIZE 256
#define MAX_KEYWORDS 8
#define KEYWORDLENGTH 256
//#define KEYWORDLENGTH 8

// definitions for experimental data

#define MAX_NUM_DATA 670					// the maximum s value in pixel
#define MAX_NUM_POLY 8						// the maximum order of the background polynomial
#define MAX_NUM_PROFILE 32					// the maximum number of bins for the electron beam profile

#define MAX_MIXTURE 18						// the maximum number of species present in the ensemble 
#define MAX_NUM_ATOM 50						// maximum number of atoms in a molecular species
#define MAX_NUM_BOND ((MAX_NUM_ATOM)*(MAX_NUM_ATOM-1)/2)
#define MAX_NUM_ZMAT (3*(MAX_NUM_ATOM))
#define MAX_NUM_RIC  (6*(MAX_NUM_ATOM))
#define MAX_NUM_DEPENDENT 5
#define MAX_NUM_INT_ROT 4
//#define NUM_BIN_INT_ROT 360
#define NUM_BIN_INT_ROT 72
//#define NUM_BIN_INT_ROT 36
//#define NUM_BIN_INT_ROT 8

//#define FRD_FFT_BIN (12*M_PI)
#define FRD_FFT_BIN 16
#define FRD_FFT_MAX 4
//#define FRD_FFT_BIN (2*M_PI)
//#define FRD_FFT_MAX 12
#define FRDR(ns,sd,fine) (2*M_PI/((ns)*(sd))/(fine))
#define MAX_NUM_FRD (MAX_NUM_DATA*FRD_FFT_MAX)
#define MAX_NUM_FIT (1+MAX_NUM_POLY+MAX_MIXTURE)
#define MAX_HISTORY 50

#define MOLECULARNAMELENGTH 32
#define INTERNALCOORDINATELENGTH 32
#define ATOMICINDEXNAMELENGTH 32

// definitions for precalibrated data

#define MAX_NUCLEI 104
#define NUCLEICSYMBOLLENGTH 3

#define SCATTERINGENERGIES 4
#define ELASTICSCATTERINGBINNING 0.25
#define ELASTICSCATTERINGPREDATA 242
#define INELASTICSCATTERINGBINNING 1.0
#define INELASTICSCATTERINGPREDATA 66

// definitions for file I/O

#define ELEMENTfnFILENAME "/pgm/ueda-60kV/PREDATA/fn.dat"
// fn.dat contains a header line containing the different electron kinetic energies, after a blank line the body of the file contains
// 11 columns containing the atomic symbol, atomic charge, the monentum transfer vector (in A^-1), 
// and the elastic scattering amplitudes and phases for the respective electron kinetic energies. (see International Tables for Crytallography)
#define ELEMENTsiFILENAME "/pgm/ueda-60kV/PREDATA/Si.dat"	
// Si.dat contains 4 columns containing the atomic symbol, atomic charge,
// the monentum transfer vector (in A^-1), and the inelastic scattering factors. (see International Tables for Crytallography)

// definition for default values

#define DEFAULT_SPIX_START 	34
#define DEFAULT_SPIX_END 	210
#define DEFAULT_NUM_POLY 	5
#define CURRENTSMSFILENAME "_currentsms.dat"
#define CURRENTFRDFILENAME "_currentfrd.dat"

#define rindex(i,j,m,n)   ((j)*(m)+(i))           // i,j
#define uindex(i,j)       (((j)*((j)+1))/2 + (i)) // j,i
#define mindex(i,j)       (((j)*((j)-1))/2 + (i)) // j,i
#define binvalue(i,n,s,e) ((s)+((e)-(s))*(i)/(n))

typedef struct {
	double width;						// FWHM of the electron beam profile (in units of pixel)
	int nprofile;						// the total number of bins
	int jprofile[1+2*MAX_NUM_PROFILE];			// bin number
	double eprofile[1+2*MAX_NUM_PROFILE];			// probability histogram data
} ELECTRONPROFILE;

typedef struct {
	char symbol[NUCLEICSYMBOLLENGTH];			// atomic symbol	
	int charge;						// atomic charge
	double radius;						
	double E[SCATTERINGENERGIES];				// electron kinetic energy (in keV)
	double se[ELASTICSCATTERINGPREDATA];			// momentum transfer s (in A^-1)
	double si[INELASTICSCATTERINGPREDATA];			// momentum transfer s (in A^-1)
	double f[SCATTERINGENERGIES][ELASTICSCATTERINGPREDATA]; // elastic scattering amplitudes corresponding to array se at different kinetic energies 
	double n[SCATTERINGENERGIES][ELASTICSCATTERINGPREDATA];	// elastic scattering phases corresponding to array se at different kinetic energies
	double S[INELASTICSCATTERINGPREDATA];			// inelastic scattering factors corresponding to array si
	double logfe[ELASTICSCATTERINGPREDATA];
	double fe[ELASTICSCATTERINGPREDATA];
	double ne[ELASTICSCATTERINGPREDATA];
	double S2[INELASTICSCATTERINGPREDATA];
	double f2[ELASTICSCATTERINGPREDATA];
	double n2[ELASTICSCATTERINGPREDATA];
	double Si[MAX_NUM_DATA];
	double fi[MAX_NUM_DATA];
	double ni[MAX_NUM_DATA];
	double dSi[MAX_NUM_DATA];
	double dfi[MAX_NUM_DATA];
	double dni[MAX_NUM_DATA];
} ELEMENTAL;

typedef struct {
	int OverallTemperature;
	int Reference;				// Default: DIVIDEDBYREFNUCLEI 1
	char ReferenceAtom[NUCLEICSYMBOLLENGTH];  // the identity of atomic reference gas
	int sMs;				// defines the sMs Leveling function Default: INDEX_LEVELING_FIFJ 1
	char fi[NUCLEICSYMBOLLENGTH];		// identity of the atom fi for the leveling function
	char fj[NUCLEICSYMBOLLENGTH];		// identity of the atom fi for the leveling function
	int ElectronBeamSize;			// the size of the electron beam (FWHM ?)
	int polynomials;			// the type of background polynomial (see instrumental.h)
	double KineticEnergy;			// the kinetic energy of the electron beam in kV
	double CameraLength;
	double CameraLengthVariance;
	double PixelSize;			// the height or width in um of a detector pixel
	double dampingk;			// the damping parameter k for f(r) sine transformation
	double noise;
	ELECTRONPROFILE e;
} INSTRUMENTAL;

typedef struct {
	int ss;					// lower s range limit
	int se;					// upper s range limit
	int cs;					// lower s range limit of loaded experimental data
	int ce;					// upper s range limit of loaded experimental data
	int np;					// order of the polynomial background
	int preset;
	double R;				// Crystallographic R value (see ... for a definition)
	double chisqr;				// Chi squared value (see ... for a definition)
	double scale;				// scaling factor
	double atomicbackground;		// additional atomic background
	double pbc[MAX_NUM_POLY];		// coefficients of polynomial background
	double theta[MAX_NUM_DATA];
	double s[MAX_NUM_DATA];
	double s2[MAX_NUM_DATA];		// s2=s^2
	double s4[MAX_NUM_DATA];		// s4=s^4
	double ds[MAX_NUM_DATA];		// s binning for each pixel
	double damping[MAX_NUM_DATA];		// damping due to mol beam width
	double sf[MAX_NUM_DATA];		// s/(fifj)
	double w[MAX_NUM_DATA];			// weighting function
	double n[MAX_NUM_DATA];			// noise function
	double wg[MAX_NUM_DATA];		// weighting function
	double chi[MAX_NUM_DATA];		// smc - sMt
	double frx[MAX_NUM_FRD];		// experimental radial distribution
	double frt[MAX_NUM_FRD];		// theoretical radial distribution
	double bkg[MAX_NUM_DATA];		// background
	double imx[MAX_NUM_DATA];		// experimental intensity
	double snx[MAX_NUM_DATA];		// experimental standard deviation
	double smx[MAX_NUM_DATA];		// sf * imx
	double sdx[MAX_NUM_DATA];		// sf * snx
	double sme[MAX_NUM_DATA];		// - sf * imx
	double sMx[MAX_NUM_DATA];		// corrected experimental molecular scattering
	double smc[MAX_NUM_DATA];		// scaled and background corrected smx
	double sMt[MAX_NUM_DATA];		// theoretical molecular scattering
	double sAt[MAX_NUM_DATA];		// theoretical atomic scattering
	double irt[MAX_NUM_DATA];		// theoretical intensity of reference atom (Xe)
	double fifj[MAX_NUM_DATA];		// leveling function
	double iat[MAX_MIXTURE][MAX_NUM_DATA];
	double imt[MAX_MIXTURE][MAX_NUM_DATA];
	double sat[MAX_MIXTURE][MAX_NUM_DATA];
	double smt[MAX_MIXTURE][MAX_NUM_DATA];
	double sam[MAX_MIXTURE][MAX_NUM_DATA];
	double ps[MAX_NUM_POLY][MAX_NUM_DATA];
	char filename[STRINGBUFFERSIZE];
	double *noise;
} DIFFRACTION;

typedef struct {
	char molecule[MOLECULARNAMELENGTH];
	int na;
	int et0[MAX_NUM_ATOM];
	int ne0[MAX_NUM_ATOM];
	int nl;
	char a1[MAX_NUM_BOND][NUCLEICSYMBOLLENGTH];
	char a2[MAX_NUM_BOND][NUCLEICSYMBOLLENGTH];
	int et1[MAX_NUM_BOND];
	int et2[MAX_NUM_BOND];
	int d[MAX_NUM_BOND];
	double re[MAX_NUM_BOND];
	double ra[MAX_NUM_BOND];
	double rg[MAX_NUM_BOND];
	double lh[MAX_NUM_BOND];	// harmonic amplitude (read for mls or estimated for zmx)
	double lm[MAX_NUM_BOND];
	double dr[MAX_NUM_BOND];
	double a[MAX_NUM_BOND];
	double k[MAX_NUM_BOND];
	double mu[MAX_NUM_BOND];
	double nu[MAX_NUM_BOND];
	double T[MAX_NUM_BOND];
	double limit;
	double temperature;
} MLS;

typedef struct {
	char molecule[MOLECULARNAMELENGTH];
	int na;								// number of atoms
	int nz;								// number of internal coordinate
	int et[MAX_NUM_ATOM];						// type of element
	int eZ[MAX_NUM_ATOM];						// atomic number of element
	int zt[MAX_NUM_ZMAT];						// type of internal coordinate
	double r[MAX_NUM_ZMAT];						// value of internal coordinate
	double rf[MAX_NUM_ZMAT];					// value of internal coordinate of reference in ensembled structure
	char z[MAX_NUM_ZMAT][INTERNALCOORDINATELENGTH];			// name of internal coordinate
	char atom[MAX_NUM_ATOM][ATOMICINDEXNAMELENGTH];			// name of atom
	char reference[MAX_NUM_ATOM][3][ATOMICINDEXNAMELENGTH];		// name of referenced atoms
	char coordinate[MAX_NUM_ATOM][3][INTERNALCOORDINATELENGTH];	// z-matrices atom
	int ref[MAX_NUM_ATOM][3];					// index of referenced atom
	int zindex[MAX_NUM_ATOM][3];					// index of internal coordinate
	int nd[MAX_NUM_ZMAT];						// number of dependency
	int b[MAX_NUM_ZMAT][MAX_NUM_DEPENDENT];				// r = a[] * r[b[]]
	double a[MAX_NUM_ZMAT][MAX_NUM_DEPENDENT];
	double (*function[MAX_NUM_ZMAT])(double);

	int nr;				// number of internal rotation coordinate
	int ne;				// number of ensemble space
	int ir[MAX_NUM_INT_ROT];	// index of internal rotation coordinate
	int nb[MAX_NUM_INT_ROT];	// numbers of binning in rotations
	int ien[MAX_NUM_ZMAT];		// ensembled or not
	int ird[MAX_NUM_ZMAT];		// n-fold degeneracy of internal rotation coordinate
	double v0[MAX_NUM_ZMAT];	// potential energy of internal rotation
	double tv[MAX_NUM_ZMAT];	// temperature of internal rotation
	double rs[MAX_NUM_ZMAT];	// starting range
	double re[MAX_NUM_ZMAT];	// ending range
	double w[MAX_NUM_ZMAT][NUM_BIN_INT_ROT];	// weight of each bin
	double sm[MAX_NUM_DATA];
//	double sm[NUM_BIN_INT_ROT][NUM_BIN_INT_ROT][NUM_BIN_INT_ROT][NUM_BIN_INT_ROT][MAX_NUM_DATA];// this is too big
} ZMAT;

typedef struct {
        int type;
        int indices;
        int id[4];
        double r;
        double f;
} ZMx;

typedef struct {
	char molecule[STRINGBUFFERSIZE];
	int na;					// number of atoms
	int nc;					// number of cartesian coordinates
	int nr;					// number of redunant internal coordinates
	ZMx z[MAX_NUM_RIC];
	double r[MAX_NUM_RIC];
	double q[MAX_NUM_ATOM][3];
	double *cc;
	double *m;
	double *bt;
	double *mb;
	double *g;
	double *gi;
	double *gs;
	double *gq;
	double *bi;
	double *pi;
} INTERNAL;

typedef struct {
	char molecule[MOLECULARNAMELENGTH];
	char atom[MAX_NUM_ATOM][ATOMICINDEXNAMELENGTH];
	int na;
	int et[MAX_NUM_ATOM];
	int charge[MAX_NUM_ATOM];
	double m[MAX_NUM_ATOM][3];
	double q[MAX_NUM_ATOM][3];
} ATOMIC;

typedef struct {
	int n;					//
	int i;
	int j;
	int kind[MAX_MIXTURE];			// the kind of structure index used (zmx, xyz, mls, zmx_amp)
	int amp[MAX_MIXTURE];			// the type of amplitudes used
	int ric[MAX_MIXTURE];			// are redundant coordinates used
	int preset[MAX_MIXTURE];
	double fsum;				// the fraction sum of populations
	double fraction[MAX_MIXTURE];		// fraction of the population
	double temperature[MAX_MIXTURE];	// internal temperature of the species
	MLS mls[MAX_MIXTURE];
	ZMAT zmx[MAX_MIXTURE];
	ATOMIC atomic[MAX_MIXTURE];
	INTERNAL h[MAX_MIXTURE];
} MOLECULAR;

#define INDEX_KIND_ZMX		1
#define INDEX_KIND_XYZ		2
#define INDEX_KIND_MLS		3
#define INDEX_KIND_ZMX_AMP	4

#define INDEX_MLS_EMPIRICAL	0
#define INDEX_MLS_AMPLITUDE	1
#define INDEX_RIC_NONE		0
#define INDEX_RIC_SUPPLIED	1

// #define INDEX_KIND_ATOMIC	2
#define INDEX_ZMX_WRONG		    -999
#define INDEX_ZMX_UNUSED	       0
//#define INDEX_ZMX_UNUSED	     -11
#define INDEX_ZMX_BONDLENGTH 	       1
#define INDEX_ZMX_BENDINGANGLE	       2
#define INDEX_ZMX_DIHEDRAL	       3
#define INDEX_ZMX_DEPENDENT         -100
//#define INDEX_ZMX_DEPENDENT          0
#define INDEX_ZMX_DEPENDENT_LENGTH    -1
#define INDEX_ZMX_DEPENDENT_ANGLE     -2
#define INDEX_ZMX_DEPENDENT_DIHEDRAL  -3
#define INDEX_ZMX_FUNCTION           100

typedef struct {
	int background;
	int scalefactor;
	int fractions;			// sum of fractions
	int fraction[MAX_MIXTURE]; 	// linear parameters
	int atomicbackground;
	int camera;
	int cameravariance;
	int temperature[MAX_MIXTURE];
	int coordinates;
	int internal[MAX_MIXTURE][MAX_NUM_RIC]; 	// nonlinear parameters
	int coordinate[MAX_MIXTURE][MAX_NUM_ZMAT]; 	// nonlinear parameters
	int potential[MAX_MIXTURE][MAX_NUM_ZMAT]; 	// nonlinear parameters
	int linears;
	int nonlinears;
	int linear[1+MAX_NUM_POLY+MAX_MIXTURE];
	int nonlinear[1+(1+MAX_NUM_ZMAT)*MAX_MIXTURE];
	int update;
	int method;
	int d2yda2;
	int group;
	int coupled[2];
	long iteration;
	double alpha;
	double range[1+(1+MAX_NUM_ZMAT)*MAX_MIXTURE];
	double bin[1+(1+MAX_NUM_ZMAT)*MAX_MIXTURE];
	double step[1+(1+MAX_NUM_ZMAT)*MAX_MIXTURE];
} FITTING;

#define INDEX_FIT_MARQUARDT		0
#define INDEX_FIT_JACOBIEIGEN		1
#define INDEX_FIT_MONTECARLO		2
#define INDEX_FIT_SEARCH		3

#define INDEX_FIT_BACKGROUND 		0
#define INDEX_FIT_SCALEFACTOR 		1
#define INDEX_FIT_FRACTION 		2
#define INDEX_FIT_CAMERA 		3
#define INDEX_FIT_CAMERAVARIANCE 	4
#define INDEX_FIT_TEMPERATURE 		5
#define INDEX_FIT_COORDINATE 		6
#define INDEX_FIT_COORDINATE_BONDLENGTH 	(INDEX_FIT_COORDINATE+INDEX_ZMX_BONDLENGTH)		// 7
#define INDEX_FIT_COORDINATE_BENDINGANGLE 	(INDEX_FIT_COORDINATE+INDEX_ZMX_BENDINGANGLE)		// 8
#define INDEX_FIT_COORDINATE_DIHEDRAL		(INDEX_FIT_COORDINATE+INDEX_ZMX_DIHEDRAL)		// 9
#define INDEX_FIT_POTENTIAL 		10
#define INDEX_FIT_POTENTIAL_BONDLENGTH  	(INDEX_FIT_POTENTIAL+INDEX_ZMX_BONDLENGTH)		// 11
#define INDEX_FIT_POTENTIAL_BENDINGANGLE 	(INDEX_FIT_POTENTIAL+INDEX_ZMX_BENDINGANGLE)		// 12
#define INDEX_FIT_POTENTIAL_DIHEDRAL		(INDEX_FIT_POTENTIAL+INDEX_ZMX_DIHEDRAL)		// 13

#define INDEX_FIT_RADIAN_BENDINGANGLE 		(INDEX_FIT_COORDINATE)		// 6
#define INDEX_FIT_RADIAN_DIHEDRAL		(INDEX_FIT_COORDINATE)		// 6
