#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "programming.h"
#include "instrumental.h"
#include "status.h"

#include "leastsquare.h"
#include "gaussjordan.h"
#include "jacobi.h"
#include "tools.h"
#include "errors.h"

#include "radial.h"

int makefld(DIFFRACTION *data,INSTRUMENTAL *instrument)
{
	double MAXDISTANCE=32;
	int i,j,is,ng,fine=16;
	double ds=data->s[1]-data->s[0];
	int ns=(int)(data->s[data->ce]/ds);
	int np=data->ce-data->cs;
	double dr=FRDR(ns,ds,fine);
	int nr=ns*fine;
	double **p,**y,**x,*w;
	if(dr*nr>MAXDISTANCE) nr=MAXDISTANCE/dr;
	if(nr>MAX_NUM_FRD) nr=MAX_NUM_FRD;

	for(is=0;is<data->ss;is++)
		data->sMx[is]=0;
	for(is=data->ss;is<data->cs;is++)
		data->sMx[is]=data->sMt[is];
	for(is=data->cs;is<data->ce;is++)
		data->sMx[is]=data->smc[is];
	for(is=data->ce;is<data->se;is++)
		data->sMx[is]=data->sMt[is];

	fprintf(stderr," Linear prediction from %d to %d out of %d\n",data->cs,data->ce,data->se);

	if(NULL==(p=(double **)calloc(2,sizeof(double *)))) uerror("makefld","lack of memory");
	if(NULL==(y=(double **)calloc(2,sizeof(double *)))) uerror("makefld","lack of memory");
	if(NULL==(x=(double **)calloc(nr,sizeof(double *)))) uerror("makefld","lack of memory");
	for(j=0;j<nr;j++)
		if(NULL==(x[j]=(double *)calloc(np,sizeof(double)))) uerror("makefld","lack of memory");
	if(NULL==(w=(double *)calloc(np,sizeof(double)))) uerror("makefld","lack of memory");
	data->frt[0]=0;
	data->frx[0]=0;
	p[0]=data->frt+1;
	p[1]=data->frx+1;
	y[0]=data->sMt+data->cs;
	y[1]=data->sMx+data->cs;
	for(j=0;j<nr/2;j++)
	{
		for(i=0;i<np;i++)
		{
			x[j][i]=sin(data->s[i+data->cs]*(dr*(1+j)));
			x[j+nr/2][i]=cos(data->s[i+data->cs]*(dr*(1+j)));
		}
	}
	for(i=0;i<np;i++)
		w[i]=1;

	ng=weighted2leastsquare(1,nr,np,w,x,y,p);

	for(j=0;j<nr;j++)
		fprintf(stdout,"fld: %5d %+le %+le %+le\n",j,dr*(1+j),p[0][j],p[1][j]);

	free(w);
	for(j=0;j<nr;j++) free(x[j]);
	free(x);
	free(y);
	free(p);
	return(nr);
}

double weighted2leastsquare(int detail,int np,int nx,double *w,double **x,double **y,double **p)
{
	int method=3;
	int i,j,k,ng=0,ns=2;
	double **a,**b,*pc;
	double error;
	
	if(NULL==(a=(double **)calloc(np,sizeof(double *)))) uerror("weighted2leastsquare","lack of memory");
	for(i=0;i<np;i++)
		if(NULL==(a[i]=(double *)calloc(np,sizeof(double)))) uerror("weighted2leastsquare","lack of memory");
	if(NULL==(b=(double **)calloc(ns,sizeof(double *)))) uerror("weighted2leastsquare","lack of memory");
	for(i=0;i<ns;i++)
		if(NULL==(b[i]=(double *)calloc(np,sizeof(double)))) uerror("weighted2leastsquare","lack of memory");
	if(NULL==(pc=(double *)calloc(np,sizeof(double)))) uerror("weighted2leastsquare","lack of memory");

	for(i=0;i<np;i++)
	{
		for(j=0;j<=i;j++)
		{
			a[i][j]=0;
			for(k=0;k<nx;k++)
				a[i][j]+=w[k]*x[i][k]*x[j][k];
			a[j][i]=a[i][j];
		}
	}
	//printmatrix(np,a);
	for(j=0;j<ns;j++)
	{
		for(i=0;i<np;i++)
		{
			b[j][i]=0;
			for(k=0;k<nx;k++)
				b[j][i]+=w[k]*y[j][k]*x[i][k];
		}
	}

	if(detail>DETAIL_SO_MUCH) diagnosis(np,a);
	switch(method)
	{
		default:
		case 1: ng=cgaussjordan(a,np,b,ns);
			break;
		case 2: ng=choleskydecompose(np,a,pc);
			for(i=0;i<ns;i++)
				choleskysolve(np,a,pc,b[i],b[i]);
			// if(check) printmatrix(np,a);
			// if(check) check_cholesky();
			break;
		case 3: ng=cjacobisolve(a,np,b,ns,JACOBI_LINEAR_SMALL,0);
		//case 3: ng=cjacobisolve(a,np,b,ns,JACOBI_LINEAR_SMALL,32);
			break;
		case 4: for(j=0;j<ns;j++)
				for(i=0;i<np;i++)
					b[j][i]=b[j][i]/a[i][i];
			ng=4;
			break;
	}
	if(ng)
	{
		for(j=0;j<ns;j++)
			for(i=0;i<np;i++)
				p[j][i]=b[j][i];	// just replace b with p

		if(0)
		{
			if(2==method) 
			{
				choleskyinverselowertriangle(np,a,pc);
				choleskyinverse(np,a,pc);
			}
			//printmatrix(np,a);
			for(i=0;i<np;i++)
			{
				error=sqrt(fabs(a[i][i]));
				if(a[i][i]<0) error*=-1;
				fprintf(stderr,"#UED4# result for r[%d]= %+lf +/- (%lf x scalefactor)\n",i,p[1][i],error);
			}
		}
	}

	free(pc);
	for(i=0;i<ns;i++)
		free(b[i]);
	free(b);
	for(i=0;i<np;i++)
		free(a[i]);
	free(a);
	return(ng);
}

