#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "programming.h"
//#include "physicalconstants.h"

#include "errors.h"
//#include "initialize.h"
#include "intrinsic.h"
#include "readzmatrix.h"
#include "readinternal.h"

int deletememoryinternal(INTERNAL *h)
{
	int nr=h->nr;
	if(NULL==h->bi) return(0);
	free(h->pi);
	free(h->bi);
	free(h->gq);
	free(h->gs);
	free(h->gi);
	free(h->g);
	free(h->mb);
	free(h->bt);
	h->nr=0;
	return(nr);
}

int allocatememoryinternal(INTERNAL *h)
{
	int nc=h->nc;
	int nr=h->nr;
	if(NULL!=h->bi)
	{
		deletememoryinternal(h);
	}
	if(NULL==(h->bt=(double *)calloc(nr*nc,sizeof(double)))) uerror("allocatememoryinternal","bt");
	if(NULL==(h->mb=(double *)calloc(nr*nc,sizeof(double)))) uerror("allocatememoryinternal","mb");
	if(NULL==(h->g =(double *)calloc(nr*nr,sizeof(double)))) uerror("allocatememoryinternal","g");
	if(NULL==(h->gi=(double *)calloc(nr*nr,sizeof(double)))) uerror("allocatememoryinternal","gi");
	if(NULL==(h->gs=(double *)calloc(nr*nr,sizeof(double)))) uerror("allocatememoryinternal","gs");
	if(NULL==(h->gq=(double *)calloc(nr*nr,sizeof(double)))) uerror("allocatememoryinternal","gq");
	if(NULL==(h->bi=(double *)calloc(nr*nc,sizeof(double)))) uerror("allocatememoryinternal","bi");
	if(NULL==(h->pi=(double *)calloc(nr*nr,sizeof(double)))) uerror("allocatememoryinternal","pi");
	return(nr);
}

int readredundant(FILE *fp,INTERNAL *h,ZMAT *z)
{
	int i,j,nr;
	char buffer[STRINGBUFFERSIZE];
	char t[5][STRINGBUFFERSIZE];

	if(NULL==(fgets(buffer,STRINGBUFFERSIZE,fp))) uerror("readredundant","reading internal coordinates");
	sscanf(buffer,"%s",h->molecule);
	if(NULL==(fgets(buffer,STRINGBUFFERSIZE,fp))) uerror("readredundant","reading internal coordinates");
	sscanf(buffer,"%d%d",&(h->na),&(h->nr));
	h->nc=3*h->na;
	for(i=0;i<h->na;i++)
	{
		if(NULL==(fgets(buffer,STRINGBUFFERSIZE,fp))) uerror("readredundant","reading reference");
	}
	if(NULL==(fgets(buffer,STRINGBUFFERSIZE,fp))) uerror("readredundant","reading internal coordinates");
	for(i=0;i<h->nr;i++)
	{
		if(NULL==(fgets(buffer,STRINGBUFFERSIZE,fp)))
		{
			uerror("readredundant","reading references");
			break;
		}
		if(3>(nr=sscanf(buffer,"%s%s%s%s%s",t[0],t[1],t[2],t[3],t[4]))) break;
		if(isdigit(t[0][0])) h->z[i].type=atoi(t[0]);
		else if(!strcasecmp(t[0],"r")) h->z[i].type = BOND_STRETCHING ;
		else if(!strcasecmp(t[0],"z")) h->z[i].type = BOND_RECIPROCAL;
		else if(!strcasecmp(t[0],"z2")) h->z[i].type = BOND_RECIPROCAL2;
		else if(!strcasecmp(t[0],"z6")) h->z[i].type = BOND_RECIPROCAL6;
		else if(!strcasecmp(t[0],"a")) h->z[i].type = BENDING_ANGLE;
		else if(!strcasecmp(t[0],"b")) h->z[i].type = BENDING_ANGLE;
		else if(!strcasecmp(t[0],"a2")) h->z[i].type = BENDING2_ANGLE;
		else if(!strcasecmp(t[0],"b2")) h->z[i].type = BENDING2_ANGLE;
		else if(!strcasecmp(t[0],"t")) h->z[i].type = DIHEDRAL_ANGLE;
		else if(!strcasecmp(t[0],"d")) h->z[i].type = DIHEDRAL_ANGLE;
//		else if(!strcasecmp(t[0],"t2")) h->z[i].type = DIHEDRAL_360;
//		else if(!strcasecmp(t[0],"d2")) h->z[i].type = DIHEDRAL_360;
		else h->z[i].type=atoi(t[0]);
		h->z[i].indices=nr-1;
		switch(h->z[i].type)
		{
			case BOND_STRETCHING: 
			case BOND_RECIPROCAL: 
			case BOND_RECIPROCAL2: 
			case BOND_RECIPROCAL6: 
				h->z[i].indices=2; h->z[i].f=1; break;
			case BENDING_ANGLE: 
				h->z[i].indices=3; h->z[i].f=180/M_PI; break;
			case BENDING2_ANGLE: 
				h->z[i].indices=4; h->z[i].f=180/M_PI; break;
			case DIHEDRAL_ANGLE:
			case TANGENT_DIHEDRAL2:
			case TANGENT_PI_DIHEDRAL2: 
				h->z[i].indices=4; h->z[i].f=180/M_PI; break;
			case PLANAR_BENDING:
			case LINEAR_BENDING: 
				h->z[i].indices=4; h->z[i].f=180/M_PI; break;
			default: 
				h->z[i].f=1;
		}
		for(j=0;j<h->z[i].indices;j++)
			if(isalpha(t[j+1][0]))
				h->z[i].id[j]=findzreference(t[j+1],z->atom,z->na);
			else
				h->z[i].id[j]=atoi(t[j+1])-1;
	}
	if(i<h->nr)
	{
		fprintf(stderr,"########################################################\n");
		fprintf(stderr," you said %d coordinates, but i only find %d\n",h->nr,i);
		fprintf(stderr,"########################################################\n");
	}
	if(DETAIL)
		fprintf(stderr," read %d coordinates for %d atoms of %s\n"
			,h->nr,h->na,h->molecule);
	return(h->nr);
}

int writeredundant(int detail,FILE *fp,INTERNAL *h)
{
	int i,j;
	fprintf(fp,"molecule= %s\n",h->molecule);
	fprintf(fp,"number_of_atoms= %d\n",h->na);
	//for(i=0;i<h->na;i++)
	//	fprintf(fp," %4d   %s\n",i+1,h->ai[i].name);
	for(i=0;i<h->nr;i++)
	{
		fprintf(fp," %4d %4d",i+1,h->z[i].type);
		for(j=0;j<h->z[i].indices;j++)
			fprintf(fp," %4d",h->z[i].id[j]+1);
		for(j=h->z[i].indices;j<5;j++)
			fprintf(fp," %4s","");
		if(detail>1) fprintf(fp," %15.8lf",h->z[i].r*h->z[i].f);
		if(detail>1) fprintf(fp," %15.8lf",h->r[i]*h->z[i].f);
		//if(detail>1) fprintf(fp," %lf",h->z[i].r);
		fprintf(fp,"\n");
	}
	fprintf(stderr,"\n");
	return(h->nr);
}

int readric(int detail,MOLECULAR *molecule,int ne,ELEMENTAL *el,char *fn)
{
	int i=molecule->i,m=0;
	char fnr[STRINGBUFFERSIZE];
	FILE *fp;
	sprintf(fnr,"%s.ric",fn);
	if(NULL==(fp=fopen(fnr,"rt"))) uerror("readric",fnr);
	else
	{
		if(0<(m=readredundant(fp,molecule->h+i,molecule->zmx+i)))
			molecule->ric[i]=INDEX_RIC_SUPPLIED;
		if(detail) fprintf(stderr," read %d internal coordinates for %s from %s\n"
				,m,molecule->h[i].molecule,fnr);
	}
	// writeredundant(detail,stderr,molecule->h+i);
	return(m);
}

