#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "programming.h"
#include "instrumental.h"
#include "status.h"

#include "errors.h"
#include "evaluate.h"
//#include "leastsquare.h"
#include "numericalfit.h"
#include "readzmatrix.h"
#include "setzmatrix.h"

int showcoordinate(int detail,FILE *fpi,DIFFRACTION *data,MOLECULAR *molecule
		,int ne,ELEMENTAL *elemental,INSTRUMENTAL *instrument,FITTING *fit)
{
	ZMAT *z=&(molecule->zmx[molecule->i]);
	int nz=z->nz,mi=molecule->i;
	int zindex,rindex,i,nc,set=0;
	char f[][10]={"fixed    ","to fit   ","dependent"};
	char input[STRINGBUFFERSIZE];
	char *ef,*c[MAX_KEYWORDS];

	if((INDEX_KIND_ZMX!=molecule->kind[mi])&&(INDEX_KIND_ZMX_AMP!=molecule->kind[mi])) return(0);

	for(i=0;i<MAX_KEYWORDS;i++)
		if(NULL==(c[i]=(char *)calloc(KEYWORDLENGTH,sizeof(char)))) uerror("showcoordinate","lack of memory");

	while(1)
	{
		fprintf(stderr,"    [%d/%d] %s %lfK\n"
				,1+mi,molecule->n,z->molecule,molecule->temperature[mi]);
		fprintf(stderr,"  ---------------------------------------------------------------\n");
		for(i=0;i<z->na;i++)
			fprintf(stderr,"%6d  %-7s%-5s%-7s%-5s%-7s%-5s%-7s\n",1+i,z->atom[i]
					,z->reference[i][0],z->coordinate[i][0]
					,z->reference[i][1],z->coordinate[i][1]
					,z->reference[i][2],z->coordinate[i][2]);
		fprintf(stderr,"  ---------------------------------------------------------------\n");
		for(i=0;i<nz;i++)
		{
			fprintf(stderr,"%6d(%d) %-8s ",i,z->zt[i],z->z[i]);
			switch(z->zt[i])
			{
				case INDEX_ZMX_FUNCTION:
				case INDEX_ZMX_DEPENDENT:
				case INDEX_ZMX_DEPENDENT_LENGTH:
				case INDEX_ZMX_DEPENDENT_ANGLE:
				case INDEX_ZMX_DEPENDENT_DIHEDRAL:
					z->r[i]=evaluatedependent(i,z);
			}
			switch(z->zt[i])
			{
				default:
				case INDEX_ZMX_UNUSED:
					fprintf(stderr,"%12lf %10s",z->r[i],f[fit->coordinate[mi][i]]);
					break;
				case INDEX_ZMX_BONDLENGTH:
					fprintf(stderr,"%12.8lf %10s",z->r[i],f[fit->coordinate[mi][i]]);
					break;
				case INDEX_ZMX_BENDINGANGLE:
				case INDEX_ZMX_DIHEDRAL:
					fprintf(stderr,"%12.6lf %10s",z->r[i],f[fit->coordinate[mi][i]]);
					break;
				case INDEX_ZMX_FUNCTION:
				case INDEX_ZMX_DEPENDENT:
				case INDEX_ZMX_DEPENDENT_LENGTH:
							fprintf(stderr," %12.8lf %10s",z->r[i],f[2]);
							break;
				case INDEX_ZMX_DEPENDENT_ANGLE:
				case INDEX_ZMX_DEPENDENT_DIHEDRAL:
							fprintf(stderr," %12.6lf %10s",z->r[i],f[2]);
							break;
			}
			if(z->ien[i])
			{
				fprintf(stderr," (%d) V= %lf [%lf] (%lf,%lf) %10s",z->ird[i],z->v0[i],z->tv[i],z->rs[i],z->re[i],f[fit->potential[mi][i]]);	
			}
			fprintf(stderr," \n");
		}
		if(z->nr) fprintf(stderr,"  ---------------------------------------------------------------\n");
		for(i=0;i<z->nr;i++)
			fprintf(stderr,"%6d: %s has %d-fold potential of %lf with %lf\n"
				,i+1,z->z[z->ir[i]]
				,z->ird[z->ir[i]],z->v0[z->ir[i]],z->tv[z->ir[i]]);
		fprintf(stderr,"  ---------------------------------------------------------------\n");
		fprintf(stderr,"    which ? ");
		// fscanf(fp,"%s",input);
		if(NULL==(fgets(input,STRINGBUFFERSIZE,fpi))) break;
		for(i=0;i<MAX_KEYWORDS;i++) sprintf(c[i],"%s","");
		nc=0;
		switch(MAX_KEYWORDS)
		{
			case 2 : nc=sscanf(input,"%s%s",c[0],c[1]); break;
			case 8 : nc=sscanf(input,"%s%s%s%s%s%s%s%s",c[0],c[1],c[2],c[3],c[4],c[5],c[6],c[7]); break;
			default: 
				 fprintf(stderr," code error in reading zmatrix\n");
				 exit(1);
		}
		if(!strcasecmp("done",c[0])) break;
		else if(!strcasecmp("allset",c[0])) break;
		else if(!strcasecmp("go",c[0])) 
		{
			if(set)
			{
				setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
				// setmolecule(detail,1,molecule,ne,elemental);
				// setmoleculemakesmt(detail,1,data,molecule,ne,elemental,instrument);
				set=0;
			}
			singlepoint(0,1,data,molecule,ne,elemental,instrument,fit);
			calculatenonlinears(detail,data,molecule,ne,elemental,instrument,fit);
			// updatesmscurves(detail,output,data);
		}
		else if(!strcasecmp("fit",c[0])) 
		{
			for(i=1;i<nc;i++)
			{
				if(-1<(zindex=findzreference(c[i],z->z,nz)))
				{
					switch(z->zt[zindex])
					{
						case INDEX_ZMX_FUNCTION:
						case INDEX_ZMX_DEPENDENT:
						case INDEX_ZMX_DEPENDENT_LENGTH:
						case INDEX_ZMX_DEPENDENT_ANGLE:
						case INDEX_ZMX_DEPENDENT_DIHEDRAL:
							fit->coordinate[mi][zindex]=0;
							break;
						default:
							fit->coordinate[mi][zindex]=1;
							break;
					}
				}
				else
					if(!strcasecmp("temperature",c[i]))
						fit->temperature[mi]=1;
			}
		}
		else if(!strcasecmp("fix",c[0])) 
		{
			for(i=1;i<nc;i++)
			{
				if(-1<(zindex=findzreference(c[i],z->z,nz)))
					fit->coordinate[mi][zindex]=0;
				else
					if(!strcasecmp("temperature",c[i]))
						fit->temperature[mi]=0;
			}
		}
		else if(!strcasecmp("rfit",c[0])) 
		{
			for(i=1;i<nc;i++)
			{
				if(-1<(zindex=findzreference(c[i],z->z,nz)))
					fit->potential[mi][zindex]=1;
			}
		}
		else if(!strcasecmp("rfix",c[0])) 
		{
			for(i=1;i<nc;i++)
			{
				if(-1<(zindex=findzreference(c[i],z->z,nz)))
					fit->potential[mi][zindex]=0;
			}
		}
		else if(!strcasecmp("loosen",c[0])) 
		{
			if(0>(zindex=findzreference(c[1],z->z,nz))) 
			{
				fprintf(stderr,"# can't find %s in zmx list\n",c[1]);
			}
			else 
			{
				switch(z->zt[zindex])
				{
					default :
					case INDEX_ZMX_BONDLENGTH :
						fprintf(stderr,"# %s is not angle\n",c[1]);
						break;
					case INDEX_ZMX_UNUSED:
					case INDEX_ZMX_BENDINGANGLE :
					case INDEX_ZMX_DIHEDRAL :
					case INDEX_ZMX_DEPENDENT_ANGLE :
					case INDEX_ZMX_DEPENDENT_DIHEDRAL :
						if((z->ien[zindex])||(z->nr<MAX_NUM_INT_ROT))
						{
							z->ien[zindex]=1;
							z->ird[zindex]=atoi(c[2]);
							z->v0[zindex]=atof(c[3]);
							z->tv[zindex]=atof(c[4]);
							if(nc>6)
							{
								z->rs[zindex]=atof(c[5]);
								z->re[zindex]=atof(c[6]);
							}
							else
							{
								z->rs[zindex]=0;
								z->re[zindex]=360;
							}
							z->nr=rotationalweight(0,molecule);
							set++;
						}
						else
							fprintf(stderr,"# sorry, maximum internal rotation is %d...\n",MAX_NUM_INT_ROT);
				}
			}
		}
		else if(!strcasecmp("fasten",c[0])) 
		{
			if(0>(zindex=findzreference(c[1],z->z,nz))) 
			{
				fprintf(stderr,"# can't find %s in zmx list\n",c[1]);
			}
			else
			{
				switch (z->zt[zindex])
				{
					default :
					case INDEX_ZMX_BONDLENGTH:
						fprintf(stderr,"# %s is not angle\n",c[1]);
						break;
					case INDEX_ZMX_UNUSED:
					case INDEX_ZMX_BENDINGANGLE :
					case INDEX_ZMX_DIHEDRAL :
					case INDEX_ZMX_DEPENDENT_ANGLE :
					case INDEX_ZMX_DEPENDENT_DIHEDRAL :
						if(z->ien[zindex])
						{
							z->ien[zindex]=0;
							z->nr=rotationalweight(0,molecule);
							setpreset(&(molecule->preset[mi]),STATUS_ZMX_NEED_TO_MAKE_ALL);
							set++;
						}
						else
							fprintf(stderr,"# %s was not loose...",c[1]);
				}
			}
		}
		else if(!strcasecmp("set",c[0])) 
		{
			if(0>(zindex=findzreference(c[1],z->z,nz))) 
			{
				if(!strcasecmp("temperature",c[1])) 
				{
					molecule->temperature[mi]=atof(c[2]);
					setpreset(&(molecule->preset[mi]),STATUS_ZMX_NEED_TO_MAKE_AMPLITUDE);
					set++;
				}
				else if(!strcasecmp("molecule",c[1])) 
				{
					mi=atoi(c[2])-1;
					if((0<=mi)&&(mi<molecule->n)) molecule->i=mi;
					else mi=molecule->i;
					z=&(molecule->zmx[molecule->i]);
					nz=z->nz;
					fprintf(stderr,"    changed molecule to %d\n",1+mi);
				}
			}
			else
			{
				if(0>(rindex=findzreference(c[2],z->z,nz)))
					z->r[zindex]=atof(c[2]);
				else
					z->r[zindex]=z->r[rindex];
				setpreset(&(molecule->preset[mi]),STATUS_ZMX_NEED_TO_MAKE_ALL);
				set++;
			}
			// setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR); // will be dealt in ueda.c
		}
	}
	// fgets(input,STRINGBUFFERSIZE,fpi);
	for(i=0;i<MAX_KEYWORDS;i++)
		free(c[i]);
	if(set)
	{
		setpreset(&(data->preset),STATUS_NEED_TO_MAKE_MOLECULAR);
//		setmolecule(detail,1,molecule,ne,elemental);
		setmoleculemakesmt(detail,1,data,molecule,ne,elemental,instrument);
	}
	return(set);
}

int rotationalweight(int detail,MOLECULAR *molecule)
{
	ZMAT *z=&(molecule->zmx[molecule->i]);
	int i,ir,j,k,n=NUM_BIN_INT_ROT;
	double wsum,v,p;
	double angleoffset,anglestep,ikt;
	double THRESHOLD=1.0E-6/n;
	z->nr=0;
	z->ne=1;
	for(i=0;i<MAX_NUM_INT_ROT;i++)
	{
		z->nb[i]=1;
		z->ir[i]=-1;
		z->w[i][0]=1;
		for(j=1;j<n;j++) z->w[i][j]=0;
	}
	for(i=0;i<z->nz;i++)
		if(z->ien[i])
			z->ir[z->nr++]=i;
	for(i=0;i<z->nr;i++)
	{
		ir=z->ir[i];
		z->nb[i]=n;
		z->ne*=n;
		angleoffset=z->ird[ir]*(z->rs[ir])/180*PI;
		anglestep=z->ird[ir]*(z->re[ir]-z->rs[ir])/180*PI/n;
		ikt=1/z->tv[ir];
		wsum=0;
		for(j=0;j<n;j++)
		{
			z->w[ir][j]=0;
			for(k=-8;k<8;k++)
			{
				v=z->v0[ir]*0.5*(1-cos(angleoffset+anglestep*(j+(k+0.5)/16))); 
				z->w[ir][j]+=exp(-v*ikt);
			}
			if(z->w[ir][j]<THRESHOLD) z->w[ir][j]=0;
			wsum+=z->w[ir][j];
		}
		wsum=1/wsum;
		for(j=0;j<n;j++)
		{
			z->w[ir][j]*=wsum;
		}
	}
	if(detail)
	{
		for(i=0;i<z->nr;i++)
		{
			ir=z->ir[i];
			fprintf(stderr,"(%d) %s:\n",i+1,z->z[ir]);
			for(j=0;j<n;j++)
				fprintf(stderr,"%8d %20.15lf %20.15lf\n"
				,j,z->rs[ir]+(z->re[ir]-z->rs[ir])/n*j,z->w[ir][j]);
			fprintf(stderr,"\n");
		}
	}
	for(i=0;i<z->nr;i++)
	{
		p=0;
		ir=z->ir[i];
		for(j=0;j<n;j++)
			p+=z->w[ir][j]*z->w[ir][j];
		fprintf(stderr,"(%d) %s: %lf\n",i+1,z->z[ir],1/p);
	}
	return(z->nr);
}

