#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "programming.h"
#include "instrumental.h"

#include "calculate.h"
#include "evaluate.h"
#include "gaussjordan.h"
#include "jacobi.h"
#include "numericalfit.h"
#include "fitmarquardt.h"
#include "montecarlo.h"
#include "outputs.h"
#include "errors.h"
#include "status.h"

int diagnosis(int n,double **a)
{
	int i,j,l=0;
	double *e,**v,**s;
	if(NULL==(e=(double *)calloc(n,sizeof(double)))) uerror("diagnosis","lack of memory");
	if(NULL==(v=(double **)calloc(n,sizeof(double*)))) uerror("diagnosis","lack of memory");
	for(i=0;i<n;i++)
		if(NULL==(v[i]=(double *)calloc(n,sizeof(double)))) uerror("diagnosis","lack of memory");
	if(NULL==(s=(double **)calloc(n,sizeof(double*)))) uerror("diagnosis","lack of memory");
	for(i=0;i<n;i++)
		if(NULL==(s[i]=(double *)calloc(n,sizeof(double)))) uerror("diagnosis","lack of memory");

	for(i=0;i<n;i++)
		for(j=0;j<n;j++)
			s[i][j]=a[i][j];
	jacobidiagonalize(n,s,e,v,&l);
	jacobisort(n,e,v);
	for(i=0;i<n;i++)
		fprintf(stderr," disgnosis jacobi i= %d e= %le\n",i+1,e[i]);
	for(i=0;i<n;i++)
		free(s[i]);
	free(s);
	for(i=0;i<n;i++)
		free(v[i]);
	free(v);
	free(e);
	return(0);
}

