#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "programming.h"

#include "errors.h"
#include "outputs.h"
#include "interface.h"
#include "coordinates.h"
#include "calculate.h"
#include "transform.h"

int calculatemmatrix(int m,double *w,double *mm,double *mi)	// m=nc u=f->m mm=h->m mi=h->mi
{
	int i,j;
	for(j=0;j<m;j++)
		for(i=0;i<=j;i++)
			mi[uindex(i,j)]=(mm[uindex(i,j)]=0);
	for(j=0;j<m;j++)
		mi[uindex(j,j)]=1/(mm[uindex(j,j)]=w[j]);
	return(m);
}

int calculatebtmatrix(int nr,int nc,ZMx *z,double *r,double *x,double *bt)
{
	int i;
	ZMx *zi;
	for(i=0;i<nr;i++)
	{
		zi=z+i;
		zi->r=(r[i]=evaluatebtcolumn(zi->type,zi->id,x,bt+i*nc));
		//zi->r=zi->f*(r[i]=evaluatebtcolumn(zi->type,zi->id,x,bt+i*nc));
	}
	return(nr);
}

int calculatetranspose(int m,int n,double *a,double *t) // m=nc n=nr a=h->bt t=h->b
{
	int i,j;
	for(j=0;j<m;j++)
		for(i=0;i<n;i++)
			t[rindex(i,j,n,m)]=a[rindex(j,i,m,n)];
	return(m*n);
}

int calculatemibtmatrix(int m,int n,double *bt,double *w,double *mibt)	// m=nc n=nr w=f->m
{
	int i,j;
	for(j=0;j<n;j++)
		for(i=0;i<m;i++)
			mibt[rindex(i,j,m,n)]=bt[rindex(i,j,m,n)]/w[i];
			// M^-1 B^T = (B M^-1^T)^T = (B M^-1)^T
	return(m);
}

int calculategtmatrix(int m,int n,double *bt,double *mibt,double *g) // m=nc n=nr 
{
	fDGEMM('T','N',n,n,m,1.0,bt,m,mibt,m,0.0,g,n);
	// G= B (M^-1 B^T)
	return(0);
}

int calculategimatrix(int n,double *g,double *gi) // n=nr
{
	int j,nz=0,INFO=0;
	double *reciprocal=NULL,*eigenvalue=NULL,*eigenvector=NULL,*WORK=NULL;
	if(NULL==(WORK=(double *)calloc(3*n,sizeof(double)))) uerror("calculategimatrix","lack of memory");
	if(NULL==(reciprocal=(double *)calloc(n,sizeof(double)))) uerror("calculategimatrix","lack of memory");
	if(NULL==(eigenvalue=(double *)calloc(n,sizeof(double)))) uerror("calculategimatrix","lack of memory");
	if(NULL==(eigenvector=(double *)calloc(n*n,sizeof(double)))) uerror("calculategimatrix","lack of memory");

	calculatetriangular(n,g,gi);
	fDSPEV('V','U',n,gi,eigenvalue,eigenvector,n,WORK,&INFO);
	for(j=0;j<n;j++)	// retrieve symmetry
	{
		if(eigenvalue[j]<1E-6) { nz++; reciprocal[j]=0; }
		else
			reciprocal[j]=1/eigenvalue[j];
	}
	evsimilartransform(n,reciprocal,eigenvector,gi);

	free(eigenvector);
	free(eigenvalue);
	free(reciprocal);
	free(WORK);
	return(nz);
}

int calculategsmatrix(int n,double *g,double *gi,double *gs,double *gq) // n=nr
{
	int j,nz=0,INFO=0;
	double *reciprocal=NULL,*eigenvalue=NULL,*eigenvector=NULL,*WORK=NULL;
	double TOLERANCE=1E-10*sqrt((double)(n));
	if(NULL==(WORK=(double *)calloc(3*n,sizeof(double)))) uerror("calculategsmatrix","lack of memory");
	if(NULL==(reciprocal=(double *)calloc(n,sizeof(double)))) uerror("calculategsmatrix","lack of memory");
	if(NULL==(eigenvalue=(double *)calloc(n,sizeof(double)))) uerror("calculategsmatrix","lack of memory");
	if(NULL==(eigenvector=(double *)calloc(n*n,sizeof(double)))) uerror("calculategsmatrix","lack of memory");

	calculatetriangular(n,g,gi);
	fDSPEV('V','U',n,gi,eigenvalue,eigenvector,n,WORK,&INFO);
	for(j=0;j<n;j++)
		if(eigenvalue[j]<TOLERANCE) nz++;
		// fprintf(stderr,"%5d: %12.8lf\n",j+1,eigenvalue[j]);

	for(j=0;j<n;j++)	// retrieve symmetry
		if(eigenvalue[j]<TOLERANCE) reciprocal[j]=0; 
		else reciprocal[j]=1/eigenvalue[j];
	evsimilartransform(n,reciprocal,eigenvector,gi);

	for(j=0;j<n;j++)
		if(eigenvalue[j]<TOLERANCE) reciprocal[j]=0; 
		else reciprocal[j]=sqrt(eigenvalue[j]);
	evsimilartransform(n,reciprocal,eigenvector,gs);

	for(j=0;j<n;j++)
		if(eigenvalue[j]<TOLERANCE) reciprocal[j]=0; 
		else reciprocal[j]=1/sqrt(eigenvalue[j]);
	evsimilartransform(n,reciprocal,eigenvector,gq);

	free(eigenvector);
	free(eigenvalue);
	free(reciprocal);
	free(WORK);
	//if(1) fprintf(stderr," zero components in g matrix, nz= %d\n",nz);
	return(nz);
}

int calculatebimatrix(int m,int n,double *mibt,double *gi,double *bi)	// m=nc n=nr
{
	fDGEMM('N','N',m,n,n,1.0,mibt,m,gi,n,0.0,bi,m); // B^-1 = (M^-1 B^T) G^-1
	return(0);
}

int calculatepimatrix(int m,int n,double *bt,double *bi,double *pi) 
{
	fDGEMM('T','N',n,n,m,1.0,bt,m,bi,m,0.0,pi,n); 
	return(n);
}

int calculatetriangular(int n,double *r,double *t)	// n=nr r=h->g t=h->gt
{
	int i,j;
	for(j=0;j<n;j++)
		for(i=0;i<=j;i++)
			t[uindex(i,j)]=0.5*(r[rindex(i,j,n,n)]+r[rindex(j,i,n,n)]);
	return(n);
}

int evsimilartransform(int n,double *v,double *u,double *t)
{
	int i,j,k;
	double e;
	for(i=0;i<n;i++)
	{
		for(j=0;j<n;j++)
		{
			e=0;
			for(k=0;k<n;k++)
				e+=u[rindex(i,k,n,n)]*v[k]*u[rindex(j,k,n,n)];
			t[rindex(i,j,n,n)]=e;
		}
	}
	return(0);
}

int checkvalidinverse(int m,int n,double *b,double *a,char *s) // m=nc n=nr b=b a=bi
{
	double *u;
	if(NULL==(u=(double *)calloc(n*n,sizeof(double)))) uerror("checkvalidinverse","memory");
	fDGEMM('N','N',n,n,m,1.0,b,n,a,m,0.0,u,n); 
	fprintf(stderr,"%s %s^-1 = I\n",s,s);
	//printrectangularmatrix(n,n,u);
	free(u);
	return(0);
}

int calculategmatrix(int m,int n,double *b,double *mibt,double *g) // m=nc n=nr 
{
	fDGEMM('N','N',n,n,m,1.0,b,n,mibt,m,0.0,g,n);
	// G= B (M^-1 B^T)
	return(0);
}

int calculategmatrix_direct(int m,int n,double *mf,double *b,double *g)
{
	int i,j,k;
	double e;
	for(i=0;i<n;i++)
	{
		for(j=0;j<n;j++)
		{
			e=0;
			for(k=0;k<m;k++)
				e+=b[rindex(k,i,m,n)]/mf[k]*b[rindex(k,j,m,n)];
			g[rindex(j,i,n,m)]=e;
		}
	}
	return(n);
}

