#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "programming.h"
#include "instrumental.h"
#include "status.h"

#include "calculate.h"
#include "empirical.h"
#include "evaluate.h"
//#include "gaussjordan.h"
#include "leastsquare.h"
#include "mathematical.h"
#include "numericalfit.h"
#include "outputs.h"
#include "readdata.h"
#include "readpredata.h"
#include "readzmatrix.h"
#include "setzmatrix.h"
#include "writezmatrix.h"
#include "commandstext.h"
#include "ueda.h"

void smerror(char *s)
{
	fprintf(stderr,"memory allocation failed for %s\n",s);
	exit(0);
}

int main(int argc, char *argv[])
{
	int detail=1,debug=0;
	int i,ne;
	FILE *fp=stdin;
	FILE *fp1=stdout;
	FILE *fp2=stderr;
//	char filename[STRINGBUFFERSIZE];

	ELEMENTAL elemental[MAX_NUCLEI];				// structure declarations
	INSTRUMENTAL instrument[1];
	DIFFRACTION data[1];
	MOLECULAR *molecule;
	FITTING fit[1];

	if(NULL==(molecule=(MOLECULAR*)calloc(1,sizeof(MOLECULAR)))) smerror("molecular");

	initialize(data,molecule,instrument,fit);
	// readconfig(data,molecule,instrument,fit);
	ne=readelements(detail,elemental);
//	instrument->KineticEnergy=30;
//	interpolateenergy(instrument->KineticEnergy,elemental);	// in evaluate.c
//	printinterpolated(6,elemental);
	// makecorrfactors(ne,elemental,data);
	// estimateradius(ne,elemental);
	if(debug)confirmelements(ne,elemental);

	for(i=0;i<argc;i++)   			// loop through the arguments supplied to the the main() function
	{
		if((!strcmp("-c",argv[i]))&&(i+1<argc))
		{
			if(NULL==(fp=fopen(argv[i+1],"rt")))
			{
				fprintf(stderr,"    %s doesn't exist\n",argv[i+1]);
			}
			else
			{
				commandstext(detail,debug,fp,fp1,fp2,data,molecule,ne,elemental,instrument,fit);
				fclose(fp);
			}
		}
	}
	commandstext(detail,debug,stdin,fp1,fp2,data,molecule,ne,elemental,instrument,fit);
	fprintf(fp2,"\n");
	return(1);
}
