#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "programming.h"
#include "instrumental.h"
#include "status.h"

#include "readpredata.h"
#include "errors.h"
#include "writezmatrix.h"

int savezmx(int detail,MOLECULAR *molecule,char *fn)
{
	ZMAT *z=&(molecule->zmx[molecule->i]);
	int i,j;
	FILE *fp;
	char fnz[STRINGBUFFERSIZE];

	sprintf(fnz,"%s.zmx",fn);
	if(NULL==(fp=fopen(fnz,"wt"))) ioerror(fnz);
	else
	{
		fprintf(fp,"%s\n",z->molecule);
		fprintf(fp,"%d\n",z->na);
		for(i=0;i<z->na;i++)
		{
			fprintf(fp,"%-5s %-5s %-5s %-5s %-5s %-5s %-5s\n",z->atom[i]
					,z->reference[i][0],z->coordinate[i][0]
					,z->reference[i][1],z->coordinate[i][1]
					,z->reference[i][2],z->coordinate[i][2]); 
		}
		fprintf(fp,"\n");
		for(i=0;i<z->nz;i++)
		{
			switch(z->zt[i])
			{
				default:
					fprintf(fp,"%-5s %20.15lf\n",z->z[i],z->r[i]);
					break;
				case INDEX_ZMX_BONDLENGTH:
					fprintf(fp,"%-5s %12.8lf\n",z->z[i],z->r[i]);
					break;
				case INDEX_ZMX_BENDINGANGLE:
				case INDEX_ZMX_DIHEDRAL:
					fprintf(fp,"%-5s %12.6lf\n",z->z[i],z->r[i]);
					break;
				case INDEX_ZMX_DEPENDENT_LENGTH:
					fprintf(fp," %-5s   %12.8lf = %12.8lf" ,z->z[i],z->r[i],z->a[i][0]);
					for(j=1;j<z->nd[i];j++)
						fprintf(fp," + %12.8lf * %s",z->a[i][j],z->z[z->b[i][j]]);
					fprintf(fp,"\n");
					break;
				case INDEX_ZMX_DEPENDENT_ANGLE:
				case INDEX_ZMX_DEPENDENT_DIHEDRAL:
					fprintf(fp," %-5s   %12.6lf = %12.6lf" ,z->z[i],z->r[i],z->a[i][0]);
					for(j=1;j<z->nd[i];j++)
						fprintf(fp," + %12.6lf * %s",z->a[i][j],z->z[z->b[i][j]]);
					fprintf(fp,"\n");
					break;
			}
		}
		fclose(fp);
		if(detail) fprintf(stderr,"    save %d coordinates for %s to %s\n",z->nz,z->molecule,fnz);
	}
	return(z->nz);
}

int printmls(FILE *fp,MOLECULAR *molecule,int ne,ELEMENTAL *ele)
{
        MLS *mls=&(molecule->mls[molecule->i]);
        int k;
        for(k=0;k<mls->nl;k++)
        {
                fprintf(fp,"%s %s   %5d",mls->a1[k],mls->a2[k],1);
                fprintf(fp," %13.5lf",mls->ra[k]);
                fprintf(fp," %10.5lf",mls->lh[k]);
                fprintf(fp,"  %5.1lf",mls->a[k]);
                fprintf(fp,"\n");
        }
        return(mls->nl);
}

