(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     60082,       1623]
NotebookOptionsPosition[     57510,       1532]
NotebookOutlinePosition[     57849,       1547]
CellTagsIndexPosition[     57806,       1544]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input",
 CellChangeTimes->{{3.665859232344759*^9, 3.665859236735454*^9}, {
  3.665863815026243*^9, 3.665863849178424*^9}, {3.665863882380316*^9, 
  3.665863929521386*^9}, {3.665899891044674*^9, 3.66589989242861*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"PDE", " ", "we", " ", "seek", " ", "symmetries", " ", 
    RowBox[{"of", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], "-", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], "^", "2"}]}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Q1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]u", "[", 
       RowBox[{"t", ",", "x", ",", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"t", ",", "x", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"t", ",", "x", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", "\[CapitalDelta]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x"}], "}"}], ",", 
       RowBox[{"{", "u", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "Q1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"1", ",", "0"}], "]"}], "[", "u", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665859055545368*^9, 3.665859056670993*^9}, 
   3.665859222359338*^9, {3.6658595332618227`*^9, 3.665859535110145*^9}, {
   3.665859711964427*^9, 3.665859713110396*^9}, {3.665860496681065*^9, 
   3.6658605636404743`*^9}, {3.665860875037993*^9, 3.665860881549271*^9}, {
   3.665861046773204*^9, 3.665861049549117*^9}, {3.665861674569313*^9, 
   3.6658616967593813`*^9}, {3.6658620374299707`*^9, 3.665862049470551*^9}, {
   3.6658621101506977`*^9, 3.6658621268486853`*^9}, 3.665862225420937*^9, {
   3.665867355970107*^9, 3.6658674061107483`*^9}, {3.665867527086009*^9, 
   3.66586757559233*^9}, {3.66589959391077*^9, 3.6658996402035427`*^9}, {
   3.665903080783215*^9, 3.665903095503909*^9}, {3.6659037581561604`*^9, 
   3.6659037716046867`*^9}, {3.668473271434855*^9, 3.668473304686426*^9}, {
   3.668894012460692*^9, 3.668894062380164*^9}, {3.6688941012525797`*^9, 
   3.668894126884075*^9}, 3.668894166403956*^9, {3.669047598135438*^9, 
   3.6690476013513947`*^9}, {3.669057996322817*^9, 3.6690580706731987`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
          "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.665860553384531*^9, 3.665860557223929*^9}, {
   3.665860738233917*^9, 3.665860740785784*^9}, {3.6658612774842663`*^9, 
   3.66586128001158*^9}, {3.665862134590067*^9, 3.6658621370127*^9}, {
   3.665863682232481*^9, 3.6658636923756037`*^9}, 3.668473271281144*^9, {
   3.6688941033129587`*^9, 3.668894105268138*^9}, {3.6689968704756947`*^9, 
   3.6689969586815147`*^9}, 3.668997040693952*^9, {3.669058091858159*^9, 
   3.669058092986145*^9}, {3.6690582906575537`*^9, 3.669058301935751*^9}, 
   3.669061976951337*^9}],

Cell[BoxData["28"], "Output",
 CellChangeTimes->{
  3.665860568806402*^9, 3.665860699218162*^9, 3.665860749239545*^9, 
   3.665860819579459*^9, 3.6658609687318277`*^9, 3.6658610978311157`*^9, 
   3.665861176145685*^9, 3.665861281631703*^9, {3.665861323616026*^9, 
   3.6658613388447933`*^9}, 3.66586137306406*^9, 3.665861437934593*^9, 
   3.665861501300076*^9, 3.665861707960017*^9, 3.6658620570322323`*^9, 
   3.66586222951998*^9, 3.66586232498002*^9, 3.665863667447193*^9, 
   3.665863704429582*^9, 3.665864035012487*^9, 3.665867213835298*^9, 
   3.665867415896546*^9, 3.6658675788940573`*^9, 3.665876577588208*^9, 
   3.665882779043414*^9, {3.665883075700088*^9, 3.6658830991137543`*^9}, 
   3.665883332741406*^9, 3.6658836128544483`*^9, {3.665899649408271*^9, 
   3.6658996731491613`*^9}, 3.665899897463888*^9, 3.6659003582501183`*^9, 
   3.665903108062612*^9, 3.6659032261403837`*^9, {3.6659034131789093`*^9, 
   3.665903429433507*^9}, 3.6659037730712023`*^9, {3.665903968310936*^9, 
   3.6659039857972717`*^9}, 3.665904127080491*^9, 3.665904237173439*^9, 
   3.66605826709249*^9, 3.666058546423069*^9, 3.6660628753747807`*^9, 
   3.6684733086689777`*^9, 3.6686268784801483`*^9, 3.668631888391078*^9, 
   3.66863392396094*^9, 3.6686342372198563`*^9, 3.668634398702403*^9, 
   3.668634452595289*^9, 3.6686344838861723`*^9, 3.668661586451476*^9, 
   3.668661812275021*^9, 3.668698590710103*^9, 3.668708844126989*^9, 
   3.668813912960228*^9, 3.6688296756451473`*^9, 3.668893995358885*^9, {
   3.6688940706425037`*^9, 3.668894084875491*^9}, 3.668894129194908*^9, 
   3.668894173712976*^9, 3.668968119323862*^9, 3.668996959169669*^9, 
   3.668997042948945*^9, 3.6690476174839687`*^9, 3.6690478478467007`*^9, {
   3.669058083632536*^9, 3.669058093534789*^9}, {3.6690582831786003`*^9, 
   3.6690583113618307`*^9}, 3.669058677118166*^9, 3.669059084723119*^9, 
   3.669059209130599*^9, 3.669059316009824*^9, 3.6690594382511187`*^9, 
   3.669059732428218*^9, 3.669062012215165*^9, 3.6694096317842207`*^9, {
   3.669412009064496*^9, 3.669412027164033*^9}, 3.669415126877686*^9, 
   3.6700414298434067`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665860568806402*^9, 3.665860699218162*^9, 3.665860749239545*^9, 
   3.665860819579459*^9, 3.6658609687318277`*^9, 3.6658610978311157`*^9, 
   3.665861176145685*^9, 3.665861281631703*^9, {3.665861323616026*^9, 
   3.6658613388447933`*^9}, 3.66586137306406*^9, 3.665861437934593*^9, 
   3.665861501300076*^9, 3.665861707960017*^9, 3.6658620570322323`*^9, 
   3.66586222951998*^9, 3.66586232498002*^9, 3.665863667447193*^9, 
   3.665863704429582*^9, 3.665864035012487*^9, 3.665867213835298*^9, 
   3.665867415896546*^9, 3.6658675788940573`*^9, 3.665876577588208*^9, 
   3.665882779043414*^9, {3.665883075700088*^9, 3.6658830991137543`*^9}, 
   3.665883332741406*^9, 3.6658836128544483`*^9, {3.665899649408271*^9, 
   3.6658996731491613`*^9}, 3.665899897463888*^9, 3.6659003582501183`*^9, 
   3.665903108062612*^9, 3.6659032261403837`*^9, {3.6659034131789093`*^9, 
   3.665903429433507*^9}, 3.6659037730712023`*^9, {3.665903968310936*^9, 
   3.6659039857972717`*^9}, 3.665904127080491*^9, 3.665904237173439*^9, 
   3.66605826709249*^9, 3.666058546423069*^9, 3.6660628753747807`*^9, 
   3.6684733086689777`*^9, 3.6686268784801483`*^9, 3.668631888391078*^9, 
   3.66863392396094*^9, 3.6686342372198563`*^9, 3.668634398702403*^9, 
   3.668634452595289*^9, 3.6686344838861723`*^9, 3.668661586451476*^9, 
   3.668661812275021*^9, 3.668698590710103*^9, 3.668708844126989*^9, 
   3.668813912960228*^9, 3.6688296756451473`*^9, 3.668893995358885*^9, {
   3.6688940706425037`*^9, 3.668894084875491*^9}, 3.668894129194908*^9, 
   3.668894173712976*^9, 3.668968119323862*^9, 3.668996959169669*^9, 
   3.668997042948945*^9, 3.6690476174839687`*^9, 3.6690478478467007`*^9, {
   3.669058083632536*^9, 3.669058093534789*^9}, {3.6690582831786003`*^9, 
   3.6690583113618307`*^9}, 3.669058677118166*^9, 3.669059084723119*^9, 
   3.669059209130599*^9, 3.669059316009824*^9, 3.6690594382511187`*^9, 
   3.669059732428218*^9, 3.669062012215165*^9, 3.6694096317842207`*^9, {
   3.669412009064496*^9, 3.669412027164033*^9}, 3.669415126877686*^9, 
   3.6700414298957*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", 
      "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.665883470602792*^9, 3.665883514147079*^9}, {
   3.6658835910581913`*^9, 3.665883603233927*^9}, {3.666058269448471*^9, 
   3.666058275008499*^9}, 3.668473271314509*^9, {3.668894132930522*^9, 
   3.668894133178796*^9}, 3.6690583165445127`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.096679`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.665883474634829*^9, 3.665883516446656*^9}, {
   3.665883604370013*^9, 3.665883615183599*^9}, 3.665899682027528*^9, 
   3.665899906151244*^9, 3.6659003657925673`*^9, 3.6659031092468853`*^9, 
   3.665903226185507*^9, {3.6659034136957006`*^9, 3.665903429963566*^9}, 
   3.665903780304195*^9, {3.665903968378437*^9, 3.665903985864032*^9}, 
   3.665904127165639*^9, 3.665904237224958*^9, {3.6660582712262983`*^9, 
   3.66605827540174*^9}, 3.666058548098983*^9, 3.666062875454933*^9, 
   3.668473310240049*^9, 3.668626882236739*^9, 3.668631891270399*^9, 
   3.668633925376134*^9, 3.6686342388000593`*^9, 3.668634400180252*^9, 
   3.668634453508534*^9, 3.668634485726962*^9, 3.668661587452196*^9, 
   3.668661812944393*^9, 3.668698591470532*^9, 3.668708844167305*^9, 
   3.668813916978917*^9, 3.668829676264106*^9, 3.668894140035177*^9, 
   3.668894174310769*^9, 3.668968120001901*^9, 3.669047857390625*^9, {
   3.669058314318245*^9, 3.669058317167804*^9}, 3.669058678535186*^9, 
   3.669059085961323*^9, 3.669059440082634*^9, 3.6690597333357553`*^9, 
   3.6690620122869053`*^9, 3.669409633122437*^9, {3.669412011946866*^9, 
   3.669412027296976*^9}, 3.669415127302319*^9, 3.6700414308174047`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Xi]t1", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", 
      "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665903131697522*^9, 3.665903148784086*^9}, {
   3.6660582771551123`*^9, 3.666058277529414*^9}, 3.668473271344961*^9, {
   3.668894142985647*^9, 3.668894143243328*^9}, 3.669058345134787*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.023886`", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Xi]x", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665903150988785*^9, 3.665903226249514*^9, {3.665903414175057*^9, 
   3.665903431672311*^9}, 3.6659037893053637`*^9, {3.6659039684324837`*^9, 
   3.665903985946793*^9}, 3.665904127276421*^9, 3.66590423740845*^9, 
   3.66605827856422*^9, 3.666058549001218*^9, 3.666062875515252*^9, 
   3.66847331230473*^9, 3.6686319373928413`*^9, 3.668634455995935*^9, 
   3.668634486331493*^9, 3.668661588397964*^9, 3.66866181340278*^9, 
   3.6686985919914837`*^9, 3.668708844224326*^9, 3.668813920599997*^9, 
   3.668829676679975*^9, {3.6688941515425777`*^9, 3.668894174805665*^9}, 
   3.6689681205129304`*^9, 3.669047859465942*^9, 3.6690583494076653`*^9, 
   3.669059443859074*^9, 3.669059734091897*^9, 3.669062012359366*^9, 
   3.669409640635089*^9, {3.6694120178553667`*^9, 3.6694120273596897`*^9}, 
   3.669415127907332*^9, 3.6700414315449038`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"t", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", 
      "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6659031545559464`*^9, 3.665903175848455*^9}, 
   3.665903219153366*^9, 3.665903812245529*^9, {3.666058280702724*^9, 
   3.6660582812881947`*^9}, 3.668473271369453*^9, {3.668894144866435*^9, 
   3.6688941451480207`*^9}, 3.669059448313025*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.024004`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t1", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Phi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.665903176142964*^9, {3.665903219619857*^9, 3.665903226302685*^9}, {
   3.665903414615954*^9, 3.6659034326001472`*^9}, {3.665903798411003*^9, 
   3.665903812584072*^9}, {3.665903968487999*^9, 3.665903986014864*^9}, 
   3.6659041273449507`*^9, 3.665904237459149*^9, 3.66605828182171*^9, 
   3.666058549906246*^9, 3.666062875646574*^9, 3.668473313746578*^9, 
   3.668631938324904*^9, 3.668634456736661*^9, 3.668634487147821*^9, 
   3.668661589313979*^9, 3.668661813960388*^9, 3.668698592586412*^9, 
   3.668708844279948*^9, 3.668813921374866*^9, 3.6688296770528917`*^9, 
   3.6688941754823017`*^9, 3.6689681211439667`*^9, 3.66904786094164*^9, {
   3.66905944618816*^9, 3.669059448746314*^9}, 3.669059734987487*^9, 
   3.669062012582849*^9, 3.669409642883649*^9, 3.669412027416692*^9, 
   3.669415128380046*^9, 3.6700414321103*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x2", "[", "t", "]"}], "+", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Xi]t1", "'"}], "[", "t", "]"}], "/", "2"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", 
      "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6659031787843533`*^9, 3.66590320999507*^9}, {
   3.665903401464679*^9, 3.665903402455502*^9}, 3.665903438696186*^9, {
   3.665903822387979*^9, 3.6659038471894073`*^9}, 3.6659039321004257`*^9, {
   3.6660582843926477`*^9, 3.66605828469632*^9}, 3.668473271391272*^9, {
   3.66889414686207*^9, 3.668894147066136*^9}, 3.669059450679185*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.026232`", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "u"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Phi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.665903210274227*^9, 3.6659032263554487`*^9}, {
   3.66590341510082*^9, 3.6659034397983522`*^9}, {3.66590384481207*^9, 
   3.665903847395591*^9}, {3.665903968544813*^9, 3.665903986087721*^9}, 
   3.665904127408512*^9, 3.665904237515317*^9, 3.666058285204959*^9, 
   3.666058550959387*^9, 3.666062875694682*^9, 3.668473316197226*^9, 
   3.668631939585347*^9, 3.668634458110361*^9, 3.6686344883686132`*^9, 
   3.668661590490992*^9, 3.668661814592576*^9, 3.6686985935100527`*^9, 
   3.6687088443358994`*^9, 3.668813937568548*^9, 3.668829678044154*^9, 
   3.668894180693815*^9, 3.668968121764002*^9, 3.6690478625581417`*^9, 
   3.669059451239049*^9, 3.6690597358628407`*^9, 3.6690620127086*^9, 
   3.669409649069037*^9, 3.669412027481636*^9, 3.669415128934803*^9, 
   3.6700414329859962`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Phi]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "u"}], "]"}], "+", 
     RowBox[{
      SuperscriptBox["\[Phi]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"\[Phi]", "[", 
    RowBox[{"t", ",", "x", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "u"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.665903881684417*^9, 3.665903891043828*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]", "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "u"}]]}], " ", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "[", 
       RowBox[{"t", ",", "x"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], "[", 
      RowBox[{"t", ",", "x"}], "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.665903891468218*^9, {3.665903968643249*^9, 3.66590398616348*^9}, 
   3.665904127482329*^9, 3.6659042376010923`*^9, 3.6660582878614492`*^9, 
   3.666058552052608*^9, 3.666062875767193*^9, 3.668473317118059*^9, 
   3.668631941314733*^9, 3.668634459280921*^9, 3.6686344897147093`*^9, 
   3.668661591760797*^9, 3.668661815489811*^9, 3.668698594748001*^9, 
   3.668708844387151*^9, 3.668813940319804*^9, 3.66882967886252*^9, 
   3.668894183712624*^9, 3.668968125121194*^9, 3.66904786411077*^9, 
   3.669059453566634*^9, 3.66905973706176*^9, 3.6690620127707376`*^9, 
   3.669409654624691*^9, 3.6694120275523*^9, 3.669415129427989*^9, 
   3.670041433891123*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Phi]u", "[", 
   RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "u"}]]}], "*", 
    RowBox[{"\[Phi]2", "[", 
     RowBox[{"t", ",", "x"}], "]"}]}], "+", 
   RowBox[{"\[Phi]3", "[", 
    RowBox[{"t", ",", "x"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
      
      RowBox[{"\"\<extras\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Exp", "[", "u", "]"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665903212919697*^9, 3.665903245055894*^9}, {
   3.6659033047112007`*^9, 3.6659033072233953`*^9}, {3.6659034509191008`*^9, 
   3.665903470815235*^9}, {3.66590389513383*^9, 3.665903949932832*^9}, {
   3.665904097411807*^9, 3.6659040975231867`*^9}, {3.665904210851178*^9, 
   3.665904211021058*^9}, {3.666058291135744*^9, 3.6660582927216473`*^9}, 
   3.6660586318243017`*^9, 3.668473271400497*^9, {3.668661600854169*^9, 
   3.668661608370488*^9}, 3.668829685291739*^9, {3.6688941888513613`*^9, 
   3.668894198346884*^9}, {3.668894233588537*^9, 3.6688942349460697`*^9}, {
   3.669059456223721*^9, 3.66905953363192*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.019242`", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x2", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{"x", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t1", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}]}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665903226401801*^9, 3.665903307571018*^9, 3.665903415962225*^9, {
   3.6659034687425413`*^9, 3.665903471039426*^9}, {3.66590391877177*^9, 
   3.665903986248824*^9}, 3.665904127557559*^9, 3.665904237692821*^9, 
   3.6660582940010223`*^9, 3.66605855349504*^9, 3.666058633703822*^9, 
   3.666062875843261*^9, 3.668473317813272*^9, 3.6686319422502623`*^9, 
   3.668634459952682*^9, 3.668634490735083*^9, {3.6686616055115023`*^9, 
   3.668661608651375*^9}, 3.668661816146902*^9, 3.668698595596888*^9, 
   3.668708844455567*^9, 3.668813941307989*^9, {3.6688296796323633`*^9, 
   3.668829686009626*^9}, {3.668894184723489*^9, 3.668894199416272*^9}, 
   3.6688942471993523`*^9, 3.6689681266492815`*^9, 3.669047865799522*^9, {
   3.669059457303144*^9, 3.669059533846211*^9}, 3.6690597377585077`*^9, 
   3.6690620128272753`*^9, 3.6694096558641977`*^9, 3.669412027614023*^9, 
   3.669415130023068*^9, 3.670041434391499*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]x2", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], "+", 
     RowBox[{"x", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]t1", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{
       SuperscriptBox["\[Phi]3", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"\[Phi]3", "[", 
    RowBox[{"t", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.665904028156803*^9, 3.665904035450716*^9}, {
  3.665904105715448*^9, 3.665904106026861*^9}, {3.665904217403008*^9, 
  3.6659042174890337`*^9}, {3.6688942421865587`*^9, 3.66889427221912*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]3", "[", 
     RowBox[{"t", ",", "x"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", "t", "]"}], "+", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "x", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x2", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "-", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t1", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.665904035696335*^9, 3.665904127660862*^9, 
  3.66590423777185*^9, 3.6660586437569447`*^9, 3.666062875899219*^9, 
  3.668473318486374*^9, 3.668631942934029*^9, 3.668634499818774*^9, 
  3.668661611925674*^9, 3.6686618167740507`*^9, 3.6686985967159986`*^9, 
  3.668708844503524*^9, 3.668813945706388*^9, 3.668829690706903*^9, 
  3.66889427312372*^9, 3.668968127974357*^9, 3.6690478673764753`*^9, 
  3.669059539430058*^9, 3.669059738948867*^9, 3.6690620128759127`*^9, 
  3.6694096621562023`*^9, 3.6694120276705027`*^9, 3.669415130524475*^9, 
  3.670041435033723*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]3", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]4", "[", "t", "]"}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "x", " ", 
        RowBox[{
         SuperscriptBox["\[Xi]x2", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["x", "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Xi]t1", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", "4", 
      ",", 
      RowBox[{"\"\<extras\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Exp", "[", "u", "]"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665904042459031*^9, 3.665904118796851*^9}, {
   3.6659042199875307`*^9, 3.6659042201644917`*^9}, {3.666058650877903*^9, 
   3.666058660590176*^9}, 3.668473271403417*^9, {3.668661614662087*^9, 
   3.668661618278163*^9}, 3.668829694747323*^9, {3.668894250050552*^9, 
   3.668894280034007*^9}, 3.669059545192492*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.025711`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"8", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]4", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t1", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["\[Xi]x2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], "+", 
          RowBox[{"x", " ", 
           RowBox[{
            SuperscriptBox["\[Xi]t1", 
             TagBox[
              RowBox[{"(", "3", ")"}],
              Derivative],
             MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6659040589998703`*^9, 3.66590408904496*^9}, 
   3.6659041277779818`*^9, 3.665904237857576*^9, {3.666058652759323*^9, 
   3.66605866098575*^9}, 3.6660628759808273`*^9, 3.668473319149046*^9, 
   3.6686319435886097`*^9, 3.6686345013221483`*^9, 3.668661618985326*^9, 
   3.6686618174430027`*^9, 3.668698597625566*^9, 3.668708844572603*^9, 
   3.6688139490435534`*^9, 3.6688296954348288`*^9, 3.668894285116103*^9, 
   3.6689681290044165`*^9, 3.669047868998275*^9, {3.6690595417281437`*^9, 
   3.6690595457260237`*^9}, 3.669059739965756*^9, 3.669062012931726*^9, 
   3.669409665943468*^9, 3.669412027740316*^9, 3.669415131251978*^9, 
   3.670041435691329*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Symmetries", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Phi]4", "[", "t_", "]"}], ":=", 
     RowBox[{"\[Phi]0", "-", 
      RowBox[{
       RowBox[{"1", "/", "4"}], "*", 
       RowBox[{
        RowBox[{"\[Xi]t1", "'"}], "[", "t", "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]x2", "[", "t_", "]"}], ":=", 
     RowBox[{"\[Xi]x0", "+", 
      RowBox[{"\[Xi]x3", "*", "t"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]t1", "[", "t_", "]"}], ":=", 
     RowBox[{"\[Xi]t0", "+", 
      RowBox[{"t", "*", "\[Xi]t2"}], "+", 
      RowBox[{
       RowBox[{"t", "^", "2"}], "*", "\[Xi]t3"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"FindInvariance", "[", 
     RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
     "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Flatten", "[", "Q", "]"}], "[", 
       RowBox[{"[", "i", "]"}], "]"}], "@@", 
      RowBox[{"Flatten", "[", 
       RowBox[{"var", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", 
        RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6659036503065033`*^9, 3.665903692261022*^9}, {
   3.665903977923088*^9, 3.665903978459127*^9}, {3.665904331160164*^9, 
   3.665904331666333*^9}, 3.665904362019681*^9, 3.6684732714051733`*^9, {
   3.6688942915860233`*^9, 3.6688943158106956`*^9}, {3.669059550118444*^9, 
   3.669059555758853*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "u"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Phi]2", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x"}], "]"}], "-", 
     RowBox[{
      SuperscriptBox["\[Phi]2", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x"}], "]"}]}], ")"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.665903684879056*^9, 3.665903693440545*^9}, {
   3.665903968806595*^9, 3.665903986352631*^9}, 3.665904127937907*^9, 
   3.665904238033609*^9, 3.665904270621902*^9, {3.665904334826468*^9, 
   3.665904362300152*^9}, 3.6660586687385597`*^9, 3.666062876039987*^9, 
   3.66847331974933*^9, 3.668631947065647*^9, 3.668634502096539*^9, 
   3.668661620797283*^9, 3.668661818086995*^9, 3.6686985989154987`*^9, 
   3.6687088446395597`*^9, 3.668813951258897*^9, 3.668829697407958*^9, {
   3.6688942983534117`*^9, 3.6688943188100367`*^9}, 3.668968130479501*^9, 
   3.669047873126431*^9, 3.669059557630425*^9, 3.669059740907054*^9, 
   3.669062012986319*^9, 3.6694096974466953`*^9, 3.669412027802689*^9, 
   3.6694151318540773`*^9, 3.670041436329996*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "\[Xi]t2"}], "-", 
      RowBox[{"2", " ", "t", " ", "\[Xi]t3"}]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["x", "2"]}], " ", "\[Xi]t3"}], "-", 
      RowBox[{"2", " ", "x", " ", "\[Xi]x3"}]}], ")"}]}], "+", "\[Phi]0", "-", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "x"}], "]"}]}]], " ", 
    RowBox[{"\[Phi]2", "[", 
     RowBox[{"t", ",", "x"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "x", " ", 
       RowBox[{"(", 
        RowBox[{"\[Xi]t2", "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]t3"}]}], ")"}]}], "+", "\[Xi]x0", 
      "+", 
      RowBox[{"t", " ", "\[Xi]x3"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Xi]t0", "+", 
      RowBox[{"t", " ", "\[Xi]t2"}], "+", 
      RowBox[{
       SuperscriptBox["t", "2"], " ", "\[Xi]t3"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x"}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.665903684879056*^9, 3.665903693440545*^9}, {
   3.665903968806595*^9, 3.665903986352631*^9}, 3.665904127937907*^9, 
   3.665904238033609*^9, 3.665904270621902*^9, {3.665904334826468*^9, 
   3.665904362300152*^9}, 3.6660586687385597`*^9, 3.666062876039987*^9, 
   3.66847331974933*^9, 3.668631947065647*^9, 3.668634502096539*^9, 
   3.668661620797283*^9, 3.668661818086995*^9, 3.6686985989154987`*^9, 
   3.6687088446395597`*^9, 3.668813951258897*^9, 3.668829697407958*^9, {
   3.6688942983534117`*^9, 3.6688943188100367`*^9}, 3.668968130479501*^9, 
   3.669047873126431*^9, 3.669059557630425*^9, 3.669059740907054*^9, 
   3.669062012986319*^9, 3.6694096974466953`*^9, 3.669412027802689*^9, 
   3.6694151318540773`*^9, 3.670041436347074*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Adjoint", " ", "symmetries"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]u", "[", 
       RowBox[{"t", ",", "x", ",", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"t", ",", "x", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"t", ",", "x", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x"}], "}"}], ",", 
       RowBox[{"{", "u", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "\[CapitalLambda]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"1", ",", "0"}], "]"}], "[", "u", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.668661642541936*^9, 3.6686616516828213`*^9}, {
   3.668661802413631*^9, 3.668661802533092*^9}, {3.668662103706786*^9, 
   3.668662104825788*^9}, {3.668894328234558*^9, 3.6688943856098747`*^9}, {
   3.668968137309891*^9, 3.668968149062564*^9}, 3.669047890806055*^9, {
   3.6690595908153973`*^9, 3.669059699822117*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
       RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{
          "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
           RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.668661663533547*^9, 3.6686616659648113`*^9}, {
   3.668894389801292*^9, 3.668894395609468*^9}, {3.669059682306562*^9, 
   3.669059718086059*^9}, 3.669062003904222*^9}],

Cell[BoxData["37"], "Output",
 CellChangeTimes->{
  3.6686616661573677`*^9, 3.6686618221096573`*^9, 3.668698604698943*^9, 
   3.668708844700034*^9, 3.6688139550407543`*^9, 3.66882970020786*^9, 
   3.668894396522973*^9, 3.668968152118738*^9, {3.66904787754315*^9, 
   3.669047893953603*^9}, {3.6690597230628223`*^9, 3.669059743663822*^9}, 
   3.6690620131956778`*^9, 3.669409704389374*^9, 3.66941202786569*^9, 
   3.6694151330546913`*^9, 3.670041437921103*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6686616661573677`*^9, 3.6686618221096573`*^9, 3.668698604698943*^9, 
   3.668708844700034*^9, 3.6688139550407543`*^9, 3.66882970020786*^9, 
   3.668894396522973*^9, 3.668968152118738*^9, {3.66904787754315*^9, 
   3.669047893953603*^9}, {3.6690597230628223`*^9, 3.669059743663822*^9}, 
   3.6690620131956778`*^9, 3.669409704389374*^9, 3.66941202786569*^9, 
   3.6694151330546913`*^9, 3.670041437970834*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", "1", 
      ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.668661694574628*^9, 3.6686616984617653`*^9}, {
  3.668894399881776*^9, 3.668894404107216*^9}, {3.6690597498456783`*^9, 
  3.66905975650108*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.05423`", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668661673307419*^9, 3.66866169869315*^9}, 
   3.6686618232127647`*^9, 3.668698606677692*^9, 3.66870884478137*^9, 
   3.668813957203792*^9, 3.668829702116355*^9, 3.6688944048394423`*^9, 
   3.668968153041791*^9, 3.6690478960893927`*^9, 3.669059757098669*^9, 
   3.669062013272005*^9, 3.669409706287972*^9, 3.669412027960703*^9, 
   3.669415133715219*^9, 3.670041438931785*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", "2", 
      ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6686616765560207`*^9, 3.668661708446416*^9}, {
  3.668894409828227*^9, 3.668894411993767*^9}, {3.6690597600221033`*^9, 
  3.6690597618055162`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.020688`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]x", "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Zeta]x", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "u"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "u"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668661705440069*^9, 3.668661708566723*^9}, 
   3.668661825357212*^9, 3.668698609041868*^9, 3.668708844845602*^9, 
   3.6688139590243483`*^9, 3.668829702838869*^9, 3.6688944134438553`*^9, 
   3.6689681537468314`*^9, 3.669047897867885*^9, 3.669059762203446*^9, 
   3.669062013329014*^9, 3.669409708555372*^9, 3.669412028036111*^9, 
   3.669415134239297*^9, 3.670041439599553*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Zeta]x", "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", 
    RowBox[{"2", " ", 
     RowBox[{
      SuperscriptBox["\[Zeta]x", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "u"}], "]"}]}]}], ",", 
   RowBox[{"\[Zeta]x", "[", 
    RowBox[{"t", ",", "x", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "u"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6686617298138323`*^9, 3.668661738837509*^9}, {
  3.668661855990892*^9, 3.668661862310032*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Zeta]x", "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"u", "/", "2"}]], " ", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"t", ",", "x"}], "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.668661739261806*^9, 3.6686618630054407`*^9, 
  3.668698611082128*^9, 3.668708844896058*^9, 3.668813960543605*^9, 
  3.6688297035793543`*^9, 3.668894419187215*^9, 3.6689681547118864`*^9, 
  3.66904789969628*^9, 3.669059765203514*^9, 3.669062013372768*^9, 
  3.669409709830246*^9, 3.6694120282102547`*^9, 3.669415134846459*^9, 
  3.670041440276875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Zeta]x", "[", 
   RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"u", "/", "2"}]], " ", 
   RowBox[{"\[Zeta]x1", "[", 
    RowBox[{"t", ",", "x"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", "1", 
      ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.66866174450912*^9, 3.6686617926769857`*^9}, {
  3.66866186670989*^9, 3.6686618925732527`*^9}, {3.6688944214968*^9, 
  3.6688944232577057`*^9}, {3.6690597675334063`*^9, 3.669059769445465*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.036241`", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"u", "/", "2"}]], " ", 
        RowBox[{"\[Zeta]x1", "[", 
         RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6686617662105837`*^9, 3.6686617931129847`*^9}, {
   3.6686618888101053`*^9, 3.668661892805415*^9}, 3.66869861317848*^9, 
   3.6687088449739847`*^9, 3.668813961954125*^9, 3.6688297063625927`*^9, 
   3.668894424801663*^9, 3.668968155798949*^9, 3.669047901237125*^9, 
   3.6690597706573067`*^9, 3.6690620134383287`*^9, 3.6694097118406267`*^9, 
   3.669412028253433*^9, 3.669415135460504*^9, 3.670041440851544*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]x1", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", "2", 
      ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6686619001814747`*^9, 3.668661910917046*^9}, {
  3.6688944296816053`*^9, 3.66889443294599*^9}, {3.669059773085534*^9, 
  3.669059774564906*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.00918`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Psi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Psi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"\[Psi]u", "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Psi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "u"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668661908729377*^9, 3.668661911343542*^9}, 
   3.668698614554531*^9, 3.6687088450433817`*^9, 3.668813962991334*^9, 
   3.668829710164405*^9, 3.668894435580112*^9, 3.6689681570370197`*^9, 
   3.669047903130766*^9, 3.6690597750916233`*^9, 3.669062013485776*^9, 
   3.66940971367966*^9, 3.669412028293828*^9, 3.6694151359451513`*^9, 
   3.67004144132747*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Psi]u", "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", 
    RowBox[{
     SuperscriptBox["\[Psi]u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], ",", 
   RowBox[{"\[Psi]u", "[", 
    RowBox[{"t", ",", "x", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "u"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6686619208709917`*^9, 3.668661929468091*^9}, {
  3.6688944404493837`*^9, 3.668894445897843*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Psi]u", "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "u"], " ", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"t", ",", "x"}], "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.668661930407866*^9, 3.668698615931229*^9, 3.668708845163753*^9, 
   3.668813965536557*^9, 3.668829711799094*^9, {3.66889444361723*^9, 
   3.668894446365643*^9}, 3.66896815879212*^9, 3.6690479048688107`*^9, 
   3.669059776739902*^9, 3.66906201352617*^9, 3.6694097149144173`*^9, 
   3.6694120283327703`*^9, 3.669415136445944*^9, 3.670041442475065*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "u"], " ", 
    RowBox[{"\[Psi]2", "[", 
     RowBox[{"t", ",", "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Flatten", "[", "Q", "]"}], "[", 
     RowBox[{"[", "i", "]"}], "]"}], "@@", 
    RowBox[{"Flatten", "[", 
     RowBox[{"var", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"Length", "[", 
      RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6686619384040003`*^9, 3.668661953388062*^9}, {
  3.6686619989797573`*^9, 3.668662002956098*^9}, {3.668894448842002*^9, 
  3.6688944745770817`*^9}, {3.6690597786456757`*^9, 3.6690597828205233`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["\[ExponentialE]", "u"]}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Psi]2", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x"}], "]"}], "+", 
     RowBox[{
      SuperscriptBox["\[Psi]2", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x"}], "]"}]}], ")"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.668661954029357*^9, 3.668662003259172*^9, 3.668698616918366*^9, 
   3.668708845213871*^9, 3.668813967376766*^9, 3.668829714868078*^9, {
   3.668894456908682*^9, 3.668894474999834*^9}, 3.668968159734174*^9, 
   3.669047906468968*^9, 3.669059784076942*^9, 3.669062013564311*^9, 
   3.669409717295638*^9, 3.669412028373129*^9, 3.669415136979349*^9, 
   3.670041443059187*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"u", "[", 
     RowBox[{"t", ",", "x"}], "]"}]], " ", 
   RowBox[{"\[Psi]2", "[", 
    RowBox[{"t", ",", "x"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.668661954029357*^9, 3.668662003259172*^9, 3.668698616918366*^9, 
   3.668708845213871*^9, 3.668813967376766*^9, 3.668829714868078*^9, {
   3.668894456908682*^9, 3.668894474999834*^9}, 3.668968159734174*^9, 
   3.669047906468968*^9, 3.669059784076942*^9, 3.669062013564311*^9, 
   3.669409717295638*^9, 3.669412028373129*^9, 3.669415136979349*^9, 
   3.670041443059959*^9}]
}, Open  ]]
},
WindowSize->{755, 848},
WindowMargins->{{Automatic, -3}, {Automatic, -10}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 265, 4, 32, "Input"],
Cell[826, 26, 3408, 88, 187, "Input"],
Cell[CellGroupData[{
Cell[4259, 118, 1834, 43, 165, "Input"],
Cell[6096, 163, 2101, 30, 32, "Output"],
Cell[8200, 195, 2373, 41, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10610, 241, 576, 13, 32, "Input"],
Cell[11189, 256, 1998, 42, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13224, 303, 702, 17, 55, "Input"],
Cell[13929, 322, 1310, 28, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15276, 355, 779, 19, 55, "Input"],
Cell[16058, 376, 2027, 50, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18122, 431, 979, 25, 55, "Input"],
Cell[19104, 458, 2171, 55, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21312, 518, 818, 25, 37, "Input"],
Cell[22133, 545, 1176, 27, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23346, 577, 1441, 33, 99, "Input"],
Cell[24790, 612, 1748, 39, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26575, 656, 1007, 28, 37, "Input"],
Cell[27585, 686, 1348, 33, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28970, 724, 1457, 39, 127, "Input"],
Cell[30430, 765, 1676, 40, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32143, 810, 1748, 48, 143, "Input"],
Cell[33894, 860, 1382, 33, 37, "Output"],
Cell[35279, 895, 2384, 66, 121, "Output"]
}, Open  ]],
Cell[37678, 964, 1938, 55, 143, "Input"],
Cell[CellGroupData[{
Cell[39641, 1023, 1594, 40, 187, "Input"],
Cell[41238, 1065, 459, 7, 32, "Output"],
Cell[41700, 1074, 819, 21, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42556, 1100, 531, 13, 55, "Input"],
Cell[43090, 1115, 672, 15, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43799, 1135, 682, 18, 77, "Input"],
Cell[44484, 1155, 2186, 60, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46707, 1220, 708, 20, 37, "Input"],
Cell[47418, 1242, 731, 17, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48186, 1264, 852, 21, 80, "Input"],
Cell[49041, 1287, 802, 18, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49880, 1310, 669, 18, 77, "Input"],
Cell[50552, 1330, 2693, 76, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53282, 1411, 674, 19, 37, "Input"],
Cell[53959, 1432, 705, 16, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54701, 1453, 1146, 29, 77, "Input"],
Cell[55850, 1484, 1016, 29, 37, "Output"],
Cell[56869, 1515, 625, 14, 38, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
