(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    362071,      10259]
NotebookOptionsPosition[    354555,      10011]
NotebookOutlinePosition[    354902,      10026]
CellTagsIndexPosition[    354859,      10023]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input",
 CellChangeTimes->{{3.665859232344759*^9, 3.665859236735454*^9}, {
  3.665863815026243*^9, 3.665863849178424*^9}, {3.665863882380316*^9, 
  3.665863929521386*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"PDE", " ", "we", " ", "seek", " ", "symmetries", " ", 
    RowBox[{"of", "."}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]1", "[", 
      RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Rho]", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
          "]"}], "+", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
           "]"}]}], "+", 
         RowBox[{
          RowBox[{"v", "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
           "]"}]}], "+", 
         RowBox[{
          RowBox[{"w", "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
           "]"}]}]}], ")"}]}], "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
       "]"}]}]}], ";", 
    RowBox[{
     RowBox[{"\[CapitalDelta]2", "[", 
      RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Rho]", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"v", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
          "]"}], "+", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"v", "[", 
             RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
           "]"}]}], "+", 
         RowBox[{
          RowBox[{"v", "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"v", "[", 
             RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
           "]"}]}], "+", 
         RowBox[{
          RowBox[{"w", "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"v", "[", 
             RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
           "]"}]}]}], ")"}]}], "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
       "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]3", "[", 
      RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Rho]", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"w", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
          "]"}], "+", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"w", "[", 
             RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
           "]"}]}], "+", 
         RowBox[{
          RowBox[{"v", "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"w", "[", 
             RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
           "]"}]}], "+", 
         RowBox[{
          RowBox[{"w", "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"w", "[", 
             RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
           "]"}]}]}], ")"}]}], "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
       "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]4", "[", 
      RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", " ", "x"}], 
       "]"}], "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"v", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
       "]"}], "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"w", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
       "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Q1", "[", 
      RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]u", "[", 
       RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"v", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]y", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]z", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
        "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Q2", "[", 
      RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]v", "[", 
       RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"v", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]y", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]z", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
        "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Q3", "[", 
      RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]w", "[", 
       RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"v", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]y", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]z", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
        "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Q4", "[", 
      RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]p", "[", 
       RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"v", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]y", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]z", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
        "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", 
      RowBox[{
      "\[CapitalDelta]1", ",", "\[CapitalDelta]2", ",", "\[CapitalDelta]3", 
       ",", "\[CapitalDelta]4"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", 
      RowBox[{"Q1", ",", "Q2", ",", "Q3", ",", "Q4"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], "[", "u", "]"}], 
       ",", 
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], "[", "v", "]"}], 
       ",", 
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], "[", "w", "]"}], 
       ",", 
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], "[", "p", 
        "]"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665859055545368*^9, 3.665859056670993*^9}, 
   3.665859222359338*^9, {3.6658595332618227`*^9, 3.665859535110145*^9}, {
   3.665859711964427*^9, 3.665859713110396*^9}, {3.665860496681065*^9, 
   3.6658605636404743`*^9}, {3.665860875037993*^9, 3.665860881549271*^9}, {
   3.665861046773204*^9, 3.665861049549117*^9}, {3.665861674569313*^9, 
   3.6658616967593813`*^9}, {3.6658620374299707`*^9, 3.665862049470551*^9}, {
   3.6658621101506977`*^9, 3.6658621268486853`*^9}, 3.665862225420937*^9, {
   3.665867355970107*^9, 3.6658674061107483`*^9}, {3.665867527086009*^9, 
   3.66586757559233*^9}, {3.668473335238072*^9, 3.668473364071412*^9}, {
   3.668473403958996*^9, 3.6684734041744432`*^9}, {3.668666934110867*^9, 
   3.668666934716411*^9}, {3.6688948436278563`*^9, 3.6688949629672737`*^9}, {
   3.668900298940126*^9, 3.668900342122751*^9}, {3.6690479336378517`*^9, 
   3.669047950500247*^9}, {3.66905981321465*^9, 3.669059999756505*^9}, {
   3.669060054638034*^9, 3.669060071373188*^9}, {3.669060852322695*^9, 
   3.669060852673479*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
          "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.665860553384531*^9, 3.665860557223929*^9}, {
   3.665860738233917*^9, 3.665860740785784*^9}, {3.6658612774842663`*^9, 
   3.66586128001158*^9}, {3.665862134590067*^9, 3.6658621370127*^9}, {
   3.665863682232481*^9, 3.6658636923756037`*^9}, 3.6684733641198683`*^9, {
   3.6688949686804667`*^9, 3.668894968952523*^9}, {3.668906211003017*^9, 
   3.668906218098483*^9}, {3.668914698913643*^9, 3.668914713105369*^9}, 
   3.6689969883515882`*^9, {3.668997070299459*^9, 3.6689970724589577`*^9}, 
   3.669060038541649*^9, {3.669061019500914*^9, 3.6690610284298487`*^9}, {
   3.669061092076696*^9, 3.669061092452908*^9}}],

Cell[BoxData["733"], "Output",
 CellChangeTimes->{
  3.668829179360745*^9, 3.668894974300693*^9, 3.668896830794547*^9, 
   3.668897156833852*^9, 3.668900358939768*^9, 3.668903394160543*^9, 
   3.668903454000346*^9, 3.668905197105061*^9, {3.6689062086317673`*^9, 
   3.6689062188211813`*^9}, 3.668914703150516*^9, 3.668966693607316*^9, 
   3.66896804182543*^9, 3.6689757920103593`*^9, 3.668996989243285*^9, 
   3.6689970735365763`*^9, 3.6690479544496517`*^9, 3.669060044266777*^9, 
   3.6690600819067173`*^9, 3.669061813547114*^9, 3.669069060450801*^9, 
   3.6691468906519337`*^9, 3.669409735570098*^9, 3.669410087581698*^9, 
   3.669410250656396*^9, 3.669410802643087*^9, 3.669411469766863*^9, 
   3.669412087612791*^9, 3.6694123711554832`*^9, 3.6694124602899027`*^9, 
   3.6694133518473997`*^9, 3.67004150058679*^9, 3.670043645795409*^9, 
   3.670043767356159*^9, 3.670043941250325*^9, 3.670044036271064*^9, 
   3.670044295977173*^9, 3.670044916507249*^9, 3.670090704104378*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]], ",", 
   SubscriptBox["v", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["v", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["v", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]], ",", 
   SubscriptBox["w", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["w", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["w", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]], ",", 
   SubscriptBox["p", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["p", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["p", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.668829179360745*^9, 3.668894974300693*^9, 3.668896830794547*^9, 
   3.668897156833852*^9, 3.668900358939768*^9, 3.668903394160543*^9, 
   3.668903454000346*^9, 3.668905197105061*^9, {3.6689062086317673`*^9, 
   3.6689062188211813`*^9}, 3.668914703150516*^9, 3.668966693607316*^9, 
   3.66896804182543*^9, 3.6689757920103593`*^9, 3.668996989243285*^9, 
   3.6689970735365763`*^9, 3.6690479544496517`*^9, 3.669060044266777*^9, 
   3.6690600819067173`*^9, 3.669061813547114*^9, 3.669069060450801*^9, 
   3.6691468906519337`*^9, 3.669409735570098*^9, 3.669410087581698*^9, 
   3.669410250656396*^9, 3.669410802643087*^9, 3.669411469766863*^9, 
   3.669412087612791*^9, 3.6694123711554832`*^9, 3.6694124602899027`*^9, 
   3.6694133518473997`*^9, 3.67004150058679*^9, 3.670043645795409*^9, 
   3.670043767356159*^9, 3.670043941250325*^9, 3.670044036271064*^9, 
   3.670044295977173*^9, 3.670044916507249*^9, 3.6700907069675417`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.665883470602792*^9, 3.665883514147079*^9}, {
   3.6658835910581913`*^9, 3.665883603233927*^9}, {3.6660626172013083`*^9, 
   3.66606261739368*^9}, 3.6684733641361437`*^9, {3.668894976596033*^9, 
   3.66889499076326*^9}, {3.6688964521645393`*^9, 3.6688964990912857`*^9}, {
   3.668900365665225*^9, 3.668900373105051*^9}, 3.669060099587496*^9, 
   3.669146821297082*^9, 3.669410836218403*^9, {3.669411070190836*^9, 
   3.6694110778059263`*^9}, 3.66941122766998*^9, {3.6694115433553467`*^9, 
   3.669411543594496*^9}, {3.669411593978429*^9, 3.669411596993354*^9}, 
   3.67004366174312*^9, {3.670043715182968*^9, 3.670043734590304*^9}, 
   3.670044047740943*^9, 3.670044298971052*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.31424680000000027035866878577508032322`6.6555048989261465", ",", 
   RowBox[{"{", 
    RowBox[{"135", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Xi]t", "w"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]t", "v"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]z", "w"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]z", "v"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]y", "v"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]y", "w"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]x", "v"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]x", "w"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Phi]p", "v"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Phi]p", "w"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]t", "u"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]z", "u"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]x", "u"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]y", "u"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]x", "p"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]t", "p"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]z", "p"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]y", "p"], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["p", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["u", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["w", "t"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["p", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["u", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["v", "t"], " ", 
            SubscriptBox["v", "y"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubsuperscriptBox["p", "z", "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["u", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["v", "z"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubsuperscriptBox["p", "y", "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["u", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["w", "y"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["v", "t"], " ", 
            SubscriptBox["v", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["v", "t"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["v", "z"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubsuperscriptBox["v", "y", "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["v", "z"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["v", "t"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["w", "t"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubsuperscriptBox["w", "z", "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["w", "y"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["w", "y"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["v", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["v", "t"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["v", "z"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["v", "z"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["w", "t"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["w", "y"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["w", "y"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["u", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["u", "z"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{
           SubscriptBox["p", "z"], " ", 
           SubscriptBox["u", "y"]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["u", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["u", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["u", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["u", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubsuperscriptBox["u", "y", "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["u", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["u", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["v", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["u", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubsuperscriptBox["u", "z", "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["u", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["v", "y"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{
           SubscriptBox["p", "y"], " ", 
           SubscriptBox["u", "z"]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubsuperscriptBox["p", "z", "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubsuperscriptBox["p", "y", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubsuperscriptBox["u", "t", "2"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubsuperscriptBox["u", "z", "2"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubsuperscriptBox["u", "y", "2"]}], "}"}], "}"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.66941240247227*^9, 3.669412474644533*^9, 3.66941251914633*^9, 
   3.669413358714472*^9, 3.669413449678046*^9, 3.6700415075687523`*^9, {
   3.670043652183133*^9, 3.670043663941832*^9}, {3.670043717140983*^9, 
   3.670043737676291*^9}, 3.670043772612995*^9, 3.6700439478555307`*^9, {
   3.670044043888258*^9, 3.6700440499157887`*^9}, 3.670044302608807*^9, 
   3.670044922381089*^9, 3.6700907124638567`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Xi]t1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Xi]y1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]z", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Xi]z1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]p", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Phi]p1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "p"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
    RowBox[{"\"\<SuppressArgs\>\"", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665876703858831*^9, 3.665876707858623*^9}, {
   3.665876738658638*^9, 3.665876756751383*^9}, {3.665883445308009*^9, 
   3.665883448292351*^9}, {3.6658836292598047`*^9, 3.6658836310027103`*^9}, {
   3.66606263714058*^9, 3.666062637329859*^9}, 3.6684733641482077`*^9, {
   3.668809306990337*^9, 3.6688093131308403`*^9}, 3.6688093488520403`*^9, {
   3.66889652440303*^9, 3.668896625243271*^9}, 3.668900396894652*^9, {
   3.66890050775347*^9, 3.6689005080967703`*^9}, {3.668900640103466*^9, 
   3.668900646190693*^9}, 3.6690607441750307`*^9, 3.669146821299073*^9, 
   3.66941127375244*^9, {3.6694116608511066`*^9, 3.669411664042927*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.32507580000000002584670255600940436125`6.142840635763879", ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Xi]t1", "x"], "\[Equal]", 
        RowBox[{"\[Rho]", " ", 
         SubscriptBox["\[Phi]u", "p"]}]}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]t1", "y"], "\[Equal]", 
        RowBox[{"\[Rho]", " ", 
         SubscriptBox["\[Phi]v", "p"]}]}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]t1", "z"], "\[Equal]", 
        RowBox[{"\[Rho]", " ", 
         SubscriptBox["\[Phi]w", "p"]}]}], ",", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[Xi]t1", "x"], "+", 
         RowBox[{"\[Rho]", " ", 
          SubscriptBox["\[Phi]u", "p"]}]}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["p", "t"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          SubscriptBox["p", "t"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          SubscriptBox["p", "t"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["u", "t"]}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.668829181798842*^9, {3.668896623795455*^9, 3.668896626410475*^9}, 
   3.668896836009557*^9, 3.668897161392569*^9, 3.668900440476499*^9, 
   3.6689005094844847`*^9, 3.668900647913986*^9, 3.66890346179364*^9, 
   3.66890520145934*^9, 3.66896670433593*^9, 3.668968047169736*^9, 
   3.668975800255831*^9, 3.669047971939519*^9, 3.6690607470903788`*^9, 
   3.669061819600719*^9, 3.6691468970681353`*^9, 3.669411275328764*^9, 
   3.6694116215267*^9, {3.669411661848036*^9, 3.6694116650138206`*^9}, 
   3.669412145987336*^9, 3.6694125339498863`*^9, 3.669413473293969*^9, 
   3.670041511038501*^9, 3.670044926574533*^9, 3.670090716156068*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Phi]u1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t1", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{"\[Xi]t2", "[", 
    RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]v", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]v1", "[", 
     RowBox[{
     "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], "]"}],
     "+", 
    RowBox[{
     RowBox[{"p", "/", "\[Rho]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[Xi]t2", "[", 
        RowBox[{"y", ",", "z", ",", "t"}], "]"}], ",", "y"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]w", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]w1", "[", 
     RowBox[{
     "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], "]"}],
     "+", 
    RowBox[{
     RowBox[{"p", "/", "\[Rho]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[Xi]t2", "[", 
        RowBox[{"y", ",", "z", ",", "t"}], "]"}], ",", "z"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
    RowBox[{"\"\<SuppressArgs\>\"", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.66587679055571*^9, 3.6658768108625402`*^9}, 
   3.665883636747652*^9, {3.6660626486990623`*^9, 3.666062649043416*^9}, 
   3.668473364151894*^9, {3.668896690162174*^9, 3.668896737338677*^9}, {
   3.668896819217697*^9, 3.668896819288863*^9}, {3.668896865905225*^9, 
   3.66889699764072*^9}, {3.66889713821699*^9, 3.66889713915184*^9}, 
   3.668900396921994*^9, {3.6689006728961153`*^9, 3.668900676975967*^9}, {
   3.6689007113352623`*^9, 3.668900714135788*^9}, 3.669060749646805*^9, 
   3.669146821300641*^9, 3.6694116829785433`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.40408029999999994785753187898080796003`6.167991859285414", ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["\[Xi]z1", "x"], "+", 
         SubscriptBox["\[Phi]u1", "w"]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[Xi]y1", "x"], "+", 
         SubscriptBox["\[Phi]u1", "v"]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]z1", "x"], "\[Equal]", 
        SubscriptBox["\[Phi]w1", "u"]}], ",", 
       RowBox[{
        SubscriptBox["\[Xi]y1", "x"], "\[Equal]", 
        SubscriptBox["\[Phi]v1", "u"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["p", "z"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["p", "y"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["u", "z"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["u", "y"]}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.668829182403842*^9, {3.66889672996837*^9, 3.6688967380619087`*^9}, {
   3.6688969928142633`*^9, 3.6688970011347933`*^9}, 3.66889716347946*^9, 
   3.668900735223298*^9, 3.668903477632566*^9, 3.6689052024670267`*^9, 
   3.6689667077711267`*^9, 3.6689680483928056`*^9, 3.6689758020839353`*^9, 
   3.669047978660656*^9, 3.669060751094665*^9, 3.6690618206959*^9, 
   3.6691468981508923`*^9, 3.66941168451086*^9, 3.6694121477393436`*^9, 
   3.6694125373103867`*^9, 3.669413475915141*^9, 3.670041513402212*^9, 
   3.6700449317024107`*^9, 3.670090718547204*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]v1", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]v2", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v", ",", "w"}], "]"}], 
    "+", 
    RowBox[{"u", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[Xi]y1", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]w1", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]w2", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v", ",", "w"}], "]"}], 
    "+", 
    RowBox[{"u", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[Xi]z1", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u2", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u"}], "]"}], "-", 
    RowBox[{"v", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[Xi]y1", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
      "]"}]}], "-", 
    RowBox[{"w", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[Xi]z1", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668897034116686*^9, 3.6688971344392643`*^9}, {
   3.668897184166318*^9, 3.668897247351473*^9}, {3.668897280230227*^9, 
   3.6688973025590277`*^9}, 3.6689003969393177`*^9, 3.6690607524706697`*^9, 
   3.669146821302251*^9, {3.669411688289488*^9, 3.6694116896983137`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.53208760000000010492726687516551464796`6.20588351089277", ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"w", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]z1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]v2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], 
             ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v", ",", "w"}], 
          "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"u", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"v", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]w2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], 
             ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v", ",", "w"}], 
          "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"u", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]z1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"u", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]t2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]z1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"u", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]t2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          SubscriptBox["p", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          SubscriptBox["p", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["p", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["p", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
        "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668897235685157*^9, 3.6688972481124077`*^9}, {
   3.6688972840813932`*^9, 3.668897303400296*^9}, 3.668900783008217*^9, 
   3.6689039829853888`*^9, 3.668905203616664*^9, 3.6689667106072884`*^9, 
   3.6689680497988863`*^9, 3.668975803441013*^9, 3.669047983967156*^9, 
   3.669060754306019*^9, 3.669061821879222*^9, 3.669146899373314*^9, 
   3.66941169126175*^9, 3.6694121493478823`*^9, 3.669412540105043*^9, 
   3.669413478262743*^9, 3.6700415173262587`*^9, 3.670044936656879*^9, 
   3.6700907216823835`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t2", "[", 
    RowBox[{"y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{"\[Xi]t3", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668897342740034*^9, 3.668897375590358*^9}, 
   3.668900396945252*^9, 3.669060755270528*^9, 3.6691468213038883`*^9, {
   3.669411695257547*^9, 3.669411696825809*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.07606150000000000410693701269337907434`6.052437006494169", ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]z1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]v2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], 
             ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v", ",", "w"}], 
          "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]w2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], 
             ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v", ",", "w"}], 
          "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]z1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          SubscriptBox["p", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["p", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          SubscriptBox["p", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["p", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}]}], 
        "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6688973739011183`*^9, 3.668897376507536*^9}, 
   3.6689013548274527`*^9, 3.668903988154406*^9, 3.6689052043904343`*^9, 
   3.6689667124043913`*^9, 3.66896805075294*^9, 3.6689758043550653`*^9, 
   3.669047986826331*^9, 3.669060756413988*^9, 3.6690618226968603`*^9, 
   3.669146900220298*^9, 3.669411700087576*^9, 3.669412153947665*^9, 
   3.669412543913966*^9, 3.669413480438702*^9, 3.670041519412592*^9, 
   3.670044939645612*^9, 3.670090723870509*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]v2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "v_", ",", "w_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]v3", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v"}], "]"}], "-", 
    RowBox[{"w", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[Xi]z1", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]w2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "v_", ",", "w_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]w3", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "w"}], "]"}], "-", 
    RowBox[{"v", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[Xi]y1", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"\"\<SuppressArgs\>\"", "\[Rule]", "True"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668897391492137*^9, 3.6688975111180983`*^9}, {
  3.668900396948195*^9, 3.668900396949169*^9}, {3.668901410099019*^9, 
  3.6689014104509172`*^9}, {3.669060758902568*^9, 3.66906076225626*^9}, {
  3.669146821305533*^9, 3.669146821306067*^9}, {3.669411708713718*^9, 
  3.669411713874361*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.19006809999999996207975527795497328043`6.096171727283915", ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["\[Xi]x1", "y"], "+", 
         SubscriptBox["\[Xi]y1", "x"]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[Xi]x1", "z"], "+", 
         SubscriptBox["\[Xi]z1", "x"]}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["u", "t"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["u", "z"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["w", "z"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["p", "y"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["v", "t"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["u", "t"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["u", "y"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["v", "y"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["p", "z"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["w", "t"]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.6688974671006737`*^9, 3.668897513062999*^9}, 
   3.6689013781315823`*^9, 3.668901411428666*^9, 3.668904019328115*^9, 
   3.668905205316946*^9, 3.6689667144675093`*^9, 3.668968051792*^9, 
   3.6689758053791237`*^9, 3.669047991069314*^9, {3.669060759552556*^9, 
   3.669060763276289*^9}, 3.669061823607472*^9, 3.6691469011688967`*^9, 
   3.66941171524369*^9, 3.669412157437414*^9, 3.669413482419273*^9, 
   3.670041521833785*^9, 3.670044941384737*^9, 3.6700907250865784`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.84904849999999998377830934259691275656`5.949532412334842", ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"v", " ", "\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x1", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
         RowBox[{"v", " ", "\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y1", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]p1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], 
             ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "p"}], 
          "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"w", " ", "\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x1", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
         RowBox[{"w", " ", "\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]z1", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]p1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], 
             ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "p"}], 
          "]"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          SubscriptBox["u", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          SubscriptBox["u", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
        "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6688974671006737`*^9, 3.668897513062999*^9}, 
   3.6689013781315823`*^9, 3.668901411428666*^9, 3.668904019328115*^9, 
   3.668905205316946*^9, 3.6689667144675093`*^9, 3.668968051792*^9, 
   3.6689758053791237`*^9, 3.669047991069314*^9, {3.669060759552556*^9, 
   3.669060763276289*^9}, 3.669061823607472*^9, 3.6691469011688967`*^9, 
   3.66941171524369*^9, 3.669412157437414*^9, 3.669413482419273*^9, 
   3.670041521833785*^9, 3.670044941384737*^9, 3.670090725940627*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]p1", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "p_"}], 
    "]"}], ":=", 
   RowBox[{"\[Phi]p2", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "p"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "4", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6688975207910337`*^9, 3.6688975713902893`*^9}, {
   3.6688976043722687`*^9, 3.668897604611917*^9}, 3.668900396951092*^9, 
   3.6690607658068523`*^9, 3.6691468213076057`*^9, {3.669412162759701*^9, 
   3.669412164231553*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.98705650000000000332534000335726886988`6.014941926066723", ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]t3", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]p2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "p"}], "]"}]}], 
        "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u"}], "]"}]}]}], 
       ",", 
       RowBox[{
        RowBox[{"u", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]y1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]z1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], ")"}]}], 
        "\[Equal]", 
        RowBox[{"w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]y1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], ")"}]}]}], 
       ",", 
       RowBox[{
        RowBox[{"u", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]y1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]z1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], ")"}]}], 
        "\[Equal]", 
        RowBox[{"v", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]z1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], ")"}]}]}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["u", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["v", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["w", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
        "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668897564444887*^9, 3.6688975723005047`*^9}, 
   3.668897605605389*^9, 3.668901420511117*^9, 3.6689040750132113`*^9, 
   3.668905206411847*^9, 3.6689667172786703`*^9, 3.6689680532720847`*^9, 
   3.668975806811206*^9, 3.669048012183609*^9, 3.669060766887787*^9, 
   3.669061824941386*^9, 3.6691469025656013`*^9, 3.669412077364225*^9, 
   3.669412165309382*^9, 3.6694134877599287`*^9, 3.670041525336512*^9, 
   3.6700449435332623`*^9, 3.6700907269586854`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u3", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
    RowBox[{"u", "*", 
     RowBox[{"\[Phi]u4", "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]p2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "p_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]p3", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
    RowBox[{"p", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Xi]x1", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
       RowBox[{"\[Phi]u4", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "-", 
       RowBox[{
        SuperscriptBox["\[Xi]t3", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "p"}], "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6688976147942543`*^9, 3.668897621907588*^9}, {
   3.66889766473204*^9, 3.668897714219904*^9}, {3.668897801851637*^9, 
   3.668897819676046*^9}, {3.668897870819001*^9, 3.668897902450008*^9}, 
   3.668900396953006*^9, {3.668901498603385*^9, 3.668901508873001*^9}, {
   3.668901579216977*^9, 3.668901592800974*^9}, 3.669060768902616*^9, {
   3.669146821309531*^9, 3.669146830134397*^9}, 3.669413501222458*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.97105549999999996035882077194401063025`6.007843965695278", ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]z1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Equal]", 
        "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SuperscriptBox["u", "2"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          SuperscriptBox["u", "3"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          SuperscriptBox["u", "3"]}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.668897696514228*^9, 3.668897715032261*^9}, {
   3.668897802420762*^9, 3.6688978203036213`*^9}, {3.668897873724143*^9, 
   3.6688979031506977`*^9}, {3.668901586062488*^9, 3.668901594441037*^9}, 
   3.668904128060974*^9, 3.6689052073423433`*^9, 3.668966719152777*^9, 
   3.668968054053129*^9, 3.6689758075742493`*^9, 3.669048018684855*^9, 
   3.669060770173614*^9, 3.6690618257215853`*^9, 3.669146903313006*^9, {
   3.669413494842465*^9, 3.669413505629901*^9}, 3.670041527736374*^9, 
   3.670044945264316*^9, 3.6700907279567423`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u4", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{"\[Phi]u5", "[", 
    RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y1", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]y2", "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
    RowBox[{"x", "*", 
     RowBox[{"\[Xi]y3", "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]z1", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]z2", "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
    RowBox[{"x", "*", 
     RowBox[{"\[Xi]z3", "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "p"}], "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.66890167943736*^9, 3.668901724473075*^9}, 
   3.669060775214347*^9, {3.66914682131104*^9, 3.66914683013673*^9}, 
   3.6694135219016867`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.2000686000000000408505229643196798861`6.099805985785515", ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Xi]x1", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Equal]", "0"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "p"}], "}"}], "}"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668901725999949*^9, 3.668904156418161*^9, 
  3.668905208728425*^9, 3.6689667211658926`*^9, 3.668968054991183*^9, 
  3.668975808483301*^9, 3.669048021540511*^9, 3.669060777019487*^9, 
  3.6690618265891542`*^9, 3.669146904235759*^9, 3.6694135233527403`*^9, 
  3.670041529519895*^9, 3.670044947093088*^9, 3.6700907291848125`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x2", "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
    RowBox[{"x", "*", 
     RowBox[{"\[Xi]x3", "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "p"}], "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668901729620818*^9, 3.668901752288957*^9}, 
   3.669060777926631*^9, {3.669146821312862*^9, 3.6691468301388197`*^9}, 
   3.669413529157716*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.32707590000000008600977707828860729933`6.143495675638051", ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]z3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"p", " ", "u"}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"p", " ", "u"}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SuperscriptBox["u", "2"]}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.668901750095435*^9, 3.668901753210146*^9}, 
   3.6689042055636587`*^9, 3.668905209841111*^9, 3.668966723098003*^9, 
   3.668968056059244*^9, 3.668975809836379*^9, 3.669048024072474*^9, 
   3.6690607793457727`*^9, 3.669061827556879*^9, 3.669146905254764*^9, 
   3.669413531176035*^9, 3.6700415312518578`*^9, 3.670044948836339*^9, 
   3.670090732437999*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]x3", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
     RowBox[{
      SuperscriptBox["\[Phi]u5", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"\[Phi]u5", "[", 
    RowBox[{"y", ",", "z", ",", "t"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z", ",", "t"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]x3", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
     RowBox[{
      SuperscriptBox["\[Phi]u5", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"\[Phi]u5", "[", 
    RowBox[{"y", ",", "z", ",", "t"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z", ",", "t"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.668901886529396*^9, 3.668901904144631*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]u5", "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"\[Xi]x3", "[", 
       RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"y", ",", "t"}], "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.6689019046059427`*^9, 3.668904216285178*^9, 
  3.6689052103563557`*^9, 3.668966725053115*^9, 3.6689680569052925`*^9, 
  3.6689758106234236`*^9, 3.669048025724553*^9, 3.669060780326622*^9, 
  3.6690618276852283`*^9, 3.6691469053541803`*^9, 3.669413540370303*^9, 
  3.670041532138784*^9, 3.6700449496840963`*^9, 3.6700907333650517`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]u5", "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"\[Xi]x3", "[", 
       RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"z", ",", "t"}], "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.6689019046059427`*^9, 3.668904216285178*^9, 
  3.6689052103563557`*^9, 3.668966725053115*^9, 3.6689680569052925`*^9, 
  3.6689758106234236`*^9, 3.669048025724553*^9, 3.669060780326622*^9, 
  3.6690618276852283`*^9, 3.6691469053541803`*^9, 3.669413540370303*^9, 
  3.670041532138784*^9, 3.6700449496840963`*^9, 3.6700907333770523`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u5", "[", 
    RowBox[{"y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"\[Xi]x3", "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "+", 
    RowBox[{"\[Phi]u6", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "p"}], "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689019080394506`*^9, 3.6689019623832693`*^9}, {
   3.668901994503681*^9, 3.668901995702168*^9}, 3.6690607827099323`*^9, {
   3.669146821314459*^9, 3.669146830140963*^9}, 3.66941355030159*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.17306709999999991822505762684158980846`6.089922767958049", ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Xi]x3", "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"\[Phi]u6", "[", "t", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]t3", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Xi]y3", "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]x2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Xi]z3", "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]x2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}], "\[Equal]", "0"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["v", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["w", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["v", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["w", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}]}], 
          "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SuperscriptBox["u", "2"], " ", 
            SubscriptBox["v", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SuperscriptBox["u", "2"], " ", 
            SubscriptBox["w", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["u", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["u", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["u", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["p", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SuperscriptBox["u", "2"], " ", 
            SubscriptBox["v", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SuperscriptBox["u", "2"], " ", 
            SubscriptBox["w", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["u", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["u", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["u", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["p", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}]}], 
        "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689019346153517`*^9, 3.668901963392932*^9}, 
   3.66890199937913*^9, 3.668904249795663*^9, 3.668905211950363*^9, 
   3.6689667266742077`*^9, 3.6689680578783484`*^9, 3.668975811765489*^9, 
   3.6690480287750587`*^9, 3.6690607842951927`*^9, 3.6690618286084137`*^9, 
   3.669146906296891*^9, 3.669413551813983*^9, 3.6700415347435293`*^9, 
   3.6700449518317738`*^9, 3.6700907347591314`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x3", "[", 
    RowBox[{"y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Phi]u6", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"\[Xi]t3", "'"}], "[", "t", "]"}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y3", "[", 
    RowBox[{"y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["\[Xi]x2", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]z3", "[", 
    RowBox[{"y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["\[Xi]x2", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "p"}], "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668901974134149*^9, 3.668902087719062*^9}, 
   3.6690607869907513`*^9, {3.6691468213160973`*^9, 3.669146830143429*^9}, 
   3.669413560341179*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9570547000000000359420937456889078021`6.001536673657585", ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u6", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]u3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]t3", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{"v", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"2", ",", "0", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Phi]v3", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v"}], "]"}]}], ",", 
       
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{"w", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Phi]w3", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "w"}], "]"}]}], ",", 
       
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]z2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        RowBox[{"2", " ", "x", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "u"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          SuperscriptBox["u", "2"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          SuperscriptBox["u", "2"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}]}], 
        "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668902077444894*^9, 3.66890208865318*^9}, 
   3.66890437454272*^9, 3.668905212695805*^9, 3.6689667292403545`*^9, 
   3.6689680588164015`*^9, 3.6689758125365334`*^9, 3.6690480314603233`*^9, 
   3.6690607880370073`*^9, 3.6690618293684273`*^9, 3.669146907064043*^9, 
   3.669413562269486*^9, 3.670041536609726*^9, 3.670044953728838*^9, 
   3.670090735766189*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x2", "[", 
    RowBox[{"y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x4", "[", 
     RowBox[{"y", ",", "t"}], "]"}], "+", 
    RowBox[{"\[Xi]x5", "[", 
     RowBox[{"z", ",", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "4", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "p"}], "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.66890233059378*^9, 3.668902383668816*^9}, {
   3.668902442964419*^9, 3.668902456291873*^9}, 3.669060789790278*^9, {
   3.6691468211602*^9, 3.6691468300393667`*^9}, 3.6694135661502333`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.85304880000000005146887360751861706376`5.95157378965758", ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"\[Phi]u6", "[", "t", "]"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x4", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"y", ",", "t"}], "]"}]}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]v3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v"}], "]"}]}]}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Phi]u6", "[", "t", "]"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x5", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"z", ",", "t"}], "]"}]}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]z2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]w3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "w"}], "]"}]}]}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]t3", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x4", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"y", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]v3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v"}], "]"}]}], 
        "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]y2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]t3", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x5", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"z", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]w3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "w"}], "]"}]}], 
        "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]z2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"u", " ", 
           SubscriptBox["p", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"u", " ", 
           SubscriptBox["p", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["v", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["w", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
        "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668902376637794*^9, 3.668902384411126*^9}, {
   3.668902443565365*^9, 3.668902456859561*^9}, 3.668904403871745*^9, 
   3.6689052139141703`*^9, 3.6689667307314396`*^9, 3.6689680594524384`*^9, 
   3.6689758131885705`*^9, 3.669048034002617*^9, 3.669060790793426*^9, 
   3.669061830015761*^9, 3.669146907712369*^9, 3.669413567996655*^9, 
   3.670041538112685*^9, 3.670044955109908*^9, 3.6700907366662407`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t3", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "+", 
     RowBox[{"x", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]x4", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"y", ",", "t"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[Phi]v3", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v"}], "]"}]}], 
    "\[Equal]", 
    RowBox[{
     SuperscriptBox["\[Xi]y2", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], ",", 
   RowBox[{"\[Phi]v3", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t3", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "+", 
     RowBox[{"x", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]x5", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"z", ",", "t"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[Phi]w3", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "w"}], "]"}]}], 
    "\[Equal]", 
    RowBox[{
     SuperscriptBox["\[Xi]z2", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], ",", 
   RowBox[{"\[Phi]w3", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "w"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "w"}], "}"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6689024881228228`*^9, 3.668902571221004*^9}, {
  3.668904415801585*^9, 3.668904425377263*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]v3", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v"}], "]"}], "\[Rule]", 
    
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
     RowBox[{"v", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          SuperscriptBox["\[Xi]t3", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "-", 
        RowBox[{"x", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "t"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[Xi]y2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.66890249888124*^9, 3.668902542210018*^9}, 
   3.668902572237028*^9, 3.668904433326354*^9, 3.668905214565192*^9, 
   3.6689667313734765`*^9, 3.6689680594934406`*^9, 3.6689758132545743`*^9, 
   3.6690480354801207`*^9, 3.66906079187668*^9, 3.669061830107895*^9, 
   3.669146907816325*^9, 3.669413570660132*^9, 3.6700415393402576`*^9, 
   3.670044955760254*^9, 3.670090736712243*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]w3", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "w"}], "]"}], "\[Rule]", 
    
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
     RowBox[{"w", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          SuperscriptBox["\[Xi]t3", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "-", 
        RowBox[{"x", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"z", ",", "t"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[Xi]z2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.66890249888124*^9, 3.668902542210018*^9}, 
   3.668902572237028*^9, 3.668904433326354*^9, 3.668905214565192*^9, 
   3.6689667313734765`*^9, 3.6689680594934406`*^9, 3.6689758132545743`*^9, 
   3.6690480354801207`*^9, 3.66906079187668*^9, 3.669061830107895*^9, 
   3.669146907816325*^9, 3.669413570660132*^9, 3.6700415393402576`*^9, 
   3.670044955760254*^9, 3.670090736724244*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]v3", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "v_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]v4", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
    RowBox[{"v", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         SuperscriptBox["\[Xi]t3", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "-", 
       RowBox[{"x", " ", 
        RowBox[{
         SuperscriptBox["\[Xi]x4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"y", ",", "t"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[Xi]y2", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]w3", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "w_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]w4", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
    RowBox[{"w", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         SuperscriptBox["\[Xi]t3", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "-", 
       RowBox[{"x", " ", 
        RowBox[{
         SuperscriptBox["\[Xi]x5", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"z", ",", "t"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[Xi]z2", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668902575060195*^9, 3.668902628066045*^9}, {
   3.668902661010337*^9, 3.668902662906083*^9}, {3.668904476904828*^9, 
   3.668904480280778*^9}, 3.669060794166354*^9, {3.669146821169157*^9, 
   3.6691468300470533`*^9}, 3.669413578953199*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6570375999999999994116706147906370461`5.838190136728706", ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"y", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x5", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"z", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]z2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"y", ",", "z", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"y", ",", "z", ",", "t"}], "]"}], "\[Equal]", "0"}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SuperscriptBox["v", "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SuperscriptBox["u", "2"], " ", "v"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SuperscriptBox["w", "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SuperscriptBox["u", "2"], " ", "w"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"u", " ", 
           SuperscriptBox["w", "2"]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"u", " ", 
           SuperscriptBox["v", "2"]}]}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6689026307481956`*^9, 3.66890266590057*^9, 
  3.668904494509482*^9, 3.6689052160544777`*^9, 3.668966732856561*^9, 
  3.668968059981468*^9, 3.6689758137946053`*^9, 3.669048037906393*^9, 
  3.66906079518482*^9, 3.66906183059*^9, 3.669146908386559*^9, 
  3.669413580020219*^9, 3.670041540756778*^9, 3.670044956975086*^9, 
  3.670090738392339*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x4", "[", 
    RowBox[{"y_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x6", "[", "t", "]"}], "+", 
    RowBox[{"y", "*", 
     RowBox[{"\[Xi]x7", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x5", "[", 
    RowBox[{"z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x8", "[", "t", "]"}], "+", 
    RowBox[{"z", "*", 
     RowBox[{"\[Xi]x9", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y2", "[", 
    RowBox[{"y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]y4", "[", 
     RowBox[{"y", ",", "t"}], "]"}], "+", 
    RowBox[{"\[Xi]y5", "[", 
     RowBox[{"z", ",", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]z2", "[", 
    RowBox[{"y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]z4", "[", 
     RowBox[{"y", ",", "t"}], "]"}], "+", 
    RowBox[{"\[Xi]z5", "[", 
     RowBox[{"z", ",", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668902674252735*^9, 3.668902762554091*^9}, 
   3.6690607973101377`*^9, {3.66914682122008*^9, 3.6691468301013937`*^9}, 
   3.669413583541588*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.68403910000000001101483348975307308137`5.855680840188212", ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"y", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]z4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"y", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y5", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"z", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]z5", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"z", ",", "t"}], "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"u", " ", 
           SuperscriptBox["v", "2"]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"u", " ", "v", " ", "w"}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"u", " ", "v", " ", "w"}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"u", " ", 
           SuperscriptBox["w", "2"]}]}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668902783600564*^9, 3.6689047620548573`*^9, 
  3.668905217182918*^9, 3.6689667343966494`*^9, 3.6689680604454947`*^9, 
  3.6689758147446594`*^9, 3.669048039895849*^9, 3.669060798174238*^9, 
  3.669061831135469*^9, 3.669146908937994*^9, 3.669413584595203*^9, 
  3.6700415422519197`*^9, 3.670044958275763*^9, 3.6700907398844247`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y4", "[", 
    RowBox[{"y_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]y6", "[", "t", "]"}], "+", 
    RowBox[{"y", "*", 
     RowBox[{"\[Xi]y7", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y5", "[", 
    RowBox[{"z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]y8", "[", "t", "]"}], "+", 
    RowBox[{"z", "*", 
     RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]z4", "[", 
    RowBox[{"y_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]z6", "[", "t", "]"}], "+", 
    RowBox[{"y", "*", 
     RowBox[{"\[Xi]z7", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]z5", "[", 
    RowBox[{"z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]z8", "[", "t", "]"}], "+", 
    RowBox[{"z", "*", 
     RowBox[{"\[Xi]z9", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6689027953220778`*^9, 3.668902892625475*^9}, 
   3.668903059488344*^9, {3.668904867892849*^9, 3.668904868067821*^9}, 
   3.669060800631888*^9, {3.6691468212262907`*^9, 3.66914683010852*^9}, 
   3.669413588172811*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.70604040000000001242597136297263205051`5.869429465599244", ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u6", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]u3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]t3", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y7", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]v4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]t3", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Xi]y7", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"\[Phi]u6", "[", "t", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]t3", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]z9", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]w4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]t3", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Xi]z9", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"\[Phi]u6", "[", "t", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]t3", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]w4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]v4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "u"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"u", " ", "v"}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"u", " ", 
           SubscriptBox["p", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"u", " ", "w"}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"u", " ", 
           SubscriptBox["p", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1"}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.66890289058486*^9, 3.6689028934609833`*^9}, 
   3.668903059955945*^9, 3.668904802747257*^9, 3.668904870994012*^9, 
   3.6689052183620977`*^9, 3.668966735669722*^9, 3.668968060918522*^9, 
   3.6689758166157665`*^9, 3.669048041853454*^9, {3.669060799493424*^9, 
   3.6690608014465303`*^9}, 3.6690618317012463`*^9, 3.66914690952915*^9, 
   3.669413589143278*^9, 3.670041543563558*^9, 3.6700449594186497`*^9, 
   3.670090741428513*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y7", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Phi]u6", "[", "t", "]"}], "+", 
      RowBox[{
       SuperscriptBox["\[Xi]t3", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]z9", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Phi]u6", "[", "t", "]"}], "+", 
      RowBox[{
       SuperscriptBox["\[Xi]t3", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "7", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668903084662938*^9, 3.668903128551154*^9}, {
   3.668904815717905*^9, 3.668904821645956*^9}, {3.6689048998924522`*^9, 
   3.668904902076125*^9}, {3.6689049549722233`*^9, 3.66890496750041*^9}, 
   3.669060803750381*^9, {3.6691468212340813`*^9, 3.66914683011406*^9}, 
   3.669413592588811*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.66803820000000002643503194121876731515`5.84540121044809", ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Phi]w4", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]x9", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], 
        "\[Equal]", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]z6", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"2", " ", "y", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]z7", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]z8", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]u6", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]t3", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Phi]v4", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]x7", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], 
        "\[Equal]", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y6", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y8", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y9", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]u6", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]t3", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Phi]u3", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x6", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"2", " ", "y", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x7", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x8", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x9", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]u6", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]t3", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["v", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["w", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], 
          "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["v", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{"u", " ", 
            SubscriptBox["w", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], 
          "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"v", " ", 
            SubscriptBox["v", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"w", " ", 
            SubscriptBox["v", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["p", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{"v", " ", 
            SubscriptBox["w", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{"w", " ", 
            SubscriptBox["w", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["p", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}]}], 
        "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668903113019651*^9, 3.668903129101102*^9}, {
   3.6689048921831284`*^9, 3.6689049027345867`*^9}, {3.668904955380735*^9, 
   3.668904967910809*^9}, 3.668905219811932*^9, 3.66896673685279*^9, 
   3.66896806140555*^9, 3.66897581737681*^9, 3.669048044668356*^9, 
   3.669060804613493*^9, 3.669061832224419*^9, 3.669146910078554*^9, 
   3.669413593557106*^9, 3.670041545342271*^9, 3.6700449613231297`*^9, 
   3.6700907424305706`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u3", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]x6", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"2", " ", "y", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]x7", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]x8", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]x9", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"x", " ", 
       RowBox[{
        SuperscriptBox["\[Phi]u6", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"x", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]t3", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]v4", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "x", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]x7", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]y6", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]y8", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]y9", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"y", " ", 
       RowBox[{
        SuperscriptBox["\[Phi]u6", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"y", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]t3", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]w4", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "x", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]x9", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]z6", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"2", " ", "y", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]z7", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]z8", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["\[Phi]u6", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]t3", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
         RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
         RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
         RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
         RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668904994154673*^9, 3.6689050707706633`*^9}, {
   3.668905185330592*^9, 3.6689051873380127`*^9}, 3.669060807630452*^9, {
   3.6691468212391577`*^9, 3.6691468301165*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.50202869999999999439665998579584993422`5.721328458901427", ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u6", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x7", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x9", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668905071667199*^9, 3.668905222296928*^9, 
  3.668966737800844*^9, 3.668968061692566*^9, 3.668975818149854*^9, 
  3.669048046699112*^9, 3.6690608084090977`*^9, 3.6690618326223497`*^9, 
  3.66914691048066*^9, 3.6694135994956503`*^9, 3.67004154687884*^9, 
  3.6700449623949614`*^9, 3.6700907431736126`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x7", "[", "t_", "]"}], ":=", "a"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x9", "[", "t_", "]"}], ":=", "b"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u6", "[", "t_", "]"}], ":=", "c"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6689050756797447`*^9, 3.668905115435554*^9}, 
   3.669060810238091*^9, {3.669146821241342*^9, 3.669146830118704*^9}, 
   3.6694136029260273`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.39502260000000000150777168528293259442`5.6172218564365055", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Xi]t3", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}], "}"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.668905100794684*^9, 3.6689051158976707`*^9}, 
   3.6689052240059557`*^9, 3.6689667393479323`*^9, 3.6689680618845773`*^9, 
   3.66897581877289*^9, 3.6690480487587214`*^9, 3.669060811165172*^9, 
   3.669061832933428*^9, 3.669146910789733*^9, 3.669413603695294*^9, 
   3.670041549022801*^9, 3.6700449635846977`*^9, 3.6700907439936595`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t3", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Xi]t0", "+", 
    RowBox[{"t", "*", "d"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668905231254181*^9, 3.668905262681984*^9}, 
   3.6690608125419617`*^9, {3.6691468212431498`*^9, 3.669146830120926*^9}, 
   3.669413607485468*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.40302310000000002299103130098956171423`5.6259298525101125", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x6", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{"\[Rho]", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x8", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[Phi]p3", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "}"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.668905247114585*^9, 3.668905263145866*^9}, 
   3.668966740928023*^9, 3.668968062067588*^9, 3.668975819506932*^9, 
   3.669048050661322*^9, 3.669060813654501*^9, 3.669061833251397*^9, 
   3.669146911092229*^9, 3.669413608502925*^9, 3.670041550313162*^9, 
   3.6700449643948183`*^9, 3.6700907448637094`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]p3", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]p4", "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}], "-", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Rho]", " ", 
        RowBox[{
         SuperscriptBox["\[Xi]x6", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "+", 
       RowBox[{"\[Rho]", " ", 
        RowBox[{
         SuperscriptBox["\[Xi]x8", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "4", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668905269140937*^9, 3.668905325633574*^9}, 
   3.669060815534544*^9, {3.6691468212454987`*^9, 3.669146830123116*^9}, 
   3.669413618396744*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3770216000000000122760468457272509113`5.596966145427292", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y6", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y8", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"z", " ", "\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y9", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]p4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]z6", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"y", " ", "\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]z7", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]z8", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]p4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.668905315852509*^9, 3.668905326087777*^9}, 
   3.6689667426561213`*^9, 3.6689680622685995`*^9, 3.6689758201409683`*^9, 
   3.669048051740756*^9, 3.66906081643743*^9, 3.669061833560158*^9, 
   3.6691469113899317`*^9, 3.6694136193662243`*^9, 3.670041551350356*^9, 
   3.670044965181864*^9, 3.6700907457907624`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Rho]", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]z6", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], "+", 
     RowBox[{"y", " ", "\[Rho]", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]z7", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], "+", 
     RowBox[{"\[Rho]", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]z8", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[Phi]p4", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"\[Phi]p4", "[", 
    RowBox[{"y", ",", "z", ",", "t"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z", ",", "t"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Rho]", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]y6", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], "+", 
     RowBox[{"\[Rho]", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]y8", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], "+", 
     RowBox[{"z", " ", "\[Rho]", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]y9", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[Phi]p4", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"\[Phi]p4", "[", 
    RowBox[{"y", ",", "z", ",", "t"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z", ",", "t"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689053374724007`*^9, 3.668905362296371*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]p4", "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"y", ",", "t"}], "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Rho]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Xi]z6", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "-", 
        RowBox[{"y", " ", "\[Rho]", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]z7", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "-", 
        RowBox[{"\[Rho]", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]z8", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6689053627730827`*^9, 3.668966743888192*^9, 
  3.6689680622866*^9, 3.6689758206029944`*^9, 3.669048053545946*^9, 
  3.669060818006987*^9, 3.669061833610729*^9, 3.669146911437002*^9, 
  3.669413621952787*^9, 3.670041552179825*^9, 3.670044965817618*^9, 
  3.6700907464948025`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]p4", "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"z", ",", "t"}], "]"}], "+", 
     RowBox[{"y", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Rho]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y6", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "-", 
        RowBox[{"\[Rho]", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y8", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "-", 
        RowBox[{"z", " ", "\[Rho]", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y9", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6689053627730827`*^9, 3.668966743888192*^9, 
  3.6689680622866*^9, 3.6689758206029944`*^9, 3.669048053545946*^9, 
  3.669060818006987*^9, 3.669061833610729*^9, 3.669146911437002*^9, 
  3.669413621952787*^9, 3.670041552179825*^9, 3.670044965817618*^9, 
  3.6700907465018034`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]p4", "[", 
    RowBox[{"y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]p0", "[", "t", "]"}], "+", 
    RowBox[{"y", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Rho]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Xi]y6", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "-", 
       RowBox[{"\[Rho]", " ", 
        RowBox[{
         SuperscriptBox["\[Xi]y8", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "-", 
       RowBox[{"z", " ", "\[Rho]", " ", 
        RowBox[{
         SuperscriptBox["\[Xi]y9", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], "+", 
    RowBox[{"z", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Rho]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Xi]z6", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "-", 
       RowBox[{"y", " ", "\[Rho]", " ", 
        RowBox[{
         SuperscriptBox["\[Xi]z7", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "-", 
       RowBox[{"\[Rho]", " ", 
        RowBox[{
         SuperscriptBox["\[Xi]z8", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668905367192272*^9, 3.668905405473762*^9}, 
   3.669060819725856*^9, {3.669146821249963*^9, 3.669146830125531*^9}, 
   3.669413625573243*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.37002109999999999168096564972074702382`5.588826403163623", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]z7", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{"y", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y9", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.668905403041121*^9, 3.668905406042013*^9}, 
   3.668966745146264*^9, 3.6689680624566097`*^9, 3.668975821379039*^9, 
   3.669048056973049*^9, 3.669060820354212*^9, 3.669061833902945*^9, 
   3.669146911728394*^9, 3.6694136266501102`*^9, 3.6700415533527317`*^9, 
   3.670044966968535*^9, 3.670090747581865*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y9", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Xi]y0", "+", 
    RowBox[{"t", "*", "\[Xi]y00"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]z7", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Xi]z0", "+", 
    RowBox[{"t", "*", "\[Xi]z00"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668905409933548*^9, 3.668905457281234*^9}, 
   3.669060822078549*^9, {3.669146821251965*^9, 3.669146830127673*^9}, 
   3.669413630397297*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.40902329999999997856008349117473699152`5.632347961563755", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]y00", "\[Equal]", "\[Xi]z00"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "w"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "v"}], "}"}]}], "}"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.668905454413962*^9, 3.668905457659046*^9}, 
   3.6689667462023244`*^9, 3.66896806264062*^9, 3.6689758219890738`*^9, 
   3.669048059229023*^9, 3.6690608227327423`*^9, 3.6690618342426643`*^9, 
   3.669146912053636*^9, 3.6694136311657267`*^9, 3.670041554369904*^9, 
   3.670044967873681*^9, 3.6700907483949113`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Xi]y00", "=", "e"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]z00", "=", "e"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
       RowBox[{"\[Rho]", ">", "0"}]}], "}"}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6689054646711597`*^9, 3.668905487872888*^9}, 
   3.6690608239745207`*^9, {3.669146821253666*^9, 3.6691468301303663`*^9}, 
   3.6694136353657417`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.38302190000000002623181671879137866199`5.603823519564807", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "e", " ", "t"}], "+", "\[Xi]y0", "+", "\[Xi]z0"}], 
       "\[Equal]", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"v", " ", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"w", " ", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"v", " ", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"w", " ", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"v", " ", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"w", " ", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["v", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["w", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}]}], 
       "}"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689054856452217`*^9, 3.668905488290213*^9}, 
   3.668966747084375*^9, 3.66896806280863*^9, 3.668975822528105*^9, 
   3.669048062208187*^9, 3.669060824655115*^9, 3.669061834582053*^9, 
   3.669146912360021*^9, 3.669413637210854*^9, 3.670041555345289*^9, 
   3.670044968818695*^9, 3.6700907491699557`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"c", "+", "d"}], ")"}]}], "\[Equal]", "c1"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"c", "-", "d"}], ")"}]}], "\[Equal]", "c2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6689057672569647`*^9, 3.6689058054933643`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"c", "\[Rule]", 
     RowBox[{"c1", "+", "c2"}]}], ",", 
    RowBox[{"d", "\[Rule]", 
     RowBox[{"c1", "-", "c2"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.6689057968659077`*^9, 3.668905805986027*^9}, 
   3.6689667483194456`*^9, 3.6689680628176303`*^9, 3.6689758228881254`*^9, 
   3.669048063401429*^9, 3.669060826023168*^9, 3.669061834674767*^9, 
   3.669146912451722*^9, 3.66941363874115*^9, 3.67004155628364*^9, 
   3.670044970276767*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Two", " ", "scalings", " ", 
     RowBox[{"(", 
      RowBox[{"s1", ",", " ", "s2"}], ")"}]}], ",", " ", 
    RowBox[{"three", " ", "rotations", " ", 
     RowBox[{"(", 
      RowBox[{"a", ",", " ", "b", " ", ",", " ", "f"}], ")"}]}], ",", " ", 
    RowBox[{"one", " ", "time", " ", "translation", " ", "\[Xi]t0"}], ",", 
    " ", 
    RowBox[{"three", " ", "moving", " ", "coordinates", " ", 
     RowBox[{"fx", "[", "t", "]"}]}], ",", " ", 
    RowBox[{"fy", "[", "t", "]"}], ",", " ", 
    RowBox[{"fz", "[", "t", "]"}], ",", " ", 
    RowBox[{"and", " ", "one", " ", "pressure", " ", "change", " ", 
     RowBox[{"\[Phi]p0", "[", "t", "]"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Xi]y0", "=", 
     RowBox[{"-", "ff"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Xi]z0", "=", "ff"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"s1", "+", "s2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", "=", 
     RowBox[{"s1", "-", "s2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]x8", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fx", "[", "t", "]"}], "-", 
      RowBox[{"\[Xi]x6", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]y8", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fy", "[", "t", "]"}], "-", 
      RowBox[{"\[Xi]y6", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]z8", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fz", "[", "t", "]"}], "-", 
      RowBox[{"\[Xi]z6", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"AbsoluteTiming", "[", 
    RowBox[{"FindInvariance", "[", 
     RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
     "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Flatten", "[", "Q", "]"}], "[", 
         RowBox[{"[", "i", "]"}], "]"}], "@@", 
        RowBox[{"Flatten", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", 
          RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}], "]"}], 
    "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", "u"}], 
      ",", 
      RowBox[{
       RowBox[{"v", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", "v"}], 
      ",", 
      RowBox[{
       RowBox[{"w", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", "w"}], 
      ",", 
      RowBox[{
       RowBox[{"p", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", 
       "p"}]}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.668905495096547*^9, 3.668905535983613*^9}, {
  3.668905620487249*^9, 3.668905717926223*^9}, {3.6689058100138063`*^9, 
  3.668905825126025*^9}, {3.668905894965814*^9, 3.6689059567641153`*^9}, {
  3.669048096044055*^9, 3.669048097251122*^9}, {3.669060828638196*^9, 
  3.669060830822357*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.29001650000000001039524022417026571929`5.483022620334108", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668905510842114*^9, 3.6689055372201767`*^9}, {
   3.668905661371661*^9, 3.668905673708321*^9}, 3.668905718507009*^9, 
   3.6689058283289022`*^9, 3.668905962560389*^9, 3.668966749785529*^9, 
   3.668968062944638*^9, 3.6689758235861654`*^9, {3.6690480761923656`*^9, 
   3.669048101268417*^9}, 3.669060833730249*^9, 3.669061834869438*^9, 
   3.669146912648336*^9, 3.66941364368434*^9, 3.670041558153404*^9, 
   3.6700449720738363`*^9, 3.6700907547092724`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"s2", " ", "u"}], "+", 
    RowBox[{"a", " ", "v"}], "+", 
    RowBox[{"b", " ", "w"}], "+", 
    RowBox[{
     SuperscriptBox["fx", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s1", " ", "t"}], "-", 
       RowBox[{"s2", " ", "t"}], "+", "\[Xi]t0"}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["u", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], " ", "x"}], "+", 
       RowBox[{"ff", " ", "y"}], "+", 
       RowBox[{"s1", " ", "z"}], "+", 
       RowBox[{"fz", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["u", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "x"}], "-", 
       RowBox[{"s1", " ", "y"}], "+", 
       RowBox[{"ff", " ", "z"}], "-", 
       RowBox[{"fy", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["u", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s1", " ", "x"}], "+", 
       RowBox[{"a", " ", "y"}], "+", 
       RowBox[{"b", " ", "z"}], "+", 
       RowBox[{"fx", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["u", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "a"}], " ", "u"}], "+", 
    RowBox[{"s2", " ", "v"}], "-", 
    RowBox[{"ff", " ", "w"}], "+", 
    RowBox[{
     SuperscriptBox["fy", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s1", " ", "t"}], "-", 
       RowBox[{"s2", " ", "t"}], "+", "\[Xi]t0"}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["v", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], " ", "x"}], "+", 
       RowBox[{"ff", " ", "y"}], "+", 
       RowBox[{"s1", " ", "z"}], "+", 
       RowBox[{"fz", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["v", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "x"}], "-", 
       RowBox[{"s1", " ", "y"}], "+", 
       RowBox[{"ff", " ", "z"}], "-", 
       RowBox[{"fy", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["v", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s1", " ", "x"}], "+", 
       RowBox[{"a", " ", "y"}], "+", 
       RowBox[{"b", " ", "z"}], "+", 
       RowBox[{"fx", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["v", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], " ", "u"}], "+", 
    RowBox[{"ff", " ", "v"}], "+", 
    RowBox[{"s2", " ", "w"}], "+", 
    RowBox[{
     SuperscriptBox["fz", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s1", " ", "t"}], "-", 
       RowBox[{"s2", " ", "t"}], "+", "\[Xi]t0"}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["w", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], " ", "x"}], "+", 
       RowBox[{"ff", " ", "y"}], "+", 
       RowBox[{"s1", " ", "z"}], "+", 
       RowBox[{"fz", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["w", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "x"}], "-", 
       RowBox[{"s1", " ", "y"}], "+", 
       RowBox[{"ff", " ", "z"}], "-", 
       RowBox[{"fy", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["w", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s1", " ", "x"}], "+", 
       RowBox[{"a", " ", "y"}], "+", 
       RowBox[{"b", " ", "z"}], "+", 
       RowBox[{"fx", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["w", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "p", " ", "s2"}], "+", 
    RowBox[{"\[Phi]p0", "[", "t", "]"}], "-", 
    RowBox[{"x", " ", "\[Rho]", " ", 
     RowBox[{
      SuperscriptBox["fx", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "-", 
    RowBox[{"y", " ", "\[Rho]", " ", 
     RowBox[{
      SuperscriptBox["fy", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "-", 
    RowBox[{"z", " ", "\[Rho]", " ", 
     RowBox[{
      SuperscriptBox["fz", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s1", " ", "t"}], "-", 
       RowBox[{"s2", " ", "t"}], "+", "\[Xi]t0"}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["p", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], " ", "x"}], "+", 
       RowBox[{"ff", " ", "y"}], "+", 
       RowBox[{"s1", " ", "z"}], "+", 
       RowBox[{"fz", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["p", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "x"}], "-", 
       RowBox[{"s1", " ", "y"}], "+", 
       RowBox[{"ff", " ", "z"}], "-", 
       RowBox[{"fy", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["p", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s1", " ", "x"}], "+", 
       RowBox[{"a", " ", "y"}], "+", 
       RowBox[{"b", " ", "z"}], "+", 
       RowBox[{"fx", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["p", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.668905510842114*^9, 3.6689055372201767`*^9}, {
   3.668905661371661*^9, 3.668905673708321*^9}, 3.668905718507009*^9, 
   3.6689058283289022`*^9, 3.668905962560389*^9, 3.668966749785529*^9, 
   3.668968062944638*^9, 3.6689758235861654`*^9, {3.6690480761923656`*^9, 
   3.669048101268417*^9}, 3.669060833730249*^9, 3.669061834869438*^9, 
   3.669146912648336*^9, 3.66941364368434*^9, 3.670041558153404*^9, 
   3.6700449720738363`*^9, 3.6700907548192787`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Adjoint", " ", "symmetries"}], "  ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]1", "[", 
      RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]u", "[", 
       RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"v", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]y", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]z", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
        "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]2", "[", 
      RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]v", "[", 
       RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"v", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]y", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]z", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
        "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]3", "[", 
      RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]w", "[", 
       RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"v", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]y", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]z", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
        "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]4", "[", 
      RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]p", "[", 
       RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"v", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]y", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]z", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
        "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", 
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
        "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", 
      RowBox[{
      "\[CapitalDelta]1", ",", "\[CapitalDelta]2", ",", "\[CapitalDelta]3", 
       ",", "\[CapitalDelta]4"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", 
      RowBox[{
      "\[CapitalLambda]1", ",", "\[CapitalLambda]2", ",", "\[CapitalLambda]3",
        ",", "\[CapitalLambda]4"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], "[", "u", "]"}], 
       ",", 
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], "[", "v", "]"}], 
       ",", 
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], "[", "w", "]"}], 
       ",", 
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], "[", "p", 
        "]"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.668666921646707*^9, 3.668666958650989*^9}, {
   3.6689060061240063`*^9, 3.668906150795698*^9}, 3.668966767745557*^9, 
   3.669048126100605*^9, {3.669060870007956*^9, 3.6690609427426987`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
       RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{
          "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
           RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.669060977261962*^9, 3.669060993853898*^9}, {
  3.6690610416219683`*^9, 3.6690610838051863`*^9}}],

Cell[BoxData["878"], "Output",
 CellChangeTimes->{{3.6690609729388037`*^9, 3.669060996844322*^9}, 
   3.669061050605801*^9, 3.669061084866872*^9, 3.669061835524694*^9, 
   3.669146913296091*^9, 3.6694136528931704`*^9, 3.670041570506505*^9, 
   3.670044977526506*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]], ",", 
   SubscriptBox["v", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["v", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["v", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]], ",", 
   SubscriptBox["w", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["w", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["w", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]], ",", 
   SubscriptBox["p", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["p", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["p", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.6690609729388037`*^9, 3.669060996844322*^9}, 
   3.669061050605801*^9, 3.669061084866872*^9, 3.669061835524694*^9, 
   3.669146913296091*^9, 3.6694136528931704`*^9, 3.670041570506505*^9, 
   3.670044979585444*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6689196384303737`*^9, 3.668919641690779*^9}, {
   3.669061108108327*^9, 3.669061111285079*^9}, 3.669061223348763*^9, 
   3.6694136596457367`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.164904`", ",", 
   RowBox[{"{", 
    RowBox[{"175", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Zeta]t", "w"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]t", "v"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]z", "v"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]y", "w"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]x", "v"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]x", "w"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]t", "u"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]z", "u"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]y", "u"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]x", "p"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]t", "p"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]z", "p"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]y", "p"], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["p", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["u", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["w", "t"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["p", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["u", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["v", "t"], " ", 
            SubscriptBox["v", "y"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["u", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["v", "z"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["u", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["w", "y"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["v", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["v", "t"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["v", "z"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["v", "z"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["v", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["v", "t"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["u", "z"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["u", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "z"], " ", 
            SubscriptBox["v", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["p", "y"], " ", 
            SubscriptBox["w", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{
            SubscriptBox["v", "y"], " ", 
            SubscriptBox["w", "t"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["u", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           RowBox[{
            SubscriptBox["p", "t"], " ", 
            SubscriptBox["u", "z"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{
           SubscriptBox["p", "z"], " ", 
           SubscriptBox["u", "y"]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{
           SubscriptBox["p", "y"], " ", 
           SubscriptBox["u", "z"]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubsuperscriptBox["p", "z", "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubsuperscriptBox["p", "y", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubsuperscriptBox["u", "t", "2"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubsuperscriptBox["u", "z", "2"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubsuperscriptBox["u", "y", "2"]}], "}"}], "}"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6689282612453136`*^9, 3.66892837235532*^9, 
  3.6689668137051854`*^9, 3.66896806876097*^9, 3.66897583241567*^9, 
  3.6690481415943127`*^9, 3.669061116322104*^9, 3.669061842052876*^9, 
  3.66914691994881*^9, 3.669413666703392*^9, 3.6700415784496202`*^9, 
  3.670044985091278*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Zeta]t1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]x", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Zeta]x1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]y", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Zeta]y1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]z", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Zeta]z1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "w"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668919663390417*^9, 3.6689197725302095`*^9}, {
   3.6689282325140867`*^9, 3.668928232524393*^9}, {3.669061119092495*^9, 
   3.669061127738674*^9}, 3.6690612172921953`*^9, 3.6694136747741413`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.024243`", ",", 
   RowBox[{"{", 
    RowBox[{"81", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Zeta]t1", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]z1", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "w"}], "]"}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]y1", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v"}], "]"}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]x1", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u"}], "]"}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Zeta]x1", "u"], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["v", "y"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["u", "t"], " ", 
            SubscriptBox["w", "z"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["u", "z"], " ", 
           SubscriptBox["v", "y"]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["u", "y"], " ", 
           SubscriptBox["w", "z"]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["v", "y"], " ", 
           SubscriptBox["w", "z"]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          RowBox[{
           SubscriptBox["v", "y"], " ", 
           SubscriptBox["w", "z"]}]}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.668928378262083*^9, 3.668966818895482*^9, 3.668968071409122*^9, 
   3.6689758349768167`*^9, 3.669048147715679*^9, {3.669061132949548*^9, 
   3.669061136427281*^9}, 3.66906184420049*^9, 3.669146922141205*^9, 
   3.669413687483355*^9, 3.670041582784811*^9, 3.670044991403458*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t1", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]x1", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_"}], "]"}], ":=", 
   "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]y1", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "v_"}], "]"}], ":=", 
   "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]z1", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "w_"}], "]"}], ":=", 
   "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668919790844641*^9, 3.6689198352745194`*^9}, {
   3.668928232564631*^9, 3.668928232570448*^9}, {3.6690611622282124`*^9, 
   3.6690612009558573`*^9}, 3.669413693036648*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.508648`", ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Psi]u", "p"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]v", "p"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]w", "p"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]u", "v"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]u", "w"], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["p", "t"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["u", "t"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          SubscriptBox["p", "t"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          SubscriptBox["p", "t"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["v", "t"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["w", "t"]}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.668928383220551*^9, 3.66896682129762*^9, 3.6689680721901665`*^9, 
   3.6689758357418604`*^9, 3.669048163076127*^9, {3.669061190087818*^9, 
   3.66906120207342*^9}, 3.669061844749572*^9, 3.669146922675498*^9, 
   3.669413694064591*^9, 3.670041584393778*^9, 3.670044993432275*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Psi]u1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]v", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Psi]v1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]w", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{"\[Psi]w1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668919845024536*^9, 3.668919913573057*^9}, {
   3.6689282430467157`*^9, 3.6689282430566273`*^9}, {3.669061238987547*^9, 
   3.669061242781399*^9}, 3.669413697756907*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.260084`", ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Psi]v1", "w"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]v1", "u"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]w1", "v"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]w1", "u"], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["p", "z"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["w", "y"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["u", "t"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["u", "z"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["w", "z"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["u", "y"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["p", "y"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["v", "z"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["u", "t"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["u", "y"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["v", "y"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           SubscriptBox["u", "z"]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.66892839187401*^9, 3.668966822634696*^9, 
  3.6689680726431923`*^9, 3.6689758362098875`*^9, 3.669048165347603*^9, 
  3.6690612472294207`*^9, 3.669061845045773*^9, 3.669146922996924*^9, 
  3.669413700480225*^9, 3.6700415859880037`*^9, 3.670044994460081*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]v1", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_"}], 
    "]"}], ":=", 
   RowBox[{"\[Psi]v2", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]w1", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_"}], 
    "]"}], ":=", 
   RowBox[{"\[Psi]w2", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "w"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689199232762737`*^9, 3.668919999779808*^9}, {
   3.6689282431013393`*^9, 3.668928243107386*^9}, {3.669061277516479*^9, 
   3.6690612874531116`*^9}, 3.669413704685237*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.233837`", ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"\[Psi]w2", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "w"}], "]"}]}], 
        "\[Equal]", 
        SubscriptBox["\[Psi]p", "w"]}], ",", 
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"\[Psi]v2", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v"}], "]"}]}], 
        "\[Equal]", 
        SubscriptBox["\[Psi]p", "v"]}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]u1", "u"], "\[Equal]", 
        SubscriptBox["\[Psi]p", "p"]}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]v2", "v"], "\[Equal]", 
        SubscriptBox["\[Psi]p", "p"]}], ",", 
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"\[Psi]u1", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u"}], "]"}]}], 
        "\[Equal]", 
        SubscriptBox["\[Psi]p", "u"]}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]w2", "w"], "\[Equal]", 
        SubscriptBox["\[Psi]p", "p"]}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]u1", "u"], "\[Equal]", 
        SubscriptBox["\[Psi]v2", "v"]}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]u1", "u"], "\[Equal]", 
        SubscriptBox["\[Psi]w2", "w"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["p", "z"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["w", "t"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["w", "y"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["w", "y"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["w", "z"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["p", "y"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["v", "t"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["v", "z"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["v", "y"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["v", "z"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["u", "t"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["u", "z"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["u", "y"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          SubscriptBox["p", "y"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["u", "y"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["u", "z"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          SubscriptBox["p", "z"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["v", "y"]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          SubscriptBox["w", "z"]}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.6689283938608313`*^9, 3.668966823833765*^9, 3.6689680730972185`*^9, 
   3.6689758366589127`*^9, 3.6690481686485767`*^9, {3.669061284391305*^9, 
   3.669061288425345*^9}, 3.669061845345516*^9, 3.6691469232973146`*^9, 
   3.66941370548599*^9, 3.670041587022698*^9, 3.6700449954107857`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u1", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]u2", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
    RowBox[{"u", "*", 
     RowBox[{"\[Psi]0", "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]v2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "v_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]v3", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
    RowBox[{"v", "*", 
     RowBox[{"\[Psi]0", "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]w2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_", ",", "w_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]w3", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
    RowBox[{"w", "*", 
     RowBox[{"\[Psi]0", "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]p", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_", 
     ",", "p_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]p1", "[", 
     RowBox[{
     "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], "]"}],
     "+", 
    RowBox[{"p", "*", 
     RowBox[{"\[Psi]0", "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", "p", "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689200503550973`*^9, 3.6689202596928654`*^9}, {
   3.668928243158009*^9, 3.66892824316951*^9}, {3.669061293395445*^9, 
   3.669061331451536*^9}, 3.669413711068458*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.294818`", ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Psi]0", "x"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]0", "y"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]0", "z"], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "p"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "p"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", "p"}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.6689283969565783`*^9, 3.668966825625867*^9, 3.6689680735822463`*^9, 
   3.6689758371619415`*^9, 3.669048173204876*^9, {3.669061314055767*^9, 
   3.669061333070504*^9}, 3.669061845677882*^9, 3.669146923628654*^9, 
   3.669413714194235*^9, 3.670041588310141*^9, 3.6700449970338573`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]0", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{"\[Psi]00", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", "p", "}"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689202797585*^9, 3.6689203780280733`*^9}, {
   3.6689282432073*^9, 3.668928243211256*^9}, {3.669061345715309*^9, 
   3.669061375961722*^9}, 3.6694137192680807`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.247265`", ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]p1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}],
             ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{
         "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], 
         "]"}], "\[Equal]", 
        RowBox[{"\[Rho]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"w", " ", 
            RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
           RowBox[{"\[Psi]w3", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], ")"}]}]}], 
       ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]p1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}],
             ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{
         "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], 
         "]"}], "\[Equal]", 
        RowBox[{"\[Rho]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"v", " ", 
            RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
           RowBox[{"\[Psi]v3", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], ")"}]}]}], 
       ",", 
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"v", " ", 
            RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
           RowBox[{"\[Psi]v3", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], ")"}]}], 
        "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Psi]p1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}],
             ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{
         "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], 
         "]"}]}], ",", 
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"w", " ", 
            RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
           RowBox[{"\[Psi]w3", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], ")"}]}], 
        "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Psi]p1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{
            "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}],
             ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{
         "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], 
         "]"}]}], ",", 
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"u", " ", 
            RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
           RowBox[{"\[Psi]u2", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], ")"}]}], 
        "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Psi]p1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{
            "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0"}],
             ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{
         "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], 
         "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]w3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]v3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]u2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["p", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["p", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["v", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["w", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           SubscriptBox["u", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]]}], "}"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1"}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.668928399300639*^9, 3.668966827475973*^9, 3.6689680740582733`*^9, 
   3.66897583765897*^9, 3.669048175794835*^9, {3.6690613628304777`*^9, 
   3.669061376945993*^9}, 3.669061845988873*^9, 3.669146923952433*^9, 
   3.669413720280901*^9, 3.670041589424548*^9, 3.670044998034891*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Rho]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"u", " ", 
        RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
       RowBox[{"\[Psi]u2", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], ")"}]}], 
    "\[Equal]", 
    RowBox[{
     SuperscriptBox["\[Psi]p1", 
      TagBox[
       RowBox[{"(", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0"}], 
        ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{
     "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], 
     "]"}]}], ",", 
   RowBox[{"\[Psi]p1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}],
     "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Rho]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"v", " ", 
        RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
       RowBox[{"\[Psi]v3", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], ")"}]}], 
    "\[Equal]", 
    RowBox[{
     SuperscriptBox["\[Psi]p1", 
      TagBox[
       RowBox[{"(", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0"}], 
        ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{
     "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], 
     "]"}]}], ",", 
   RowBox[{"\[Psi]p1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}],
     "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Rho]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"w", " ", 
        RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
       RowBox[{"\[Psi]w3", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], ")"}]}], 
    "\[Equal]", 
    RowBox[{
     SuperscriptBox["\[Psi]p1", 
      TagBox[
       RowBox[{"(", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], 
        ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{
     "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], 
     "]"}]}], ",", 
   RowBox[{"\[Psi]p1", "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}],
     "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689203847828856`*^9, 3.6689204275269604`*^9}, {
  3.6689282432567863`*^9, 3.668928243267824*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Psi]p1", "[", 
     RowBox[{
     "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], "]"}],
     "\[Rule]", 
    RowBox[{
     RowBox[{"\[Rho]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], " ", 
         SuperscriptBox["u", "2"], " ", 
         RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
        RowBox[{"u", " ", 
         RowBox[{"\[Psi]u2", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ")"}]}], 
     "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "v", ",", "w"}], 
      "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.6689284016697474`*^9, 3.6689668300011177`*^9, 
  3.668968074101276*^9, 3.6689758377079725`*^9, 3.66904817864923*^9, 
  3.669061379839608*^9, 3.6690618460371037`*^9, 3.669146923998473*^9, 
  3.669413723761821*^9, 3.670041596423291*^9, 3.670044998760294*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Psi]p1", "[", 
     RowBox[{
     "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], "]"}],
     "\[Rule]", 
    RowBox[{
     RowBox[{"\[Rho]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], " ", 
         SuperscriptBox["v", "2"], " ", 
         RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
        RowBox[{"v", " ", 
         RowBox[{"\[Psi]v3", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ")"}]}], 
     "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "w"}], 
      "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.6689284016697474`*^9, 3.6689668300011177`*^9, 
  3.668968074101276*^9, 3.6689758377079725`*^9, 3.66904817864923*^9, 
  3.669061379839608*^9, 3.6690618460371037`*^9, 3.669146923998473*^9, 
  3.669413723761821*^9, 3.670041596423291*^9, 3.6700449987616167`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Psi]p1", "[", 
     RowBox[{
     "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], "]"}],
     "\[Rule]", 
    RowBox[{
     RowBox[{"\[Rho]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], " ", 
         SuperscriptBox["w", "2"], " ", 
         RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
        RowBox[{"w", " ", 
         RowBox[{"\[Psi]w3", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ")"}]}], 
     "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v"}], 
      "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.6689284016697474`*^9, 3.6689668300011177`*^9, 
  3.668968074101276*^9, 3.6689758377079725`*^9, 3.66904817864923*^9, 
  3.669061379839608*^9, 3.6690618460371037`*^9, 3.669146923998473*^9, 
  3.669413723761821*^9, 3.670041596423291*^9, 3.670044998815658*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]p1", "[", 
    RowBox[{
    "x_", ",", "y_", ",", "z_", ",", "t_", ",", "u_", ",", "v_", ",", "w_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Rho]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["u", "2"], " ", 
        RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
       RowBox[{"u", " ", 
        RowBox[{"\[Psi]u2", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{"\[Rho]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["v", "2"], " ", 
        RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
       RowBox[{"v", " ", 
        RowBox[{"\[Psi]v3", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{"\[Rho]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["w", "2"], " ", 
        RowBox[{"\[Psi]00", "[", "t", "]"}]}], "+", 
       RowBox[{"w", " ", 
        RowBox[{"\[Psi]w3", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{"\[Psi]p2", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6689204852314615`*^9, 3.668920546523969*^9}, {
   3.668928243369341*^9, 3.668928243378263*^9}, {3.6690613876678343`*^9, 
   3.669061416186514*^9}, 3.669413728549477*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.092295`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]00", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]u2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], "\[Equal]",
         "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]u2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]v3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]u2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]w3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]u2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]p2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]00", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]v3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], "\[Equal]",
         "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]v3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]w3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]v3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]p2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]00", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]w3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], "\[Equal]",
         "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]w3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]p2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "u"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "v"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "u"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "w"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "u"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "v"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "w"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "v"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", "w"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.668928405148423*^9, 3.668966831780219*^9, 3.6689680743672915`*^9, 
   3.6689758379759884`*^9, 3.669048182386937*^9, {3.6690614008204947`*^9, 
   3.669061416716782*^9}, 3.669061846169558*^9, 3.66914692413278*^9, 
   3.6694137290993032`*^9, 3.6700415977412024`*^9, 3.670044999628845*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]w3", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]w4", "[", 
     RowBox[{"x", ",", "y", ",", "t"}], "]"}], "-", 
    RowBox[{
     RowBox[{"z", "/", "2"}], "*", 
     RowBox[{
      RowBox[{"\[Psi]00", "'"}], "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]v3", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]v4", "[", 
     RowBox[{"x", ",", "z", ",", "t"}], "]"}], "-", 
    RowBox[{
     RowBox[{"y", "/", "2"}], "*", 
     RowBox[{
      RowBox[{"\[Psi]00", "'"}], "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]u3", "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}], "-", 
    RowBox[{
     RowBox[{"x", "/", "2"}], "*", 
     RowBox[{
      RowBox[{"\[Psi]00", "'"}], "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6689205643558006`*^9, 3.6689207013240414`*^9}, {
   3.6689282434218073`*^9, 3.6689282434300823`*^9}, {3.669061422410214*^9, 
   3.6690614311392727`*^9}, 3.6694137355979033`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.098045`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Psi]00", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}], "}"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668928408376834*^9, 3.6689668361964717`*^9, 
  3.6689680745783033`*^9, 3.668975838210002*^9, 3.669048187531519*^9, 
  3.6690614369634743`*^9, 3.669061846300497*^9, 3.66914692424551*^9, 
  3.669413736089962*^9, 3.670041599465527*^9, 3.670045000413246*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]00", "[", "t_", "]"}], ":=", "\[Psi]000"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6689207044908466`*^9, 3.668920758579142*^9}, {
   3.6689282434605293`*^9, 3.668928243464232*^9}, {3.669061441378646*^9, 
   3.669061443946123*^9}, 3.669413739213303*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.071135`", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]u3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]v4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]u3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]w4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]u3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]p2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]v4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]w4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]v4", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "z", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]p2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]w4", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]p2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
        "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "v"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "u"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "w"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "u"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "w"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "v"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668928411028126*^9, 3.6689668373515377`*^9, 
  3.668968074765314*^9, 3.668975838421014*^9, 3.6690481888756113`*^9, 
  3.6690614452892933`*^9, 3.6690618464041*^9, 3.669146924345595*^9, 
  3.669413739770482*^9, 3.670041600299797*^9, 3.670045001116*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]v4", "[", 
    RowBox[{"x_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]v5", "[", 
     RowBox[{"x", ",", "t"}], "]"}], "+", 
    RowBox[{"z", "*", 
     RowBox[{"\[Psi]v6", "[", 
      RowBox[{"x", ",", "t"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]w4", "[", 
    RowBox[{"x_", ",", "y_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]w5", "[", 
     RowBox[{"x", ",", "t"}], "]"}], "-", 
    RowBox[{"y", "*", 
     RowBox[{"\[Psi]v6", "[", 
      RowBox[{"x", ",", "t"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668920769218361*^9, 3.6689208612117224`*^9}, {
   3.668928243508778*^9, 3.668928243515277*^9}, {3.669061449627531*^9, 
   3.669061451018227*^9}, 3.669413743852683*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.079286`", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]u3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[Psi]p2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "}"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668928413789234*^9, 3.66896683861061*^9, 
  3.668968074950324*^9, 3.6689758386310253`*^9, 3.669048191153584*^9, 
  3.669061451655046*^9, 3.6690618465233994`*^9, 3.669146924470193*^9, 
  3.669413744367672*^9, 3.670041601694284*^9, 3.67004500196563*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]p2", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]p3", "[", 
     RowBox[{"y", ",", "z", ",", "t"}], "]"}], "-", 
    RowBox[{"\[Rho]", "*", "x", "*", 
     RowBox[{
      SuperscriptBox["\[Psi]u3", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6689208680133343`*^9, 3.668920908292605*^9}, {
   3.668926848608567*^9, 3.668926890846661*^9}, {3.668926935983589*^9, 
   3.668926937727007*^9}, {3.66892824354703*^9, 3.6689282435512257`*^9}, {
   3.6690614571143103`*^9, 3.6690614593699007`*^9}, 3.669413748533498*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.075979`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]v5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "t"}], "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]v6", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "t"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]u3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{"y", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]v6", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "t"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]w5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]u3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "v"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "u"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "w"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "u"}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668928415225442*^9, 3.668966839713673*^9, 
  3.6689680751453357`*^9, 3.6689758388500385`*^9, 3.669048192480225*^9, 
  3.669061460452854*^9, 3.6690618466487303`*^9, 3.669146924582161*^9, 
  3.669413748969859*^9, 3.6700416026632833`*^9, 3.6700450027227087`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", " ", 
     RowBox[{
      SuperscriptBox["\[Psi]v6", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "t"}], "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Psi]w5", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "t"}], "]"}], "+", 
     RowBox[{
      SuperscriptBox["\[Psi]u3", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}], ",", "y"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.668926990473749*^9, 3.668926992638238*^9}, {
  3.668928243585936*^9, 3.668928243590025*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[Psi]v6", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
  RowBox[{
   SuperscriptBox["\[Psi]u3", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]], "Output",
 CellChangeTimes->{3.6689284163505383`*^9, 3.6689668411407547`*^9, 
  3.6689680751793375`*^9, 3.668975840144112*^9, 3.6690481949282103`*^9, 
  3.669061462650004*^9, 3.669061846714788*^9, 3.669146924618842*^9, 
  3.669413751222513*^9, 3.670041603576358*^9, 3.670045003338312*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]v6", "[", 
    RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]v7", "[", "t", "]"}], "+", 
    RowBox[{"x", "*", 
     RowBox[{"\[Psi]v8", "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668926994297282*^9, 3.668927027926648*^9}, {
   3.668927074398724*^9, 3.6689270992465878`*^9}, {3.668928243620679*^9, 
   3.668928243624572*^9}, {3.669061466722393*^9, 3.6690614683059587`*^9}, 
   3.6694137540848007`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.083471`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"z", " ", 
          RowBox[{"\[Psi]v8", "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]v5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]u3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{"y", " ", 
         RowBox[{"\[Psi]v8", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]w5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]u3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "v"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "u"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "w"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "u"}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]],
  "Output",
 CellChangeTimes->{3.66892841946206*^9, 3.668966843765905*^9, 
  3.6689680754023504`*^9, 3.6689758412191734`*^9, 3.669048197251361*^9, 
  3.669061469426465*^9, 3.669061846827409*^9, 3.669146924732129*^9, 
  3.6694137546102333`*^9, 3.670041604710083*^9, 3.67004500401388*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", " ", 
     RowBox[{"\[Psi]v8", "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Psi]w5", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "t"}], "]"}], "+", 
     RowBox[{
      SuperscriptBox["\[Psi]u3", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}], ",", "y"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"\[Psi]v8", "[", "t", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[Psi]v5", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "t"}], "]"}], "+", 
     RowBox[{
      SuperscriptBox["\[Psi]u3", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
   "z"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668927106695156*^9, 3.668927132013019*^9}, {
  3.668928243657941*^9, 3.6689282436637917`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]v8", "[", "t", "]"}], "\[Equal]", 
  RowBox[{
   SuperscriptBox["\[Psi]u3", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]], "Output",
 CellChangeTimes->{3.668928422845119*^9, 3.668966845171985*^9, 
  3.668968075410351*^9, 3.6689758423592386`*^9, 3.669048199404985*^9, 
  3.6690614712435427`*^9, 3.669061846868196*^9, 3.6691469247665253`*^9, 
  3.669413756918529*^9, 3.670041605690074*^9, 3.670045004538146*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]v8", "[", "t", "]"}], "+", 
   RowBox[{
    SuperscriptBox["\[Psi]u3", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{3.668928422845119*^9, 3.668966845171985*^9, 
  3.668968075410351*^9, 3.6689758423592386`*^9, 3.669048199404985*^9, 
  3.6690614712435427`*^9, 3.669061846868196*^9, 3.6691469247665253`*^9, 
  3.669413756918529*^9, 3.670041605690074*^9, 3.670045004539709*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]v8", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u3", "[", 
    RowBox[{"y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]u4", "[", 
     RowBox[{"y", ",", "t"}], "]"}], "+", 
    RowBox[{"\[Psi]u5", "[", 
     RowBox[{"z", ",", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6689271920269003`*^9, 3.668927239717011*^9}, {
   3.668928243728587*^9, 3.668928243734681*^9}, {3.66906147654596*^9, 
   3.669061479249806*^9}, 3.669413760564334*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.08316`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]u4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]v5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]u5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"z", ",", "t"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]w5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "t"}], "]"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "v"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "u"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "w"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "u"}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668928423806533*^9, 3.6689668464160566`*^9, 
  3.668968075608362*^9, 3.668975843238289*^9, 3.6690482017355127`*^9, 
  3.669061479851322*^9, 3.669061846940778*^9, 3.669146924839435*^9, 
  3.669413761049685*^9, 3.670041606572124*^9, 3.670045005158389*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u4", "[", 
    RowBox[{"y_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]u6", "[", "t", "]"}], "+", 
    RowBox[{"y", "*", 
     RowBox[{"\[Psi]u7", "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]v5", "[", 
    RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]v9", "[", "t", "]"}], "-", 
    RowBox[{"x", "*", 
     RowBox[{"\[Psi]u7", "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u5", "[", 
    RowBox[{"z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]u8", "[", "t", "]"}], "+", 
    RowBox[{"z", "*", 
     RowBox[{"\[Psi]u9", "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]w5", "[", 
    RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]w6", "[", "t", "]"}], "-", 
    RowBox[{"x", "*", 
     RowBox[{"\[Psi]u9", "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "4", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668927250093465*^9, 3.668927403452283*^9}, {
   3.668928243767334*^9, 3.668928243777878*^9}, {3.66906148552284*^9, 
   3.669061486993874*^9}, 3.669413765388282*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.052401`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "x", " ", "\[Rho]", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]u7", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"z", " ", "\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]v7", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]v9", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]p3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "x", " ", "\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]u9", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"y", " ", "\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]v7", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]w6", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]p3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668928425313921*^9, 3.668966847226103*^9, 
  3.6689680757913723`*^9, 3.668975843879326*^9, 3.6690482043017597`*^9, 
  3.6690614876168327`*^9, 3.669061847029574*^9, 3.669146924933097*^9, 
  3.669413765880272*^9, 3.670041607563883*^9, 3.670045005804491*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u7", "[", "t_", "]"}], ":=", "a"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u9", "[", "t_", "]"}], ":=", "b"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668927437603167*^9, 3.668927486819179*^9}, {
   3.6689275835302563`*^9, 3.668927587658495*^9}, {3.668928243813155*^9, 
   3.668928243816436*^9}, {3.669061492129879*^9, 3.669061493665491*^9}, 
   3.669413768716359*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.056157`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"z", " ", "\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]v7", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]v9", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]p3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{"y", " ", "\[Rho]", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]v7", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]w6", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]p3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6689284276785707`*^9, 3.6689668485351777`*^9, 
  3.668968075957382*^9, 3.6689758446413693`*^9, 3.669048206901349*^9, 
  3.669061494679541*^9, 3.669061847108179*^9, 3.66914692502497*^9, 
  3.6694137691666393`*^9, 3.6700416086878347`*^9, 3.6700450063573103`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", " ", "\[Rho]", " ", 
      RowBox[{
       SuperscriptBox["\[Psi]v7", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], "+", 
     RowBox[{"\[Rho]", " ", 
      RowBox[{
       SuperscriptBox["\[Psi]v9", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[Psi]p3", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
   "z"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", " ", "\[Rho]", " ", 
     RowBox[{
      SuperscriptBox["\[Psi]v7", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"\[Rho]", " ", 
      RowBox[{
       SuperscriptBox["\[Psi]w6", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[Psi]p3", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]}], ",", "y"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668927625626918*^9, 3.668927635145917*^9}, {
  3.66892824385047*^9, 3.668928243856427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]", " ", 
    RowBox[{
     SuperscriptBox["\[Psi]v7", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[Psi]p3", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"y", ",", "z", ",", "t"}], "]"}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{3.668928428970557*^9, 3.6689668494742312`*^9, 
  3.6689680759653826`*^9, 3.6689758451914005`*^9, 3.669048208579173*^9, 
  3.6690614964382753`*^9, 3.669061847147723*^9, 3.669146925071303*^9, 
  3.669413771492731*^9, 3.670041609569522*^9, 3.670045006981195*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Rho]", " ", 
   RowBox[{
    SuperscriptBox["\[Psi]v7", "\[Prime]",
     MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
  RowBox[{
   SuperscriptBox["\[Psi]p3", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"y", ",", "z", ",", "t"}], "]"}]}]], "Output",
 CellChangeTimes->{3.668928428970557*^9, 3.6689668494742312`*^9, 
  3.6689680759653826`*^9, 3.6689758451914005`*^9, 3.669048208579173*^9, 
  3.6690614964382753`*^9, 3.669061847147723*^9, 3.669146925071303*^9, 
  3.669413771492731*^9, 3.670041609569522*^9, 3.670045006982532*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]v7", "[", "t_", "]"}], ":=", "cc"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]p3", "[", 
    RowBox[{"y_", ",", "z_", ",", "t_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]p4", "[", 
     RowBox[{"y", ",", "t"}], "]"}], "+", 
    RowBox[{"\[Psi]p5", "[", 
     RowBox[{"z", ",", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"u", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"v", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"w", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"p", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"\[Rho]", ">", "0"}]}]}], ",", 
    RowBox[{"extras", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w", ",", "p"}], "}"}]}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668927494487886*^9, 3.6689275358662663`*^9}, {
   3.668927642313768*^9, 3.668927719466467*^9}, {3.668928243922472*^9, 
   3.668928243927711*^9}, {3.668968024958465*^9, 3.668968025158477*^9}, {
   3.669061500746594*^9, 3.669061502841568*^9}, 3.669413774523995*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.060181`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]v9", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]p4", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"y", ",", "t"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           SuperscriptBox["\[Psi]w6", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]p5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"z", ",", "t"}], "]"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668928430727466*^9, 3.6689668507553043`*^9, 
  3.6689680761413927`*^9, 3.668975846109453*^9, 3.6690482127467337`*^9, 
  3.669061503422388*^9, 3.669061847195292*^9, 3.669146925152482*^9, 
  3.669413775017931*^9, 3.670041610569566*^9, 3.670045007558136*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Three", " ", "rotations", " ", 
     RowBox[{"(", 
      RowBox[{"a", ",", " ", "b", ",", " ", "c"}], ")"}], " ", "conserve", 
     " ", "angular", " ", "momentum"}], ",", " ", 
    RowBox[{"three", " ", "moving", " ", "coordinates", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"fx", "[", "t", "]"}], ",", " ", 
       RowBox[{"fy", "[", "t", "]"}], ",", " ", 
       RowBox[{"fz", "[", "t", "]"}]}], ")"}], " ", "conserve", " ", 
     "momentum"}], ",", " ", 
    RowBox[{"scaling", " ", 
     RowBox[{"(", "\[Psi]000", ")"}], " ", "conserves", " ", "energy"}], ",", 
    " ", 
    RowBox[{"and", " ", "pressure", " ", "change", " ", 
     RowBox[{"(", 
      RowBox[{"\[Psi]p0", "[", "t", "]"}], ")"}], " ", "conserves", " ", 
     RowBox[{"mass", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]p4", "[", 
      RowBox[{"y_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]p6", "[", "t", "]"}], "-", 
      RowBox[{"\[Rho]", "*", "y", "*", 
       RowBox[{
        RowBox[{"\[Psi]v9", "'"}], "[", "t", "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]p5", "[", 
      RowBox[{"z_", ",", "t_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]p7", "[", "t", "]"}], "-", 
      RowBox[{"\[Rho]", "*", "z", "*", 
       RowBox[{
        RowBox[{"\[Psi]w6", "'"}], "[", "t", "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]u6", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"fx", "[", "t", "]"}], "-", 
      RowBox[{"\[Psi]u8", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]v9", "[", "t_", "]"}], ":=", 
     RowBox[{"fy", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]w6", "[", "t_", "]"}], ":=", 
     RowBox[{"fz", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]p6", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]p0", "[", "t", "]"}], "-", 
      RowBox[{"\[Psi]p7", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"AbsoluteTiming", "[", 
    RowBox[{"FindInvariance", "[", 
     RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Flatten", "[", "Q", "]"}], "[", 
         RowBox[{"[", "i", "]"}], "]"}], "@@", 
        RowBox[{"var", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", 
          RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}], "]"}], 
    "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", "u"}], 
      ",", 
      RowBox[{
       RowBox[{"v", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", "v"}], 
      ",", 
      RowBox[{
       RowBox[{"w", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", "w"}], 
      ",", 
      RowBox[{
       RowBox[{"p", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", 
       "p"}]}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6689277266199093`*^9, 3.668927805576353*^9}, {
  3.6689278718164663`*^9, 3.6689280734473553`*^9}, {3.668928243960326*^9, 
  3.6689282439738073`*^9}, {3.6689668597758207`*^9, 3.6689668802139893`*^9}, {
  3.669061507601997*^9, 3.669061517097381*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.052488`", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.668928432924117*^9, {3.6689668518163652`*^9, 3.6689668807090178`*^9}, 
   3.6689680762994013`*^9, 3.6689758471625137`*^9, 3.669048215291232*^9, 
   3.669061519876267*^9, 3.6690618472614603`*^9, 3.669146925220726*^9, 
   3.669413790453343*^9, 3.670041611399289*^9, 3.67004500805855*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "y"}], "+", 
    RowBox[{"b", " ", "z"}], "+", 
    RowBox[{"u", " ", "\[Psi]000"}], "+", 
    RowBox[{"fx", "[", "t", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "a"}], " ", "x"}], "+", 
    RowBox[{"cc", " ", "z"}], "+", 
    RowBox[{"v", " ", "\[Psi]000"}], "+", 
    RowBox[{"fy", "[", "t", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], " ", "x"}], "-", 
    RowBox[{"cc", " ", "y"}], "+", 
    RowBox[{"w", " ", "\[Psi]000"}], "+", 
    RowBox[{"fz", "[", "t", "]"}]}], ",", 
   RowBox[{
    RowBox[{"p", " ", "\[Psi]000"}], "+", 
    RowBox[{"\[Rho]", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["u", "2"], " ", "\[Psi]000"}], "2"], "+", 
       RowBox[{"u", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "y"}], "+", 
          RowBox[{"b", " ", "z"}], "+", 
          RowBox[{"fx", "[", "t", "]"}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", "v", " ", "\[Rho]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a", " ", "x"}], "+", 
       RowBox[{"2", " ", "cc", " ", "z"}], "+", 
       RowBox[{"v", " ", "\[Psi]000"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"fy", "[", "t", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", "w", " ", "\[Rho]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"cc", " ", "y"}]}], ")"}]}], "+", 
       RowBox[{"w", " ", "\[Psi]000"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"fz", "[", "t", "]"}]}]}], ")"}]}], "+", 
    RowBox[{"\[Psi]p0", "[", "t", "]"}], "-", 
    RowBox[{"x", " ", "\[Rho]", " ", 
     RowBox[{
      SuperscriptBox["fx", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "-", 
    RowBox[{"y", " ", "\[Rho]", " ", 
     RowBox[{
      SuperscriptBox["fy", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "-", 
    RowBox[{"z", " ", "\[Rho]", " ", 
     RowBox[{
      SuperscriptBox["fz", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.668928432924117*^9, {3.6689668518163652`*^9, 3.6689668807090178`*^9}, 
   3.6689680762994013`*^9, 3.6689758471625137`*^9, 3.669048215291232*^9, 
   3.669061519876267*^9, 3.6690618472614603`*^9, 3.669146925220726*^9, 
   3.669413790453343*^9, 3.670041611399289*^9, 3.6700450081903048`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "We", " ", "can", " ", "check", " ", "adjoint", " ", "equations", " ", 
    "by", " ", "hand"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Rho]", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]1", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[CapitalLambda]1", "[", 
             RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
           "]"}], "-", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"\[CapitalLambda]1", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
            "]"}]}], "-", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]1", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"v", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"\[CapitalLambda]1", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
            "]"}]}], "-", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"v", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", " ", 
             "y"}], "]"}], "*", 
           RowBox[{"\[CapitalLambda]1", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"w", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"\[CapitalLambda]1", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
            "]"}]}], "-", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"w", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]1", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"v", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]2", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"w", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]3", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ")"}]}], 
       "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalLambda]4", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
        "]"}]}], ",", 
      RowBox[{
       RowBox[{"\[Rho]", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"v", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]2", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[CapitalLambda]2", "[", 
             RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
           "]"}], "-", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"\[CapitalLambda]2", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
            "]"}]}], "-", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]2", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"v", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"\[CapitalLambda]2", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
            "]"}]}], "-", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"v", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", " ", 
             "y"}], "]"}], "*", 
           RowBox[{"\[CapitalLambda]2", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"w", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"\[CapitalLambda]2", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
            "]"}]}], "-", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"w", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]2", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]1", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"w", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]3", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ")"}]}], 
       "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalLambda]4", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
        "]"}]}], ",", " ", 
      RowBox[{
       RowBox[{"\[Rho]", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"v", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]2", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[CapitalLambda]2", "[", 
             RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "t"}], 
           "]"}], "-", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"\[CapitalLambda]2", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
            "]"}]}], "-", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]2", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"v", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"\[CapitalLambda]2", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
            "]"}]}], "-", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"v", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", " ", 
             "y"}], "]"}], "*", 
           RowBox[{"\[CapitalLambda]2", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"w", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"\[CapitalLambda]2", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
            "]"}]}], "-", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"w", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]2", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]1", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"w", "[", 
              RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
            "]"}], "*", 
           RowBox[{"\[CapitalLambda]3", "[", 
            RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], ")"}]}], 
       "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalLambda]4", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
        "]"}]}], ",", " ", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"\[CapitalLambda]1", "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "x"}], 
         "]"}]}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalLambda]2", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "y"}], 
        "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalLambda]3", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", "z"}], 
        "]"}]}]}], "}"}], "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Through", "[", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "]"}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{"Through", "[", 
        RowBox[{"solvefor", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "]"}]}], "]"}], 
     "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.668922160846868*^9, 3.6689221879505444`*^9}, {
   3.668922635859913*^9, 3.668922643372414*^9}, {3.668922711092043*^9, 
   3.668922731243772*^9}, {3.668922805708433*^9, 3.668922822322277*^9}, {
   3.668928080382922*^9, 3.668928172129081*^9}, {3.668928244014607*^9, 
   3.668928244022801*^9}, 3.6690483260598803`*^9, {3.6690615563642693`*^9, 
   3.669061642683112*^9}, {3.6690617921290903`*^9, 3.669061792197254*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.66892843497297*^9, 3.668966893427745*^9, 3.6689680764834123`*^9, 
   3.6689758496286545`*^9, 3.6690482180100813`*^9, 3.669048328793263*^9, {
   3.6690616263164587`*^9, 3.669061643729958*^9}, 3.6690618473856907`*^9, 
   3.66914692534695*^9, 3.669413792764491*^9, 3.670041614146632*^9, 
   3.67004500901549*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Conserved", " ", "currents"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalPhi]", "[", 
      RowBox[{"X_", ",", "Y_", ",", "Z_", ",", "T_"}], "]"}], ":=", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{"Integrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"1", "/", "\[Lambda]"}], "*", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"D", "[", 
                   RowBox[{
                    RowBox[{"Through", "[", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "]"}],
                     ",", 
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"u", "[", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"var", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}], "*", 
                  RowBox[{"u", "[", 
                   RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
                 
                 RowBox[{
                  RowBox[{"D", "[", 
                   RowBox[{
                    RowBox[{"Through", "[", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "]"}],
                     ",", 
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"v", "[", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"var", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}], "*", 
                  RowBox[{"v", "[", 
                   RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
                 
                 RowBox[{
                  RowBox[{"D", "[", 
                   RowBox[{
                    RowBox[{"Through", "[", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "]"}],
                     ",", 
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"w", "[", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"var", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}], "*", 
                  RowBox[{"w", "[", 
                   RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}], "+", 
                 
                 RowBox[{
                  RowBox[{"D", "[", 
                   RowBox[{
                    RowBox[{"Through", "[", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "]"}],
                     ",", 
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"var", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}], "*", 
                  RowBox[{"p", "[", 
                   RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]}]}], 
                ")"}], ".", 
               RowBox[{"Through", "[", 
                RowBox[{"Q", "[", 
                 RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "]"}]}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "1", ",", 
                RowBox[{"Length", "[", 
                 RowBox[{"var", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}], "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", 
              
              RowBox[{"\[Lambda]", "*", "u"}]}], ",", 
             RowBox[{
              RowBox[{"v", "[", 
               RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", 
              
              RowBox[{"\[Lambda]", "*", "v"}]}], ",", 
             RowBox[{
              RowBox[{"w", "[", 
               RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", 
              
              RowBox[{"\[Lambda]", "*", "w"}]}], ",", 
             RowBox[{
              RowBox[{"p", "[", 
               RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", 
              
              RowBox[{"\[Lambda]", "*", "p"}]}]}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "\[Rule]", 
          RowBox[{"u", "[", 
           RowBox[{"X", ",", "Y", ",", "Z", ",", "T"}], "]"}]}], ",", 
         RowBox[{"v", "\[Rule]", 
          RowBox[{"v", "[", 
           RowBox[{"X", ",", "Y", ",", "Z", ",", "T"}], "]"}]}], ",", 
         RowBox[{"w", "\[Rule]", 
          RowBox[{"w", "[", 
           RowBox[{"X", ",", "Y", ",", "Z", ",", "T"}], "]"}]}], ",", 
         RowBox[{"p", "\[Rule]", 
          RowBox[{"p", "[", 
           RowBox[{"X", ",", "Y", ",", "Z", ",", "T"}], "]"}]}]}], "}"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Div", "[", 
      RowBox[{
       RowBox[{"\[CapitalPhi]", "[", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}]}], "]"}], "/.", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Through", "[", 
          RowBox[{"\[CapitalDelta]", "[", 
           RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "]"}], 
         "\[Equal]", "0"}], ",", 
        RowBox[{"Through", "[", 
         RowBox[{"solvefor", "[", 
          RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "]"}]}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"\[CapitalPhi]", "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", "u"}],
        ",", 
       RowBox[{
        RowBox[{"v", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", "v"}],
        ",", 
       RowBox[{
        RowBox[{"w", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", "w"}],
        ",", 
       RowBox[{
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}], "\[Rule]", 
        "p"}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6689675706444798`*^9, 3.66896759565291*^9}, {
   3.66896762903882*^9, 3.668967800245612*^9}, 3.669048333954924*^9, {
   3.6690616787619867`*^9, 3.669061698353503*^9}, {3.66906176271497*^9, 
   3.669061769554141*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.6689676528801837`*^9, 3.6689676653928995`*^9}, {
   3.6689677230641975`*^9, 3.6689677560140824`*^9}, {3.6689677863298163`*^9, 
   3.668967801027657*^9}, 3.6689680771204486`*^9, 3.668975852851839*^9, 
   3.6690483418693933`*^9, 3.669061705751071*^9, 3.669061771439972*^9, 
   3.6690618478443327`*^9, 3.66914692591124*^9, 3.669413795751437*^9, 
   3.670041616606811*^9, 3.670045010200849*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "p", " ", "y"}], "+", 
    RowBox[{"b", " ", "p", " ", "z"}], "+", 
    RowBox[{"a", " ", "u", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "v"}], " ", "x"}], "+", 
       RowBox[{"u", " ", "y"}]}], ")"}], " ", "\[Rho]"}], "+", 
    RowBox[{"b", " ", "u", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "w"}], " ", "x"}], "+", 
       RowBox[{"u", " ", "z"}]}], ")"}], " ", "\[Rho]"}], "+", 
    RowBox[{"cc", " ", "u", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "w"}], " ", "y"}], "+", 
       RowBox[{"v", " ", "z"}]}], ")"}], " ", "\[Rho]"}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", "u", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "p"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["u", "2"], "+", 
          SuperscriptBox["v", "2"], "+", 
          SuperscriptBox["w", "2"]}], ")"}], " ", "\[Rho]"}]}], ")"}], " ", 
     "\[Psi]000"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"p", "+", 
       RowBox[{
        SuperscriptBox["u", "2"], " ", "\[Rho]"}]}], ")"}], " ", 
     RowBox[{"fx", "[", "t", "]"}]}], "+", 
    RowBox[{"u", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"v", " ", "\[Rho]", " ", 
        RowBox[{"fy", "[", "t", "]"}]}], "+", 
       RowBox[{"w", " ", "\[Rho]", " ", 
        RowBox[{"fz", "[", "t", "]"}]}], "+", 
       RowBox[{"\[Psi]p0", "[", "t", "]"}], "-", 
       RowBox[{"\[Rho]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", " ", 
           RowBox[{
            SuperscriptBox["fx", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], "+", 
          RowBox[{"y", " ", 
           RowBox[{
            SuperscriptBox["fy", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["fz", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"cc", " ", "p", " ", "z"}], "+", 
    RowBox[{"b", " ", "v", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "w"}], " ", "x"}], "+", 
       RowBox[{"u", " ", "z"}]}], ")"}], " ", "\[Rho]"}], "+", 
    RowBox[{"cc", " ", "v", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "w"}], " ", "y"}], "+", 
       RowBox[{"v", " ", "z"}]}], ")"}], " ", "\[Rho]"}], "-", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"p", " ", "x"}], "+", 
       RowBox[{"v", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"v", " ", "x"}], "-", 
          RowBox[{"u", " ", "y"}]}], ")"}], " ", "\[Rho]"}]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", "v", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "p"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["u", "2"], "+", 
          SuperscriptBox["v", "2"], "+", 
          SuperscriptBox["w", "2"]}], ")"}], " ", "\[Rho]"}]}], ")"}], " ", 
     "\[Psi]000"}], "+", 
    RowBox[{"p", " ", 
     RowBox[{"fy", "[", "t", "]"}]}], "+", 
    RowBox[{"v", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Psi]p0", "[", "t", "]"}], "+", 
       RowBox[{"\[Rho]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"u", " ", 
           RowBox[{"fx", "[", "t", "]"}]}], "+", 
          RowBox[{"v", " ", 
           RowBox[{"fy", "[", "t", "]"}]}], "+", 
          RowBox[{"w", " ", 
           RowBox[{"fz", "[", "t", "]"}]}], "-", 
          RowBox[{"x", " ", 
           RowBox[{
            SuperscriptBox["fx", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], "-", 
          RowBox[{"y", " ", 
           RowBox[{
            SuperscriptBox["fy", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], "-", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["fz", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"u", " ", "w", " ", "\[Rho]", " ", 
     RowBox[{"fx", "[", "t", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"cc", " ", "y"}]}], ")"}]}], "+", 
       RowBox[{"2", " ", "w", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "a"}], " ", "v", " ", "x"}], "-", 
          RowBox[{"b", " ", "w", " ", "x"}], "+", 
          RowBox[{"a", " ", "u", " ", "y"}], "-", 
          RowBox[{"cc", " ", "w", " ", "y"}], "+", 
          RowBox[{"b", " ", "u", " ", "z"}], "+", 
          RowBox[{"cc", " ", "v", " ", "z"}]}], ")"}], " ", "\[Rho]"}], "+", 
       RowBox[{"w", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "p"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             SuperscriptBox["v", "2"], "+", 
             SuperscriptBox["w", "2"]}], ")"}], " ", "\[Rho]"}]}], ")"}], " ",
         "\[Psi]000"}], "+", 
       RowBox[{"2", " ", "p", " ", 
        RowBox[{"fz", "[", "t", "]"}]}]}], ")"}]}], "+", 
    RowBox[{"w", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"v", " ", "\[Rho]", " ", 
        RowBox[{"fy", "[", "t", "]"}]}], "+", 
       RowBox[{"w", " ", "\[Rho]", " ", 
        RowBox[{"fz", "[", "t", "]"}]}], "+", 
       RowBox[{"\[Psi]p0", "[", "t", "]"}], "-", 
       RowBox[{"\[Rho]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", " ", 
           RowBox[{
            SuperscriptBox["fx", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], "+", 
          RowBox[{"y", " ", 
           RowBox[{
            SuperscriptBox["fy", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["fz", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", "\[Rho]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], " ", "v", " ", "x"}], "-", 
         RowBox[{"b", " ", "w", " ", "x"}], "+", 
         RowBox[{"a", " ", "u", " ", "y"}], "-", 
         RowBox[{"cc", " ", "w", " ", "y"}], "+", 
         RowBox[{"b", " ", "u", " ", "z"}], "+", 
         RowBox[{"cc", " ", "v", " ", "z"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["u", "2"], "+", 
         SuperscriptBox["v", "2"], "+", 
         SuperscriptBox["w", "2"]}], ")"}], " ", "\[Psi]000"}], "+", 
      RowBox[{"2", " ", "u", " ", 
       RowBox[{"fx", "[", "t", "]"}]}], "+", 
      RowBox[{"2", " ", "v", " ", 
       RowBox[{"fy", "[", "t", "]"}]}], "+", 
      RowBox[{"2", " ", "w", " ", 
       RowBox[{"fz", "[", "t", "]"}]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689676528801837`*^9, 3.6689676653928995`*^9}, {
   3.6689677230641975`*^9, 3.6689677560140824`*^9}, {3.6689677863298163`*^9, 
   3.668967801027657*^9}, 3.6689680771204486`*^9, 3.668975852851839*^9, 
   3.6690483418693933`*^9, 3.669061705751071*^9, 3.669061771439972*^9, 
   3.6690618478443327`*^9, 3.66914692591124*^9, 3.669413795751437*^9, 
   3.670041616606811*^9, 3.670045014537801*^9}]
}, Open  ]]
},
WindowSize->{750, 848},
WindowMargins->{{Automatic, 87}, {Automatic, -10}},
FrontEndVersion->"10.0 for Microsoft Windows (64-bit) (September 9, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 220, 4, 31, "Input"],
Cell[781, 26, 20887, 521, 1212, "Input"],
Cell[CellGroupData[{
Cell[21693, 551, 1932, 44, 152, "Input"],
Cell[23628, 597, 979, 14, 31, "Output"],
Cell[24610, 613, 2252, 52, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26899, 670, 1268, 23, 52, "Input"],
Cell[28170, 695, 19707, 585, 451, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47914, 1285, 2704, 67, 152, "Input"],
Cell[50621, 1354, 2049, 52, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52707, 1411, 2782, 73, 172, "Input"],
Cell[55492, 1486, 1863, 48, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57392, 1539, 2499, 69, 132, "Input"],
Cell[59894, 1610, 9276, 264, 224, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69207, 1879, 878, 20, 72, "Input"],
Cell[70088, 1901, 6029, 171, 162, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76154, 2077, 2354, 59, 132, "Input"],
Cell[78511, 2138, 2157, 58, 77, "Output"],
Cell[80671, 2198, 3450, 89, 98, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84158, 2292, 1034, 24, 72, "Input"],
Cell[85195, 2318, 5489, 150, 164, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90721, 2473, 2263, 56, 115, "Input"],
Cell[92987, 2531, 2212, 59, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95236, 2595, 1705, 47, 112, "Input"],
Cell[96944, 2644, 992, 25, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97973, 2674, 1129, 29, 72, "Input"],
Cell[99105, 2705, 2895, 84, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102037, 2794, 1586, 50, 55, "Input"],
Cell[103626, 2846, 744, 17, 31, "Output"],
Cell[104373, 2865, 744, 17, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105154, 2887, 1125, 27, 72, "Input"],
Cell[106282, 2916, 7661, 223, 186, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113980, 3144, 1890, 57, 112, "Input"],
Cell[115873, 3203, 4936, 139, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120846, 3347, 1113, 27, 72, "Input"],
Cell[121962, 3376, 5831, 166, 140, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127830, 3547, 2528, 78, 99, "Input"],
Cell[130361, 3627, 1515, 41, 55, "Output"],
Cell[131879, 3670, 1515, 41, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133431, 3716, 2947, 84, 138, "Input"],
Cell[136381, 3802, 2719, 80, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139137, 3887, 1888, 53, 132, "Input"],
Cell[141028, 3942, 2361, 68, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143426, 4015, 1886, 52, 132, "Input"],
Cell[145315, 4069, 5094, 138, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[150446, 4212, 1607, 43, 92, "Input"],
Cell[152056, 4257, 7913, 218, 204, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160006, 4480, 4380, 121, 212, "Input"],
Cell[164389, 4603, 1020, 24, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165446, 4632, 1128, 31, 112, "Input"],
Cell[166577, 4665, 849, 21, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167463, 4691, 963, 24, 72, "Input"],
Cell[168429, 4717, 1340, 35, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169806, 4757, 1441, 38, 72, "Input"],
Cell[171250, 4797, 2525, 66, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173812, 4868, 2046, 58, 99, "Input"],
Cell[175861, 4928, 1194, 31, 31, "Output"],
Cell[177058, 4961, 1194, 31, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178289, 4997, 2184, 58, 92, "Input"],
Cell[180476, 5057, 1193, 32, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[181706, 5094, 1133, 29, 92, "Input"],
Cell[182842, 5125, 800, 19, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[183679, 5149, 957, 23, 92, "Input"],
Cell[184639, 5174, 2472, 70, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187148, 5249, 537, 17, 46, "Input"],
Cell[187688, 5268, 523, 12, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[188248, 5285, 3444, 93, 312, "Input"],
Cell[191695, 5380, 678, 11, 31, "Output"],
Cell[192376, 5393, 9359, 284, 336, "Output"]
}, Open  ]],
Cell[201750, 5680, 15044, 365, 932, "Input"],
Cell[CellGroupData[{
Cell[216819, 6049, 1523, 39, 187, "Input"],
Cell[218345, 6090, 266, 4, 32, "Output"],
Cell[218614, 6096, 1537, 42, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[220188, 6143, 752, 16, 77, "Input"],
Cell[220943, 6161, 12964, 386, 372, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[233944, 6552, 2010, 52, 165, "Input"],
Cell[235957, 6606, 2348, 68, 107, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[238342, 6679, 1448, 36, 165, "Input"],
Cell[239793, 6717, 1667, 48, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[241497, 6770, 1728, 43, 143, "Input"],
Cell[243228, 6815, 2220, 65, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[245485, 6885, 1362, 34, 121, "Input"],
Cell[246850, 6921, 3995, 116, 178, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[250882, 7042, 2469, 66, 187, "Input"],
Cell[253354, 7110, 1047, 29, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[254438, 7144, 980, 22, 99, "Input"],
Cell[255421, 7168, 7713, 229, 272, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[263171, 7402, 2918, 89, 224, "Input"],
Cell[266092, 7493, 1021, 27, 80, "Output"],
Cell[267116, 7522, 1023, 27, 80, "Output"],
Cell[268142, 7551, 1021, 27, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[269200, 7583, 2186, 59, 200, "Input"],
Cell[271389, 7644, 7390, 212, 269, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[278816, 7861, 1948, 55, 143, "Input"],
Cell[280767, 7918, 706, 19, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[281510, 7942, 962, 23, 99, "Input"],
Cell[282475, 7967, 5287, 157, 200, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[287799, 8129, 1483, 39, 121, "Input"],
Cell[289285, 8170, 1212, 34, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[290534, 8209, 1478, 37, 101, "Input"],
Cell[292015, 8248, 2653, 80, 86, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[294705, 8333, 956, 32, 37, "Input"],
Cell[295664, 8367, 748, 21, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[296449, 8393, 1156, 29, 99, "Input"],
Cell[297608, 8424, 2219, 66, 86, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[299864, 8495, 1451, 48, 62, "Input"],
Cell[301318, 8545, 585, 14, 34, "Output"],
Cell[301906, 8561, 617, 15, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[302560, 8581, 1244, 32, 121, "Input"],
Cell[303807, 8615, 2017, 61, 84, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[305861, 8681, 1876, 55, 165, "Input"],
Cell[307740, 8738, 2397, 64, 86, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[310174, 8807, 1111, 28, 121, "Input"],
Cell[311288, 8837, 2031, 56, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[313356, 8898, 1452, 44, 62, "Input"],
Cell[314811, 8944, 714, 18, 34, "Output"],
Cell[315528, 8964, 679, 17, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[316244, 8986, 1342, 33, 121, "Input"],
Cell[317589, 9021, 1642, 47, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[319268, 9073, 3799, 104, 341, "Input"],
Cell[323070, 9179, 460, 9, 32, "Output"],
Cell[323533, 9190, 2625, 74, 196, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[326195, 9269, 12011, 306, 693, "Input"],
Cell[338209, 9577, 427, 8, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[338673, 9590, 7680, 188, 561, "Input"],
Cell[346356, 9780, 441, 6, 32, "Output"],
Cell[346800, 9788, 7739, 220, 375, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
