(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    209276,       5992]
NotebookOptionsPosition[    204817,       5848]
NotebookOutlinePosition[    205155,       5863]
CellTagsIndexPosition[    205112,       5860]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input",
 CellChangeTimes->{{3.665859232344759*^9, 3.665859236735454*^9}, {
  3.665863815026243*^9, 3.665863849178424*^9}, {3.665863882380316*^9, 
  3.665863929521386*^9}, {3.665899891044674*^9, 3.66589989242861*^9}, {
  3.669415158441733*^9, 3.6694151594735613`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"PDE", " ", "we", " ", "seek", " ", "symmetries", " ", 
    RowBox[{"of", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}], "+", 
      RowBox[{"Div", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "3"}], "*", 
         RowBox[{
          RowBox[{"H", "[", 
           RowBox[{"t", ",", "x", ",", "y"}], "]"}], "^", "3"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Grad", "[", 
            RowBox[{
             RowBox[{"Laplacian", "[", 
              RowBox[{
               RowBox[{"H", "[", 
                RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "-", 
           RowBox[{
            RowBox[{
             RowBox[{"W", "''"}], "[", 
             RowBox[{"H", "[", 
              RowBox[{"t", ",", "x", ",", "y"}], "]"}], "]"}], "*", 
            RowBox[{"Grad", "[", 
             RowBox[{
              RowBox[{"H", "[", 
               RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Q1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]H", "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", 
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Xi]y", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", "\[CapitalDelta]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", "H", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "Q1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "H", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665859055545368*^9, 3.665859056670993*^9}, 
   3.665859222359338*^9, {3.6658595332618227`*^9, 3.665859535110145*^9}, {
   3.665859711964427*^9, 3.665859713110396*^9}, {3.665860496681065*^9, 
   3.6658605636404743`*^9}, {3.665860875037993*^9, 3.665860881549271*^9}, {
   3.665861046773204*^9, 3.665861049549117*^9}, {3.665861674569313*^9, 
   3.6658616967593813`*^9}, {3.6658620374299707`*^9, 3.665862049470551*^9}, {
   3.6658621101506977`*^9, 3.6658621268486853`*^9}, 3.665862225420937*^9, {
   3.665867355970107*^9, 3.6658674061107483`*^9}, {3.665867527086009*^9, 
   3.66586757559233*^9}, {3.66589959391077*^9, 3.6658996402035427`*^9}, {
   3.6684740041232986`*^9, 3.668474004298764*^9}, {3.668928491972403*^9, 
   3.668928560387536*^9}, {3.668928621763188*^9, 3.668928623797504*^9}, {
   3.668970786478415*^9, 3.668970786774432*^9}, {3.669048707520356*^9, 
   3.669048712776091*^9}, {3.669064753155752*^9, 3.66906482337147*^9}, {
   3.669394688486672*^9, 3.669394700550179*^9}, {3.669396643194087*^9, 
   3.669396651529612*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
          "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.665860553384531*^9, 3.665860557223929*^9}, {
   3.665860738233917*^9, 3.665860740785784*^9}, {3.6658612774842663`*^9, 
   3.66586128001158*^9}, {3.665862134590067*^9, 3.6658621370127*^9}, {
   3.665863682232481*^9, 3.6658636923756037`*^9}, 3.66847400080856*^9, {
   3.6689284786925907`*^9, 3.668928478955988*^9}, 3.668997203408203*^9, {
   3.6689972694617662`*^9, 3.668997327834869*^9}, {3.669050535692339*^9, 
   3.669050535908247*^9}, 3.669064839789331*^9}],

Cell[BoxData["3071"], "Output",
 CellChangeTimes->{
  3.665860568806402*^9, 3.665860699218162*^9, 3.665860749239545*^9, 
   3.665860819579459*^9, 3.6658609687318277`*^9, 3.6658610978311157`*^9, 
   3.665861176145685*^9, 3.665861281631703*^9, {3.665861323616026*^9, 
   3.6658613388447933`*^9}, 3.66586137306406*^9, 3.665861437934593*^9, 
   3.665861501300076*^9, 3.665861707960017*^9, 3.6658620570322323`*^9, 
   3.66586222951998*^9, 3.66586232498002*^9, 3.665863667447193*^9, 
   3.665863704429582*^9, 3.665864035012487*^9, 3.665867213835298*^9, 
   3.665867415896546*^9, 3.6658675788940573`*^9, 3.665876577588208*^9, 
   3.665882779043414*^9, {3.665883075700088*^9, 3.6658830991137543`*^9}, 
   3.665883332741406*^9, 3.6658836128544483`*^9, {3.665899649408271*^9, 
   3.6658996731491613`*^9}, 3.665899897463888*^9, 3.6659003582501183`*^9, 
   3.666059307074613*^9, 3.6660602258226023`*^9, 3.666060350753686*^9, 
   3.666060416652234*^9, 3.666060611000554*^9, 3.66606064322018*^9, 
   3.666060946764861*^9, 3.66606129253741*^9, 3.666061494070034*^9, 
   3.666061730236937*^9, 3.6660632457588797`*^9, 3.668474017748556*^9, 
   3.668639944311246*^9, 3.668640688535591*^9, 3.668641279811082*^9, 
   3.668642327388788*^9, 3.668644854223962*^9, 3.668645113192018*^9, 
   3.668645285494177*^9, 3.668663409977647*^9, 3.668663447221861*^9, 
   3.668698781177578*^9, 3.66881471162405*^9, 3.668814922150466*^9, 
   3.66881507117148*^9, 3.6688297981046963`*^9, {3.668928465275116*^9, 
   3.6689284824446087`*^9}, 3.668928565811469*^9, 3.668928636304759*^9, 
   3.6689706650804715`*^9, {3.6689972047445593`*^9, 3.668997224384193*^9}, 
   3.668997292953072*^9, 3.669048735368332*^9, 3.6690648416748037`*^9, 
   3.6693947207208643`*^9, 3.669395318689571*^9, 3.669395792050228*^9, {
   3.66939665955208*^9, 3.669396675455168*^9}, 3.6694037028768053`*^9, 
   3.669404607691176*^9, 3.669404973048571*^9, 3.669405260930932*^9, 
   3.6694065301075487`*^9, 3.669406878064672*^9, 3.669415163150577*^9, 
   3.6694152283218327`*^9, 3.670041651782514*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "6"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "7"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "6"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "7", ",", "0"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665860568806402*^9, 3.665860699218162*^9, 3.665860749239545*^9, 
   3.665860819579459*^9, 3.6658609687318277`*^9, 3.6658610978311157`*^9, 
   3.665861176145685*^9, 3.665861281631703*^9, {3.665861323616026*^9, 
   3.6658613388447933`*^9}, 3.66586137306406*^9, 3.665861437934593*^9, 
   3.665861501300076*^9, 3.665861707960017*^9, 3.6658620570322323`*^9, 
   3.66586222951998*^9, 3.66586232498002*^9, 3.665863667447193*^9, 
   3.665863704429582*^9, 3.665864035012487*^9, 3.665867213835298*^9, 
   3.665867415896546*^9, 3.6658675788940573`*^9, 3.665876577588208*^9, 
   3.665882779043414*^9, {3.665883075700088*^9, 3.6658830991137543`*^9}, 
   3.665883332741406*^9, 3.6658836128544483`*^9, {3.665899649408271*^9, 
   3.6658996731491613`*^9}, 3.665899897463888*^9, 3.6659003582501183`*^9, 
   3.666059307074613*^9, 3.6660602258226023`*^9, 3.666060350753686*^9, 
   3.666060416652234*^9, 3.666060611000554*^9, 3.66606064322018*^9, 
   3.666060946764861*^9, 3.66606129253741*^9, 3.666061494070034*^9, 
   3.666061730236937*^9, 3.6660632457588797`*^9, 3.668474017748556*^9, 
   3.668639944311246*^9, 3.668640688535591*^9, 3.668641279811082*^9, 
   3.668642327388788*^9, 3.668644854223962*^9, 3.668645113192018*^9, 
   3.668645285494177*^9, 3.668663409977647*^9, 3.668663447221861*^9, 
   3.668698781177578*^9, 3.66881471162405*^9, 3.668814922150466*^9, 
   3.66881507117148*^9, 3.6688297981046963`*^9, {3.668928465275116*^9, 
   3.6689284824446087`*^9}, 3.668928565811469*^9, 3.668928636304759*^9, 
   3.6689706650804715`*^9, {3.6689972047445593`*^9, 3.668997224384193*^9}, 
   3.668997292953072*^9, 3.669048735368332*^9, 3.6690648416748037`*^9, 
   3.6693947207208643`*^9, 3.669395318689571*^9, 3.669395792050228*^9, {
   3.66939665955208*^9, 3.669396675455168*^9}, 3.6694037028768053`*^9, 
   3.669404607691176*^9, 3.669404973048571*^9, 3.669405260930932*^9, 
   3.6694065301075487`*^9, 3.669406878064672*^9, 3.669415163150577*^9, 
   3.6694152283218327`*^9, 3.670041653387475*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1"}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.665883470602792*^9, 3.665883514147079*^9}, {
   3.6658835910581913`*^9, 3.665883603233927*^9}, {3.666059310410915*^9, 
   3.666059312210524*^9}, {3.666059360058694*^9, 3.666059360239512*^9}, 
   3.668474000848822*^9, {3.6689285694511623`*^9, 3.668928569779299*^9}, 
   3.6690648791467037`*^9, {3.66940462594588*^9, 3.669404631024884*^9}, {
   3.669404678177184*^9, 3.66940471025184*^9}, {3.66940497722304*^9, 
   3.6694049804704237`*^9}, 3.669406561092401*^9, 3.6694066315233*^9, {
   3.6694068846503363`*^9, 3.669406887841236*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.758584`", ",", 
   RowBox[{"{", 
    RowBox[{"316", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "7"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "5"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "6", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubsuperscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}], "2"]}]}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "6"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubsuperscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}], "2"]}]}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubsuperscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}], "2"]}]}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "4"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubsuperscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}], "2"]}]}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "6", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubsuperscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}], "2"], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "5"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "5"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "6"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "6"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "4"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "5", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "7", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "5"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "5", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubsuperscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}], "2"], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "4"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "5", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "4"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubsuperscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}], "2"]}]}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "4"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubsuperscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}], "2"]}]}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "6", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "5", ",", "0"}], "}"}]]}]}], "}"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "5"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "3"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "5", ",", "1"}], "}"}]]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "6"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "4"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "5", ",", "2"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "7", ",", "0"}], "}"}]]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "7"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "5"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "4", ",", "3"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "6", ",", "1"}], "}"}]]}], "}"}]}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.665883474634829*^9, 3.665883516446656*^9}, {
   3.665883604370013*^9, 3.665883615183599*^9}, 3.665899682027528*^9, 
   3.665899906151244*^9, 3.6659003657925673`*^9, 3.666059351965775*^9, 
   3.66605940075403*^9, 3.666060459403976*^9, 3.666060705682064*^9, 
   3.66606114246948*^9, 3.6660613507908373`*^9, 3.66606154477321*^9, 
   3.666061768080144*^9, 3.666063283190283*^9, 3.668474052613628*^9, 
   3.668639981349491*^9, 3.668640724232782*^9, 3.668641315288306*^9, 
   3.668642368217092*^9, 3.668644896848131*^9, 3.668645113577855*^9, 
   3.668645327157365*^9, 3.6686634870968523`*^9, 3.66869882044004*^9, 
   3.668814744823042*^9, 3.668815105228682*^9, 3.668829830307872*^9, 
   3.668928602692143*^9, 3.668928668790959*^9, 3.6689707122851715`*^9, 
   3.669048787059308*^9, 3.669064917375269*^9, 3.6693947380326443`*^9, 
   3.669395328514729*^9, 3.669395801260365*^9, 3.669396692002305*^9, 
   3.669403715971488*^9, {3.669404624228424*^9, 3.66940464198431*^9}, 
   3.669404719379361*^9, 3.669404990777585*^9, 3.66940654300873*^9, {
   3.6694066186592627`*^9, 3.669406641632913*^9}, 3.66940689905339*^9, 
   3.6694151850194807`*^9, 3.669415240822673*^9, 3.670041665198481*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", 
   RowBox[{"\[Xi]t1", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1"}], 
   "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665876703858831*^9, 3.665876707858623*^9}, {
   3.665876738658638*^9, 3.665876756751383*^9}, {3.665883445308009*^9, 
   3.665883448292351*^9}, {3.6658836292598047`*^9, 3.6658836310027103`*^9}, {
   3.6658996927596807`*^9, 3.6658997175491743`*^9}, 3.66590033838011*^9, {
   3.666059318423967*^9, 3.666059320671864*^9}, {3.66605936183305*^9, 
   3.666059362066478*^9}, 3.6684740008853083`*^9, {3.668928775985708*^9, 
   3.6689287761940727`*^9}, 3.6690648974729643`*^9, {3.669407056977141*^9, 
   3.6694070595047417`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.123743`", ",", 
   RowBox[{"{", 
    RowBox[{"78", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "4"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
           SubsuperscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "0"}], "}"}], "2"]}]}], "}"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubsuperscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "2"}], "}"}], "2"], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6658767400894012`*^9, 3.665876759266461*^9}, 
   3.665883449802403*^9, 3.665883633047475*^9, {3.665899721652379*^9, 
   3.6658997293137627`*^9}, 3.6658999089895887`*^9, 3.665900368592868*^9, 
   3.6660594115609407`*^9, 3.6660604868847713`*^9, 3.666060756749189*^9, 
   3.666061803089653*^9, 3.666063287464396*^9, 3.6684740565455103`*^9, 
   3.668639992423995*^9, 3.668640730974599*^9, 3.668641339671123*^9, 
   3.6686423806270447`*^9, 3.668644907784545*^9, 3.668645340351701*^9, 
   3.668663495391472*^9, 3.668698828800406*^9, 3.668814749758007*^9, 
   3.668815110309901*^9, 3.668829836240344*^9, 3.6689287841476803`*^9, 
   3.6689707773348923`*^9, 3.669048851274742*^9, 3.6690649393119087`*^9, 
   3.669394784899781*^9, 3.6693953302387447`*^9, 3.6693958029416647`*^9, 
   3.669396701093276*^9, 3.669403718156598*^9, 3.669407068928748*^9, 
   3.66941520182168*^9, 3.669415243053466*^9, 3.670041670493066*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", 
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", 
   RowBox[{"\[Xi]y1", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1"}], 
   "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.66587679055571*^9, 3.6658768108625402`*^9}, 
   3.665883636747652*^9, {3.665899736831049*^9, 3.665899780912407*^9}, {
   3.665899881568077*^9, 3.6658998826316223`*^9}, {3.666059363769414*^9, 
   3.666059364049697*^9}, 3.6684740009135647`*^9, {3.668970782966214*^9, 
   3.6689707833422356`*^9}, 3.6690649005603943`*^9, {3.6694070938556023`*^9, 
   3.6694071023205147`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.535757`", ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"H", " ", 
        RowBox[{
         SuperscriptBox["\[Phi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubsuperscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "2"}], "}"}], "2"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubsuperscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "1"}], "}"}], "2"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubsuperscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "2", ",", "0"}], "}"}], "2"]}], "}"}]}], "}"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665876812496026*^9, 3.665883639432242*^9, 3.665899783664258*^9, {
   3.665899885343059*^9, 3.665899911375683*^9}, 3.66590037095161*^9, 
   3.666059415734138*^9, 3.666060492410275*^9, 3.666060779172318*^9, 
   3.66606181577527*^9, 3.666063290311077*^9, 3.668474059234006*^9, 
   3.6686400085185966`*^9, 3.668640734753441*^9, 3.6686413461169033`*^9, 
   3.668642386153282*^9, 3.668644910974415*^9, 3.668645343021432*^9, 
   3.668663498209319*^9, 3.668698831497258*^9, 3.668814753952498*^9, 
   3.668815112204434*^9, 3.668829839213091*^9, {3.668970779289004*^9, 
   3.668970792811777*^9}, 3.669048862870607*^9, 3.6690649477004423`*^9, 
   3.669394795062786*^9, 3.669395331323633*^9, 3.66939580417665*^9, 
   3.669396706687811*^9, 3.669403719708569*^9, 3.669407115081455*^9, 
   3.669415211794187*^9, 3.669415244682652*^9, 3.670041673643277*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]H1", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
    RowBox[{"H", "*", 
     RowBox[{"\[Phi]H2", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "4"}], 
   "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665899793003783*^9, 3.6658998373929*^9}, {
   3.6660593662885237`*^9, 3.6660593678729267`*^9}, 3.668474000924986*^9, {
   3.668644912199544*^9, 3.6686449155347443`*^9}, {3.6689707920217323`*^9, 
   3.6689708216944294`*^9}, {3.669064904168413*^9, 3.6690649071685467`*^9}, {
   3.669394930581637*^9, 3.6693949490765953`*^9}, {3.669394984547956*^9, 
   3.6693949973806963`*^9}, {3.6693950615461683`*^9, 3.669395098875025*^9}, {
   3.669395137763685*^9, 3.669395138274571*^9}, {3.669395293018694*^9, 
   3.669395293290131*^9}, 3.669395337330267*^9, 3.669407110666173*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.541169`", ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"\[Phi]H1", "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
           RowBox[{"H", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               RowBox[{"\[Phi]H2", "[", 
                RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["\[Xi]t1", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], "-", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox["\[Xi]y1", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ")"}]}]}], 
          ")"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]x1", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["\[Phi]H2", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]y1", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]x1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ")"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{
             SuperscriptBox["\[Phi]H1", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
           RowBox[{"H", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"7", " ", 
               RowBox[{
                SuperscriptBox["\[Phi]H2", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  RowBox[{
                   SuperscriptBox["\[Xi]y1", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["\[Xi]y1", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"\[Phi]H1", "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
           RowBox[{"H", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               RowBox[{"\[Phi]H2", "[", 
                RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["\[Xi]t1", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], "-", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox["\[Xi]y1", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ")"}]}]}], 
          ")"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"2", " ", "H", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]y1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]x1", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]y1", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"\[Phi]H1", "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
           RowBox[{"H", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               RowBox[{"\[Phi]H2", "[", 
                RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["\[Xi]t1", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], "-", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox["\[Xi]x1", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ")"}]}]}], 
          ")"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "H", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]x1", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
           RowBox[{"3", " ", 
            RowBox[{
             SuperscriptBox["\[Phi]H1", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
           RowBox[{"7", " ", "H", " ", 
            RowBox[{
             SuperscriptBox["\[Phi]H2", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
           RowBox[{"6", " ", "H", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]x1", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ")"}]}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"\[Phi]H1", "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
           RowBox[{"H", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               RowBox[{"\[Phi]H2", "[", 
                RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["\[Xi]t1", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], "-", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox["\[Xi]x1", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ")"}]}]}], 
          ")"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "3"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "1"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "3"}], "}"}]]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "4"}], "}"}]]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "1"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "4", ",", "0"}], "}"}]]}], "}"}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.665899830552203*^9, 3.6658998432886257`*^9}, 
   3.665899916990336*^9, 3.665900376510582*^9, 3.666059494981407*^9, 
   3.666059954562258*^9, 3.6660605045505123`*^9, 3.666060797712768*^9, 
   3.6660618237612753`*^9, 3.666063294882207*^9, 3.668474064089863*^9, 
   3.668640124988151*^9, 3.668640355565539*^9, 3.668640842692589*^9, 
   3.668641352716543*^9, 3.668642391012136*^9, 3.668644921748301*^9, 
   3.668645425811573*^9, 3.668663500688115*^9, 3.6686988338647213`*^9, 
   3.668814823797998*^9, 3.6688151145868073`*^9, 3.668829842375648*^9, {
   3.6689708059205275`*^9, 3.6689708256976585`*^9}, 3.669048872127378*^9, 
   3.669064951270563*^9, 3.669394804635302*^9, {3.6693949344825974`*^9, 
   3.669394950100234*^9}, {3.669394985639964*^9, 3.669394998911953*^9}, 
   3.6693950626832943`*^9, 3.6693951012150106`*^9, {3.669395140275221*^9, 
   3.669395153513254*^9}, {3.6693953331831827`*^9, 3.6693953385368137`*^9}, 
   3.669395805258606*^9, 3.6693967096620283`*^9, 3.669396759091333*^9, 
   3.6694037213084373`*^9, 3.6694071242587976`*^9, 3.669415253614264*^9, 
   3.670041675935824*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2"}], 
   "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665899848026286*^9, 3.6658998755333433`*^9}, {
   3.66589991086653*^9, 3.665899928767115*^9}, {3.66605995831616*^9, 
   3.666059959983368*^9}, 3.668474000927956*^9, {3.668645435491775*^9, 
   3.668645437627535*^9}, {3.6689708042304306`*^9, 3.668970812821922*^9}, {
   3.6690649097606707`*^9, 3.6690649128802357`*^9}, 3.669395177978643*^9, {
   3.6693952216751003`*^9, 3.6693952273632517`*^9}, {3.669396768120429*^9, 
   3.669396778328969*^9}, 3.669407139185257*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.296648`", ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]y1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ")"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{"2", " ", "H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{"2", " ", "H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.66589993316047*^9, 3.6659003806128883`*^9, 3.666059969796754*^9, 
   3.666061843852667*^9, 3.666063298131621*^9, 3.6684740672320633`*^9, 
   3.668640467105505*^9, 3.6686413907720633`*^9, 3.668642394438387*^9, 
   3.6686454416558437`*^9, 3.668663502332964*^9, 3.668698835485046*^9, 
   3.668815120679582*^9, 3.668829845809763*^9, 3.6689708375523367`*^9, 
   3.669048879131063*^9, 3.669064954810523*^9, 3.669395193138435*^9, {
   3.6693952239095373`*^9, 3.669395228675085*^9}, 3.669395363611034*^9, 
   3.669395806168339*^9, {3.669396761465979*^9, 3.669396779971107*^9}, 
   3.669403722650013*^9, 3.6694071409539537`*^9, 3.669415285191139*^9, 
   3.6700416782517843`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Phi]H2", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
      RowBox[{"2", "  ", 
       RowBox[{
        SuperscriptBox["\[Xi]x1", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ",", 
     RowBox[{"\[Phi]H2", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "x", ",", "y"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Phi]H2", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
      RowBox[{"2", "  ", 
       RowBox[{
        SuperscriptBox["\[Xi]y1", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ",", 
     RowBox[{"\[Phi]H2", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "x", ",", "y"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6693952533623857`*^9, 3.669395287810788*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]H2", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"t", ",", "x"}], "]"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]x1", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], "}"}], "}"}]], "Output",\

 CellChangeTimes->{{3.669395269266458*^9, 3.669395288801969*^9}, 
   3.669395368712522*^9, 3.669395807126652*^9, 3.669396783356862*^9, 
   3.669403722840513*^9, 3.669407142884763*^9, 3.66941528799971*^9, 
   3.670041679003817*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]H2", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"t", ",", "y"}], "]"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]y1", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], "}"}], "}"}]], "Output",\

 CellChangeTimes->{{3.669395269266458*^9, 3.669395288801969*^9}, 
   3.669395368712522*^9, 3.669395807126652*^9, 3.669396783356862*^9, 
   3.669403722840513*^9, 3.669407142884763*^9, 3.66941528799971*^9, 
   3.6700416790244303`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x2", "[", 
     RowBox[{"t", ",", "y"}], "]"}], "+", 
    RowBox[{"x", "*", 
     RowBox[{"\[Xi]x3", "[", 
      RowBox[{"t", ",", "y"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]y2", "[", 
     RowBox[{"t", ",", "x"}], "]"}], "+", 
    RowBox[{"y", "*", 
     RowBox[{"\[Xi]y3", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H2", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]H3", "[", "t", "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"\[Xi]x3", "[", 
      RowBox[{"t", ",", "y"}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"\[Xi]y3", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3"}], 
   "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665899939246879*^9, 3.6658999582943*^9}, {
   3.666059979516252*^9, 3.666059984163163*^9}, {3.668474000929165*^9, 
   3.668474000929886*^9}, {3.668645450164427*^9, 3.668645451444056*^9}, {
   3.668970842013592*^9, 3.6689708501980596`*^9}, {3.669064918610566*^9, 
   3.66906492906656*^9}, {3.669395379305471*^9, 3.6693953875295353`*^9}, {
   3.6693954723774014`*^9, 3.66939549800881*^9}, {3.669395535144391*^9, 
   3.669395547593485*^9}, {3.669395767831727*^9, 3.6693957679349413`*^9}, 
   3.669407146449789*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.310875`", ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"6", " ", "H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]y2", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "x"}], "]"}], "+", 
           RowBox[{"y", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]y3", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x"}], "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"2", " ", "H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", 
        RowBox[{"3", " ", "H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x2", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "y"}], "]"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]x3", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "y"}], "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"7", " ", "H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]y2", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "x"}], "]"}], "+", 
           RowBox[{"y", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]y3", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x"}], "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"2", " ", "H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{"3", " ", "H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]y2", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "x"}], "]"}], "+", 
           RowBox[{"y", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]y3", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x"}], "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"6", " ", "H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", 
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x2", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "y"}], "]"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]x3", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "y"}], "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", 
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x2", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "y"}], "]"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]x3", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "y"}], "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]y2", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "x"}], "]"}], "+", 
           RowBox[{"y", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]y3", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x"}], "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"7", " ", "H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", 
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x2", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "y"}], "]"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]x3", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "y"}], "]"}]}]}], ")"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "2"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "1"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "3"}], "}"}]]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "1"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}], "}"}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6658999627208776`*^9, 3.665900384767316*^9, 3.666059991204812*^9, 
   3.6660618522674437`*^9, 3.6660633015778513`*^9, 3.6684740704231663`*^9, 
   3.6686413999615593`*^9, 3.66864239685548*^9, 3.66864545447152*^9, 
   3.668663504107422*^9, 3.668698837138329*^9, 3.668815123332662*^9, 
   3.668829848189979*^9, 3.6689708525761957`*^9, 3.6690488824230413`*^9, 
   3.6690649598018503`*^9, {3.6693955413723097`*^9, 3.669395548650981*^9}, 
   3.669395820866749*^9, 3.6693967907388077`*^9, 3.669403724358047*^9, 
   3.669407148253861*^9, 3.669415313187461*^9, 3.6700416812498207`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Since", " ", "LHS", " ", "is", " ", "funciton", " ", "of", " ", 
     RowBox[{"(", 
      RowBox[{"t", ",", "y"}], ")"}], " ", "and", " ", 
     RowBox[{"(", 
      RowBox[{"t", ",", "x"}], ")"}]}], ",", " ", 
    RowBox[{
    "RHS", " ", "must", " ", "not", " ", "depend", " ", "on", " ", "x", " ", 
     "and", " ", 
     RowBox[{"y", ".", " ", "Thus"}], " ", "\[Xi]x2"}], ",", "\[Xi]y2", ",", 
    "\[Xi]x3", ",", 
    RowBox[{
    "\[Xi]y3", " ", "are", " ", "at", " ", "most", " ", "quadratic", " ", 
     "in", " ", "x", " ", "and", " ", 
     RowBox[{"y", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", "H", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]x3", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "y"}], "]"}]}], "\[Equal]", 
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "x"}], "]"}]}]}], ")"}]}]}], ",", 
     RowBox[{"\[Xi]x3", "[", 
      RowBox[{"t", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", "H", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]y3", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", 
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "y"}], "]"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "y"}], "]"}]}]}], ")"}]}]}], ",", 
     RowBox[{"\[Xi]y3", "[", 
      RowBox[{"t", ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "x"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.669407198839666*^9, 3.6694072144959087`*^9}, {
  3.6694072600239697`*^9, 3.6694073062246103`*^9}, {3.669415394514028*^9, 
  3.669415400706553*^9}, {3.6694155417055473`*^9, 3.669415665527103*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Xi]x3", "[", 
     RowBox[{"t", ",", "y"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", "t", "]"}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SuperscriptBox["y", "2"], " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.669407209902832*^9, 3.6694072152492247`*^9}, {
   3.66940729522797*^9, 3.669407306401208*^9}, 3.669415402260189*^9, {
   3.6694155645636053`*^9, 3.6694155804502077`*^9}, 3.66941562243808*^9, 
   3.669415666127228*^9, 3.670041682522846*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Xi]y3", "[", 
     RowBox[{"t", ",", "x"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", "t", "]"}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "y"}], "]"}]}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "y"}], "]"}]}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.669407209902832*^9, 3.6694072152492247`*^9}, {
   3.66940729522797*^9, 3.669407306401208*^9}, 3.669415402260189*^9, {
   3.6694155645636053`*^9, 3.6694155804502077`*^9}, 3.66941562243808*^9, 
   3.669415666127228*^9, 3.670041682572979*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x2", "[", 
    RowBox[{"t_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x4", "[", "t", "]"}], "+", 
    RowBox[{"y", "*", 
     RowBox[{"\[Xi]x5", "[", "t", "]"}]}], "+", 
    RowBox[{
     RowBox[{"y", "^", "2"}], "*", 
     RowBox[{"\[Xi]x6", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x3", "[", 
    RowBox[{"t_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x7", "[", "t", "]"}], "+", 
    RowBox[{"y", "*", 
     RowBox[{"\[Xi]x8", "[", "t", "]"}]}], "+", 
    RowBox[{
     RowBox[{"y", "^", "2"}], "*", 
     RowBox[{"\[Xi]x9", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y2", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]y4", "[", "t", "]"}], "+", 
    RowBox[{"x", "*", 
     RowBox[{"\[Xi]y5", "[", "t", "]"}]}], "+", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{"\[Xi]y6", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y3", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]y7", "[", "t", "]"}], "+", 
    RowBox[{"x", "*", 
     RowBox[{"\[Xi]y8", "[", "t", "]"}]}], "+", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "4"}], 
   "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669415671655398*^9, 3.669415728438181*^9}, {
  3.669415790781721*^9, 3.669415831902143*^9}, {3.669415903308934*^9, 
  3.669415942619832*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.543159`", ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"3", " ", "H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Xi]x8", "[", "t", "]"}], "+", 
           RowBox[{"2", " ", "y", " ", 
            RowBox[{"\[Xi]x9", "[", "t", "]"}]}]}], ")"}]}], "\[Equal]", 
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Xi]y6", "[", "t", "]"}], "+", 
           RowBox[{"y", " ", 
            RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"3", " ", "H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Xi]x6", "[", "t", "]"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"\[Xi]x9", "[", "t", "]"}]}]}], ")"}]}], "\[Equal]", 
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Xi]y8", "[", "t", "]"}], "+", 
           RowBox[{"2", " ", "x", " ", 
            RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"7", " ", 
            RowBox[{"\[Xi]x8", "[", "t", "]"}]}], "+", 
           RowBox[{"14", " ", "y", " ", 
            RowBox[{"\[Xi]x9", "[", "t", "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Xi]y6", "[", "t", "]"}], "+", 
              RowBox[{"y", " ", 
               RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Xi]x8", "[", "t", "]"}], "+", 
           RowBox[{"2", " ", "y", " ", 
            RowBox[{"\[Xi]x9", "[", "t", "]"}]}], "-", 
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Xi]y6", "[", "t", "]"}], "+", 
              RowBox[{"y", " ", 
               RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Xi]x6", "[", "t", "]"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"\[Xi]x9", "[", "t", "]"}]}], "-", 
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Xi]y8", "[", "t", "]"}], "+", 
              RowBox[{"2", " ", "x", " ", 
               RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"2", " ", "H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Xi]x6", "[", "t", "]"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"\[Xi]x9", "[", "t", "]"}]}]}], ")"}]}], "\[Equal]", 
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Xi]y8", "[", "t", "]"}], "+", 
           RowBox[{"2", " ", "x", " ", 
            RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Xi]x8", "[", "t", "]"}], "+", 
           RowBox[{"2", " ", "y", " ", 
            RowBox[{"\[Xi]x9", "[", "t", "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Xi]y6", "[", "t", "]"}], "+", 
              RowBox[{"y", " ", 
               RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"\[Xi]x6", "[", "t", "]"}]}], "+", 
           RowBox[{"2", " ", "x", " ", 
            RowBox[{"\[Xi]x9", "[", "t", "]"}]}], "-", 
           RowBox[{"7", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Xi]y8", "[", "t", "]"}], "+", 
              RowBox[{"2", " ", "x", " ", 
               RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], 
        "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "2"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "1"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "3"}], "}"}]]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "1"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}], "}"}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6694159096145067`*^9, 3.669415944580925*^9}, 
   3.6700416850939198`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "There", " ", "must", " ", "vanish", " ", "since", " ", "they", " ", 
    RowBox[{"don", "'"}], "t", " ", "depend", " ", "on", " ", "x", " ", "and",
     " ", "y"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"3", " ", "H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Xi]x8", "[", "t", "]"}], "+", 
          RowBox[{"2", " ", "y", " ", 
           RowBox[{"\[Xi]x9", "[", "t", "]"}]}]}], ")"}]}], "\[Equal]", 
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Xi]y6", "[", "t", "]"}], "+", 
          RowBox[{"y", " ", 
           RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{"3", " ", "H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Xi]x6", "[", "t", "]"}], "+", 
          RowBox[{"x", " ", 
           RowBox[{"\[Xi]x9", "[", "t", "]"}]}]}], ")"}]}], "\[Equal]", 
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Xi]y8", "[", "t", "]"}], "+", 
          RowBox[{"2", " ", "x", " ", 
           RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"7", " ", 
           RowBox[{"\[Xi]x8", "[", "t", "]"}]}], "+", 
          RowBox[{"14", " ", "y", " ", 
           RowBox[{"\[Xi]x9", "[", "t", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Xi]y6", "[", "t", "]"}], "+", 
             RowBox[{"y", " ", 
              RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], 
       "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Xi]x8", "[", "t", "]"}], "+", 
          RowBox[{"2", " ", "y", " ", 
           RowBox[{"\[Xi]x9", "[", "t", "]"}]}], "-", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Xi]y6", "[", "t", "]"}], "+", 
             RowBox[{"y", " ", 
              RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], 
       "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Xi]x6", "[", "t", "]"}], "+", 
          RowBox[{"x", " ", 
           RowBox[{"\[Xi]x9", "[", "t", "]"}]}], "-", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Xi]y8", "[", "t", "]"}], "+", 
             RowBox[{"2", " ", "x", " ", 
              RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], 
       "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"2", " ", "H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Xi]x6", "[", "t", "]"}], "+", 
          RowBox[{"x", " ", 
           RowBox[{"\[Xi]x9", "[", "t", "]"}]}]}], ")"}]}], "\[Equal]", 
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Xi]y8", "[", "t", "]"}], "+", 
          RowBox[{"2", " ", "x", " ", 
           RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Xi]x8", "[", "t", "]"}], "+", 
          RowBox[{"2", " ", "y", " ", 
           RowBox[{"\[Xi]x9", "[", "t", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Xi]y6", "[", "t", "]"}], "+", 
             RowBox[{"y", " ", 
              RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], 
       "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"\[Xi]x6", "[", "t", "]"}]}], "+", 
          RowBox[{"2", " ", "x", " ", 
           RowBox[{"\[Xi]x9", "[", "t", "]"}]}], "-", 
          RowBox[{"7", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Xi]y8", "[", "t", "]"}], "+", 
             RowBox[{"2", " ", "x", " ", 
              RowBox[{"\[Xi]y9", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], 
       "\[Equal]", "0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]x5", "[", "t", "]"}], ",", 
      RowBox[{"\[Xi]x6", "[", "t", "]"}], ",", 
      RowBox[{"\[Xi]x8", "[", "t", "]"}], ",", 
      RowBox[{"\[Xi]x9", "[", "t", "]"}], ",", 
      RowBox[{"\[Xi]y5", "[", "t", "]"}], ",", 
      RowBox[{"\[Xi]y6", "[", "t", "]"}], ",", 
      RowBox[{"\[Xi]y8", "[", "t", "]"}], ",", 
      RowBox[{"\[Xi]y9", "[", "t", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.669416025952395*^9, 3.6694160837482853`*^9}, {
  3.669416227188346*^9, 3.669416244451449*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "svars"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.669416084505912*^9, 3.669416244951157*^9, 
  3.670041686858864*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]x6", "[", "t", "]"}], "\[Rule]", 
     FractionBox[
      RowBox[{"x", " ", 
       RowBox[{"\[Xi]x8", "[", "t", "]"}]}], 
      RowBox[{"2", " ", "y"}]]}], ",", 
    RowBox[{
     RowBox[{"\[Xi]x9", "[", "t", "]"}], "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[Xi]x8", "[", "t", "]"}], 
       RowBox[{"2", " ", "y"}]]}]}], ",", 
    RowBox[{
     RowBox[{"\[Xi]y8", "[", "t", "]"}], "\[Rule]", 
     FractionBox[
      RowBox[{"2", " ", "x", " ", 
       RowBox[{"\[Xi]y6", "[", "t", "]"}]}], "y"]}], ",", 
    RowBox[{
     RowBox[{"\[Xi]y9", "[", "t", "]"}], "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[Xi]y6", "[", "t", "]"}], "y"]}]}]}], "}"}], "}"}]], "Output",\

 CellChangeTimes->{3.669416084506863*^9, 3.6694162449523697`*^9, 
  3.670041686861228*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x6", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y6", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x8", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y8", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x9", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y9", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2"}], 
   "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669416249919631*^9, 3.669416304851242*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.136291`", ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Xi]x5", "[", "t", "]"}], "+", 
           RowBox[{"\[Xi]y5", "[", "t", "]"}]}], ")"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Xi]x5", "[", "t", "]"}], "+", 
           RowBox[{"\[Xi]y5", "[", "t", "]"}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["W", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "H", "]"}]}], "\[Equal]", "0"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "1"}], "}"}]]}], "}"}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6694162996708517`*^9, 3.6694163064768877`*^9}, 
   3.6700416894728527`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y5", "[", "t_", "]"}], ":=", 
   RowBox[{"-", 
    RowBox[{"\[Xi]x5", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3"}], 
   "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669395872735736*^9, 3.669395915902651*^9}, 
   3.669407681685381*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.068917`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x5", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y4", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y7", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x4", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x5", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x7", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]x7", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["\[Xi]y7", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[Phi]H3", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], ")"}]}], "\[Equal]",
         "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}]]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0"}], "}"}]]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.669395892906046*^9, 3.669395916717738*^9}, 
   3.6693968156115932`*^9, 3.669403726495007*^9, 3.669407683096624*^9, 
   3.6694163348280897`*^9, 3.6700416914954777`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x5", "[", "t_", "]"}], ":=", "c"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x4", "[", "t_", "]"}], ":=", "\[Xi]x0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y4", "[", "t_", "]"}], ":=", "\[Xi]y0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x7", "[", "t_", "]"}], ":=", "\[Xi]x10"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y7", "[", "t_", "]"}], ":=", "\[Xi]y10"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H3", "[", "t_", "]"}], ":=", "b"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "4"}], 
   "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669395927238237*^9, 3.6693960712059803`*^9}, 
   3.669407689069641*^9, {3.669416353113556*^9, 3.669416364465467*^9}, {
   3.6694164087694283`*^9, 3.669416431985469*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.10288`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "b"}], "+", 
           RowBox[{"6", " ", "\[Xi]x10"}], "+", 
           RowBox[{"2", " ", "\[Xi]y10"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]t1", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], ")"}]}], "\[Equal]",
         "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "b"}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"\[Xi]x10", "+", "\[Xi]y10"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]t1", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], ")"}]}], "\[Equal]",
         "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "b"}], "+", 
           RowBox[{"2", " ", "\[Xi]x10"}], "+", 
           RowBox[{"6", " ", "\[Xi]y10"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]t1", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], ")"}]}], "\[Equal]",
         "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "4"}], "}"}]]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "2"}], "}"}]]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "4", ",", "0"}], "}"}]]}], "}"}]}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6693960642055597`*^9, 3.6693960719653883`*^9}, 
   3.669396823121002*^9, 3.6694037276100597`*^9, 3.66940769279749*^9, 
   3.6694164554263697`*^9, 3.6700416933408012`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "b"}], "+", 
         RowBox[{"6", " ", "\[Xi]x10"}], "+", 
         RowBox[{"2", " ", "\[Xi]y10"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]t1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], ")"}]}], "\[Equal]", 
      "0"}], ",", 
     RowBox[{
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "b"}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]x10", "+", "\[Xi]y10"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]t1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], ")"}]}], "\[Equal]", 
      "0"}], ",", 
     RowBox[{
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "b"}], "+", 
         RowBox[{"2", " ", "\[Xi]x10"}], "+", 
         RowBox[{"6", " ", "\[Xi]y10"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]t1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], ")"}]}], "\[Equal]", 
      "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]x10", ",", "\[Xi]y10", ",", 
     RowBox[{
      RowBox[{"\[Xi]t1", "'"}], "[", "t", "]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.669396099094124*^9, 3.6693961242923393`*^9}, {
  3.6694164640828257`*^9, 3.669416481657258*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "svars"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.669396125338813*^9, 3.669396826612459*^9, 
  3.669403727795919*^9, 3.669407706333734*^9, 3.669416482616724*^9, 
  3.6700416942054234`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Xi]y10", "\[Rule]", "\[Xi]x10"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t1", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "b"}], "-", 
      RowBox[{"8", " ", "\[Xi]x10"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.6693961253404903`*^9, 3.6693968266140423`*^9, 
  3.669403727797059*^9, 3.669407706335741*^9, 3.66941648261874*^9, 
  3.670041694206811*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Xi]y10", ":=", "d"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]x10", ":=", "d"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t1", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Xi]t0", "+", 
    RowBox[{"t", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], "*", "b"}], "-", 
       RowBox[{"8", "*", "d"}]}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3"}], 
   "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FindAllEquations", "[", 
  RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.669396133030457*^9, 3.6693961930286007`*^9}, {
   3.6693962287244043`*^9, 3.6693962448766336`*^9}, {3.6693968435680723`*^9, 
   3.669396847912513*^9}, {3.669397573602553*^9, 3.669397577282365*^9}, 
   3.669407709570038*^9, {3.669416490281068*^9, 3.669416504320359*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.024281`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "d", " ", 
           RowBox[{
            SuperscriptBox["W", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "H", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "+", 
             RowBox[{"4", " ", "d"}]}], ")"}], " ", "H", " ", 
           RowBox[{
            SuperscriptBox["W", 
             TagBox[
              RowBox[{"(", "3", ")"}],
              Derivative],
             MultilineFunction->None], "[", "H", "]"}]}]}], ")"}]}], 
       "\[Equal]", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "2"}], "}"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}], "}"}]}], "}"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.669396194676466*^9, {3.6693962295745068`*^9, 3.669396245821394*^9}, {
   3.669396831067831*^9, 3.669396849180554*^9}, 3.669397584924868*^9, 
   3.669403728890851*^9, 3.669407716931465*^9, 3.6694165117527657`*^9, 
   3.6700416961454077`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", "d", " ", 
          RowBox[{
           SuperscriptBox["W", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "H", "]"}]}], "+", 
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "b"}], "+", 
               RowBox[{"9", " ", "d"}]}], ")"}], " ", 
             RowBox[{
              SuperscriptBox["W", 
               TagBox[
                RowBox[{"(", "3", ")"}],
                Derivative],
               MultilineFunction->None], "[", "H", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"b", "+", 
               RowBox[{"4", " ", "d"}]}], ")"}], " ", "H", " ", 
             RowBox[{
              SuperscriptBox["W", 
               TagBox[
                RowBox[{"(", "4", ")"}],
                Derivative],
               MultilineFunction->None], "[", "H", "]"}]}]}], ")"}]}]}], 
        ")"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "d", " ", 
          RowBox[{
           SuperscriptBox["W", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "H", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "d"}]}], ")"}], " ", "H", " ", 
          RowBox[{
           SuperscriptBox["W", 
            TagBox[
             RowBox[{"(", "3", ")"}],
             Derivative],
            MultilineFunction->None], "[", "H", "]"}]}]}], ")"}]}], 
      "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      SubsuperscriptBox["H", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], "2"], ",", 
      SubscriptBox["H", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
      SubsuperscriptBox["H", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], "2"], ",", 
      SubscriptBox["H", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", "d", " ", 
           RowBox[{
            SuperscriptBox["W", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "H", "]"}]}], "+", 
          RowBox[{"H", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "b"}], "+", 
                RowBox[{"9", " ", "d"}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["W", 
                TagBox[
                 RowBox[{"(", "3", ")"}],
                 Derivative],
                MultilineFunction->None], "[", "H", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"b", "+", 
                RowBox[{"4", " ", "d"}]}], ")"}], " ", "H", " ", 
              RowBox[{
               SuperscriptBox["W", 
                TagBox[
                 RowBox[{"(", "4", ")"}],
                 Derivative],
                MultilineFunction->None], "[", "H", "]"}]}]}], ")"}]}]}], 
         ")"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "d", " ", 
           RowBox[{
            SuperscriptBox["W", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "H", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "+", 
             RowBox[{"4", " ", "d"}]}], ")"}], " ", "H", " ", 
           RowBox[{
            SuperscriptBox["W", 
             TagBox[
              RowBox[{"(", "3", ")"}],
              Derivative],
             MultilineFunction->None], "[", "H", "]"}]}]}], ")"}]}], 
       "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", "d", " ", 
           RowBox[{
            SuperscriptBox["W", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "H", "]"}]}], "+", 
          RowBox[{"H", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "b"}], "+", 
                RowBox[{"9", " ", "d"}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["W", 
                TagBox[
                 RowBox[{"(", "3", ")"}],
                 Derivative],
                MultilineFunction->None], "[", "H", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"b", "+", 
                RowBox[{"4", " ", "d"}]}], ")"}], " ", "H", " ", 
              RowBox[{
               SuperscriptBox["W", 
                TagBox[
                 RowBox[{"(", "4", ")"}],
                 Derivative],
                MultilineFunction->None], "[", "H", "]"}]}]}], ")"}]}]}], 
         ")"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"H", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "d", " ", 
           RowBox[{
            SuperscriptBox["W", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "H", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "+", 
             RowBox[{"4", " ", "d"}]}], ")"}], " ", "H", " ", 
           RowBox[{
            SuperscriptBox["W", 
             TagBox[
              RowBox[{"(", "3", ")"}],
              Derivative],
             MultilineFunction->None], "[", "H", "]"}]}]}], ")"}]}], 
       "\[Equal]", "0"}]}], "}"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.669396194676466*^9, {3.6693962295745068`*^9, 3.669396245821394*^9}, {
   3.669396831067831*^9, 3.669396849180554*^9}, 3.669397584924868*^9, 
   3.669403728890851*^9, 3.669407716931465*^9, 3.6694165117527657`*^9, 
   3.67004169712171*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Power", " ", "law", " ", "form"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", ":=", 
     FractionBox[
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "n"}], ")"}]}], 
      RowBox[{"6", "-", 
       RowBox[{"4", " ", "n"}]}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "d", " ", 
          RowBox[{
           SuperscriptBox["W", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "H", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "d"}]}], ")"}], " ", "H", " ", 
          RowBox[{
           SuperscriptBox["W", 
            TagBox[
             RowBox[{"(", "3", ")"}],
             Derivative],
            MultilineFunction->None], "[", "H", "]"}]}]}], ")"}]}], 
      "\[Equal]", "0"}], ",", 
     RowBox[{"W", "[", "H", "]"}], ",", "H"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6693962648728657`*^9, 3.669396270083292*^9}, 
   3.6693968578495893`*^9, {3.669397132349309*^9, 3.6693971560144663`*^9}, {
   3.669397241645433*^9, 3.6693972460849524`*^9}, {3.669397327860417*^9, 
   3.6693973312121677`*^9}, {3.6693976901064463`*^9, 3.669397770929246*^9}, {
   3.669416525602078*^9, 3.669416534721093*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"W", "[", "H", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["H", "n"], " ", 
       RowBox[{"C", "[", "1", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n"}]], "+", 
     RowBox[{"C", "[", "2", "]"}], "+", 
     RowBox[{"H", " ", 
      RowBox[{"C", "[", "3", "]"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6693962722995253`*^9, 3.669396861970398*^9, {3.669397138168*^9, 
   3.669397156583356*^9}, 3.66939734850644*^9, {3.669397711002501*^9, 
   3.6693977739516478`*^9}, 3.669403729942173*^9, 3.669407733081265*^9, 
   3.669416538071567*^9, 3.670041699165175*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Or", " ", "a", " ", "few", " ", "special", " ", "cases"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "n"}], ")"}]}], 
       RowBox[{"6", "-", 
        RowBox[{"4", " ", "n"}]}]], "\[Equal]", 
      RowBox[{
       RowBox[{"-", "b"}], "/", "2"}]}], ",", "n"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "n"}], ")"}]}], 
       RowBox[{"6", "-", 
        RowBox[{"4", " ", "n"}]}]], "\[Equal]", 
      RowBox[{
       RowBox[{"-", "b"}], "/", "3"}]}], ",", "n"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "n"}], ")"}]}], 
       RowBox[{"6", "-", 
        RowBox[{"4", " ", "n"}]}]], "\[Equal]", 
      RowBox[{
       RowBox[{"-", "b"}], "/", "4"}]}], ",", "n"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", ":=", 
     RowBox[{
      RowBox[{"-", "b"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "\[Xi]x7", " ", 
          RowBox[{
           SuperscriptBox["W", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "H", "]"}]}], "+", 
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "\[Xi]x7"}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["W", 
            TagBox[
             RowBox[{"(", "3", ")"}],
             Derivative],
            MultilineFunction->None], "[", "H", "]"}]}]}], ")"}]}], 
      "\[Equal]", "0"}], ",", 
     RowBox[{"W", "[", "H", "]"}], ",", "H"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", ":=", 
     RowBox[{
      RowBox[{"-", "b"}], "/", "3"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "\[Xi]x7", " ", 
          RowBox[{
           SuperscriptBox["W", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "H", "]"}]}], "+", 
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "\[Xi]x7"}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["W", 
            TagBox[
             RowBox[{"(", "3", ")"}],
             Derivative],
            MultilineFunction->None], "[", "H", "]"}]}]}], ")"}]}], 
      "\[Equal]", "0"}], ",", 
     RowBox[{"W", "[", "H", "]"}], ",", "H"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", ":=", 
     RowBox[{
      RowBox[{"-", "b"}], "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "\[Xi]x7", " ", 
          RowBox[{
           SuperscriptBox["W", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "H", "]"}]}], "+", 
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "\[Xi]x7"}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["W", 
            TagBox[
             RowBox[{"(", "3", ")"}],
             Derivative],
            MultilineFunction->None], "[", "H", "]"}]}]}], ")"}]}], 
      "\[Equal]", "0"}], ",", 
     RowBox[{"W", "[", "H", "]"}], ",", "H"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6693973976930637`*^9, 3.6693974201317*^9}, {
  3.669397503220016*^9, 3.669397508372959*^9}, {3.6694165414243383`*^9, 
  3.669416543328877*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"n", "\[Rule]", "1"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.669397402313555*^9, 3.669397420700473*^9}, 
   3.669397511302623*^9, 3.669403730039418*^9, 3.669407735262528*^9, 
   3.669416544742806*^9, 3.670041701192677*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"n", "\[Rule]", "0"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.669397402313555*^9, 3.669397420700473*^9}, 
   3.669397511302623*^9, 3.669403730039418*^9, 3.669407735262528*^9, 
   3.669416544742806*^9, 3.6700417012313213`*^9}],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{{3.669397402313555*^9, 3.669397420700473*^9}, 
   3.669397511302623*^9, 3.669403730039418*^9, 3.669407735262528*^9, 
   3.669416544742806*^9, 3.67004170123199*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"W", "[", "H", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "\[Xi]x7"}]}], ")"}]}], ")"}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"3", " ", "\[Xi]x7"}]}], ")"}]}], 
         RowBox[{"b", "+", 
          RowBox[{"4", " ", "\[Xi]x7"}]}]]], " ", 
       RowBox[{"C", "[", "1", "]"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"2", " ", "\[Xi]x7"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"3", " ", "\[Xi]x7"}]}], ")"}]}]], "+", 
     RowBox[{"C", "[", "2", "]"}], "+", 
     RowBox[{"H", " ", 
      RowBox[{"C", "[", "3", "]"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.669397402313555*^9, 3.669397420700473*^9}, 
   3.669397511302623*^9, 3.669403730039418*^9, 3.669407735262528*^9, 
   3.669416544742806*^9, 3.6700417012787*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"W", "[", "H", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "\[Xi]x7"}]}], ")"}]}], ")"}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"3", " ", "\[Xi]x7"}]}], ")"}]}], 
         RowBox[{"b", "+", 
          RowBox[{"4", " ", "\[Xi]x7"}]}]]], " ", 
       RowBox[{"C", "[", "1", "]"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"2", " ", "\[Xi]x7"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"3", " ", "\[Xi]x7"}]}], ")"}]}]], "+", 
     RowBox[{"C", "[", "2", "]"}], "+", 
     RowBox[{"H", " ", 
      RowBox[{"C", "[", "3", "]"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.669397402313555*^9, 3.669397420700473*^9}, 
   3.669397511302623*^9, 3.669403730039418*^9, 3.669407735262528*^9, 
   3.669416544742806*^9, 3.670041701308927*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"W", "[", "H", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "\[Xi]x7"}]}], ")"}]}], ")"}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"3", " ", "\[Xi]x7"}]}], ")"}]}], 
         RowBox[{"b", "+", 
          RowBox[{"4", " ", "\[Xi]x7"}]}]]], " ", 
       RowBox[{"C", "[", "1", "]"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"2", " ", "\[Xi]x7"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"3", " ", "\[Xi]x7"}]}], ")"}]}]], "+", 
     RowBox[{"C", "[", "2", "]"}], "+", 
     RowBox[{"H", " ", 
      RowBox[{"C", "[", "3", "]"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.669397402313555*^9, 3.669397420700473*^9}, 
   3.669397511302623*^9, 3.669403730039418*^9, 3.669407735262528*^9, 
   3.669416544742806*^9, 3.670041701309782*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"W", "[", "H_", "]"}], ":=", 
   RowBox[{"A", "*", 
    RowBox[{"H", "^", "n"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", ":=", 
   FractionBox[
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}], ")"}]}], 
    RowBox[{"6", "-", 
     RowBox[{"4", " ", "n"}]}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Q1", "[", 
   RowBox[{"t", ",", "x", ",", "y"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"W", "[", "H_", "]"}], ":=", 
   RowBox[{"Log", "[", "H", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", ":=", 
   RowBox[{
    RowBox[{"-", "b"}], "/", "3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Q1", "[", 
   RowBox[{"t", ",", "x", ",", "y"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"W", "[", "H_", "]"}], ":=", 
   RowBox[{"H", "*", 
    RowBox[{"Log", "[", "H", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", ":=", 
   RowBox[{
    RowBox[{"-", "b"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Q1", "[", 
   RowBox[{"t", ",", "x", ",", "y"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"W", "[", "H_", "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", "d", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Q1", "[", 
   RowBox[{"t", ",", "x", ",", "y"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669397785897129*^9, 3.669397860137055*^9}, {
  3.669397893640936*^9, 3.669397941551261*^9}, {3.6694165496170197`*^9, 
  3.669416555832388*^9}}],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{
  3.669397804460579*^9, {3.669397839109239*^9, 3.6693978624095087`*^9}, 
   3.669397896213393*^9, {3.669397927369021*^9, 3.669397944238351*^9}, 
   3.6694037317881527`*^9, 3.6694077427225723`*^9, 3.669416564026958*^9, 
   3.670041704375193*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"b", " ", 
    RowBox[{"H", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    RowBox[{"2", " ", "n"}]}]], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "c"}], " ", "x"}], "+", 
     FractionBox[
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", "y"}], 
      RowBox[{"6", "-", 
       RowBox[{"4", " ", "n"}]}]], "+", "\[Xi]y0"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", "x"}], 
      RowBox[{"6", "-", 
       RowBox[{"4", " ", "n"}]}]], "+", 
     RowBox[{"c", " ", "y"}], "+", "\[Xi]x0"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "n"}]}], ")"}], " ", "t"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "-", 
         RowBox[{"2", " ", "n"}]}], ")"}], " ", "\[Xi]t0"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["H", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    RowBox[{"2", " ", "n"}]}]]}]], "Output",
 CellChangeTimes->{
  3.669397804460579*^9, {3.669397839109239*^9, 3.6693978624095087`*^9}, 
   3.669397896213393*^9, {3.669397927369021*^9, 3.669397944238351*^9}, 
   3.6694037317881527`*^9, 3.6694077427225723`*^9, 3.669416564026958*^9, 
   3.670041704461463*^9}],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{
  3.669397804460579*^9, {3.669397839109239*^9, 3.6693978624095087`*^9}, 
   3.669397896213393*^9, {3.669397927369021*^9, 3.669397944238351*^9}, 
   3.6694037317881527`*^9, 3.6694077427225723`*^9, 3.669416564026958*^9, 
   3.67004170491798*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], " ", 
     RowBox[{"H", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "c", " ", "x"}], "+", 
       RowBox[{"b", " ", "y"}], "-", 
       RowBox[{"3", " ", "\[Xi]y0"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["H", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "x"}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", "y"}], "+", "\[Xi]x0"}], ")"}]}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["H", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "t"}], "-", 
       RowBox[{"3", " ", "\[Xi]t0"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["H", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.669397804460579*^9, {3.669397839109239*^9, 3.6693978624095087`*^9}, 
   3.669397896213393*^9, {3.669397927369021*^9, 3.669397944238351*^9}, 
   3.6694037317881527`*^9, 3.6694077427225723`*^9, 3.669416564026958*^9, 
   3.670041704943721*^9}],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{
  3.669397804460579*^9, {3.669397839109239*^9, 3.6693978624095087`*^9}, 
   3.669397896213393*^9, {3.669397927369021*^9, 3.669397944238351*^9}, 
   3.6694037317881527`*^9, 3.6694077427225723`*^9, 3.669416564026958*^9, 
   3.670041705603012*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "b"}], " ", 
   RowBox[{"H", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "c", " ", "x"}], "+", 
     RowBox[{"b", " ", "y"}], "-", 
     RowBox[{"2", " ", "\[Xi]y0"}]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", "x"}], "2"]}], "+", 
     RowBox[{"c", " ", "y"}], "+", "\[Xi]x0"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"b", " ", "t"}], "+", "\[Xi]t0"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.669397804460579*^9, {3.669397839109239*^9, 3.6693978624095087`*^9}, 
   3.669397896213393*^9, {3.669397927369021*^9, 3.669397944238351*^9}, 
   3.6694037317881527`*^9, 3.6694077427225723`*^9, 3.669416564026958*^9, 
   3.670041705624434*^9}],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{
  3.669397804460579*^9, {3.669397839109239*^9, 3.6693978624095087`*^9}, 
   3.669397896213393*^9, {3.669397927369021*^9, 3.669397944238351*^9}, 
   3.6694037317881527`*^9, 3.6694077427225723`*^9, 3.669416564026958*^9, 
   3.6700417059369707`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"b", "+", 
     RowBox[{"4", " ", "d"}]}], ")"}], " ", 
   RowBox[{"H", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "c"}], " ", "x"}], "+", 
     RowBox[{"d", " ", "y"}], "+", "\[Xi]y0"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", " ", "x"}], "+", 
     RowBox[{"c", " ", "y"}], "+", "\[Xi]x0"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", "b", " ", "t"}], "+", 
     RowBox[{"8", " ", "d", " ", "t"}], "-", "\[Xi]t0"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.669397804460579*^9, {3.669397839109239*^9, 3.6693978624095087`*^9}, 
   3.669397896213393*^9, {3.669397927369021*^9, 3.669397944238351*^9}, 
   3.6694037317881527`*^9, 3.6694077427225723`*^9, 3.669416564026958*^9, 
   3.6700417059618673`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"General", " ", "case"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "W", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", ":=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", ":=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"FindInvariance", "[", 
     RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
     "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Q1", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.669403719650682*^9, 3.6694037651989183`*^9}, 
   3.6694165844641953`*^9, {3.669416617425518*^9, 3.6694166373121023`*^9}}],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{
  3.6694037669209347`*^9, 3.669407749860079*^9, {3.669416599049447*^9, 
   3.6694166397860527`*^9}, 3.670041708118496*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"c", " ", "x"}], "-", "\[Xi]y0"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"c", " ", "y"}], "+", "\[Xi]x0"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
  RowBox[{"\[Xi]t0", " ", 
   RowBox[{
    SuperscriptBox["H", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.6694037669209347`*^9, 3.669407749860079*^9, {3.669416599049447*^9, 
   3.6694166397860527`*^9}, 3.670041708130921*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Adjoint", " ", "symmetries"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]H", "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", 
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Zeta]y", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", "\[CapitalDelta]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", "H", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "\[CapitalLambda]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "H", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6686634094080887`*^9, 3.668663424448021*^9}, {
  3.6689710697036147`*^9, 3.66897110039137*^9}, {3.669048911966913*^9, 
  3.6690489157509613`*^9}, {3.6690650773884172`*^9, 3.669065132049259*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
       RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{
          "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
           RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.669065155354356*^9, 3.6690651577851458`*^9}, {
  3.66940933289853*^9, 3.669409335354055*^9}}],

Cell[BoxData["3595"], "Output",
 CellChangeTimes->{{3.669065112158536*^9, 3.669065159460647*^9}, 
   3.6694037790852537`*^9, 3.66940917280022*^9, 3.66940935461952*^9, 
   3.669416655572324*^9, 3.670041713043911*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "6"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "7"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "8"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "6"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "6"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "7", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8", ",", "0"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.669065112158536*^9, 3.669065159460647*^9}, 
   3.6694037790852537`*^9, 3.66940917280022*^9, 3.66940935461952*^9, 
   3.669416655572324*^9, 3.670041714792885*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.668663460311492*^9, 3.668663462727518*^9}, {
   3.6689711131500998`*^9, 3.6689711156142406`*^9}, {3.669065176640615*^9, 
   3.669065184112545*^9}, 3.669409177859881*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14.79151`", ",", 
   RowBox[{"{", 
    RowBox[{"335", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Zeta]t", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Zeta]t", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Zeta]t", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"\[Zeta]t", "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "5"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "3"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "5", ",", "1"}], "}"}]]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "6"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "4"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "5", ",", "2"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "7", ",", "0"}], "}"}]]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "7"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "5"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "4", ",", "3"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "6", ",", "1"}], "}"}]]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "8"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubsuperscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "3"}], "}"}], "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "6"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubsuperscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "1"}], "}"}], "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "4", ",", "4"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "6", ",", "2"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "8", ",", "0"}], "}"}]]}], "}"}]}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668663607409707*^9, 3.668698915202847*^9, 
  3.668815204768281*^9, 3.668829924349105*^9, 3.6689711955458126`*^9, 
  3.669048998422719*^9, 3.669065242054348*^9, 3.669403800908798*^9, 
  3.669409194130641*^9, 3.669416673427874*^9, 3.670041731046607*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6686636182035093`*^9, 3.668663636601469*^9}, 
   3.668829941642436*^9, {3.6689713127711153`*^9, 3.668971314611919*^9}, {
   3.66906518771906*^9, 3.669065189383038*^9}, 3.669409215243351*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.312211`", ",", 
   RowBox[{"{", 
    RowBox[{"88", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Zeta]x", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Zeta]y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Zeta]x", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Zeta]y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"\[Zeta]y", "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"\[Zeta]x", "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1"}], "}"}]], " ", 
           SubsuperscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "0"}], "}"}], "2"]}]}], "}"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           SubsuperscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "2"}], "}"}], "2"], " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}]]}]}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "3"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "1"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "1"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}]}], "}"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "5"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "3"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "4", ",", "1"}], "}"}]]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "4"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "2"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "5", ",", "0"}], "}"}]]}], "}"}]}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.668663648837791*^9, 3.6686989270231447`*^9, 3.66881521585808*^9, {
   3.668829934125942*^9, 3.668829950459835*^9}, 3.6689713263431396`*^9, 
   3.669049012070381*^9, 3.669065267033801*^9, 3.669403807953521*^9, 
   3.669409222365881*^9, 3.669416684074945*^9, 3.670041734024406*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]y", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668663651920746*^9, 3.668663675937084*^9}, {
   3.668829957529502*^9, 3.668829957809924*^9}, {3.668971323067134*^9, 
   3.6689713245335364`*^9}, {3.6690651914944077`*^9, 3.669065193774748*^9}, 
   3.669409225043803*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.251598`", ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]H", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]H", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]H", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubsuperscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "2"}], "}"}], "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}]], " ", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubsuperscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "1"}], "}"}], "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubsuperscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "0"}], "}"}], "2"]}], "}"}]}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "4"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "2"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "4", ",", "0"}], "}"}]]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          SubscriptBox["H", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "1"}], "}"}]]}], "}"}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668663677986555*^9, 3.6686989287051277`*^9, 
  3.6688152233974953`*^9, 3.66882996045297*^9, 3.668971334143153*^9, 
  3.669049014740006*^9, 3.669065276052371*^9, 3.669403815268785*^9, 
  3.669409225836184*^9, 3.669416696072586*^9, 3.670041735296266*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H1", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6686636809448347`*^9, 3.668663705488348*^9}, {
  3.6689713360463567`*^9, 3.668971346701175*^9}, {3.669065195590478*^9, 
  3.669065199822775*^9}, {3.669409229155842*^9, 3.669409234177353*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.109873`", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]H1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]H1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "\[Equal]", "0"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "3"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2", ",", "1"}], "}"}]]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "2"}], "}"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}], "}"}]}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668663706691518*^9, 3.668698929180291*^9, 
  3.668815225642538*^9, 3.668829962831512*^9, 3.6689713524263854`*^9, 
  3.669049016001623*^9, 3.669065277740592*^9, 3.6694038197735023`*^9, 
  3.669409241649589*^9, 3.669416702568556*^9, 3.670041736302079*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H2", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"FindEquations", "[", 
   RowBox[{
   "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669409267337576*^9, 3.669409267514069*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.050823`", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Psi]H2", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "}"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6694092678577642`*^9, 3.669416706228381*^9, 
  3.670041737141694*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H2", "[", "t_", "]"}], ":=", "\[Psi]H0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Flatten", "[", "Q", "]"}], "[", 
     RowBox[{"[", "i", "]"}], "]"}], "@@", 
    RowBox[{"Flatten", "[", 
     RowBox[{"var", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"Length", "[", 
      RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6686637347918463`*^9, 3.668663735200499*^9}, {
  3.668971367714412*^9, 3.6689713813020363`*^9}, {3.669065201686346*^9, 
  3.669065210582315*^9}, {3.6694092521944942`*^9, 3.6694092811619062`*^9}}],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{
  3.6686637423131523`*^9, 3.668698929532724*^9, 3.668815227255234*^9, 
   3.668829964978107*^9, {3.6689713758732266`*^9, 3.668971382534438*^9}, 
   3.669049018306418*^9, 3.669065279849146*^9, 3.6694038318878937`*^9, {
   3.6694092569452677`*^9, 3.669409283491251*^9}, 3.669416708443593*^9, 
   3.6700417379112463`*^9}],

Cell[BoxData[
 RowBox[{"{", "\[Psi]H0", "}"}]], "Output",
 CellChangeTimes->{
  3.6686637423131523`*^9, 3.668698929532724*^9, 3.668815227255234*^9, 
   3.668829964978107*^9, {3.6689713758732266`*^9, 3.668971382534438*^9}, 
   3.669049018306418*^9, 3.669065279849146*^9, 3.6694038318878937`*^9, {
   3.6694092569452677`*^9, 3.669409283491251*^9}, 3.669416708443593*^9, 
   3.670041737912591*^9}]
}, Open  ]]
},
WindowSize->{742, 702},
WindowMargins->{{Automatic, 75}, {Automatic, -8}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 316, 5, 32, "Input"],
Cell[877, 27, 4719, 120, 319, "Input"],
Cell[CellGroupData[{
Cell[5621, 151, 1779, 42, 165, "Input"],
Cell[7403, 195, 2032, 29, 32, "Output"],
Cell[9438, 226, 5344, 136, 128, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14819, 367, 747, 13, 32, "Input"],
Cell[15569, 382, 31682, 866, 812, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47288, 1253, 923, 18, 55, "Input"],
Cell[48214, 1273, 9963, 273, 255, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58214, 1551, 1039, 25, 77, "Input"],
Cell[59256, 1578, 2322, 57, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61615, 1640, 1137, 24, 55, "Input"],
Cell[62755, 1666, 13558, 359, 405, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76350, 2030, 828, 17, 55, "Input"],
Cell[77181, 2049, 5331, 147, 157, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82549, 2201, 1704, 52, 110, "Input"],
Cell[84256, 2255, 797, 23, 37, "Output"],
Cell[85056, 2280, 799, 23, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85892, 2308, 1754, 45, 99, "Input"],
Cell[87649, 2355, 10991, 322, 284, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98677, 2682, 3186, 93, 175, "Input"],
Cell[101866, 2777, 1253, 37, 50, "Output"],
Cell[103122, 2816, 1253, 37, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104412, 2858, 1762, 52, 121, "Input"],
Cell[106177, 2912, 6570, 186, 261, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112784, 3103, 4881, 133, 253, "Input"],
Cell[117668, 3238, 489, 10, 23, "Message"],
Cell[118160, 3250, 897, 28, 94, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119094, 3283, 908, 30, 165, "Input"],
Cell[120005, 3315, 2804, 82, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[122846, 3402, 446, 12, 55, "Input"],
Cell[123295, 3416, 2482, 70, 107, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[125814, 3491, 1061, 32, 165, "Input"],
Cell[126878, 3525, 3596, 103, 155, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[130511, 3633, 1506, 44, 83, "Input"],
Cell[132020, 3679, 560, 11, 23, "Message"],
Cell[132583, 3692, 548, 15, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133168, 3712, 1070, 26, 121, "Input"],
Cell[134241, 3740, 1473, 43, 61, "Output"],
Cell[135717, 3785, 6271, 183, 187, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142025, 3973, 1475, 41, 107, "Input"],
Cell[143503, 4016, 760, 21, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[144300, 4042, 4032, 125, 320, "Input"],
Cell[148335, 4169, 287, 6, 32, "Output"],
Cell[148625, 4177, 289, 6, 32, "Output"],
Cell[148917, 4185, 228, 4, 32, "Output"],
Cell[149148, 4191, 1162, 34, 66, "Output"],
Cell[150313, 4227, 1164, 34, 66, "Output"],
Cell[151480, 4263, 1164, 34, 66, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[152681, 4302, 2419, 66, 389, "Input"],
Cell[155103, 4370, 315, 6, 32, "Output"],
Cell[155421, 4378, 2254, 76, 133, "Output"],
Cell[157678, 4456, 314, 6, 32, "Output"],
Cell[157995, 4464, 1774, 56, 77, "Output"],
Cell[159772, 4522, 315, 6, 32, "Output"],
Cell[160090, 4530, 1592, 52, 90, "Output"],
Cell[161685, 4584, 317, 6, 32, "Output"],
Cell[162005, 4592, 1612, 52, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[163654, 4649, 799, 19, 143, "Input"],
Cell[164456, 4670, 193, 4, 32, "Output"],
Cell[164652, 4676, 1091, 37, 58, "Output"]
}, Open  ]],
Cell[165758, 4716, 2408, 67, 209, "Input"],
Cell[CellGroupData[{
Cell[168191, 4787, 1520, 39, 187, "Input"],
Cell[169714, 4828, 215, 3, 32, "Output"],
Cell[169932, 4833, 3997, 125, 128, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173966, 4963, 430, 8, 32, "Input"],
Cell[174399, 4973, 10419, 293, 304, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[184855, 5271, 610, 13, 55, "Input"],
Cell[185468, 5286, 9564, 273, 278, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195069, 5564, 796, 19, 77, "Input"],
Cell[195868, 5585, 3343, 96, 111, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[199248, 5686, 681, 15, 55, "Input"],
Cell[199932, 5703, 2005, 59, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[201974, 5767, 485, 11, 55, "Input"],
Cell[202462, 5780, 521, 17, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[203020, 5802, 992, 25, 77, "Input"],
Cell[204015, 5829, 389, 7, 32, "Output"],
Cell[204407, 5838, 394, 7, 32, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
