(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     43340,       1226]
NotebookOptionsPosition[     41246,       1151]
NotebookOutlinePosition[     41585,       1166]
CellTagsIndexPosition[     41542,       1163]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input",
 CellChangeTimes->{{3.665859232344759*^9, 3.665859236735454*^9}, {
  3.665863815026243*^9, 3.665863849178424*^9}, {3.665863882380316*^9, 
  3.665863929521386*^9}, {3.665899891044674*^9, 3.66589989242861*^9}, {
  3.668914096221002*^9, 3.668914098383583*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"PDE", " ", "we", " ", "seek", " ", "symmetries", " ", 
    RowBox[{"of", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], "-", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Q1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]u", "[", 
       RowBox[{"t", ",", "x", ",", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"t", ",", "x", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"t", ",", "x", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", "\[CapitalDelta]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x"}], "}"}], ",", 
       RowBox[{"{", "u", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "Q1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"1", ",", "0"}], "]"}], "[", "u", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665859055545368*^9, 3.665859056670993*^9}, 
   3.665859222359338*^9, {3.6658595332618227`*^9, 3.665859535110145*^9}, {
   3.665859711964427*^9, 3.665859713110396*^9}, {3.665860496681065*^9, 
   3.6658605636404743`*^9}, {3.665860875037993*^9, 3.665860881549271*^9}, {
   3.665861046773204*^9, 3.665861049549117*^9}, {3.665861674569313*^9, 
   3.6658616967593813`*^9}, {3.6658620374299707`*^9, 3.665862049470551*^9}, {
   3.6658621101506977`*^9, 3.6658621268486853`*^9}, 3.665862225420937*^9, {
   3.665867355970107*^9, 3.6658674061107483`*^9}, {3.665867527086009*^9, 
   3.66586757559233*^9}, {3.66589959391077*^9, 3.6658996402035427`*^9}, {
   3.665903080783215*^9, 3.665903095503909*^9}, {3.6659037581561604`*^9, 
   3.6659037716046867`*^9}, {3.66594777299163*^9, 3.6659477738786807`*^9}, {
   3.668473500020615*^9, 3.668473500237184*^9}, {3.668914009293914*^9, 
   3.668914064661757*^9}, {3.6689686820150466`*^9, 3.668968688630425*^9}, {
   3.669048396785346*^9, 3.6690484030810013`*^9}, {3.669062222999136*^9, 
   3.669062231237136*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
          "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.665860553384531*^9, 3.665860557223929*^9}, {
   3.665860738233917*^9, 3.665860740785784*^9}, {3.6658612774842663`*^9, 
   3.66586128001158*^9}, {3.665862134590067*^9, 3.6658621370127*^9}, {
   3.665863682232481*^9, 3.6658636923756037`*^9}, 3.6684734894762774`*^9, {
   3.6686525446115513`*^9, 3.6686525513140078`*^9}, {3.668914130557156*^9, 
   3.668914151020956*^9}, {3.668914227148652*^9, 3.66891423014079*^9}, {
   3.668968186293693*^9, 3.6689681865337067`*^9}, 3.668997004351677*^9, {
   3.668997090517272*^9, 3.668997093069228*^9}, {3.669062239845809*^9, 
   3.669062241845909*^9}}],

Cell[BoxData["16"], "Output",
 CellChangeTimes->{
  3.665860568806402*^9, 3.665860699218162*^9, 3.665860749239545*^9, 
   3.665860819579459*^9, 3.6658609687318277`*^9, 3.6658610978311157`*^9, 
   3.665861176145685*^9, 3.665861281631703*^9, {3.665861323616026*^9, 
   3.6658613388447933`*^9}, 3.66586137306406*^9, 3.665861437934593*^9, 
   3.665861501300076*^9, 3.665861707960017*^9, 3.6658620570322323`*^9, 
   3.66586222951998*^9, 3.66586232498002*^9, 3.665863667447193*^9, 
   3.665863704429582*^9, 3.665864035012487*^9, 3.665867213835298*^9, 
   3.665867415896546*^9, 3.6658675788940573`*^9, 3.665876577588208*^9, 
   3.665882779043414*^9, {3.665883075700088*^9, 3.6658830991137543`*^9}, 
   3.665883332741406*^9, 3.6658836128544483`*^9, {3.665899649408271*^9, 
   3.6658996731491613`*^9}, 3.665899897463888*^9, 3.6659003582501183`*^9, 
   3.665903108062612*^9, 3.6659032261403837`*^9, {3.6659034131789093`*^9, 
   3.665903429433507*^9}, 3.6659037730712023`*^9, {3.665903968310936*^9, 
   3.6659039857972717`*^9}, 3.665904127080491*^9, 3.665904237173439*^9, 
   3.6659477938648243`*^9, 3.665948056025819*^9, 3.665948932235935*^9, 
   3.6659489710731564`*^9, 3.6659490158037148`*^9, {3.6659494321615295`*^9, 
   3.665949459126072*^9}, 3.665949574698682*^9, {3.6659496941815157`*^9, 
   3.665949711981534*^9}, {3.665949983323054*^9, 3.6659499848751426`*^9}, 
   3.665950191237946*^9, 3.6659503007092075`*^9, 3.6659504263883953`*^9, 
   3.665950662528902*^9, 3.666058372722381*^9, 3.666062898262085*^9, 
   3.6684735082500362`*^9, 3.6686352738101873`*^9, 3.66863750463104*^9, 
   3.668652554106509*^9, 3.668662076112447*^9, 3.6686986369108067`*^9, 
   3.668708868524836*^9, 3.668829732261396*^9, 3.6689141513312407`*^9, 
   3.668914230358103*^9, 3.668914369319518*^9, 3.668968206047823*^9, 
   3.66899700488612*^9, {3.668997097055818*^9, 3.6689970997560987`*^9}, 
   3.6690484109330807`*^9, 3.669062248895953*^9, 3.66906907657045*^9, 
   3.6694167281106977`*^9, 3.670041753799944*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665860568806402*^9, 3.665860699218162*^9, 3.665860749239545*^9, 
   3.665860819579459*^9, 3.6658609687318277`*^9, 3.6658610978311157`*^9, 
   3.665861176145685*^9, 3.665861281631703*^9, {3.665861323616026*^9, 
   3.6658613388447933`*^9}, 3.66586137306406*^9, 3.665861437934593*^9, 
   3.665861501300076*^9, 3.665861707960017*^9, 3.6658620570322323`*^9, 
   3.66586222951998*^9, 3.66586232498002*^9, 3.665863667447193*^9, 
   3.665863704429582*^9, 3.665864035012487*^9, 3.665867213835298*^9, 
   3.665867415896546*^9, 3.6658675788940573`*^9, 3.665876577588208*^9, 
   3.665882779043414*^9, {3.665883075700088*^9, 3.6658830991137543`*^9}, 
   3.665883332741406*^9, 3.6658836128544483`*^9, {3.665899649408271*^9, 
   3.6658996731491613`*^9}, 3.665899897463888*^9, 3.6659003582501183`*^9, 
   3.665903108062612*^9, 3.6659032261403837`*^9, {3.6659034131789093`*^9, 
   3.665903429433507*^9}, 3.6659037730712023`*^9, {3.665903968310936*^9, 
   3.6659039857972717`*^9}, 3.665904127080491*^9, 3.665904237173439*^9, 
   3.6659477938648243`*^9, 3.665948056025819*^9, 3.665948932235935*^9, 
   3.6659489710731564`*^9, 3.6659490158037148`*^9, {3.6659494321615295`*^9, 
   3.665949459126072*^9}, 3.665949574698682*^9, {3.6659496941815157`*^9, 
   3.665949711981534*^9}, {3.665949983323054*^9, 3.6659499848751426`*^9}, 
   3.665950191237946*^9, 3.6659503007092075`*^9, 3.6659504263883953`*^9, 
   3.665950662528902*^9, 3.666058372722381*^9, 3.666062898262085*^9, 
   3.6684735082500362`*^9, 3.6686352738101873`*^9, 3.66863750463104*^9, 
   3.668652554106509*^9, 3.668662076112447*^9, 3.6686986369108067`*^9, 
   3.668708868524836*^9, 3.668829732261396*^9, 3.6689141513312407`*^9, 
   3.668914230358103*^9, 3.668914369319518*^9, 3.668968206047823*^9, 
   3.66899700488612*^9, {3.668997097055818*^9, 3.6689970997560987`*^9}, 
   3.6690484109330807`*^9, 3.669062248895953*^9, 3.66906907657045*^9, 
   3.6694167281106977`*^9, 3.6700417538348207`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{
   RowBox[{"FindEquations", "[", 
    RowBox[{
    "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.665949472334827*^9, 3.6659494871506743`*^9}, {
   3.666058380526462*^9, 3.666058380902713*^9}, 3.668473489540628*^9, {
   3.6686525662753773`*^9, 3.668652570004147*^9}, {3.668914197748307*^9, 
   3.668914237109293*^9}, {3.668968188189801*^9, 3.668968188397813*^9}, 
   3.669062255092519*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Xi]x", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Xi]t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Xi]t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Xi]t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], "}"}]}],
   "}"}]], "Output",
 CellChangeTimes->{{3.6659494793512287`*^9, 3.665949487354686*^9}, {
   3.6659496976187124`*^9, 3.665949718682917*^9}, 3.6659499870182652`*^9, 
   3.665950193093052*^9, 3.6659503024773083`*^9, 3.665950428348508*^9, 
   3.6659506636889687`*^9, 3.66605838152418*^9, 3.666062898388399*^9, 
   3.668473511254017*^9, 3.668635286337861*^9, 3.668637504826174*^9, 
   3.668652571329718*^9, 3.6686620795290203`*^9, 3.6686986386333637`*^9, 
   3.66870886864008*^9, 3.668829733911622*^9, {3.668914208915225*^9, 
   3.668914237395104*^9}, 3.668914373253562*^9, 3.668968208234948*^9, 
   3.669048414031445*^9, 3.669062255843729*^9, 3.669416729018902*^9, 
   3.670041754470475*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Xi]t2", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Part", "[", 
  RowBox[{
   RowBox[{"FindEquations", "[", 
    RowBox[{
    "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6659497278864436`*^9, 3.665949767135689*^9}, {
   3.666058387696374*^9, 3.666058387919169*^9}, 3.668473489550982*^9, {
   3.6686525808592854`*^9, 3.6686526011160717`*^9}, {3.668914277115456*^9, 
   3.668914282883473*^9}, {3.6689681894458733`*^9, 3.6689682231177993`*^9}, 
   3.669062258132318*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Xi]x", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Xi]x", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], "}"}]}],
   "}"}]], "Output",
 CellChangeTimes->{{3.665949758741208*^9, 3.665949769361816*^9}, 
   3.6659499882643366`*^9, 3.665950194130111*^9, 3.665950303186349*^9, 
   3.6659504291095514`*^9, 3.6659506642660017`*^9, 3.666058389125286*^9, 
   3.666062898512599*^9, 3.668473512504938*^9, 3.6686352871629753`*^9, 
   3.668637505004342*^9, 3.668652603656062*^9, 3.6686620807081833`*^9, 
   3.6686986394024477`*^9, 3.66870886869934*^9, 3.668829734738999*^9, 
   3.6689142836393557`*^9, 3.668914382182694*^9, 3.6689682253799286`*^9, 
   3.669048415649992*^9, 3.669062258847692*^9, 3.6694167297565947`*^9, 
   3.670041755034028*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"t", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Part", "[", 
  RowBox[{
   RowBox[{"FindEquations", "[", 
    RowBox[{
    "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6659497734630504`*^9, 3.665949795959337*^9}, {
   3.666058391031641*^9, 3.66605839128098*^9}, 3.668473489556089*^9, {
   3.6686526234821577`*^9, 3.6686526245631447`*^9}, {3.6689142907310867`*^9, 
   3.6689142960994873`*^9}, {3.6689681907249465`*^9, 3.668968193301094*^9}, {
   3.6689682314292746`*^9, 3.668968247726207*^9}, 3.669062261660447*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Phi]u", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.665949785956765*^9, 3.6659497961303473`*^9}, 
   3.665949989533409*^9, 3.665950195467188*^9, 3.665950304041398*^9, 
   3.665950430010603*^9, 3.665950666282117*^9, 3.666058391461895*^9, 
   3.6660628985660677`*^9, 3.6684735134386463`*^9, 3.668635289226557*^9, 
   3.668637505756322*^9, {3.668652616798071*^9, 3.6686526257751923`*^9}, 
   3.668662081756679*^9, 3.668698640134451*^9, 3.6687088687552958`*^9, 
   3.668829735446968*^9, 3.668914299271449*^9, 3.668914384399363*^9, {
   3.668968243970992*^9, 3.668968248004223*^9}, 3.6690484169291973`*^9, 
   3.669062262613782*^9, 3.669416730440957*^9, 3.670041755543665*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u1", "[", 
     RowBox[{"t", ",", "x"}], "]"}], "+", 
    RowBox[{"u", "*", 
     RowBox[{"\[Phi]u2", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Part", "[", 
  RowBox[{
   RowBox[{"FindEquations", "[", 
    RowBox[{
    "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
     RowBox[{"\"\<extras\>\"", "\[Rule]", 
      RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.665949798944508*^9, 3.665949821390792*^9}, {
   3.66605839352704*^9, 3.6660583937272377`*^9}, 3.668473489558322*^9, {
   3.6686526424586267`*^9, 3.668652669218732*^9}, {3.668914333091671*^9, 
   3.6689143422285357`*^9}, {3.66891438829156*^9, 3.668914412460084*^9}, {
   3.668968194445159*^9, 3.668968194862183*^9}, {3.6689682518614435`*^9, 
   3.668968266966307*^9}, 3.669062265788369*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Phi]u2", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["\[Phi]u2", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Xi]t2", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]x1", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Phi]u1", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["\[Phi]u1", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6659498196326914`*^9, 3.6659498216438065`*^9}, 
   3.6659499909584904`*^9, 3.665950196585252*^9, 3.665950305192464*^9, 
   3.6659504312176723`*^9, 3.6659506668981524`*^9, 3.666058394058525*^9, 
   3.666062898622034*^9, 3.668473514373651*^9, 3.668635291223714*^9, 
   3.668637505988758*^9, {3.668652666663473*^9, 3.6686526696831408`*^9}, 
   3.6686620827965384`*^9, 3.66869864084997*^9, 3.668708868805504*^9, 
   3.668829736317677*^9, {3.668914340013486*^9, 3.668914342495056*^9}, {
   3.668914409843685*^9, 3.66891441260491*^9}, {3.6689682642031493`*^9, 
   3.668968267147318*^9}, 3.669048431843281*^9, 3.669062266263275*^9, 
   3.66941673118927*^9, 3.67004175604568*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x2", "[", "t", "]"}], "+", 
    RowBox[{
     RowBox[{"1", "/", "2"}], "*", "x", "*", 
     RowBox[{
      RowBox[{"\[Xi]t2", "'"}], "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Part", "[", 
  RowBox[{
   RowBox[{"FindEquations", "[", 
    RowBox[{
    "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
     RowBox[{"extras", "\[Rule]", 
      RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689682757028065`*^9, 3.6689683099417653`*^9}, {
  3.669062269172415*^9, 3.669062272036559*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]x2", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"x", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]t2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{
        SuperscriptBox["\[Phi]u2", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x"}], "]"}]}]}], "\[Equal]", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.6689683039574227`*^9, 3.6689683101927795`*^9}, 
   3.669048433804658*^9, 3.669062274259295*^9, 3.669416733131675*^9, 
   3.670041756537962*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u2", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u3", "[", "t", "]"}], "-", 
    RowBox[{
     RowBox[{"1", "/", "2"}], "*", "x", "*", 
     RowBox[{
      RowBox[{"\[Xi]x2", "'"}], "[", "t", "]"}]}], "-", 
    RowBox[{
     RowBox[{"1", "/", "8"}], "*", 
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{
      RowBox[{"\[Xi]t2", "''"}], "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Part", "[", 
  RowBox[{
   RowBox[{"FindEquations", "[", 
    RowBox[{
    "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "4", ",", 
     RowBox[{"extras", "\[Rule]", 
      RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689683174811964`*^9, 3.668968457374198*^9}, {
  3.6689685189107175`*^9, 3.668968523805998*^9}, {3.6690622774203444`*^9, 
  3.6690622814130297`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"8", " ", 
       RowBox[{
        SuperscriptBox["\[Phi]u3", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]t2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{"x", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t2", 
           TagBox[
            RowBox[{"(", "3", ")"}],
            Derivative],
           MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.6689683941205797`*^9, 3.6689684577702208`*^9}, 
   3.668968526722164*^9, 3.669048435865779*^9, 3.669062282054122*^9, 
   3.669416734052147*^9, 3.6700417570680447`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x2", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Xi]x3", "+", 
    RowBox[{"t", "*", "\[Xi]x4"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u3", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Phi]u4", "-", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Xi]t2", "'"}], "[", "t", "]"}], "/", "4"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Part", "[", 
  RowBox[{
   RowBox[{"FindEquations", "[", 
    RowBox[{
    "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
     RowBox[{"extras", "\[Rule]", 
      RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.668968541928034*^9, 3.6689686106699657`*^9}, {
  3.669062286716301*^9, 3.66906228871596*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{
       SuperscriptBox["\[Xi]t2", 
        TagBox[
         RowBox[{"(", "3", ")"}],
         Derivative],
        MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689686059856977`*^9, 3.6689686109359813`*^9}, 
   3.669048437462113*^9, 3.669062290291684*^9, 3.669416734972842*^9, 
   3.670041757557551*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t2", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Xi]t3", "+", 
    RowBox[{"t", "*", "\[Xi]t4"}], "+", 
    RowBox[{
     RowBox[{"t", "^", "2"}], "*", "\[Xi]t5"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindInvariance", "[", 
  RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Flatten", "[", "Q", "]"}], "[", 
      RowBox[{"[", "i", "]"}], "]"}], "@@", 
     RowBox[{"Flatten", "[", 
      RowBox[{"var", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", 
       RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.668968613577132*^9, 3.668968656694598*^9}, {
  3.66896869727792*^9, 3.6689686978379517`*^9}, {3.6690622936921473`*^9, 
  3.6690622974195642`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["\[Phi]u1", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x"}], "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[Phi]u1", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668968634120307*^9, 3.6689686570486183`*^9}, 
   3.6689686981089673`*^9, 3.669048439440687*^9, 3.669062298182707*^9, 
   3.669416735706233*^9, 3.670041758085498*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    RowBox[{"(", 
     RowBox[{"\[Xi]t4", "+", 
      RowBox[{"2", " ", "t", " ", "\[Xi]t5"}], "+", 
      RowBox[{
       SuperscriptBox["x", "2"], " ", "\[Xi]t5"}], "+", 
      RowBox[{"2", " ", "x", " ", "\[Xi]x4"}], "-", 
      RowBox[{"4", " ", "\[Phi]u4"}]}], ")"}], " ", 
    RowBox[{"u", "[", 
     RowBox[{"t", ",", "x"}], "]"}]}], "+", 
   RowBox[{"\[Phi]u1", "[", 
    RowBox[{"t", ",", "x"}], "]"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"x", " ", "\[Xi]t4"}], "2"], "+", 
      RowBox[{"t", " ", "x", " ", "\[Xi]t5"}], "+", "\[Xi]x3", "+", 
      RowBox[{"t", " ", "\[Xi]x4"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Xi]t3", "+", 
      RowBox[{"t", " ", 
       RowBox[{"(", 
        RowBox[{"\[Xi]t4", "+", 
         RowBox[{"t", " ", "\[Xi]t5"}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x"}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668968634120307*^9, 3.6689686570486183`*^9}, 
   3.6689686981089673`*^9, 3.669048439440687*^9, 3.669062298182707*^9, 
   3.669416735706233*^9, 3.670041758111822*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Adjoint", " ", "symmetries"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Q1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]u", "[", 
       RowBox[{"t", ",", "x", ",", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"t", ",", "x", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"t", ",", "x", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", "\[CapitalDelta]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x"}], "}"}], ",", 
       RowBox[{"{", "u", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "Q1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"1", ",", "0"}], "]"}], "[", "u", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.668662097058765*^9, 3.668662112699535*^9}, {
  3.668968789518195*^9, 3.668968855149949*^9}, {3.6690484446650887`*^9, 
  3.669048448665633*^9}, {3.66906233674284*^9, 3.669062355852648*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{
          "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
           RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.668968863149407*^9, 3.6689688680376863`*^9}, {
  3.669062375021236*^9, 3.66906239843608*^9}}],

Cell[BoxData["16"], "Output",
 CellChangeTimes->{{3.6686621189935703`*^9, 3.668662122856901*^9}, 
   3.668698645213879*^9, 3.668708868956238*^9, 3.668829739686619*^9, 
   3.6689688685817175`*^9, 3.669048451267728*^9, 3.6690623992098827`*^9, 
   3.6694167376885767`*^9, 3.6700417594762278`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.6686621189935703`*^9, 3.668662122856901*^9}, 
   3.668698645213879*^9, 3.668708868956238*^9, 3.668829739686619*^9, 
   3.6689688685817175`*^9, 3.669048451267728*^9, 3.6690623992098827`*^9, 
   3.6694167376885767`*^9, 3.670041759516954*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", "1", 
      ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.668968873557002*^9, 3.6689688780932617`*^9}, {
  3.669062404995412*^9, 3.669062409077259*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.035721`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t", "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668662127591557*^9, 3.668698646778336*^9, 
  3.668708869018585*^9, 3.6688297404975557`*^9, 3.6689688789383097`*^9, 
  3.669048453089065*^9, 3.669062410887199*^9, 3.669416738814198*^9, 
  3.6700417602738733`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", "1", 
      ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6686621319083757`*^9, 3.668662148138484*^9}, {
  3.668968886213726*^9, 3.6689688892298985`*^9}, {3.6690624243393307`*^9, 
  3.669062426915011*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.018141`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]x", "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668662141081359*^9, 3.6686621496480923`*^9}, 
   3.668698647751771*^9, 3.668708869075242*^9, 3.66882974199611*^9, 
   3.6689688900199437`*^9, 3.669048454733889*^9, 3.66906242811486*^9, 
   3.669416739793996*^9, 3.670041760945804*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", "1", 
      ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668662151656087*^9, 3.668662161165532*^9}, {
  3.6689688929341106`*^9, 3.6689688945011997`*^9}, {3.669062430091688*^9, 
  3.669062431819128*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.007096`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6686621614558973`*^9, 3.668698648551642*^9, 
  3.668708869124878*^9, 3.66882974276115*^9, 3.6689688949712267`*^9, 
  3.669048456070002*^9, 3.6690624323698483`*^9, 3.669416740603971*^9, 
  3.670041761582155*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Psi]u1", "[", 
    RowBox[{"t", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Flatten", "[", "Q", "]"}], "[", 
     RowBox[{"[", "i", "]"}], "]"}], "@@", 
    RowBox[{"Flatten", "[", 
     RowBox[{"var", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"Length", "[", 
      RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6686621688517027`*^9, 3.668662196787683*^9}, {
  3.6689689007335567`*^9, 3.668968921006716*^9}, {3.669062434291123*^9, 
  3.6690624436521683`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["\[Psi]u1", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x"}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["\[Psi]u1", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668662183350478*^9, 3.668662197303802*^9}, 
   3.668698649415004*^9, 3.668708869171533*^9, 3.66882974359837*^9, {
   3.6689689068489065`*^9, 3.66896892123973*^9}, 3.669048457332943*^9, {
   3.669062436173833*^9, 3.6690624442895613`*^9}, 3.669416741384227*^9, 
   3.670041762201329*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Psi]u1", "[", 
   RowBox[{"t", ",", "x"}], "]"}], "}"}]], "Output",
 CellChangeTimes->{{3.668662183350478*^9, 3.668662197303802*^9}, 
   3.668698649415004*^9, 3.668708869171533*^9, 3.66882974359837*^9, {
   3.6689689068489065`*^9, 3.66896892123973*^9}, 3.669048457332943*^9, {
   3.669062436173833*^9, 3.6690624442895613`*^9}, 3.669416741384227*^9, 
   3.6700417622026157`*^9}]
}, Open  ]]
},
WindowSize->{755, 848},
WindowMargins->{{Automatic, 64}, {Automatic, -10}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 314, 5, 32, "Input"],
Cell[875, 27, 3265, 83, 187, "Input"],
Cell[CellGroupData[{
Cell[4165, 114, 1907, 44, 165, "Input"],
Cell[6075, 160, 1984, 28, 32, "Output"],
Cell[8062, 190, 2262, 39, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10361, 234, 572, 13, 32, "Input"],
Cell[10936, 249, 1929, 51, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12902, 305, 756, 18, 55, "Input"],
Cell[13661, 325, 1282, 32, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14980, 362, 830, 19, 55, "Input"],
Cell[15813, 383, 1013, 22, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16863, 410, 1068, 25, 77, "Input"],
Cell[17934, 437, 2206, 61, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20177, 503, 762, 22, 55, "Input"],
Cell[20942, 527, 879, 26, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21858, 558, 974, 28, 55, "Input"],
Cell[22835, 588, 1080, 31, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23952, 624, 835, 24, 77, "Input"],
Cell[24790, 650, 494, 15, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25321, 670, 1022, 29, 99, "Input"],
Cell[26346, 701, 696, 22, 37, "Output"],
Cell[27045, 725, 1598, 49, 121, "Output"]
}, Open  ]],
Cell[28658, 777, 1902, 55, 165, "Input"],
Cell[CellGroupData[{
Cell[30585, 836, 1470, 38, 187, "Input"],
Cell[32058, 876, 293, 4, 32, "Output"],
Cell[32354, 882, 651, 18, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33042, 905, 481, 12, 55, "Input"],
Cell[33526, 919, 1457, 41, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35020, 965, 682, 18, 77, "Input"],
Cell[35705, 985, 1170, 32, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36912, 1022, 680, 18, 77, "Input"],
Cell[37595, 1042, 1326, 38, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38958, 1085, 1031, 27, 77, "Input"],
Cell[39992, 1114, 816, 24, 37, "Output"],
Cell[40811, 1140, 419, 8, 32, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
