(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     93722,       2881]
NotebookOptionsPosition[     88388,       2695]
NotebookOutlinePosition[     88728,       2710]
CellTagsIndexPosition[     88685,       2707]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"PDE", " ", "we", " ", "seek", " ", "symmetries", " ", 
    RowBox[{"of", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "3"}], "}"}]}], "]"}], "+", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"t", ",", "x"}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Q1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{"\[Phi]u", "[", 
      RowBox[{"t", ",", "x", ",", 
       RowBox[{"u", "[", 
        RowBox[{"t", ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "3"}], "}"}]}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", "\[CapitalDelta]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x"}], "}"}], ",", 
       RowBox[{"{", "u", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "Q1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"1", ",", "0"}], "]"}], "[", "u", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.668975897158373*^9, 3.6689759366796336`*^9}, {
  3.6689774650870533`*^9, 3.668977465319067*^9}, {3.669050131150803*^9, 
  3.669050137270719*^9}, {3.6690696152588787`*^9, 3.6690696803299923`*^9}, {
  3.6690697669221897`*^9, 3.6690697830017023`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
          "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData["95"], "Output",
 CellChangeTimes->{{3.669069685061222*^9, 3.66906969637081*^9}, 
   3.6690697966625223`*^9, 3.669416834115047*^9, 3.669416875902227*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.669069685061222*^9, 3.66906969637081*^9}, 
   3.6690697966625223`*^9, 3.669416834115047*^9, 3.669416875972802*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "4"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.668975954293641*^9, 3.6689759824982543`*^9}, {
   3.6689760385594606`*^9, 3.6689760743665085`*^9}, {3.6689777227037888`*^9, 
   3.668977723102811*^9}, 3.6689777673833437`*^9, {3.669050172192054*^9, 
   3.669050176334859*^9}, 3.6690696372037783`*^9, {3.669069721298027*^9, 
   3.669069739049615*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.807207`", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Phi]u", 
         SubsuperscriptBox["u", 
          SuperscriptBox["x", "4"], "3"]], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Phi]u", 
         SubsuperscriptBox["u", 
          SuperscriptBox["x", "4"], "2"]], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6689759953149877`*^9, 3.668976079236788*^9, {3.668976283069446*^9, 
   3.6689762956661663`*^9}, 3.6689777688454275`*^9, 3.668978216100009*^9, 
   3.66898263437372*^9, 3.6689830963711443`*^9, {3.6690501599476233`*^9, 
   3.669050177449189*^9}, 3.6690698085787086`*^9, 3.669416877529964*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "u_", ",", "ux_", ",", "uxx_", ",", "uxxx_", ",", 
     "uxxxx_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u1", "[", 
     RowBox[{"t", ",", "x", ",", "u", ",", "ux", ",", "uxx", ",", "uxxx"}], 
     "]"}], "+", 
    RowBox[{"uxxxx", "*", 
     RowBox[{"\[Phi]u2", "[", 
      RowBox[{"t", ",", "x", ",", "u", ",", "ux", ",", "uxx", ",", "uxxx"}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689760999149704`*^9, 3.66897614186337*^9}, {
  3.668977785928405*^9, 3.6689777916237307`*^9}, {3.6689778512401404`*^9, 
  3.6689778515911603`*^9}, {3.669050181702739*^9, 3.669050181966816*^9}, {
  3.669069823874309*^9, 3.669069833985346*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.121268`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Phi]u2", 
         SubsuperscriptBox["u", 
          SuperscriptBox["x", "3"], "3"]], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Phi]u2", 
         SubsuperscriptBox["u", 
          SuperscriptBox["x", "3"], "2"]], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Phi]u2", 
         SubscriptBox["u", 
          SuperscriptBox["x", "3"]]], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.66897614729368*^9, 3.6689763014074945`*^9, 
  3.668977798622131*^9, 3.668977860173651*^9, 3.6689782177111015`*^9, 
  3.66898263594481*^9, 3.668983097944235*^9, 3.669050215680029*^9, 
  3.669069842608118*^9, 3.6694168845593224`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u2", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "u_", ",", "ux_", ",", "uxx_", ",", "uxxx_"}], 
    "]"}], ":=", 
   RowBox[{"\[Phi]u21", "[", 
    RowBox[{"t", ",", "x", ",", "u", ",", "ux", ",", "uxx"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668977823350545*^9, 3.6689778412385683`*^9}, {
   3.668977902886094*^9, 3.6689779030791054`*^9}, 3.669050208212364*^9, {
   3.669069847817411*^9, 3.669069864833475*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.890552`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Phi]u1", 
        SubsuperscriptBox["u", 
         SuperscriptBox["x", "3"], "3"]], "\[Equal]", "0"}], "}"}]}], "}"}]}],
   "}"}]], "Output",
 CellChangeTimes->{3.6689779053682365`*^9, 3.6689782191501837`*^9, 
  3.6689826373558903`*^9, 3.6689830993563156`*^9, 3.6690502189201927`*^9, 
  3.669069862657323*^9, 3.669416900633359*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "u_", ",", "ux_", ",", "uxx_", ",", "uxxx_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u11", "[", 
     RowBox[{"t", ",", "x", ",", "u", ",", "ux", ",", "uxx"}], "]"}], "+", 
    RowBox[{"uxxx", "*", 
     RowBox[{"\[Phi]u12", "[", 
      RowBox[{"t", ",", "x", ",", "u", ",", "ux", ",", "uxx"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"uxxx", "^", "2"}], "*", 
     RowBox[{"\[Phi]u13", "[", 
      RowBox[{"t", ",", "x", ",", "u", ",", "ux", ",", "uxx"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689780203748145`*^9, 3.6689780206548305`*^9}, 
   3.668978098415278*^9, 3.66905020822129*^9, {3.6690698951602077`*^9, 
   3.669069994376555*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.159146`", ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Phi]u13", 
         SubsuperscriptBox["u", 
          SuperscriptBox["x", "2"], "3"]], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Phi]u21", 
         SubscriptBox["u", 
          SuperscriptBox["x", "2"]]], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.6689780163295827`*^9, 3.6689780224979353`*^9}, 
   3.6689782207852774`*^9, 3.668982638959982*^9, 3.668983101023411*^9, 
   3.6690502255221157`*^9, 3.669069916511479*^9, 3.6690700042920856`*^9, 
   3.6694169040335627`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u21", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_", ",", "uxx_"}], "]"}], ":=", 
   RowBox[{"\[Phi]u211", "[", 
    RowBox[{"t", ",", "x", ",", "u", ",", "ux"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u13", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_", ",", "uxx_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u131", "[", 
     RowBox[{"t", ",", "x", ",", "u", ",", "ux"}], "]"}], "+", 
    RowBox[{"uxx", "*", 
     RowBox[{"\[Phi]u132", "[", 
      RowBox[{"t", ",", "x", ",", "u", ",", "ux"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"uxx", "^", "2"}], "*", 
     RowBox[{"\[Phi]u133", "[", 
      RowBox[{"t", ",", "x", ",", "u", ",", "ux"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668978034197605*^9, 3.6689781130381145`*^9}, {
  3.669070017599552*^9, 3.6690700339514227`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.022242`", ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]u133", "[", 
        RowBox[{"t", ",", "x", ",", "u", ",", 
         SubscriptBox["u", "x"]}], "]"}], "\[Equal]", "0"}], "}"}]}], "}"}]}],
   "}"}]], "Output",
 CellChangeTimes->{{3.6689781047366395`*^9, 3.668978113261127*^9}, 
   3.6689782208372803`*^9, 3.668982639008985*^9, 3.6689831010774136`*^9, 
   3.6690502262917137`*^9, 3.669070053584476*^9, 3.669416915020237*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u133", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668978143136836*^9, 3.6689781667831883`*^9}, 
   3.669050208240728*^9, {3.669070070895719*^9, 3.6690700801376753`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.109003`", ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]u132", "[", 
        RowBox[{"t", ",", "x", ",", "u", ",", 
         SubscriptBox["u", "x"]}], "]"}], "\[Equal]", "0"}], "}"}]}], "}"}]}],
   "}"}]], "Output",
 CellChangeTimes->{3.6689781700333743`*^9, 3.6689782254225426`*^9, 
  3.6689826435112424`*^9, 3.668983105590672*^9, 3.669050232003871*^9, 
  3.669070095898902*^9, 3.669416921874764*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u132", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689781715134587`*^9, 3.668978207246503*^9}, 
   3.669050208243177*^9, {3.669070111591659*^9, 3.6690701165130367`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.65787`", ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Phi]u12", 
         SubsuperscriptBox["u", 
          SuperscriptBox["x", "2"], "3"]], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Phi]u131", "[", 
         RowBox[{"t", ",", "x", ",", "u", ",", 
          SubscriptBox["u", "x"]}], "]"}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668978180674983*^9, 3.66897822677662*^9}, 
   3.6689826448413186`*^9, 3.668983106918748*^9, 3.669050233776664*^9, {
   3.669070114126645*^9, 3.6690701176787643`*^9}, 3.669416932260168*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u131", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u12", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_", ",", "uxx_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u121", "[", 
     RowBox[{"t", ",", "x", ",", "u", ",", "ux"}], "]"}], "+", 
    RowBox[{"uxx", "*", 
     RowBox[{"\[Phi]u122", "[", 
      RowBox[{"t", ",", "x", ",", "u", ",", "ux"}], "]"}]}], "+", 
    RowBox[{"\[Phi]u123", "[", 
     RowBox[{"t", ",", "x", ",", "u", ",", "ux"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689782304298286`*^9, 3.6689782771755023`*^9}, {
  3.669070126470921*^9, 3.669070143567296*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.555487`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]u122", "[", 
        RowBox[{"t", ",", "x", ",", "u", ",", 
         SubscriptBox["u", "x"]}], "]"}], "\[Equal]", "0"}], "}"}]}], "}"}]}],
   "}"}]], "Output",
 CellChangeTimes->{3.66907014695932*^9, 3.669416936519017*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u122", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["u", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689782996627884`*^9, 3.6689783060941563`*^9}, 
   3.669050208247711*^9, {3.669070165960081*^9, 3.669070168903076*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.023002`", ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Phi]u11", 
         SubsuperscriptBox["u", 
          SuperscriptBox["x", "2"], "3"]], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Phi]u211", 
         SubscriptBox["u", "x"]], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6689783086483026`*^9, 3.6689826481075053`*^9, 
  3.668983110194935*^9, 3.66905023951825*^9, 3.6690701705334473`*^9, 
  3.669416938771346*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u211", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_"}], "]"}], ":=", 
   RowBox[{"\[Phi]u2111", "[", 
    RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u11", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_", ",", "uxx_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u111", "[", 
     RowBox[{"t", ",", "x", ",", "u", ",", "ux"}], "]"}], "+", 
    RowBox[{"uxx", "*", 
     RowBox[{"\[Phi]u112", "[", 
      RowBox[{"t", ",", "x", ",", "u", ",", "ux"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"uxx", "^", "2"}], "*", 
     RowBox[{"\[Phi]u113", "[", 
      RowBox[{"t", ",", "x", ",", "u", ",", "ux"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6689783150946712`*^9, 3.668978382879548*^9}, {
  3.669070178198989*^9, 3.669070198862658*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.575474`", ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Phi]u113", 
        SubsuperscriptBox["u", "x", "3"]], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.669070201591374*^9, 3.6694169403139153`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u113", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u1131", "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}], "+", 
    RowBox[{"ux", "*", 
     RowBox[{"\[Phi]u1132", "[", 
      RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ux", "^", "2"}], "*", 
     RowBox[{"\[Phi]u1133", "[", 
      RowBox[{"t", ",", "x", ",", "u"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689784218407764`*^9, 3.66897848028712*^9}, {
  3.669050245951682*^9, 3.669050246174182*^9}, {3.66907021100697*^9, 
  3.66907024972654*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.68718`", ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["u", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]], " ", 
         RowBox[{
          SuperscriptBox["\[Phi]u2111", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[Phi]u2111", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], "\[Equal]", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689784670023603`*^9, 3.6689784814691873`*^9}, 
   3.6689826497906017`*^9, 3.668983111914034*^9, {3.669050243392434*^9, 
   3.6690502475798607`*^9}, {3.669070232012926*^9, 3.669070251060692*^9}, 
   3.669416945445827*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u2111", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Phi]u21111", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668978507459674*^9, 3.6689786171269464`*^9}, 
   3.6690502579343157`*^9, {3.669070274511405*^9, 3.669070279975712*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.596539`", ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u121", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u", ",", 
          SubscriptBox["u", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]]}], "]"}], "+", 
        RowBox[{
         SuperscriptBox["\[Phi]u123", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u", ",", 
          SubscriptBox["u", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]]}], "]"}]}], "\[Equal]", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689785365803394`*^9, 3.6689786182280097`*^9}, 
   3.6689826506586514`*^9, 3.6689831172603397`*^9, 3.6690502747763453`*^9, {
   3.669070277607655*^9, 3.669070280922719*^9}, 3.6694169628400803`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u123", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"\[Phi]u121", "[", 
      RowBox[{"t", ",", "x", ",", "u", ",", "ux"}], "]"}]}], "+", 
    RowBox[{"\[Phi]u1231", "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689786528139877`*^9, 3.668978676399337*^9}, 
   3.6690502709706783`*^9, {3.669070287342392*^9, 3.6690702910388393`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.407601`", ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]u1133", "[", 
        RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668978674635236*^9, 3.668978677191382*^9}, 
   3.668982652262743*^9, 3.668983118823429*^9, 3.66905027684658*^9, 
   3.669070292923773*^9, 3.669416964742814*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1133", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689786860138865`*^9, 3.668978694654381*^9}, 
   3.6690502709777527`*^9, {3.66907029537421*^9, 3.669070297966261*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.356691`", ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]u1132", "[", 
        RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668978695561433*^9, 3.66898265274277*^9, 
  3.668983119412462*^9, 3.6690502780421*^9, 3.669070299962851*^9, 
  3.6694169660532713`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1132", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668978702893852*^9, 3.668978713126437*^9}, 
   3.6690502709948397`*^9, {3.6690703036621532`*^9, 3.669070306678404*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.259699`", ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u112", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u", ",", 
          SubscriptBox["u", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]]}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Phi]u1131", "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668978714832535*^9, 3.6689826531607943`*^9, 
  3.668983120451522*^9, 3.669050279089171*^9, 3.669070307824909*^9, 
  3.669416967261832*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1131", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u112", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u1121", "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}], "+", 
    RowBox[{"ux", "*", 
     RowBox[{"\[Phi]u1122", "[", 
      RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ux", "^", "2"}], "*", 
     RowBox[{"\[Phi]u1123", "[", 
      RowBox[{"t", ",", "x", ",", "u"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689788024055443`*^9, 3.668978844206935*^9}, {
  3.6690703124153557`*^9, 3.669070328214888*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.39361`", ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]u1123", "[", 
        RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6690703293756237`*^9, 3.669416970093457*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1123", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668978884390233*^9, 3.668978927942724*^9}, 
   3.669050271001683*^9, {3.66907035059865*^9, 3.6690703541659193`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.276334`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]u1122", "[", 
        RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.66897893049487*^9, 3.668982654119849*^9, 
  3.6689831324262066`*^9, 3.6690502826235723`*^9, 3.669070356305073*^9, 
  3.669416973670985*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1122", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668978934846119*^9, 3.6689789452227125`*^9}, 
   3.668978976423497*^9, 3.669050271003396*^9, {3.669070359189808*^9, 
   3.669070361557746*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.176405`", ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u111", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u", ",", 
          SubscriptBox["u", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]]}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u1231", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668978945457726*^9, 3.668978976921526*^9, 
  3.668982654399865*^9, 3.6689831368724613`*^9, 3.6690502836298847`*^9, 
  3.669070362228046*^9, 3.66941697545555*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u111", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_", ",", "ux_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u1111", "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}], "+", 
    RowBox[{"ux", "*", 
     RowBox[{"\[Phi]u1112", "[", 
      RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ux", "^", "2"}], "*", 
     RowBox[{"\[Phi]u1113", "[", 
      RowBox[{"t", ",", "x", ",", "u"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689789801917124`*^9, 3.6689790375599937`*^9}, {
  3.669070371477659*^9, 3.669070384268805*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.142817`", ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u1113", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u1231", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u1231", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u1231", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u1231", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6690703902239017`*^9, 3.6694169822313223`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1231", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Phi]u12311", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689790571421137`*^9, 3.668979077822297*^9}, 
   3.669050271006651*^9, {3.66907039605305*^9, 3.669070398998311*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.109487`", ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Phi]u1113", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "0", ",", "3"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6689790807024612`*^9, 3.668982654739885*^9, 
  3.6689831534704103`*^9, 3.669050291721344*^9, 3.669070399751419*^9, 
  3.669416987503195*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1113", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u11131", "[", 
     RowBox[{"t", ",", "x"}], "]"}], "+", 
    RowBox[{"u", "*", 
     RowBox[{"\[Phi]u11132", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"u", "^", "2"}], "*", 
     RowBox[{"\[Phi]u11133", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689790876938615`*^9, 3.6689790963983593`*^9}, {
   3.668979475031016*^9, 3.668979498215342*^9}, 3.669050271008395*^9, {
   3.669070406005574*^9, 3.669070408909411*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.171463`", ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]u11133", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "x"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u1112", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"18", " ", 
          RowBox[{"\[Phi]u11133", "[", 
           RowBox[{"t", ",", "x"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u1121", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"5", " ", 
         RowBox[{"\[Phi]u21111", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{"3", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]u1121", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "u"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u21111", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{"3", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]u1121", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "x", ",", "u"}], "]"}]}]}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668979496158224*^9, 3.668979498593364*^9}, 
   3.6689826549608974`*^9, 3.668983188289402*^9, 3.669050294233664*^9, 
   3.669070409865123*^9, 3.669416989952746*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"5", " ", 
     RowBox[{"\[Phi]u21111", "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{"3", " ", 
     RowBox[{
      SuperscriptBox["\[Phi]u1121", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "u"}], "]"}]}]}], ",", 
   RowBox[{"\[Phi]u1121", "[", 
    RowBox[{"t", ",", "x", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "u"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Phi]u21111", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "+", 
     RowBox[{"3", " ", 
      RowBox[{
       SuperscriptBox["\[Phi]u1121", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x", ",", "u"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"\[Phi]u1121", "[", 
    RowBox[{"t", ",", "x", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "u"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689795447820053`*^9, 3.6689795682313466`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]u1121", "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      FractionBox["5", "3"], " ", "u", " ", 
      RowBox[{"\[Phi]u21111", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"t", ",", "x"}], "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.6689795535195055`*^9, 3.668979568747376*^9}, 
   3.6689826549748983`*^9, 3.66898318930046*^9, 3.669050295424942*^9, 
   3.669070417445681*^9, 3.669417010114757*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]u1121", "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"t", ",", "u"}], "]"}], "-", 
     RowBox[{
      FractionBox["1", "3"], " ", "x", " ", 
      RowBox[{
       SuperscriptBox["\[Phi]u21111", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.6689795535195055`*^9, 3.668979568747376*^9}, 
   3.6689826549748983`*^9, 3.66898318930046*^9, 3.669050295424942*^9, 
   3.669070417445681*^9, 3.6694170101373577`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1121", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     FractionBox["5", "3"], " ", "u", " ", 
     RowBox[{"\[Phi]u21111", "[", "t", "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "3"], " ", "x", " ", 
     RowBox[{
      SuperscriptBox["\[Phi]u21111", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "+", 
    RowBox[{"\[Phi]u11211", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689795790729666`*^9, 3.668979617823183*^9}, {
   3.668983210560676*^9, 3.6689832127197995`*^9}, 3.669050271009982*^9, {
   3.6690704228298492`*^9, 3.6690704255574703`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.153905`", ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]u11133", "[", 
        RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.6689796152980385`*^9, 3.66897961845922*^9}, 
   3.6689826551559086`*^9, 3.668983223930441*^9, 3.669050297591424*^9, 
   3.669070427009441*^9, 3.669417015940485*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Phi]u11133", "[", 
   RowBox[{"t_", ",", "x_"}], "]"}], ":=", "0"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689796229574766`*^9, 3.668979629470849*^9}, 
   3.669050271011239*^9, {3.669070429109126*^9, 3.669070430909255*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.11734`", ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u1112", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Phi]u11132", "[", 
         RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668979629957877*^9, 3.668982655335919*^9, 
  3.6689832265695915`*^9, 3.669050299889225*^9, 3.669070431931305*^9, 
  3.669417017439414*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Phi]u11132", "[", 
   RowBox[{"t_", ",", "x_"}], "]"}], ":=", "0"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1112", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u11121", "[", 
     RowBox[{"t", ",", "x"}], "]"}], "+", 
    RowBox[{"u", "*", 
     RowBox[{"\[Phi]u11122", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"u", "^", "2"}], "*", 
     RowBox[{"\[Phi]u11123", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668979635198177*^9, 3.668979675510483*^9}, 
   3.669050271012734*^9, {3.669070435141316*^9, 3.6690704375170918`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.134903`", ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]u11123", "[", 
        RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668979640309469*^9, 3.6689796769895673`*^9, 
  3.66898265552793*^9, 3.6689832299387846`*^9, 3.669050301047081*^9, 
  3.6690704387146797`*^9, 3.669417019009426*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Phi]u11123", "[", 
   RowBox[{"t_", ",", "x_"}], "]"}], ":=", "0"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668979699375848*^9, 3.66897970956643*^9}, 
   3.669050271013969*^9, {3.6690704411494083`*^9, 3.6690704432207537`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.094103`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Phi]u11131", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Phi]u1111", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"6", " ", 
         RowBox[{"\[Phi]u11131", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", 
        RowBox[{"5", " ", 
         RowBox[{"\[Phi]u21111", "[", "t", "]"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.6689796872221527`*^9, 3.668979709894449*^9}, 
   3.6689826556789384`*^9, 3.6689832325879354`*^9, 3.669050302211898*^9, 
   3.669070444104413*^9, 3.66941702018545*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"\[Phi]u11131", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", 
    RowBox[{
     SuperscriptBox["\[Phi]u1111", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "3"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}]}], ",", 
   RowBox[{"\[Phi]u1111", "[", 
    RowBox[{"t", ",", "x", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "u"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6689797173018727`*^9, 3.6689797325827465`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]u1111", "[", 
     RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      SuperscriptBox["u", "3"], " ", 
      RowBox[{"\[Phi]u11131", "[", 
       RowBox[{"t", ",", "x"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"t", ",", "x"}], "]"}], "+", 
     RowBox[{"u", " ", 
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], "[", 
       RowBox[{"t", ",", "x"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["u", "2"], " ", 
      RowBox[{
       RowBox[{"C", "[", "3", "]"}], "[", 
       RowBox[{"t", ",", "x"}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.6689797247022963`*^9, 3.668979732875764*^9}, 
   3.668982655693939*^9, 3.6689832348020625`*^9, 3.66905030363151*^9, 
   3.669070449034449*^9, 3.6694170217767067`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1111", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "3"], " ", 
     SuperscriptBox["u", "3"], " ", 
     RowBox[{"\[Phi]u11131", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}], "+", 
    RowBox[{"\[Phi]u11111", "[", 
     RowBox[{"t", ",", "x"}], "]"}], "+", 
    RowBox[{"u", " ", 
     RowBox[{"\[Phi]u11112", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["u", "2"], " ", 
     RowBox[{"\[Phi]u11113", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668979737807046*^9, 3.6689797565831194`*^9}, {
  3.669070459108981*^9, 3.669070473500428*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.120252`", ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u11131", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u11122", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.669070480714286*^9, 3.669417023480571*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u11122", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"\[Phi]u111221", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u11131", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"\[Phi]u111311", "[", "t", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.668979796030376*^9, 3.668979817710616*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.6689798228949127`*^9, 3.6690502710172*^9, {3.6690704919966583`*^9, 
   3.6690704936845293`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.092387`", ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]u111221", "[", "t", "]"}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689798188926835`*^9, 3.668979823244932*^9}, 
   3.6689826560389595`*^9, 3.668983243534562*^9, 3.66905031060773*^9, 
   3.669070494342844*^9, 3.6694170262862873`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u111221", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689798282062163`*^9, 3.668979835630641*^9}, 
   3.66905027101845*^9, {3.669070498004146*^9, 3.6690704997006493`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.074027`", ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]u12311", "[", "t", "]"}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6689798359646597`*^9, 3.6689826561509657`*^9, 
  3.668983245758689*^9, 3.6690503117862387`*^9, 3.66907050061518*^9, 
  3.669417027585307*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u12311", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689798418539968`*^9, 3.6689798485193777`*^9}, 
   3.669050271019671*^9, {3.669070505292521*^9, 3.66907050822042*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.069706`", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Phi]u11121", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6689798488933997`*^9, 3.6689826562549715`*^9, 
  3.6689832477718043`*^9, 3.66905031276549*^9, 3.669070509210021*^9, 
  3.669417029852644*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u11121", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"\[Phi]u111211", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.6689798724787483`*^9, 3.669050271020932*^9, {3.66907051256478*^9, 
   3.669070540148881*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.051021`", ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Phi]u11113", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.66897986148812*^9, 3.6689798743648567`*^9}, 
   3.6689826563809786`*^9, 3.668983253484131*^9, {3.669050314275648*^9, 
   3.669050317532385*^9}, 3.669070544203141*^9, 3.669417031508153*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u11113", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u111131", "[", "t", "]"}], "+", 
    RowBox[{"x", "*", 
     RowBox[{"\[Phi]u11113", "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689798803261976`*^9, 3.6689798931749325`*^9}, 
   3.6690502710223217`*^9, {3.669070561149414*^9, 3.669070564100013*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.063006`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"\[Phi]u11113", "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u111311", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{"6", " ", 
         RowBox[{"\[Phi]u111311", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{"5", " ", 
         RowBox[{"\[Phi]u21111", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"9", " ", 
          RowBox[{"\[Phi]u11113", "[", "t", "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]u21111", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u111211", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{"3", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]u11112", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "x"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u11111", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u11111", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689798907987967`*^9, 3.668979893550954*^9}, 
   3.6689826564879847`*^9, 3.6689832553352365`*^9, 3.669050321006865*^9, 
   3.6690705695987473`*^9, 3.669417033546628*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u111311", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"5", "/", "6"}], " ", 
    RowBox[{"\[Phi]u21111", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u11113", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "/", "9"}], " ", 
    RowBox[{
     SuperscriptBox["\[Phi]u21111", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668979921070528*^9, 3.6689799642869997`*^9}, 
   3.6689826112713985`*^9, {3.668983311072425*^9, 3.6689833204389606`*^9}, {
   3.668983359999223*^9, 3.668983366903618*^9}, 3.669050271024123*^9, {
   3.669070573380002*^9, 3.6690705793006077`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.052305`", ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"\[Phi]u111211", "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u21111", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u111211", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{"3", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]u11112", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "x"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u11111", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u11111", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668979957775627*^9, 3.668979964830031*^9}, 
   3.668982656611992*^9, {3.668983345936419*^9, 3.668983367963679*^9}, 
   3.669050323190439*^9, 3.6690705799053183`*^9, 3.669417035615931*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u111211", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      SuperscriptBox["\[Phi]u21111", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689826888138337`*^9, 3.668982751431415*^9}, {
   3.668983397287356*^9, 3.6689833977673836`*^9}, 3.669050271025745*^9, {
   3.669070583468079*^9, 3.6690705878362207`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.034487`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Phi]u21111", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689827425349064`*^9, 3.668982751747433*^9}, 
   3.66898339857643*^9, 3.669050324914816*^9, 3.669070588378398*^9, 
   3.669417036832003*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u21111", "[", "t_", "]"}], ":=", "a"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689827581818013`*^9, 3.6689827682073746`*^9}, {
   3.668983407567944*^9, 3.668983431375306*^9}, 3.6690502710270452`*^9, {
   3.66907059180414*^9, 3.669070603252136*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.033146`", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Phi]u11112", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.669070603988718*^9, 3.66941703790414*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u11112", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u111121", "[", "t", "]"}], "+", 
    RowBox[{"x", "*", 
     RowBox[{"\[Phi]u111122", "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668983437958682*^9, 3.668983456958769*^9}, 
   3.669050271028439*^9, {3.669070608156107*^9, 3.669070611491976*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.029576`", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"\[Phi]u111122", "[", "t", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u111131", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Phi]u111131", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{"\[Phi]u11211", "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"\[Phi]u111122", "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u11211", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u11111", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u11111", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668983450097377*^9, 3.6689834572667866`*^9}, 
   3.669050327415524*^9, 3.669070612013029*^9, 3.669417038866281*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u11211", "[", "t_", "]"}], ":=", 
   RowBox[{"2", " ", 
    RowBox[{"\[Phi]u111131", "[", "t", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u111122", "[", "t_", "]"}], ":=", 
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["\[Phi]u111131", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689834653582497`*^9, 3.668983496943056*^9}, 
   3.669050271030038*^9, {3.6690706147400723`*^9, 3.6690706176682587`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.024646`", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Phi]u111131", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689834916697545`*^9, 3.6689834972300725`*^9}, 
   3.669050328781694*^9, 3.669070618737722*^9, 3.669417041192295*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u111131", "[", "t_", "]"}], ":=", "b"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668983500366252*^9, 3.6689835100948086`*^9}, 
   3.669050271031294*^9, {3.6690706211640787`*^9, 3.669070624484559*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.019525`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u111121", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u11111", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u11111", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u11111", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689835078246784`*^9, 3.6689835104408283`*^9}, 
   3.6690503303387337`*^9, 3.669070625049205*^9, 3.6694170423245363`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u11111", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u111111", "[", "t", "]"}], "-", 
    RowBox[{"x", "*", 
     RowBox[{
      SuperscriptBox["\[Phi]u111121", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689835194943457`*^9, 3.6689835478629684`*^9}, 
   3.669050271032722*^9, {3.669070629852008*^9, 3.669070633123929*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.01854`", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Phi]u111111", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"x", " ", 
        RowBox[{
         SuperscriptBox["\[Phi]u111121", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.668983543187701*^9, 3.668983548199988*^9}, 
   3.669050331793601*^9, 3.669070634464547*^9, 3.6694170433062057`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u111111", "[", "t_", "]"}], ":=", "c"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u111121", "[", "t_", "]"}], ":=", 
   RowBox[{"d", "+", 
    RowBox[{"e", "*", "t"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindInvariance", "[", 
  RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
   RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Flatten", "[", "Q", "]"}], "[", 
     RowBox[{"[", "i", "]"}], "]"}], "@@", 
    RowBox[{"Flatten", "[", 
     RowBox[{"var", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"Length", "[", 
      RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.668983555966432*^9, 3.6689836088794584`*^9}, {
  3.6690503373192453`*^9, 3.66905033773361*^9}, {3.669070638571888*^9, 
  3.669070649491692*^9}}],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{{3.6689835844160595`*^9, 3.6689836104345474`*^9}, {
   3.669050333815645*^9, 3.669050338326891*^9}, 3.669070650581912*^9, 
   3.669417044111353*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", "-", 
   RowBox[{"e", " ", "x"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "t"}]}], ")"}], " ", 
    RowBox[{"u", "[", 
     RowBox[{"t", ",", "x"}], "]"}]}], "+", 
   RowBox[{"b", " ", 
    SuperscriptBox[
     RowBox[{"u", "[", 
      RowBox[{"t", ",", "x"}], "]"}], "2"]}], "+", 
   RowBox[{
    FractionBox["5", "18"], " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"u", "[", 
      RowBox[{"t", ",", "x"}], "]"}], "3"]}], "+", 
   RowBox[{
    FractionBox["5", "6"], " ", "a", " ", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["u", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x"}], "]"}], "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "b"}], "+", 
      RowBox[{
       FractionBox["5", "3"], " ", "a", " ", 
       RowBox[{"u", "[", 
        RowBox[{"t", ",", "x"}], "]"}]}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x"}], "]"}]}], "+", 
   RowBox[{"a", " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "4"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x"}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689835844160595`*^9, 3.6689836104345474`*^9}, {
   3.669050333815645*^9, 3.669050338326891*^9}, 3.669070650581912*^9, 
   3.6694170441252213`*^9}]
}, Open  ]]
},
WindowSize->{775, 848},
WindowMargins->{{198, Automatic}, {Automatic, -10}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 56, 1, 32, "Input"],
Cell[617, 23, 2820, 83, 187, "Input"],
Cell[CellGroupData[{
Cell[3462, 110, 1297, 35, 165, "Input"],
Cell[4762, 147, 166, 2, 32, "Output"],
Cell[4931, 151, 694, 22, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5662, 178, 1838, 50, 108, "Input"],
Cell[7503, 230, 782, 20, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8322, 255, 2022, 55, 152, "Input"],
Cell[10347, 312, 863, 23, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11247, 340, 1745, 49, 130, "Input"],
Cell[12995, 391, 486, 13, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13518, 409, 1783, 49, 174, "Input"],
Cell[15304, 460, 705, 19, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16046, 484, 1931, 53, 174, "Input"],
Cell[17980, 539, 528, 13, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18545, 557, 1310, 36, 130, "Input"],
Cell[19858, 595, 500, 13, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20395, 613, 1310, 36, 130, "Input"],
Cell[21708, 651, 699, 18, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22444, 674, 1780, 49, 174, "Input"],
Cell[24227, 725, 377, 11, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24641, 741, 1310, 36, 130, "Input"],
Cell[25954, 779, 592, 17, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26583, 801, 1648, 44, 172, "Input"],
Cell[28234, 847, 336, 10, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28607, 862, 1336, 37, 128, "Input"],
Cell[29946, 901, 1132, 32, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31115, 938, 997, 26, 106, "Input"],
Cell[32115, 966, 1208, 33, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33360, 1004, 1181, 32, 106, "Input"],
Cell[34544, 1038, 461, 12, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35042, 1055, 959, 26, 106, "Input"],
Cell[36004, 1083, 435, 12, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36476, 1100, 960, 26, 106, "Input"],
Cell[37439, 1128, 886, 25, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38362, 1158, 1441, 41, 150, "Input"],
Cell[39806, 1201, 343, 10, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40186, 1216, 957, 26, 106, "Input"],
Cell[41146, 1244, 439, 12, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41622, 1261, 984, 27, 106, "Input"],
Cell[42609, 1290, 1091, 31, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43737, 1326, 977, 26, 99, "Input"],
Cell[44717, 1354, 1799, 53, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46553, 1412, 679, 16, 77, "Input"],
Cell[47235, 1430, 617, 18, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47889, 1453, 1007, 26, 77, "Input"],
Cell[48899, 1481, 2391, 68, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51327, 1554, 1331, 39, 86, "Input"],
Cell[52661, 1595, 585, 15, 49, "Output"],
Cell[53249, 1612, 659, 18, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53945, 1635, 1040, 26, 103, "Input"],
Cell[54988, 1663, 454, 12, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55479, 1680, 610, 14, 77, "Input"],
Cell[56092, 1696, 760, 22, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56889, 1723, 1071, 28, 121, "Input"],
Cell[57963, 1753, 452, 12, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58452, 1770, 611, 14, 77, "Input"],
Cell[59066, 1786, 1000, 28, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60103, 1819, 655, 19, 61, "Input"],
Cell[60761, 1840, 929, 26, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61727, 1871, 1174, 32, 148, "Input"],
Cell[62904, 1905, 819, 26, 37, "Output"]
}, Open  ]],
Cell[63738, 1934, 421, 11, 55, "Input"],
Cell[CellGroupData[{
Cell[64184, 1949, 549, 14, 77, "Input"],
Cell[64736, 1965, 430, 11, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65203, 1981, 685, 17, 99, "Input"],
Cell[65891, 2000, 403, 11, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66331, 2016, 684, 17, 99, "Input"],
Cell[67018, 2035, 597, 18, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67652, 2058, 725, 19, 99, "Input"],
Cell[68380, 2079, 645, 18, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69062, 2102, 846, 22, 99, "Input"],
Cell[69911, 2126, 2227, 64, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72175, 2195, 1188, 31, 121, "Input"],
Cell[73366, 2228, 1735, 50, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75138, 2283, 891, 23, 101, "Input"],
Cell[76032, 2308, 475, 13, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76544, 2326, 736, 18, 99, "Input"],
Cell[77283, 2346, 496, 16, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77816, 2367, 841, 22, 99, "Input"],
Cell[78660, 2391, 1590, 46, 82, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80287, 2442, 993, 27, 121, "Input"],
Cell[81283, 2471, 453, 12, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81773, 2488, 686, 17, 99, "Input"],
Cell[82462, 2507, 1350, 40, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83849, 2552, 912, 24, 99, "Input"],
Cell[84764, 2578, 601, 16, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85402, 2599, 1054, 28, 99, "Input"],
Cell[86459, 2629, 218, 4, 32, "Output"],
Cell[86680, 2635, 1692, 57, 90, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
