(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     65786,       1839]
NotebookOptionsPosition[     63202,       1748]
NotebookOutlinePosition[     63539,       1763]
CellTagsIndexPosition[     63496,       1760]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input",
 CellChangeTimes->{{3.665859232344759*^9, 3.665859236735454*^9}, {
  3.665863815026243*^9, 3.665863849178424*^9}, {3.665863882380316*^9, 
  3.665863929521386*^9}, {3.665899891044674*^9, 3.66589989242861*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"PDE", " ", "we", " ", "seek", " ", "symmetries", " ", 
    RowBox[{"of", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], "+", 
      RowBox[{"Div", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], "*", 
         RowBox[{
          RowBox[{"H", "[", 
           RowBox[{"t", ",", "x"}], "]"}], "^", "2"}], "*", 
         RowBox[{"Grad", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]2", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], "+", 
      RowBox[{"Div", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"H", "[", 
           RowBox[{"t", ",", "x"}], "]"}]}], "*", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x"}], "]"}], "*", 
         RowBox[{"Grad", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{"\[Psi]H", "[", 
      RowBox[{"t", ",", "x", ",", 
       RowBox[{"H", "[", 
        RowBox[{"t", ",", "x"}], "]"}], ",", 
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"t", ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]2", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{"\[Psi]\[CapitalGamma]", "[", 
      RowBox[{"t", ",", "x", ",", 
       RowBox[{"H", "[", 
        RowBox[{"t", ",", "x"}], "]"}], ",", 
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"t", ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", 
      RowBox[{"\[CapitalLambda]1", ",", "\[CapitalLambda]2"}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", 
      RowBox[{"\[CapitalDelta]1", ",", "\[CapitalDelta]2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0"}], "]"}], "[", "H", "]"}], ",", 
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0"}], "]"}], "[", "\[CapitalGamma]", "]"}]}], 
      "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665859055545368*^9, 3.665859056670993*^9}, 
   3.665859222359338*^9, {3.6658595332618227`*^9, 3.665859535110145*^9}, {
   3.665859711964427*^9, 3.665859713110396*^9}, {3.665860496681065*^9, 
   3.6658605636404743`*^9}, {3.665860875037993*^9, 3.665860881549271*^9}, {
   3.665861046773204*^9, 3.665861049549117*^9}, {3.665861674569313*^9, 
   3.6658616967593813`*^9}, {3.6658620374299707`*^9, 3.665862049470551*^9}, {
   3.6658621101506977`*^9, 3.6658621268486853`*^9}, 3.665862225420937*^9, {
   3.665867355970107*^9, 3.6658674061107483`*^9}, {3.665867527086009*^9, 
   3.66586757559233*^9}, {3.66589959391077*^9, 3.6658996402035427`*^9}, {
   3.6684740041232986`*^9, 3.668474004298764*^9}, {3.668928491972403*^9, 
   3.668928560387536*^9}, {3.668928621763188*^9, 3.668928623797504*^9}, {
   3.668970786478415*^9, 3.668970786774432*^9}, {3.669048707520356*^9, 
   3.669048712776091*^9}, {3.669064753155752*^9, 3.66906482337147*^9}, {
   3.6691232055248833`*^9, 3.669123213418497*^9}, {3.669123476387762*^9, 
   3.66912348106777*^9}, {3.669123582249548*^9, 3.6691236088007946`*^9}, 
   3.669123665335294*^9, {3.669123792339117*^9, 3.66912379959313*^9}, 
   3.6691238333671894`*^9, {3.6691238733344593`*^9, 3.669123890088889*^9}, {
   3.669124006321705*^9, 3.6691240428725696`*^9}, {3.6691253754911613`*^9, 
   3.6691254172690344`*^9}, {3.6691255021955833`*^9, 3.669125508653995*^9}, {
   3.6691265559524198`*^9, 3.6691265082521544`*^9}, {3.669138773426424*^9, 
   3.669138898599615*^9}, 3.669138985479178*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"AbsoluteTiming", "[", 
    RowBox[{"Plus", "@@", 
     RowBox[{"Length", "/@", 
      RowBox[{"FindInvariance", "[", 
       RowBox[{
       "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
        RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}]}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
          "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.669065155354356*^9, 3.6690651577851458`*^9}, {
  3.669123222841914*^9, 3.6691232235439153`*^9}, {3.6691235153254304`*^9, 
  3.66912352097264*^9}, {3.6691263927811794`*^9, 3.6691263929241877`*^9}, {
  3.6691264811814885`*^9, 3.669126481399889*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.116761`", ",", "138"}], "}"}]], "Output",
 CellChangeTimes->{{3.669065112158536*^9, 3.669065159460647*^9}, 
   3.6691231888640547`*^9, 3.6691232242771163`*^9, 3.669123455000724*^9, 
   3.6691235810483456`*^9, {3.6691236823393235`*^9, 3.6691237011685567`*^9}, 
   3.6691237685022755`*^9, 3.669123844334008*^9, 3.669123895361698*^9, 
   3.669124070703018*^9, 3.6691254221674433`*^9, 3.669125515377607*^9, 
   3.6691263965653963`*^9, 3.6691264876867*^9, {3.6691265628798323`*^9, 
   3.6691262774624567`*^9}, 3.669126519658547*^9, 3.6691389387873077`*^9, 
   3.6691389934597*^9, 3.66914475216381*^9, 3.66914489931071*^9, 
   3.669145502172255*^9, 3.6700426825438643`*^9, 3.670043184100729*^9, 
   3.670044364334476*^9, 3.670044427589314*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.669065112158536*^9, 3.669065159460647*^9}, 
   3.6691231888640547`*^9, 3.6691232242771163`*^9, 3.669123455000724*^9, 
   3.6691235810483456`*^9, {3.6691236823393235`*^9, 3.6691237011685567`*^9}, 
   3.6691237685022755`*^9, 3.669123844334008*^9, 3.669123895361698*^9, 
   3.669124070703018*^9, 3.6691254221674433`*^9, 3.669125515377607*^9, 
   3.6691263965653963`*^9, 3.6691264876867*^9, {3.6691265628798323`*^9, 
   3.6691262774624567`*^9}, 3.669126519658547*^9, 3.6691389387873077`*^9, 
   3.6691389934597*^9, 3.66914475216381*^9, 3.66914489931071*^9, 
   3.669145502172255*^9, 3.6700426825438643`*^9, 3.670043184100729*^9, 
   3.670044364334476*^9, 3.6700444277163343`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.668663460311492*^9, 3.668663462727518*^9}, {
   3.6689711131500998`*^9, 3.6689711156142406`*^9}, {3.669065176640615*^9, 
   3.669065184112545*^9}, {3.6691232295811257`*^9, 3.669123268518794*^9}, {
   3.6691235541070986`*^9, 3.6691235905643625`*^9}, {3.669123628612829*^9, 
   3.6691236288624296`*^9}, {3.6691238529140234`*^9, 3.669123863896443*^9}, 
   3.6691240650870085`*^9, {3.669125375428761*^9, 3.6691253950701957`*^9}, {
   3.6691254285010543`*^9, 3.669125434085864*^9}, {3.669125522257219*^9, 
   3.669125527654828*^9}, {3.669126484310172*^9, 3.669126524002877*^9}, {
   3.669138946113028*^9, 3.669138961375452*^9}, 3.6691391965025*^9, {
   3.6691392448854513`*^9, 3.669139256925252*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.15017`", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["\[CapitalGamma]", "x"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Psi]H", 
            SubscriptBox["\[CapitalGamma]", 
             SuperscriptBox["x", "2"]]], "-", 
           SubscriptBox["\[Psi]\[CapitalGamma]", 
            SubscriptBox["H", 
             SuperscriptBox["x", "2"]]]}], ")"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          SubscriptBox["\[Psi]H", 
           SubscriptBox["H", 
            SuperscriptBox["x", "2"]]]}], "+", 
         RowBox[{"2", " ", "\[CapitalGamma]", " ", 
          SubscriptBox["\[Psi]H", 
           SubscriptBox["\[CapitalGamma]", 
            SuperscriptBox["x", "2"]]]}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          SubscriptBox["\[Psi]H", 
           SubsuperscriptBox["H", 
            SuperscriptBox["x", "2"], "2"]]}], "+", 
         RowBox[{"2", " ", "\[CapitalGamma]", " ", 
          SubscriptBox["\[Psi]\[CapitalGamma]", 
           SubsuperscriptBox["H", 
            SuperscriptBox["x", "2"], "2"]]}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          SubscriptBox["\[Psi]H", 
           RowBox[{
            SubscriptBox["H", 
             SuperscriptBox["x", "2"]], " ", 
            SubscriptBox["\[CapitalGamma]", 
             SuperscriptBox["x", "2"]]}]]}], "+", 
         RowBox[{"2", " ", "\[CapitalGamma]", " ", 
          SubscriptBox["\[Psi]\[CapitalGamma]", 
           RowBox[{
            SubscriptBox["H", 
             SuperscriptBox["x", "2"]], " ", 
            SubscriptBox["\[CapitalGamma]", 
             SuperscriptBox["x", "2"]]}]]}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          SubscriptBox["\[Psi]H", 
           SubscriptBox["H", 
            SuperscriptBox["x", "2"]]]}], "+", 
         RowBox[{"2", " ", "\[CapitalGamma]", " ", 
          SubscriptBox["\[Psi]\[CapitalGamma]", 
           SubscriptBox["H", 
            SuperscriptBox["x", "2"]]]}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          SubscriptBox["\[Psi]H", 
           SubsuperscriptBox["\[CapitalGamma]", 
            SuperscriptBox["x", "2"], "2"]]}], "+", 
         RowBox[{"2", " ", "\[CapitalGamma]", " ", 
          SubscriptBox["\[Psi]\[CapitalGamma]", 
           SubsuperscriptBox["\[CapitalGamma]", 
            SuperscriptBox["x", "2"], "2"]]}]}], "\[Equal]", "0"}]}], "}"}]}],
     "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6691237517478456`*^9, 3.669123771700281*^9}, 
   3.6691239608234468`*^9, 3.669125366739546*^9, 3.6691254862835555`*^9, 
   3.6691263892169757`*^9, {3.669126793938838*^9, 3.66912629730791*^9}, 
   3.6691270372585077`*^9, {3.669138953984124*^9, 3.669138961595611*^9}, 
   3.669139004243075*^9, 3.6691391971223507`*^9, 3.669139259852214*^9, 
   3.66914475501373*^9, 3.669144901736812*^9, 3.669145504725823*^9, 
   3.6700426908265047`*^9, {3.670043187057315*^9, 3.670043205225685*^9}, 
   3.6700443684040833`*^9, 3.670044430948387*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"H", "*", 
      RowBox[{
       RowBox[{"\[Psi]H", "'"}], "[", "z", "]"}]}], "+", 
     RowBox[{"2", "*", "\[CapitalGamma]", "*", 
      RowBox[{
       RowBox[{"\[Psi]\[CapitalGamma]", "'"}], "[", "z", "]"}]}]}], 
    "\[Equal]", "0"}], ",", 
   RowBox[{"\[Psi]H", "[", "z", "]"}], ",", 
   RowBox[{"{", "z", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.669139279592473*^9, 3.669139345075933*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Psi]H", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "-", 
     FractionBox[
      RowBox[{"2", " ", "\[CapitalGamma]", " ", 
       RowBox[{"\[Psi]\[CapitalGamma]", "[", "z", "]"}]}], "H"]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.669139345553507*^9, 3.669144756031578*^9, 3.669144901819386*^9, 
   3.669145504800067*^9, 3.670042691590049*^9, {3.6700431877207747`*^9, 
   3.670043212067439*^9}, 3.670044370832099*^9, 3.670044431433186*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "H_", ",", "\[CapitalGamma]_", ",", "Hx1_", ",", 
     "Hx2_", ",", "\[CapitalGamma]x1_", ",", "\[CapitalGamma]x2_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]H1", "[", 
     RowBox[{
     "t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", "Hx1", ",", 
      "\[CapitalGamma]x1"}], "]"}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"\[CapitalGamma]", "/", "H"}], "*", 
     RowBox[{"\[Psi]\[CapitalGamma]", "[", 
      RowBox[{
      "t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", "Hx1", ",", "Hx2",
        ",", "\[CapitalGamma]x1", ",", "\[CapitalGamma]x2"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "4", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669139239382856*^9, 3.6691392421545067`*^9}, {
  3.669139399230155*^9, 3.6691395192998857`*^9}, {3.66913957947672*^9, 
  3.6691395969877167`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.751766`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["\[CapitalGamma]", "x"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"H", " ", 
            SubscriptBox["\[Psi]\[CapitalGamma]", 
             SubscriptBox["H", 
              SuperscriptBox["x", "2"]]]}], "+", 
           RowBox[{"2", " ", "\[CapitalGamma]", " ", 
            SubscriptBox["\[Psi]\[CapitalGamma]", 
             SubscriptBox["\[CapitalGamma]", 
              SuperscriptBox["x", "2"]]]}]}], ")"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          SubscriptBox["\[Psi]\[CapitalGamma]", 
           SubscriptBox["H", 
            SuperscriptBox["x", "2"]]]}], "+", 
         RowBox[{"2", " ", "\[CapitalGamma]", " ", 
          SubscriptBox["\[Psi]\[CapitalGamma]", 
           SubscriptBox["\[CapitalGamma]", 
            SuperscriptBox["x", "2"]]]}]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.669139524486294*^9, {3.66913958024909*^9, 3.669139597841587*^9}, 
   3.669144758879298*^9, 3.669144904607422*^9, 3.669145507644969*^9, 
   3.670042695725563*^9, 3.6700432212955523`*^9, 3.670044374972684*^9, 
   3.6700444348852177`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.15554`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["H", "2"], " ", 
         SubscriptBox["\[Psi]H1", 
          SubscriptBox["H", "x"]]}], "+", 
        RowBox[{"6", " ", "\[CapitalGamma]", " ", 
         SubscriptBox["H", "x"], " ", 
         SubscriptBox["\[Psi]\[CapitalGamma]", 
          SubscriptBox["H", 
           SuperscriptBox["x", "2"]]]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["\[CapitalGamma]", "x"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "H", " ", 
            SubscriptBox["\[Psi]\[CapitalGamma]", 
             SubscriptBox["H", 
              SuperscriptBox["x", "2"]]]}], "+", 
           RowBox[{"\[CapitalGamma]", " ", 
            SubscriptBox["\[Psi]\[CapitalGamma]", 
             SubscriptBox["\[CapitalGamma]", 
              SuperscriptBox["x", "2"]]]}]}], ")"}]}]}], "\[Equal]", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.669139524486294*^9, {3.66913958024909*^9, 3.669139597841587*^9}, 
   3.669144758879298*^9, 3.669144904607422*^9, 3.669145507644969*^9, 
   3.670042695725563*^9, 3.6700432212955523`*^9, 3.670044374972684*^9, 
   3.670044435043396*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["H", "2"], " ", 
        SubscriptBox["\[Psi]H1", 
         SubscriptBox["H", "x"]]}], "+", 
       RowBox[{"6", " ", "\[CapitalGamma]", " ", 
        SubscriptBox["H", "x"], " ", 
        SubscriptBox["\[Psi]\[CapitalGamma]", 
         SubscriptBox["H", 
          SuperscriptBox["x", "2"]]]}], "+", 
       RowBox[{"2", " ", "\[CapitalGamma]", " ", 
        SubscriptBox["\[CapitalGamma]", "x"], " ", 
        SubscriptBox["\[Psi]\[CapitalGamma]", 
         SubscriptBox["\[CapitalGamma]", 
          SuperscriptBox["x", "2"]]]}]}], "\[Equal]", 
      RowBox[{"6", " ", "H", " ", 
       SubscriptBox["\[CapitalGamma]", "x"], " ", 
       SubscriptBox["\[Psi]\[CapitalGamma]", 
        SubscriptBox["H", 
         SuperscriptBox["x", "2"]]]}]}], "/.", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          SubscriptBox["\[Psi]\[CapitalGamma]", 
           SubscriptBox["H", 
            SuperscriptBox["x", "2"]]]}], "+", 
         RowBox[{"2", " ", "\[CapitalGamma]", " ", 
          SubscriptBox["\[Psi]\[CapitalGamma]", 
           SubscriptBox["\[CapitalGamma]", 
            SuperscriptBox["x", "2"]]]}]}], "\[Equal]", "0"}], ",", 
       SubscriptBox["\[Psi]\[CapitalGamma]", 
        SubscriptBox["H", 
         SuperscriptBox["x", "2"]]]}], "]"}]}], "]"}], ",", 
   SubscriptBox["\[Psi]\[CapitalGamma]", 
    SubscriptBox["\[CapitalGamma]", 
     SuperscriptBox["x", "2"]]]}], "]"}]], "Input",
 CellChangeTimes->{{3.6691396269240503`*^9, 3.6691396437316713`*^9}, {
  3.669139674778946*^9, 3.66913967992985*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Psi]\[CapitalGamma]", 
     SubscriptBox["\[CapitalGamma]", 
      SuperscriptBox["x", "2"]]], "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["H", "3"], " ", 
      SubscriptBox["\[Psi]H1", 
       SubscriptBox["H", "x"]]}], 
     RowBox[{"2", " ", "\[CapitalGamma]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", "\[CapitalGamma]", " ", 
         SubscriptBox["H", "x"]}], "-", 
        RowBox[{"7", " ", "H", " ", 
         SubscriptBox["\[CapitalGamma]", "x"]}]}], ")"}]}]]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.6691396344847927`*^9, 3.6691396442497168`*^9}, 
   3.6691396803055277`*^9, 3.6691447591590633`*^9, 3.669144905092359*^9, 
   3.6691455079115562`*^9, 3.670042697172414*^9, 3.670044376943304*^9, 
   3.670044435110447*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]\[CapitalGamma]", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "H_", ",", "\[CapitalGamma]_", ",", "Hx1_", ",", 
     "Hx2_", ",", "\[CapitalGamma]x1_", ",", "\[CapitalGamma]x2_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]\[CapitalGamma]1", "[", 
     RowBox[{
     "t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", "Hx1", ",", "Hx2", 
      ",", "\[CapitalGamma]x1"}], "]"}], "+", 
    RowBox[{"\[CapitalGamma]x2", "*", 
     FractionBox[
      RowBox[{
       SuperscriptBox["H", "3"], " ", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[Psi]H1", "[", 
          RowBox[{
          "t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", "Hx1", ",", 
           "\[CapitalGamma]x1"}], "]"}], ",", "Hx1"}], "]"}]}], 
      RowBox[{"2", " ", "\[CapitalGamma]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", "\[CapitalGamma]", " ", "Hx1"}], "-", 
         RowBox[{"7", " ", "H", " ", "\[CapitalGamma]x1"}]}], ")"}]}]]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6691396979059467`*^9, 3.669139805257812*^9}, {
   3.669139835594256*^9, 3.6691398361134157`*^9}, 3.669139920209442*^9, 
   3.669139958466538*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14.869431`", ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[CapitalGamma]", " ", 
         SubscriptBox["\[CapitalGamma]", "x"], " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{
             SuperscriptBox["H", "2"], " ", 
             SubscriptBox["\[Psi]H1", 
              SubscriptBox["H", "x"]]}], 
            RowBox[{
             RowBox[{"6", " ", "\[CapitalGamma]", " ", 
              SubscriptBox["H", "x"]}], "-", 
             RowBox[{"7", " ", "H", " ", 
              SubscriptBox["\[CapitalGamma]", "x"]}]}]], "+", 
           SubscriptBox["\[Psi]\[CapitalGamma]1", 
            SubscriptBox["H", 
             SuperscriptBox["x", "2"]]]}], ")"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", "\[CapitalGamma]", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{
             SuperscriptBox["H", "2"], " ", 
             SubscriptBox["\[Psi]H1", 
              SubscriptBox["H", "x"]]}], 
            RowBox[{
             RowBox[{"6", " ", "\[CapitalGamma]", " ", 
              SubscriptBox["H", "x"]}], "-", 
             RowBox[{"7", " ", "H", " ", 
              SubscriptBox["\[CapitalGamma]", "x"]}]}]], "+", 
           SubscriptBox["\[Psi]\[CapitalGamma]1", 
            SubscriptBox["H", 
             SuperscriptBox["x", "2"]]]}], ")"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], " ", 
         SuperscriptBox["H", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{
             SuperscriptBox["H", "2"], " ", 
             SubscriptBox["\[Psi]H1", 
              SubscriptBox["H", "x"]]}], 
            RowBox[{
             RowBox[{
              RowBox[{"-", "6"}], " ", "\[CapitalGamma]", " ", 
              SubscriptBox["H", "x"]}], "+", 
             RowBox[{"7", " ", "H", " ", 
              SubscriptBox["\[CapitalGamma]", "x"]}]}]], "-", 
           SubscriptBox["\[Psi]\[CapitalGamma]1", 
            SubscriptBox["H", 
             SuperscriptBox["x", "2"]]]}], ")"}]}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.669139834325858*^9, 3.669139891577379*^9, 
  3.6691399398195457`*^9, 3.669139976601018*^9, 3.669144774793722*^9, 
  3.669144920658094*^9, 3.6691455235896673`*^9, 3.670042712866366*^9, 
  3.67004439333375*^9, 3.670044451826592*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["H", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["H", "2"], " ", 
         SubscriptBox["\[Psi]H1", 
          SubscriptBox["H", "x"]]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", "\[CapitalGamma]", " ", 
          SubscriptBox["H", "x"]}], "+", 
         RowBox[{"7", " ", "H", " ", 
          SubscriptBox["\[CapitalGamma]", "x"]}]}]], "-", 
       SubscriptBox["\[Psi]\[CapitalGamma]1", 
        SubscriptBox["H", 
         SuperscriptBox["x", "2"]]]}], ")"}]}], "\[Equal]", "0"}], ",", 
   SubscriptBox["\[Psi]\[CapitalGamma]1", 
    SubscriptBox["H", 
     SuperscriptBox["x", "2"]]]}], "]"}]], "Input",
 CellChangeTimes->{{3.6691400081058397`*^9, 3.669140021096985*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Psi]\[CapitalGamma]1", 
     SubscriptBox["H", 
      SuperscriptBox["x", "2"]]], "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["H", "2"], " ", 
      SubscriptBox["\[Psi]H1", 
       SubscriptBox["H", "x"]]}], 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[CapitalGamma]", " ", 
       SubscriptBox["H", "x"]}], "+", 
      RowBox[{"7", " ", "H", " ", 
       SubscriptBox["\[CapitalGamma]", "x"]}]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.669140021974965*^9, 3.669144774915327*^9, 
  3.669144920716975*^9, 3.669145523629849*^9, 3.67004271293577*^9, 
  3.670044451892776*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]\[CapitalGamma]1", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "H_", ",", "\[CapitalGamma]_", ",", "Hx1_", ",", 
     "Hx2_", ",", "\[CapitalGamma]x1_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]\[CapitalGamma]2", "[", 
     RowBox[{
     "t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", "Hx1", ",", 
      "\[CapitalGamma]x1"}], "]"}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["H", "2"], " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"\[Psi]H1", "[", 
         RowBox[{
         "t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", "Hx1", ",", 
          "\[CapitalGamma]x1"}], "]"}], ",", "Hx1"}], "]"}]}], 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[CapitalGamma]", " ", "Hx1"}], "+", 
      RowBox[{"7", " ", "H", " ", "\[CapitalGamma]x1"}]}]]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669140044208267*^9, 3.669140132767818*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"27.203145`", ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{
          SubscriptBox["\[CapitalGamma]", "x"], " ", 
          SubscriptBox["\[Psi]H1", 
           SubscriptBox["H", "x"]]}], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "6"}], " ", "\[CapitalGamma]", " ", 
           SubscriptBox["H", "x"]}], "+", 
          RowBox[{"7", " ", "H", " ", 
           SubscriptBox["\[CapitalGamma]", "x"]}]}]], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        FractionBox[
         SubscriptBox["\[Psi]H1", 
          SubscriptBox["H", "x"]], 
         RowBox[{
          RowBox[{"6", " ", "\[CapitalGamma]", " ", 
           SubscriptBox["H", "x"]}], "-", 
          RowBox[{"7", " ", "H", " ", 
           SubscriptBox["\[CapitalGamma]", "x"]}]}]], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        SubscriptBox["\[Psi]H1", 
         SubsuperscriptBox["H", "x", "2"]], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.669140174974823*^9, 3.6691448035825777`*^9, 
  3.6691449493487673`*^9, 3.669145552408884*^9, 3.67004274272822*^9, 
  3.670044479129963*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H1", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "H_", ",", "\[CapitalGamma]_", ",", "Hx1_", ",", 
     "\[CapitalGamma]x1_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H2", "[", 
    RowBox[{
    "t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", 
     "\[CapitalGamma]x1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669140195254422*^9, 3.669140237528763*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.982997`", ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Psi]H2", 
        SubsuperscriptBox["\[CapitalGamma]", "x", "2"]], "\[Equal]", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6691402479558687`*^9, 3.6691448046779213`*^9, 
  3.66914495045887*^9, 3.669145553474362*^9, 3.6700427670659924`*^9, 
  3.6700444801529293`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H2", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "H_", ",", "\[CapitalGamma]_", ",", 
     "\[CapitalGamma]x1_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]H3", "[", 
     RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]"}], "]"}], "+", 
    RowBox[{"\[CapitalGamma]x1", "*", 
     RowBox[{"\[Psi]H4", "[", 
      RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669140255467581*^9, 3.669140307207922*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.521527`", ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["\[CapitalGamma]", "x"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "H"}], " ", 
            SubscriptBox["\[Psi]\[CapitalGamma]2", 
             SubscriptBox["H", "x"]]}], "-", 
           RowBox[{"2", " ", "\[CapitalGamma]", " ", 
            SubscriptBox["\[Psi]\[CapitalGamma]2", 
             SubscriptBox["\[CapitalGamma]", "x"]]}], "+", 
           RowBox[{"H", " ", 
            RowBox[{"\[Psi]H4", "[", 
             RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]"}], 
             "]"}]}]}], ")"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"\[Psi]H4", "[", 
          RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]"}], "]"}]}], 
        "\[Equal]", 
        RowBox[{
         RowBox[{"H", " ", 
          SubscriptBox["\[Psi]\[CapitalGamma]2", 
           SubscriptBox["H", "x"]]}], "+", 
         RowBox[{"2", " ", "\[CapitalGamma]", " ", 
          SubscriptBox["\[Psi]\[CapitalGamma]2", 
           SubscriptBox["\[CapitalGamma]", "x"]]}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          SubscriptBox["\[Psi]\[CapitalGamma]2", 
           SubscriptBox["H", "x"]]}], "+", 
         RowBox[{"2", " ", "\[CapitalGamma]", " ", 
          SubscriptBox["\[Psi]\[CapitalGamma]2", 
           SubscriptBox["\[CapitalGamma]", "x"]]}], "+", 
         RowBox[{"H", " ", 
          RowBox[{"\[Psi]H4", "[", 
           RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]"}], 
           "]"}]}]}], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.669140299680894*^9, 3.6691403081814547`*^9}, 
   3.669144806401821*^9, 3.669144952182497*^9, 3.669145555287354*^9, 
   3.670042769214684*^9, 3.670044848404962*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"H", " ", 
        SubscriptBox["\[Psi]\[CapitalGamma]2", 
         SubscriptBox["H", "x"]]}], "+", 
       RowBox[{"2", " ", "\[CapitalGamma]", " ", 
        SubscriptBox["\[Psi]\[CapitalGamma]2", 
         SubscriptBox["\[CapitalGamma]", "x"]]}]}], "\[Equal]", 
      RowBox[{"H", " ", 
       RowBox[{"\[Psi]H4", "[", 
        RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]"}], "]"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"H", " ", 
        SubscriptBox["\[Psi]\[CapitalGamma]2", 
         SubscriptBox["H", "x"]]}], "+", 
       RowBox[{"2", " ", "\[CapitalGamma]", " ", 
        SubscriptBox["\[Psi]\[CapitalGamma]2", 
         SubscriptBox["\[CapitalGamma]", "x"]]}], "+", 
       RowBox[{"H", " ", 
        RowBox[{"\[Psi]H4", "[", 
         RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]"}], "]"}]}]}],
       "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Psi]H4", "[", 
      RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]"}], "]"}], ",", 
     SubscriptBox["\[Psi]\[CapitalGamma]2", 
      SubscriptBox["H", "x"]]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.669140347801135*^9, 3.669140369709639*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]H4", "[", 
      RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]"}], "]"}], 
     "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["\[Psi]\[CapitalGamma]2", 
      SubscriptBox["H", "x"]], "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "\[CapitalGamma]", " ", 
        SubscriptBox["\[Psi]\[CapitalGamma]2", 
         SubscriptBox["\[CapitalGamma]", "x"]]}], "H"]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.669140370247159*^9, 3.669144806444354*^9, 
  3.6691449522323523`*^9, 3.6691455553425713`*^9, 3.670042770062338*^9, 
  3.670044850043372*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H4", "[", 
    RowBox[{"t_", ",", "x_", ",", "H_", ",", "\[CapitalGamma]_"}], "]"}], ":=",
    "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "5", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669140379653331*^9, 3.669140408637971*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.728344`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["H", "2"], " ", 
         SubscriptBox["\[Psi]H3", "H"]}], "+", 
        RowBox[{"6", " ", "\[CapitalGamma]", " ", 
         SubscriptBox["H", "x"], " ", 
         SubscriptBox["\[Psi]\[CapitalGamma]2", 
          SubscriptBox["H", "x"]]}], "+", 
        RowBox[{"2", " ", "\[CapitalGamma]", " ", 
         SubscriptBox["\[CapitalGamma]", "x"], " ", 
         SubscriptBox["\[Psi]\[CapitalGamma]2", 
          SubscriptBox["\[CapitalGamma]", "x"]]}], "+", 
        RowBox[{"2", " ", "\[CapitalGamma]", " ", 
         RowBox[{"\[Psi]\[CapitalGamma]2", "[", 
          RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", 
           SubscriptBox["H", "x"], ",", 
           SubscriptBox["\[CapitalGamma]", "x"]}], "]"}]}]}], "\[Equal]", 
       RowBox[{"6", " ", "H", " ", 
        SubscriptBox["\[CapitalGamma]", "x"], " ", 
        SubscriptBox["\[Psi]\[CapitalGamma]2", 
         SubscriptBox["H", "x"]]}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.66914039334958*^9, 3.669140409682341*^9}, 
   3.669144807209605*^9, 3.669144952993487*^9, 3.669145556101686*^9, 
   3.670042771821554*^9, 3.670044851172456*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["H", "2"], " ", 
        SubscriptBox["\[Psi]H3", "H"]}], "+", 
       RowBox[{"2", " ", "\[CapitalGamma]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SubscriptBox["H", "x"], " ", 
           SubscriptBox["\[Psi]\[CapitalGamma]2", 
            SubscriptBox["H", "x"]]}], "+", 
          RowBox[{
           SubscriptBox["\[CapitalGamma]", "x"], " ", 
           SubscriptBox["\[Psi]\[CapitalGamma]2", 
            SubscriptBox["\[CapitalGamma]", "x"]]}], "+", 
          RowBox[{"\[Psi]\[CapitalGamma]2", "[", 
           RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", 
            SubscriptBox["H", "x"], ",", 
            SubscriptBox["\[CapitalGamma]", "x"]}], "]"}]}], ")"}]}]}], 
      "\[Equal]", 
      RowBox[{"6", " ", "H", " ", 
       SubscriptBox["\[CapitalGamma]", "x"], " ", 
       SubscriptBox["\[Psi]\[CapitalGamma]2", 
        SubscriptBox["H", "x"]]}]}], "/.", 
     RowBox[{
      SubscriptBox["\[Psi]\[CapitalGamma]2", 
       SubscriptBox["H", "x"]], "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "\[CapitalGamma]", " ", 
         SubscriptBox["\[Psi]\[CapitalGamma]2", 
          SubscriptBox["\[CapitalGamma]", "x"]]}], "H"]}]}]}], "]"}], ",", 
   SubscriptBox["\[Psi]\[CapitalGamma]2", 
    SubscriptBox["\[CapitalGamma]", "x"]]}], "]"}]], "Input",
 CellChangeTimes->{{3.669140430414041*^9, 3.6691404376778297`*^9}, {
  3.669140584605082*^9, 3.669140592013363*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Psi]\[CapitalGamma]2", 
     SubscriptBox["\[CapitalGamma]", "x"]], "\[Rule]", 
    FractionBox[
     RowBox[{"H", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["H", "2"], " ", 
         SubscriptBox["\[Psi]H3", "H"]}], "+", 
        RowBox[{"2", " ", "\[CapitalGamma]", " ", 
         RowBox[{"\[Psi]\[CapitalGamma]2", "[", 
          RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", 
           SubscriptBox["H", "x"], ",", 
           SubscriptBox["\[CapitalGamma]", "x"]}], "]"}]}]}], ")"}]}], 
     RowBox[{"2", " ", "\[CapitalGamma]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", "\[CapitalGamma]", " ", 
         SubscriptBox["H", "x"]}], "-", 
        RowBox[{"7", " ", "H", " ", 
         SubscriptBox["\[CapitalGamma]", "x"]}]}], ")"}]}]]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.669140431379361*^9, 3.669140438243452*^9}, 
   3.669140592580415*^9, 3.669144807272333*^9, 3.669144953057266*^9, 
   3.66914555615974*^9, 3.670042773041566*^9, 3.6700448520011663`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]\[CapitalGamma]2", "'"}], "[", "z", "]"}], "==", 
    FractionBox[
     RowBox[{"H", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["H", "2"], " ", 
         SubscriptBox["\[Psi]H3", "H"]}], "+", 
        RowBox[{"2", " ", "\[CapitalGamma]", " ", 
         RowBox[{"\[Psi]\[CapitalGamma]2", "[", "z", "]"}]}]}], ")"}]}], 
     RowBox[{"2", " ", "\[CapitalGamma]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", "\[CapitalGamma]", " ", 
         SubscriptBox["H", "x"]}], "-", 
        RowBox[{"7", " ", "H", " ", "z"}]}], ")"}]}]]}], ",", 
   RowBox[{"\[Psi]\[CapitalGamma]2", "[", "z", "]"}], ",", "z"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.669140603944436*^9, 3.669140646124516*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Psi]\[CapitalGamma]2", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{"C", "[", "1", "]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "7"}], " ", "H", " ", "z"}], "+", 
         RowBox[{"6", " ", "\[CapitalGamma]", " ", 
          SubscriptBox["H", "x"]}]}], ")"}], 
       RowBox[{"1", "/", "7"}]]], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["H", "2"], " ", 
       SubscriptBox["\[Psi]H3", "H"]}], 
      RowBox[{"2", " ", "\[CapitalGamma]"}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.669140648077697*^9, 3.669144807491632*^9, 
  3.669144953109058*^9, 3.6691455562083387`*^9, 3.6700427742568398`*^9, 
  3.670044853201356*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]\[CapitalGamma]2", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "H_", ",", "\[CapitalGamma]_", ",", "Hx1_", ",", 
     "\[CapitalGamma]x1_"}], "]"}], ":=", 
   RowBox[{
    FractionBox[
     RowBox[{"\[Psi]\[CapitalGamma]3", "[", 
      RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", "Hx1"}], 
      "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "7"}], " ", "H", " ", "\[CapitalGamma]x1"}], "+", 
        RowBox[{"6", " ", "\[CapitalGamma]", " ", "Hx1"}]}], ")"}], 
      RowBox[{"1", "/", "7"}]]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["H", "2"], " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"\[Psi]H3", "[", 
         RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]"}], "]"}], 
        ",", "H"}], "]"}]}], 
     RowBox[{"2", " ", "\[CapitalGamma]"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindEquations", "[", 
  RowBox[{
  "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
   RowBox[{"excluded", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"H", ">", "0"}], "&&", 
     RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.669140674509062*^9, 3.6691407658201523`*^9}, {
   3.669140865485086*^9, 3.669140879307848*^9}, {3.6691409270996532`*^9, 
   3.669140929906752*^9}, {3.6691448771350727`*^9, 3.669144883063055*^9}, {
   3.669145006190106*^9, 3.669145008830634*^9}, 3.6700433245954027`*^9, {
   3.670043436065421*^9, 3.670043436256097*^9}, {3.670043517256678*^9, 
   3.6700435645197077`*^9}, {3.6700448782553673`*^9, 3.6700448819066973`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", "\[CapitalGamma]", " ", 
            RowBox[{"\[Psi]\[CapitalGamma]3", "[", 
             RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", 
              SubscriptBox["H", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]]}], "]"}]}], "+", 
           RowBox[{"7", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"6", " ", "\[CapitalGamma]", " ", 
               SubscriptBox["H", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]]}], "-", 
              RowBox[{"7", " ", "H", " ", 
               SubscriptBox["\[CapitalGamma]", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["\[Psi]\[CapitalGamma]3", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", 
              SubscriptBox["H", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]]}], "]"}]}]}], ")"}]}], ")"}], 
       "/", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", "\[CapitalGamma]", " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]]}], "-", 
          RowBox[{"7", " ", "H", " ", 
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]]}]}], ")"}], 
        RowBox[{"1", "/", "7"}]]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", "\[CapitalGamma]", " ", 
          RowBox[{"\[Psi]\[CapitalGamma]3", "[", 
           RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}]]}], "]"}]}], "+", 
         RowBox[{"7", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "\[CapitalGamma]", " ", 
             SubscriptBox["H", 
              RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]]}], "-", 
            RowBox[{"7", " ", "H", " ", 
             SubscriptBox["\[CapitalGamma]", 
              RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["\[Psi]\[CapitalGamma]3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", 
            SubscriptBox["H", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}]]}], "]"}]}]}], ")"}], "/", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", "\[CapitalGamma]", " ", 
           SubscriptBox["H", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]]}], "-", 
          RowBox[{"7", " ", "H", " ", 
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]]}]}], ")"}], 
        RowBox[{"1", "/", "7"}]]}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        SubscriptBox["H", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2"}], "}"}]]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}]]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.6691450511720877`*^9, 3.669145598266374*^9, 3.6700428017560472`*^9, 
   3.670043326833749*^9, 3.670043437542942*^9, {3.670043518007842*^9, 
   3.670043566005622*^9}, {3.670044872278698*^9, 3.6700448989926434`*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Start", " ", "again", " ", 
   RowBox[{"here", "!"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.6700436043617077`*^9, 3.670043609982535*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Since", " ", "\[Psi]\[CapitalGamma]3", " ", 
     RowBox[{"doesn", "'"}], "t", " ", "depend", " ", "on", " ", 
     "\[CapitalGamma]x"}], ",", " ", 
    RowBox[{
     RowBox[{
     "the", " ", "term", " ", "in", " ", "parenthesis", " ", "must", " ", 
      "vanish", " ", "and", " ", "\[Psi]\[CapitalGamma]3"}], "=", "0."}]}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"\[Psi]\[CapitalGamma]3", "[", 
    RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", 
     SubscriptBox["H", "x"]}], "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{"H", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", "\[CapitalGamma]", " ", 
         SubscriptBox["H", "x"]}], "-", 
        RowBox[{"7", " ", "H", " ", 
         SubscriptBox["\[CapitalGamma]", "x"]}]}], ")"}], 
      RowBox[{"1", "/", "7"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"H", " ", 
        SubscriptBox["\[Psi]H3", "H"]}], "+", 
       RowBox[{"\[CapitalGamma]", " ", 
        SubscriptBox["\[Psi]H3", "\[CapitalGamma]"]}]}], ")"}]}], 
    "\[CapitalGamma]"]}]}]], "Input",
 CellChangeTimes->{{3.6691452129654913`*^9, 3.669145267076363*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]\[CapitalGamma]3", "[", 
   RowBox[{"t", ",", "x", ",", "H", ",", "\[CapitalGamma]", ",", 
    SubscriptBox["H", "x"]}], "]"}], "\[Rule]", 
  FractionBox[
   RowBox[{"H", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"6", " ", "\[CapitalGamma]", " ", 
        SubscriptBox["H", "x"]}], "-", 
       RowBox[{"7", " ", "H", " ", 
        SubscriptBox["\[CapitalGamma]", "x"]}]}], ")"}], 
     RowBox[{"1", "/", "7"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"H", " ", 
       SubscriptBox["\[Psi]H3", "H"]}], "+", 
      RowBox[{"\[CapitalGamma]", " ", 
       SubscriptBox["\[Psi]H3", "\[CapitalGamma]"]}]}], ")"}]}], 
   "\[CapitalGamma]"]}]], "Output",
 CellChangeTimes->{3.6691455984944572`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]\[CapitalGamma]3", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "H_", ",", "\[CapitalGamma]_", ",", " ", "Hx_"}], 
    "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H3", "[", 
    RowBox[{"t_", ",", "x_", ",", "H_", ",", "\[CapitalGamma]_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H5", "[", 
    RowBox[{"\[CapitalGamma]", "/", "H"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669145290824226*^9, 3.6691453470136557`*^9}, {
  3.669145490300247*^9, 3.669145490682762*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.053709`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Psi]H5", 
        FractionBox[
         SuperscriptBox["\[CapitalGamma]", "2"], 
         SuperscriptBox["H", "2"]]], "\[Equal]", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.669145347712063*^9, 3.669145598628067*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H5", "[", "z_", "]"}], ":=", 
   RowBox[{"\[Psi]H0", "+", 
    RowBox[{"2", "*", "\[Psi]\[CapitalGamma]0", "*", "z"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalLambda]1", "[", 
  RowBox[{"t", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalLambda]2", "[", 
  RowBox[{"t", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669145354154707*^9, 3.669145407524922*^9}, {
  3.6691454496107883`*^9, 3.669145470666772*^9}}],

Cell[BoxData["\[Psi]H0"], "Output",
 CellChangeTimes->{{3.669145373150506*^9, 3.669145407961956*^9}, {
   3.669145452040573*^9, 3.669145471144034*^9}, 3.669145598667426*^9}],

Cell[BoxData["\[Psi]\[CapitalGamma]0"], "Output",
 CellChangeTimes->{{3.669145373150506*^9, 3.669145407961956*^9}, {
   3.669145452040573*^9, 3.669145471144034*^9}, 3.669145598668109*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.669145373150506*^9, 3.669145407961956*^9}, {
   3.669145452040573*^9, 3.669145471144034*^9}, 3.669145598689927*^9}]
}, Open  ]]
},
WindowSize->{755, 637},
WindowMargins->{{Automatic, 15}, {Automatic, 4}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 265, 4, 32, "Input"],
Cell[826, 26, 6524, 169, 297, "Input"],
Cell[CellGroupData[{
Cell[7375, 199, 1672, 42, 187, "Input"],
Cell[9050, 243, 779, 12, 32, "Output"],
Cell[9832, 257, 1479, 36, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11348, 298, 2117, 48, 121, "Input"],
Cell[13468, 348, 3304, 82, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16809, 435, 490, 14, 32, "Input"],
Cell[17302, 451, 559, 14, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17898, 470, 3681, 97, 297, "Input"],
Cell[21582, 569, 1352, 35, 42, "Output"],
Cell[22937, 606, 1337, 35, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24311, 646, 1741, 45, 74, "Input"],
Cell[26055, 693, 865, 23, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26957, 721, 2390, 62, 221, "Input"],
Cell[29350, 785, 2543, 66, 114, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31930, 856, 896, 26, 67, "Input"],
Cell[32829, 884, 700, 20, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33566, 909, 1924, 52, 174, "Input"],
Cell[35493, 963, 1249, 36, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36779, 1004, 1382, 37, 121, "Input"],
Cell[38164, 1043, 448, 12, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38649, 1060, 1501, 40, 121, "Input"],
Cell[40153, 1102, 1978, 50, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42168, 1157, 1322, 35, 59, "Input"],
Cell[43493, 1194, 691, 19, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44221, 1218, 1203, 32, 121, "Input"],
Cell[45427, 1252, 1327, 30, 84, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46791, 1287, 1639, 41, 147, "Input"],
Cell[48433, 1330, 1136, 28, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49606, 1363, 843, 23, 65, "Input"],
Cell[50452, 1388, 815, 23, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51304, 1416, 2089, 52, 157, "Input"],
Cell[53396, 1470, 4607, 123, 158, "Output"]
}, Open  ]],
Cell[58018, 1596, 192, 4, 32, "Input"],
Cell[CellGroupData[{
Cell[58235, 1604, 1251, 33, 106, "Input"],
Cell[59489, 1639, 780, 22, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60306, 1666, 1144, 30, 121, "Input"],
Cell[61453, 1698, 394, 12, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61884, 1715, 722, 16, 99, "Input"],
Cell[62609, 1733, 173, 2, 32, "Output"],
Cell[62785, 1737, 187, 2, 32, "Output"],
Cell[62975, 1741, 211, 4, 32, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
