(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     31632,        919]
NotebookOptionsPosition[     30127,        863]
NotebookOutlinePosition[     30465,        878]
CellTagsIndexPosition[     30422,        875]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input",
 CellChangeTimes->{{3.665859232344759*^9, 3.665859236735454*^9}, {
  3.665863815026243*^9, 3.665863849178424*^9}, {3.665863882380316*^9, 
  3.665863929521386*^9}, {3.665899891044674*^9, 3.66589989242861*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"PDE", " ", "we", " ", "seek", " ", "symmetries", " ", 
    RowBox[{"of", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], "+", 
      RowBox[{"Div", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"1", "/", "3"}], "*", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], "^", "3"}], "*", 
          RowBox[{"Grad", "[", 
           RowBox[{
            RowBox[{"Laplacian", "[", 
             RowBox[{
              RowBox[{"H", "[", 
               RowBox[{"t", ",", "x"}], "]"}], ",", 
              RowBox[{"{", "x", "}"}]}], "]"}], ",", 
            RowBox[{"{", "x", "}"}]}], "]"}]}], "-", 
         RowBox[{
          RowBox[{"1", "/", "2"}], "*", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], "^", "2"}], "*", 
          RowBox[{"Grad", "[", 
           RowBox[{
            RowBox[{"H", "[", 
             RowBox[{"t", ",", "x"}], "]"}], ",", 
            RowBox[{"{", "x", "}"}]}], "]"}]}]}], ",", 
        RowBox[{"{", "x", "}"}]}], "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{"\[Psi]H", "[", 
      RowBox[{"t", ",", "x", ",", 
       RowBox[{"H", "[", 
        RowBox[{"t", ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "3"}], "}"}]}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "4"}], "}"}]}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "5"}], "}"}]}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "6"}], "}"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "\[CapitalLambda]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", "\[CapitalDelta]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x"}], "}"}], ",", 
       RowBox[{"{", "H", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"1", ",", "0"}], "]"}], "[", "H", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665859055545368*^9, 3.665859056670993*^9}, 
   3.665859222359338*^9, {3.6658595332618227`*^9, 3.665859535110145*^9}, {
   3.665859711964427*^9, 3.665859713110396*^9}, {3.665860496681065*^9, 
   3.6658605636404743`*^9}, {3.665860875037993*^9, 3.665860881549271*^9}, {
   3.665861046773204*^9, 3.665861049549117*^9}, {3.665861674569313*^9, 
   3.6658616967593813`*^9}, {3.6658620374299707`*^9, 3.665862049470551*^9}, {
   3.6658621101506977`*^9, 3.6658621268486853`*^9}, 3.665862225420937*^9, {
   3.665867355970107*^9, 3.6658674061107483`*^9}, {3.665867527086009*^9, 
   3.66586757559233*^9}, {3.66589959391077*^9, 3.6658996402035427`*^9}, {
   3.6684740041232986`*^9, 3.668474004298764*^9}, {3.668928491972403*^9, 
   3.668928560387536*^9}, {3.668928621763188*^9, 3.668928623797504*^9}, {
   3.668970786478415*^9, 3.668970786774432*^9}, {3.669048707520356*^9, 
   3.669048712776091*^9}, {3.669064753155752*^9, 3.66906482337147*^9}, {
   3.6691232055248833`*^9, 3.669123213418497*^9}, {3.669123476387762*^9, 
   3.66912348106777*^9}, {3.669123582249548*^9, 3.6691236088007946`*^9}, 
   3.669123665335294*^9, {3.669123792339117*^9, 3.66912379959313*^9}, 
   3.6691238333671894`*^9, {3.6691238733344593`*^9, 3.669123890088889*^9}, {
   3.669124006321705*^9, 3.6691240428725696`*^9}, {3.6691253754911613`*^9, 
   3.6691254172690344`*^9}, {3.6691255021955833`*^9, 3.669125508653995*^9}, {
   3.6691265559524198`*^9, 3.6691265082521544`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"AbsoluteTiming", "[", 
    RowBox[{"Plus", "@@", 
     RowBox[{"Length", "/@", 
      RowBox[{"FindInvariance", "[", 
       RowBox[{
       "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
        RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}]}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
          "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.669065155354356*^9, 3.6690651577851458`*^9}, {
  3.669123222841914*^9, 3.6691232235439153`*^9}, {3.6691235153254304`*^9, 
  3.66912352097264*^9}, {3.6691263927811794`*^9, 3.6691263929241877`*^9}, {
  3.6691264811814885`*^9, 3.669126481399889*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.690279`", ",", "990"}], "}"}]], "Output",
 CellChangeTimes->{{3.669065112158536*^9, 3.669065159460647*^9}, 
   3.6691231888640547`*^9, 3.6691232242771163`*^9, 3.669123455000724*^9, 
   3.6691235810483456`*^9, {3.6691236823393235`*^9, 3.6691237011685567`*^9}, 
   3.6691237685022755`*^9, 3.669123844334008*^9, 3.669123895361698*^9, 
   3.669124070703018*^9, 3.6691254221674433`*^9, 3.669125515377607*^9, 
   3.6691263965653963`*^9, 3.6691264876867*^9, {3.6691265628798323`*^9, 
   3.6691262774624567`*^9}, 3.669126519658547*^9, {3.6691387393275642`*^9, 
   3.669138756066963*^9}, 3.6700426519460297`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "7"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "9"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.669065112158536*^9, 3.669065159460647*^9}, 
   3.6691231888640547`*^9, 3.6691232242771163`*^9, 3.669123455000724*^9, 
   3.6691235810483456`*^9, {3.6691236823393235`*^9, 3.6691237011685567`*^9}, 
   3.6691237685022755`*^9, 3.669123844334008*^9, 3.669123895361698*^9, 
   3.669124070703018*^9, 3.6691254221674433`*^9, 3.669125515377607*^9, 
   3.6691263965653963`*^9, 3.6691264876867*^9, {3.6691265628798323`*^9, 
   3.6691262774624567`*^9}, 3.669126519658547*^9, {3.6691387393275642`*^9, 
   3.669138756066963*^9}, 3.670042657141837*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "3"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "4"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "5"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "6"}], "}"}]}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.668663460311492*^9, 3.668663462727518*^9}, {
   3.6689711131500998`*^9, 3.6689711156142406`*^9}, {3.669065176640615*^9, 
   3.669065184112545*^9}, {3.6691232295811257`*^9, 3.669123268518794*^9}, {
   3.6691235541070986`*^9, 3.6691235905643625`*^9}, {3.669123628612829*^9, 
   3.6691236288624296`*^9}, {3.6691238529140234`*^9, 3.669123863896443*^9}, 
   3.6691240650870085`*^9, {3.669125375428761*^9, 3.6691253950701957`*^9}, {
   3.6691254285010543`*^9, 3.669125434085864*^9}, {3.669125522257219*^9, 
   3.669125527654828*^9}, {3.669126484310172*^9, 3.669126524002877*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"612.070433`", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H", 
          SubscriptBox["H", 
           SuperscriptBox["x", "6"]]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "6"], "2"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "6"], "3"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "6"], "4"]]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6691237517478456`*^9, 3.669123771700281*^9}, 
   3.6691239608234468`*^9, 3.669125366739546*^9, 3.6691254862835555`*^9, 
   3.6691263892169757`*^9, {3.669126793938838*^9, 3.66912629730791*^9}, 
   3.6691270372585077`*^9, 3.669138739396264*^9, 3.669139379977736*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "H_", ",", "Hx1_", ",", "Hx2_", ",", "Hx3_", ",", 
     "Hx4_", ",", "Hx5_", ",", "Hx6_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H1", "[", 
    RowBox[{
    "t", ",", "x", ",", "H", ",", "Hx1", ",", "Hx2", ",", "Hx3", ",", "Hx4", 
     ",", "Hx5"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "3"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "4"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "5"}], "}"}]}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669134948382984*^9, 3.669135006299947*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"329.188918`", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H1", 
          SubscriptBox["H", 
           SuperscriptBox["x", "5"]]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H1", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "5"], "2"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H1", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "5"], "3"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H1", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "5"], "4"]]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.669135276308696*^9, 3.6691387394329987`*^9, 
  3.66913970923125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H1", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "H_", ",", "Hx1_", ",", "Hx2_", ",", "Hx3_", ",", 
     "Hx4_", ",", "Hx5_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H2", "[", 
    RowBox[{
    "t", ",", "x", ",", "H", ",", "Hx1", ",", "Hx2", ",", "Hx3", ",", "Hx4"}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "3"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "4"}], "}"}]}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6691355902962*^9, 3.669135592487887*^9}, {
  3.669137208709577*^9, 3.669137212948832*^9}, {3.6691384371244993`*^9, 
  3.669138437382667*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"128.120802`", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H2", 
          SubscriptBox["H", 
           SuperscriptBox["x", "4"]]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H2", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "4"], "2"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H2", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "4"], "3"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H2", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "4"], "4"]]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.66913586142205*^9, 3.669137498084811*^9, 
  3.6691387394732237`*^9, 3.669139837429028*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H2", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "H_", ",", "Hx1_", ",", "Hx2_", ",", "Hx3_", ",", 
     "Hx4_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H3", "[", 
    RowBox[{"t", ",", "x", ",", "H", ",", "Hx1", ",", "Hx2", ",", "Hx3"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "3"}], "}"}]}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669138130567078*^9, 3.6691381540313663`*^9}, {
  3.669138417420443*^9, 3.669138421572205*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"40.067923`", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H3", 
          SubscriptBox["H", 
           SuperscriptBox["x", "3"]]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H3", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "3"], "2"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H3", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "3"], "3"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H3", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "3"], "4"]]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6691382608545218`*^9, 3.6691387395120277`*^9, 
  3.6691398775514717`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H3", "[", 
    RowBox[{
    "t_", ",", "x_", ",", "H_", ",", "Hx1_", ",", "Hx2_", ",", "Hx3_"}], 
    "]"}], ":=", 
   RowBox[{"\[Psi]H4", "[", 
    RowBox[{"t", ",", "x", ",", "H", ",", "Hx1", ",", "Hx2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669138389587595*^9, 3.669138432091714*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9.763036`", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H4", 
          SubscriptBox["H", 
           SuperscriptBox["x", "2"]]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H4", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "2"], "2"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H4", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "2"], "3"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H4", 
          SubsuperscriptBox["H", 
           SuperscriptBox["x", "2"], "4"]]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6691384594271183`*^9, 3.669138739552061*^9, 
  3.669139887412591*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H4", "[", 
    RowBox[{"t_", ",", "x_", ",", "H_", ",", "Hx1_", ",", "Hx2_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H5", "[", 
    RowBox[{"t", ",", "x", ",", "H", ",", "Hx1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"excluded", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"H", "[", 
           RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669138463347165*^9, 3.6691384934991407`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.652734`", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H5", 
          SubscriptBox["H", "x"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H5", 
          SubsuperscriptBox["H", "x", "2"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H5", 
          SubsuperscriptBox["H", "x", "3"]]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H5", 
          SubsuperscriptBox["H", "x", "4"]]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6691384987558002`*^9, 3.669138739590908*^9, 
  3.669139888131117*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H5", "[", 
    RowBox[{"t_", ",", "x_", ",", "H_", ",", "Hx1_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H5", "[", 
    RowBox[{"t", ",", "x", ",", "H"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669138513874619*^9, 3.669138529194311*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.089635`", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H5", "H"]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         SubscriptBox["\[Psi]H5", 
          SuperscriptBox["H", "2"]]}], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.669138529749436*^9, 3.6691387396334763`*^9, 
  3.6691398882756157`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H5", "[", 
    RowBox[{"t_", ",", "x_", ",", "H_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H6", "[", 
    RowBox[{"t", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "H", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"SuppressArgs", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669138546059105*^9, 3.6691385711302557`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.02434`", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Psi]H6", "t"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]H6", "x"], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]H6", 
         SuperscriptBox["x", "2"]], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]H6", 
         SuperscriptBox["x", "3"]], "\[Equal]", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Psi]H6", 
         SuperscriptBox["x", "4"]], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.669138572004472*^9, 3.669138739671008*^9, 
  3.669139888346613*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H6", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", "\[Psi]H0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Flatten", "[", "Q", "]"}], "[", 
     RowBox[{"[", "i", "]"}], "]"}], "@@", 
    RowBox[{"Flatten", "[", 
     RowBox[{"var", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"Length", "[", 
      RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6686637347918463`*^9, 3.668663735200499*^9}, {
  3.668971367714412*^9, 3.6689713813020363`*^9}, {3.669065201686346*^9, 
  3.669065210582315*^9}, {3.6691233232768908`*^9, 3.669123324602893*^9}, {
  3.66912645719097*^9, 3.669126458269508*^9}, {3.6691386138824167`*^9, 
  3.669138616794628*^9}}],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{
  3.6686637423131523`*^9, 3.668698929532724*^9, 3.668815227255234*^9, 
   3.668829964978107*^9, {3.6689713758732266`*^9, 3.668971382534438*^9}, 
   3.669049018306418*^9, 3.669065279849146*^9, 3.669126451443342*^9, 
   3.669138617412838*^9, 3.669138739703527*^9, 3.669139888408247*^9}],

Cell[BoxData[
 RowBox[{"{", "\[Psi]H0", "}"}]], "Output",
 CellChangeTimes->{
  3.6686637423131523`*^9, 3.668698929532724*^9, 3.668815227255234*^9, 
   3.668829964978107*^9, {3.6689713758732266`*^9, 3.668971382534438*^9}, 
   3.669049018306418*^9, 3.669065279849146*^9, 3.669126451443342*^9, 
   3.669138617412838*^9, 3.669138739703527*^9, 3.669139888409054*^9}]
}, Open  ]]
},
WindowSize->{755, 637},
WindowMargins->{{92, Automatic}, {27, Automatic}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 265, 4, 32, "Input"],
Cell[826, 26, 4944, 125, 275, "Input"],
Cell[CellGroupData[{
Cell[5795, 155, 1672, 42, 187, "Input"],
Cell[7470, 199, 645, 10, 32, "Output"],
Cell[8118, 211, 1369, 37, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9524, 253, 2300, 56, 121, "Input"],
Cell[11827, 311, 1176, 31, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13040, 347, 1934, 53, 165, "Input"],
Cell[14977, 402, 983, 29, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15997, 436, 1796, 49, 143, "Input"],
Cell[17796, 487, 1005, 29, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18838, 521, 1508, 41, 121, "Input"],
Cell[20349, 564, 987, 29, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21373, 598, 1218, 34, 121, "Input"],
Cell[22594, 634, 982, 29, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23613, 668, 951, 25, 99, "Input"],
Cell[24567, 695, 850, 25, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25454, 725, 714, 19, 99, "Input"],
Cell[26171, 746, 512, 16, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26720, 767, 766, 20, 99, "Input"],
Cell[27489, 789, 747, 22, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28273, 816, 1115, 28, 77, "Input"],
Cell[29391, 846, 355, 6, 32, "Output"],
Cell[29749, 854, 362, 6, 32, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
