(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     62453,       1747]
NotebookOptionsPosition[     59540,       1644]
NotebookOutlinePosition[     59878,       1659]
CellTagsIndexPosition[     59835,       1656]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input",
 CellChangeTimes->{{3.665859232344759*^9, 3.665859236735454*^9}, {
  3.665863815026243*^9, 3.665863849178424*^9}, {3.665863882380316*^9, 
  3.665863929521386*^9}, {3.665899891044674*^9, 3.66589989242861*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"PDE", " ", "we", " ", "seek", " ", "symmetries", " ", 
    RowBox[{"of", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "3"}], "}"}]}], "]"}], "+", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"t", ",", "x"}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Q1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]u", "[", 
       RowBox[{"t", ",", "x", ",", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"t", ",", "x", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"t", ",", "x", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}]}]}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", "\[CapitalDelta]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x"}], "}"}], ",", 
       RowBox[{"{", "u", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "Q1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"1", ",", "0"}], "]"}], "[", "u", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665859055545368*^9, 3.665859056670993*^9}, 
   3.665859222359338*^9, {3.6658595332618227`*^9, 3.665859535110145*^9}, {
   3.665859711964427*^9, 3.665859713110396*^9}, {3.665860496681065*^9, 
   3.6658605636404743`*^9}, {3.665860875037993*^9, 3.665860881549271*^9}, {
   3.665861046773204*^9, 3.665861049549117*^9}, {3.665861674569313*^9, 
   3.6658616967593813`*^9}, {3.6658620374299707`*^9, 3.665862049470551*^9}, {
   3.6658621101506977`*^9, 3.6658621268486853`*^9}, 3.665862225420937*^9, {
   3.665867355970107*^9, 3.6658674061107483`*^9}, {3.665867527086009*^9, 
   3.66586757559233*^9}, {3.66589959391077*^9, 3.6658996402035427`*^9}, {
   3.665903080783215*^9, 3.665903095503909*^9}, {3.6684735390121613`*^9, 
   3.6684735391648827`*^9}, {3.668912596128027*^9, 3.668912597935666*^9}, {
   3.6689126463191566`*^9, 3.668912652391884*^9}, {3.668912750479128*^9, 
   3.6689127516385117`*^9}, {3.668912837879302*^9, 3.668912842590165*^9}, {
   3.669048488832993*^9, 3.669048492872541*^9}, {3.669062460491432*^9, 
   3.669062486581092*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
          "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.668997026719249*^9, 3.6689970312861023`*^9}, 
   3.6690624969007187`*^9}],

Cell[BoxData["51"], "Output",
 CellChangeTimes->{{3.668997020113496*^9, 3.668997032048677*^9}, 
   3.669048502560075*^9, 3.669062497330744*^9, 3.66941706300007*^9, 
   3.670041809697783*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.668997020113496*^9, 3.668997032048677*^9}, 
   3.669048502560075*^9, 3.669062497330744*^9, 3.66941706300007*^9, 
   3.670041809736169*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.665883470602792*^9, 3.665883514147079*^9}, {
   3.6658835910581913`*^9, 3.665883603233927*^9}, {3.666050394037593*^9, 
   3.666050394444675*^9}, 3.668473535080964*^9, {3.668912710582488*^9, 
   3.668912710790349*^9}, {3.668913148780425*^9, 3.668913166939701*^9}, {
   3.668914494626959*^9, 3.66891449786659*^9}, {3.6689690273577995`*^9, 
   3.6689690277658224`*^9}, 3.6690625055469437`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.087891`", ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.665883474634829*^9, 3.665883516446656*^9}, {
   3.665883604370013*^9, 3.665883615183599*^9}, 3.665899682027528*^9, 
   3.665899906151244*^9, 3.6659003657925673`*^9, 3.6659031092468853`*^9, 
   3.665903226185507*^9, {3.6659034136957006`*^9, 3.665903429963566*^9}, {
   3.666050390563136*^9, 3.666050395297736*^9}, 3.666052688451301*^9, 
   3.6660592296081467`*^9, 3.666062927881114*^9, 3.668473546988154*^9, 
   3.6686345233016233`*^9, 3.66863457585646*^9, 3.668637210806184*^9, 
   3.668637354036241*^9, 3.668662230883915*^9, 3.668662423727284*^9, 
   3.6686986670172*^9, 3.6687137564807167`*^9, {3.668722424507251*^9, 
   3.668722435098178*^9}, 3.668814660956059*^9, 3.668829761408724*^9, 
   3.668912715968132*^9, {3.6689128320606422`*^9, 3.668912849990946*^9}, {
   3.668913154866541*^9, 3.6689131677054577`*^9}, {3.668914491831888*^9, 
   3.6689144984620867`*^9}, 3.6689690379914074`*^9, 3.668975879490363*^9, 
   3.669048506237318*^9, 3.669062506664*^9, 3.6694170639282017`*^9, 
   3.670041810646257*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Xi]t1", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665903131697522*^9, 3.665903148784086*^9}, {
   3.666050398837236*^9, 3.666050399279338*^9}, 3.668473535116612*^9, {
   3.668912712038632*^9, 3.668912712254723*^9}, {3.668914510458516*^9, 
   3.6689145132502337`*^9}, {3.6689690288138824`*^9, 3.668969029037895*^9}, 
   3.66906250872252*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.033837`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665903150988785*^9, 3.665903226249514*^9, {3.665903414175057*^9, 
   3.665903431672311*^9}, 3.6660504022907867`*^9, 3.666052689059865*^9, 
   3.6660592309428797`*^9, 3.666062927945478*^9, 3.668473547575676*^9, 
   3.668634528224066*^9, 3.668634577869956*^9, 3.668637212637241*^9, 
   3.6686373540919027`*^9, 3.668662231879944*^9, 3.668662423791685*^9, 
   3.6686986674819937`*^9, 3.668713756538001*^9, {3.668722424564917*^9, 
   3.668722435158637*^9}, 3.6688146623004417`*^9, 3.668829762090146*^9, 
   3.66891271971283*^9, 3.6689128510242662`*^9, 3.668913180040657*^9, 
   3.668914515887843*^9, 3.6689145590726433`*^9, 3.668969038947462*^9, 
   3.6689758795223646`*^9, 3.669048507993619*^9, 3.669062509447809*^9, 
   3.669417065876231*^9, 3.670041811330413*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"t", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6659031545559464`*^9, 3.665903175848455*^9}, 
   3.665903219153366*^9, {3.666050404949828*^9, 3.666050405197604*^9}, 
   3.6684735351424913`*^9, {3.668912713094833*^9, 3.6689127132866983`*^9}, {
   3.66891456955448*^9, 3.668914572489808*^9}, {3.66896903017396*^9, 
   3.668969030397973*^9}, 3.669062511570875*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.02536`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665903176142964*^9, {3.665903219619857*^9, 3.665903226302685*^9}, {
   3.665903414615954*^9, 3.6659034326001472`*^9}, 3.6660504066048326`*^9, 
   3.666052690334498*^9, 3.6660592314666023`*^9, 3.6660629280635366`*^9, 
   3.668473549161907*^9, 3.6686345370076303`*^9, 3.668634580793663*^9, 
   3.668637213701984*^9, 3.668637354148444*^9, 3.6686622328888483`*^9, 
   3.668662423850025*^9, 3.668698668000477*^9, 3.668713756595338*^9, {
   3.668722424624754*^9, 3.668722435208989*^9}, 3.6688146630960207`*^9, 
   3.6688297629724083`*^9, 3.668912723099319*^9, 3.668912851691455*^9, 
   3.66891318062908*^9, {3.668914566823453*^9, 3.668914573385852*^9}, 
   3.6689690410705833`*^9, 3.668975879549366*^9, 3.669048509053755*^9, 
   3.6690625119833813`*^9, 3.6694170693695498`*^9, 3.670041811907941*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u1", "[", 
     RowBox[{"t", ",", "x"}], "]"}], "+", 
    RowBox[{"u", "*", 
     RowBox[{"\[Phi]u2", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6659031787843533`*^9, 3.66590320999507*^9}, {
   3.665903401464679*^9, 3.665903402455502*^9}, 3.665903438696186*^9, {
   3.66605041001482*^9, 3.666050411198604*^9}, 3.668473535160737*^9, {
   3.668662236769884*^9, 3.668662239089242*^9}, {3.668912726765984*^9, 
   3.66891274457456*^9}, {3.669062515898643*^9, 3.66906252088234*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.021165`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Phi]u2", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.665903210274227*^9, 3.6659032263554487`*^9}, {
   3.66590341510082*^9, 3.6659034397983522`*^9}, 3.666050412560124*^9, 
   3.666052690872666*^9, 3.6660592324240227`*^9, 3.666062928110281*^9, 
   3.6684735501280127`*^9, 3.6686372156208344`*^9, 3.668637354205201*^9, 
   3.6686622395417643`*^9, 3.668662423907947*^9, 3.668698668468652*^9, 
   3.668713756648666*^9, {3.668722424672574*^9, 3.668722435258079*^9}, 
   3.6688146639710817`*^9, 3.668829763603692*^9, {3.668912740786253*^9, 
   3.6689127449294786`*^9}, 3.668912852267771*^9, 3.668913181370055*^9, 
   3.6689690449578056`*^9, 3.668975879595369*^9, 3.6690485100507812`*^9, 
   3.669062525970805*^9, 3.6694170705278883`*^9, 3.670041812343701*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u2", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"\[Phi]u3", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665903212919697*^9, 3.665903245055894*^9}, {
   3.6659033047112007`*^9, 3.6659033072233953`*^9}, {3.6659034509191008`*^9, 
   3.665903470815235*^9}, {3.6660504148203506`*^9, 3.666050415996621*^9}, 
   3.668473535166539*^9, {3.668662242193534*^9, 3.6686622441091003`*^9}, {
   3.66891276204602*^9, 3.668912771646195*^9}, {3.669062523044058*^9, 
   3.669062530132038*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.016734`", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Xi]x1", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.665903226401801*^9, 3.665903307571018*^9, 3.665903415962225*^9, {
   3.6659034687425413`*^9, 3.665903471039426*^9}, 3.666050416437347*^9, 
   3.666052691655179*^9, 3.666059234604865*^9, 3.666062928152907*^9, 
   3.668473551083028*^9, 3.668637216984441*^9, 3.668637354288559*^9, 
   3.668662244523034*^9, 3.668662423961972*^9, 3.668698669011591*^9, 
   3.668713756712929*^9, {3.668722424720886*^9, 3.6687224353018827`*^9}, 
   3.668814664930326*^9, 3.668829764455976*^9, 3.668912772048943*^9, 
   3.668912852926721*^9, 3.6689131825059834`*^9, 3.6689690466069*^9, 
   3.66897587962337*^9, 3.6690485110414886`*^9, {3.669062527821031*^9, 
   3.6690625306659317`*^9}, 3.669417071183073*^9, 3.670041812844531*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x2", "[", "t", "]"}], "+", 
    RowBox[{"x", "*", 
     RowBox[{"\[Xi]x3", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665903472676673*^9, 3.665903492615219*^9}, {
   3.666050419558096*^9, 3.666050420620152*^9}, 3.668473535168447*^9, {
   3.6686622470255136`*^9, 3.6686622488018227`*^9}, {3.668912777366949*^9, 
   3.6689127792222023`*^9}, {3.66906253301121*^9, 3.669062535514536*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.023981`", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u3", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"\[Xi]x3", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]t1", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]u1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6659034903110867`*^9, 3.665903492925448*^9}, 
   3.66605042105387*^9, 3.666052692276464*^9, 3.66605923583989*^9, 
   3.666062928204906*^9, 3.668473551942631*^9, 3.668637217582546*^9, 
   3.668637354411944*^9, 3.668662249260872*^9, 3.668662424022883*^9, 
   3.6686986695403957`*^9, 3.668713756777841*^9, {3.668722424770455*^9, 
   3.668722435349214*^9}, 3.668814665890695*^9, 3.668829765188534*^9, 
   3.6689127805094843`*^9, 3.668912853563736*^9, 3.668913183325265*^9, 
   3.6689690497790813`*^9, 3.6689758796623726`*^9, 3.66904851201672*^9, 
   3.669062536060684*^9, 3.669417071846931*^9, 3.670041813453392*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u4", "[", "t", "]"}], "-", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"\[Phi]u3", "'"}], "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665903522566173*^9, 3.6659035403091993`*^9}, {
   3.666050425902351*^9, 3.666050428318709*^9}, 3.668473535169339*^9, {
   3.668662254609589*^9, 3.6686622564818163`*^9}, {3.668912802334506*^9, 
   3.668912813126494*^9}, {3.6689128678460617`*^9, 3.668912870037627*^9}, {
   3.66906253813806*^9, 3.66906254042645*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.019395`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"\[Xi]x3", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]t1", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u4", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{"x", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]u3", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.665903540558329*^9, 3.666050430029931*^9, 3.666052693828199*^9, 
   3.666059237909417*^9, 3.6660629283422527`*^9, 3.668473554063158*^9, 
   3.668637219537537*^9, 3.66863735452894*^9, 3.668662257136937*^9, 
   3.668662424135825*^9, 3.668698670779624*^9, 3.668713756957377*^9, {
   3.668722424917883*^9, 3.6687224354472427`*^9}, 3.668814667841633*^9, 
   3.6688297666872*^9, {3.6689128086246862`*^9, 3.668912814226594*^9}, {
   3.6689128544101562`*^9, 3.6689128707873096`*^9}, 3.66891318450209*^9, 
   3.668969052009209*^9, 3.6689758796963744`*^9, 3.66904851311981*^9, 
   3.669062540976399*^9, 3.66941707250815*^9, 3.670041813968432*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x3", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]t1", "'"}], "[", "t", "]"}], "/", "3"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665903552840871*^9, 3.665903562696496*^9}, {
   3.666050432237752*^9, 3.666050433390176*^9}, 3.6684735351701593`*^9, {
   3.668662261145576*^9, 3.668662263809395*^9}, {3.668912878566427*^9, 
   3.66891288199065*^9}, {3.669062543211091*^9, 3.669062545754221*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.022547`", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"\[Phi]u3", "[", "t", "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]t1", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u4", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{"x", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]u3", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.665903562977955*^9, 3.666050434976618*^9, 3.6660526945388737`*^9, 
   3.66605923949011*^9, 3.6660629284134083`*^9, 3.668473554905444*^9, 
   3.668637220763535*^9, 3.668637354586907*^9, 3.668662264334619*^9, 
   3.6686624241882963`*^9, 3.668698671346624*^9, 3.668713757011505*^9, {
   3.6687224249643583`*^9, 3.668722435498802*^9}, 3.668814668853335*^9, 
   3.668829767369204*^9, {3.668912876223257*^9, 3.6689128823152037`*^9}, 
   3.668913185359696*^9, 3.6689690551643896`*^9, 3.6689758797303762`*^9, 
   3.669048514162757*^9, 3.6690625464528503`*^9, 3.669417073131095*^9, 
   3.670041814540124*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u3", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "/", "3"}], "*", 
    RowBox[{
     RowBox[{"\[Xi]t1", "'"}], "[", "t", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665903568529414*^9, 3.665903586685672*^9}, {
   3.666050437221641*^9, 3.666050438325389*^9}, 3.668473535170972*^9, {
   3.668662267129588*^9, 3.668662269361672*^9}, {3.6689128858294*^9, 
   3.668912890261436*^9}, {3.66906254849918*^9, 3.669062550529964*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.015573`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]u4", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "+", 
        RowBox[{"2", " ", "x", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t1", 
           TagBox[
            RowBox[{"(", "3", ")"}],
            Derivative],
           MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665903586923114*^9, 3.666050438918068*^9, 3.666052695133646*^9, 
   3.666059240050626*^9, 3.6660629284773703`*^9, 3.66847355589779*^9, 
   3.668637222012712*^9, 3.668637354641161*^9, 3.668662269826375*^9, 
   3.668662424234007*^9, 3.668698671942919*^9, 3.668713757073639*^9, {
   3.6687224250059557`*^9, 3.668722435546089*^9}, 3.668814669731777*^9, 
   3.6688297680867977`*^9, 3.668912891458931*^9, 3.6689131863925962`*^9, 
   3.6689690559684353`*^9, 3.668975879757378*^9, 3.6690485151496277`*^9, 
   3.669062551016551*^9, 3.6694170737439537`*^9, 3.670041815046167*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u4", "[", "t_", "]"}], ":=", "\[Phi]u0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t1", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Xi]t0", "+", 
    RowBox[{"t", "*", "\[Xi]t1"}], "+", 
    RowBox[{
     RowBox[{"t", "^", "2"}], "*", "\[Xi]t2"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665903603267707*^9, 3.66590364032694*^9}, {
   3.6660504430057373`*^9, 3.666050444601041*^9}, 3.668473535171821*^9, {
   3.668662272201366*^9, 3.668662273753428*^9}, {3.668912895374443*^9, 
   3.66891290163798*^9}, {3.6690625532515173`*^9, 3.669062554954558*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.01694`", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "x", " ", "\[Xi]t2"}], "+", 
        RowBox[{"3", " ", "\[Phi]u0"}]}], "\[Equal]", 
       RowBox[{"3", " ", 
        RowBox[{
         SuperscriptBox["\[Xi]x2", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.6659036363540382`*^9, 3.665903640594646*^9}, 
   3.6660504463117733`*^9, 3.666052695684564*^9, 3.6660592408073053`*^9, 
   3.666062928584519*^9, 3.6684735566635857`*^9, 3.6686372259851418`*^9, 
   3.668637354707946*^9, 3.668662274538885*^9, 3.668662424285902*^9, 
   3.668698672575294*^9, 3.668713757127111*^9, {3.6687224250509243`*^9, 
   3.668722435591827*^9}, 3.668814670882307*^9, 3.668829768784381*^9, 
   3.668912904291606*^9, 3.668913187401012*^9, 3.6689690568944883`*^9, 
   3.6689758797873793`*^9, 3.6690485162257547`*^9, 3.669062555479353*^9, 
   3.6694170749327173`*^9, 3.6700418157357283`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Symmetries", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Xi]t2", ":=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]x2", "[", "t_", "]"}], ":=", 
     RowBox[{"\[Xi]x0", "+", 
      RowBox[{"t", "*", "\[Phi]u0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"FindInvariance", "[", 
     RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
     "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Flatten", "[", "Q", "]"}], "[", 
       RowBox[{"[", "i", "]"}], "]"}], "@@", 
      RowBox[{"Flatten", "[", 
       RowBox[{"var", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", 
        RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6659036503065033`*^9, 3.665903692261022*^9}, 
   3.6684735351727333`*^9, {3.66891291403717*^9, 3.6689129228300447`*^9}, {
   3.669062560274621*^9, 3.6690625651700153`*^9}, {3.669062596227333*^9, 
   3.669062597658525*^9}}],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{{3.665903684879056*^9, 3.665903693440545*^9}, 
   3.666050475650135*^9, 3.666052696280053*^9, 3.666059244131584*^9, 
   3.6660629287259283`*^9, 3.668473559581522*^9, 3.668637246247793*^9, 
   3.668637354760249*^9, 3.668662280354068*^9, 3.6686624243298693`*^9, 
   3.6686986732092943`*^9, 3.6687137571760607`*^9, {3.668722425093904*^9, 
   3.6687224356378927`*^9}, 3.6688146730740623`*^9, 3.668829771083362*^9, {
   3.66891291639583*^9, 3.668912923166543*^9}, 3.66891318851122*^9, 
   3.668969058247566*^9, 3.668975879808381*^9, 3.669048518803838*^9, 
   3.6690625661820498`*^9, 3.669062597983316*^9, 3.669417075599412*^9, 
   3.670041816510556*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Phi]u0", "-", 
   RowBox[{
    FractionBox["2", "3"], " ", "\[Xi]t1", " ", 
    RowBox[{"u", "[", 
     RowBox[{"t", ",", "x"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"x", " ", "\[Xi]t1"}], "3"], "+", "\[Xi]x0", "+", 
      RowBox[{"t", " ", "\[Phi]u0"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Xi]t0", "+", 
      RowBox[{"t", " ", "\[Xi]t1"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x"}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.665903684879056*^9, 3.665903693440545*^9}, 
   3.666050475650135*^9, 3.666052696280053*^9, 3.666059244131584*^9, 
   3.6660629287259283`*^9, 3.668473559581522*^9, 3.668637246247793*^9, 
   3.668637354760249*^9, 3.668662280354068*^9, 3.6686624243298693`*^9, 
   3.6686986732092943`*^9, 3.6687137571760607`*^9, {3.668722425093904*^9, 
   3.6687224356378927`*^9}, 3.6688146730740623`*^9, 3.668829771083362*^9, {
   3.66891291639583*^9, 3.668912923166543*^9}, 3.66891318851122*^9, 
   3.668969058247566*^9, 3.668975879808381*^9, 3.669048518803838*^9, 
   3.6690625661820498`*^9, 3.669062597983316*^9, 3.669417075599412*^9, 
   3.670041816512368*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Adjoint", " ", "symmetries"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]1", "[", 
      RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]u", "[", 
       RowBox[{"t", ",", "x", ",", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"t", ",", "x", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"t", ",", "x", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}]}]}]}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", "\[CapitalDelta]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x"}], "}"}], ",", 
       RowBox[{"{", "u", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "\[CapitalLambda]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"1", ",", "0"}], "]"}], "[", "u", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.668913302804331*^9, 3.668913373858541*^9}, 
   3.668919525828376*^9, {3.6689690705742707`*^9, 3.668969090070386*^9}, {
   3.669048522609268*^9, 3.669048526120576*^9}, {3.6690626223955803`*^9, 
   3.6690626696096897`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
       RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{
          "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
           RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.669062681265634*^9, 3.669062690945387*^9}}],

Cell[BoxData["53"], "Output",
 CellChangeTimes->{3.6690626922303677`*^9, 3.669417076937604*^9, 
  3.6700418183585863`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{3.6690626922303677`*^9, 3.669417076937604*^9, 
  3.670041818403026*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.668662310553276*^9, 3.668662316577508*^9}, {
  3.668912973652752*^9, 3.668912978772915*^9}, {3.669062698873267*^9, 
  3.669062709826292*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.107882`", ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6686623134212923`*^9, 3.6686623170502462`*^9}, 
   3.6686624244620237`*^9, 3.66869867670621*^9, 3.668713757524517*^9, {
   3.6687224251427298`*^9, 3.668722435786922*^9}, 3.6688146766064863`*^9, 
   3.6688297739421577`*^9, 3.6689129803289843`*^9, 3.668913026181736*^9, 
   3.668913197863723*^9, 3.668913376280443*^9, {3.668969073679448*^9, 
   3.668969093311571*^9}, 3.6689758799403887`*^9, 3.669048528781671*^9, 
   3.669062713599627*^9, 3.6694170782108517`*^9, 3.6700418195945597`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Zeta]t1", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668662320381103*^9, 3.6686623457776117`*^9}, {
  3.66891338161798*^9, 3.668913385659217*^9}, {3.669062717097352*^9, 
  3.669062718401373*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.043526`", ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6686623461640253`*^9, 3.668662424621057*^9, 3.66869867804554*^9, 
   3.668713757626493*^9, {3.668722425184763*^9, 3.668722435847941*^9}, 
   3.668814681462332*^9, 3.668829774786537*^9, 3.668913389139648*^9, 
   3.668969102345088*^9, 3.6689758799783907`*^9, 3.669048530256568*^9, 
   3.669062720794074*^9, 3.669417078841693*^9, 3.670041820412846*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Zeta]x1", "[", 
    RowBox[{"t", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668662348692124*^9, 3.668662395985404*^9}, {
  3.6689134100658693`*^9, 3.668913414499176*^9}, {3.669062722842432*^9, 
  3.669062725121252*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.034072`", ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t1", "[", "t", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668662369835368*^9, 3.668662424657803*^9}, 
   3.668698678971649*^9, 3.668713757684999*^9, {3.66872242522549*^9, 
   3.668722435907838*^9}, 3.66881468319127*^9, 3.668829775667864*^9, 
   3.6689134217895737`*^9, 3.668969108347431*^9, 3.668975880014393*^9, 
   3.669048531279107*^9, 3.669062725971662*^9, 3.669417079387084*^9, 
   3.67004182108818*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t1", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668662373809268*^9, 3.66866238018603*^9}, {
  3.6689691176619644`*^9, 3.668969120534128*^9}, {3.669062728465938*^9, 
  3.669062730416918*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.017278`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6686623804992332`*^9, 3.668662424694565*^9, 3.6686986798541107`*^9, 
   3.668713757733767*^9, {3.668722425268572*^9, 3.668722436022512*^9}, 
   3.6688146847426577`*^9, 3.668829776511786*^9, {3.6689691134147215`*^9, 
   3.668969120899149*^9}, 3.668975880041394*^9, 3.669048532145196*^9, 
   3.669062730940493*^9, 3.669417079958293*^9, 3.670041821853207*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]x1", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"\[Zeta]x2", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u", "[", 
    RowBox[{"t_", ",", "x_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]u1", "[", 
     RowBox[{"t", ",", "x"}], "]"}], "+", 
    RowBox[{"u", "*", 
     RowBox[{"\[Psi]u2", "[", 
      RowBox[{"t", ",", "x"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668662385724248*^9, 3.668662453585*^9}, {
  3.668969125893435*^9, 3.6689691446615086`*^9}, {3.669062733393433*^9, 
  3.6690627351213007`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.024231`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Zeta]x2", "[", "t", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]u2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x"}], "]"}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.668662455009705*^9, 3.668698680589444*^9, 3.668713757790914*^9, {
   3.668722425309947*^9, 3.668722436060375*^9}, 3.6688146862394743`*^9, 
   3.668829777359666*^9, {3.6689691296016474`*^9, 3.6689691449745264`*^9}, 
   3.6689758800823965`*^9, 3.669048533073627*^9, 3.669062735635256*^9, 
   3.669417080514832*^9, 3.670041822820154*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]x2", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u2", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"\[Psi]u3", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"\"\<extras\>\"", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668662458940917*^9, 3.668662490336955*^9}, {
  3.668969150189825*^9, 3.6689691622135124`*^9}, {3.669062738145425*^9, 
  3.6690627398414927`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.006532`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]u3", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]u1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Psi]u1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]u1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6686624798303213`*^9, 3.6686624906848497`*^9}, 
   3.6686986813420887`*^9, 3.668713757859324*^9, {3.668722425390517*^9, 
   3.668722436096047*^9}, 3.668814687500044*^9, 3.668829778284005*^9, {
   3.668969152766972*^9, 3.6689691628305473`*^9}, 3.6689758801203985`*^9, 
   3.669048535400407*^9, 3.669062740365218*^9, 3.669417081004159*^9, 
   3.670041823545579*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u1", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]u4", "[", "t", "]"}], "-", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"\[Psi]u3", "'"}], "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"\"\<extras\>\"", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6686625004891663`*^9, 3.668662535964233*^9}, {
  3.668969171078019*^9, 3.6689691839017525`*^9}, {3.669062744130189*^9, 
  3.669062748297023*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.007853`", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Psi]u4", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"x", " ", 
        RowBox[{
         SuperscriptBox["\[Psi]u3", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.668662530425023*^9, 3.668662536390572*^9}, 
   3.66869868208654*^9, 3.668713757929006*^9, {3.6687224254307833`*^9, 
   3.668722436144497*^9}, 3.668814688720316*^9, 3.668829779054009*^9, 
   3.6689691843557787`*^9, 3.6689758801393995`*^9, 3.669048536879129*^9, 
   3.669062749293907*^9, 3.66941708153333*^9, 3.670041824508902*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u4", "[", "t_", "]"}], ":=", "\[Psi]u5"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u3", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Psi]u6", "+", 
    RowBox[{"t", "*", "\[Psi]u7"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Flatten", "[", "Q", "]"}], "[", 
     RowBox[{"[", "i", "]"}], "]"}], "@@", 
    RowBox[{"Flatten", "[", 
     RowBox[{"var", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"Length", "[", 
      RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.668662543106165*^9, 3.668662566920663*^9}, {
   3.6687226213263187`*^9, 3.668722759013934*^9}, {3.668722812773416*^9, 
   3.668722813437252*^9}, {3.6687229042220078`*^9, 3.668722907566079*^9}, {
   3.6687231324528027`*^9, 3.668723203179225*^9}, {3.668723270227429*^9, 
   3.668723351697318*^9}, {3.668723393241519*^9, 3.668723416417259*^9}, 
   3.668723464657895*^9, {3.6689691913271775`*^9, 3.668969197086507*^9}, {
   3.668969270887728*^9, 3.668969309975964*^9}, {3.669062752529969*^9, 
   3.6690627602010107`*^9}}],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{
  3.668662567278675*^9, 3.668698683030652*^9, 3.668713757967781*^9, {
   3.668722425469668*^9, 3.668722436188301*^9}, 3.6687226267456903`*^9, 
   3.668722759966501*^9, 3.66872281505756*^9, 3.668722908151075*^9, 
   3.6687231621274548`*^9, 3.668723209832389*^9, {3.668723281620203*^9, 
   3.66872330370691*^9}, {3.668723352847595*^9, 3.668723362679845*^9}, {
   3.6687233939897127`*^9, 3.668723423756281*^9}, 3.668723465233509*^9, 
   3.6688146899242163`*^9, 3.6688297797771387`*^9, {3.668969265691431*^9, 
   3.6689693102839813`*^9}, 3.6689758801584005`*^9, 3.669048538514494*^9, 
   3.669062760877624*^9, 3.669417082075368*^9, 3.670041825233809*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Psi]u5", "-", 
   RowBox[{"x", " ", "\[Psi]u7"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Psi]u6", "+", 
      RowBox[{"t", " ", "\[Psi]u7"}]}], ")"}], " ", 
    RowBox[{"u", "[", 
     RowBox[{"t", ",", "x"}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.668662567278675*^9, 3.668698683030652*^9, 3.668713757967781*^9, {
   3.668722425469668*^9, 3.668722436188301*^9}, 3.6687226267456903`*^9, 
   3.668722759966501*^9, 3.66872281505756*^9, 3.668722908151075*^9, 
   3.6687231621274548`*^9, 3.668723209832389*^9, {3.668723281620203*^9, 
   3.66872330370691*^9}, {3.668723352847595*^9, 3.668723362679845*^9}, {
   3.6687233939897127`*^9, 3.668723423756281*^9}, 3.668723465233509*^9, 
   3.6688146899242163`*^9, 3.6688297797771387`*^9, {3.668969265691431*^9, 
   3.6689693102839813`*^9}, 3.6689758801584005`*^9, 3.669048538514494*^9, 
   3.669062760877624*^9, 3.669417082075368*^9, 3.670041825234997*^9}]
}, Open  ]]
},
WindowSize->{775, 848},
WindowMargins->{{Automatic, 23}, {Automatic, 17}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 265, 4, 32, "Input"],
Cell[826, 26, 3495, 91, 187, "Input"],
Cell[CellGroupData[{
Cell[4346, 121, 1393, 37, 165, "Input"],
Cell[5742, 160, 190, 3, 32, "Output"],
Cell[5935, 165, 634, 20, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6606, 190, 719, 15, 32, "Input"],
Cell[7328, 207, 3352, 85, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10717, 297, 797, 19, 55, "Input"],
Cell[11517, 318, 1878, 46, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13432, 369, 845, 20, 55, "Input"],
Cell[14280, 391, 1911, 46, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16228, 442, 1058, 26, 77, "Input"],
Cell[17289, 470, 1152, 25, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18478, 500, 946, 22, 77, "Input"],
Cell[19427, 524, 1160, 26, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20624, 555, 927, 23, 77, "Input"],
Cell[21554, 580, 2052, 53, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23643, 638, 1004, 26, 77, "Input"],
Cell[24650, 666, 1368, 31, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26055, 702, 859, 22, 77, "Input"],
Cell[26917, 726, 1407, 34, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28361, 765, 902, 24, 77, "Input"],
Cell[29266, 791, 1190, 28, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30493, 824, 1023, 27, 99, "Input"],
Cell[31519, 853, 1070, 23, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32626, 881, 1239, 32, 121, "Input"],
Cell[33868, 915, 718, 11, 32, "Output"],
Cell[34589, 928, 1595, 42, 90, "Output"]
}, Open  ]],
Cell[36199, 973, 1952, 57, 165, "Input"],
Cell[CellGroupData[{
Cell[38176, 1034, 1470, 38, 187, "Input"],
Cell[39649, 1074, 122, 2, 32, "Output"],
Cell[39774, 1078, 564, 19, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40375, 1102, 523, 13, 55, "Input"],
Cell[40901, 1117, 2843, 77, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43781, 1199, 706, 18, 77, "Input"],
Cell[44490, 1219, 1472, 40, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45999, 1264, 732, 19, 77, "Input"],
Cell[46734, 1285, 1244, 33, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48015, 1323, 636, 17, 77, "Input"],
Cell[48654, 1342, 1455, 40, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50146, 1387, 1015, 28, 99, "Input"],
Cell[51164, 1417, 903, 24, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52104, 1446, 891, 24, 121, "Input"],
Cell[52998, 1472, 1575, 44, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54610, 1521, 894, 25, 99, "Input"],
Cell[55507, 1548, 806, 19, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56350, 1572, 1483, 35, 99, "Input"],
Cell[57836, 1609, 721, 11, 32, "Output"],
Cell[58560, 1622, 964, 19, 32, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
