(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     38709,       1090]
NotebookOptionsPosition[     36331,       1004]
NotebookOutlinePosition[     36671,       1019]
CellTagsIndexPosition[     36628,       1016]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input",
 CellChangeTimes->{{3.665859232344759*^9, 3.665859236735454*^9}, {
  3.665863815026243*^9, 3.665863849178424*^9}, {3.665863882380316*^9, 
  3.665863929521386*^9}, {3.665899891044674*^9, 3.66589989242861*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"PDE", " ", "we", " ", "seek", " ", "symmetries", " ", 
    RowBox[{"of", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]1", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"u", "[", "t", "]"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"u", "''"}], "[", "t", "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Q1", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]u", "[", 
       RowBox[{"t", ",", 
        RowBox[{"u", "[", "t", "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"t", ",", 
         RowBox[{"u", "[", "t", "]"}]}], "]"}], "*", 
       RowBox[{
        RowBox[{"u", "'"}], "[", "t", "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", "\[CapitalDelta]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{"{", "u", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "Q1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", "2", "]"}], "[", "u", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665859055545368*^9, 3.665859056670993*^9}, 
   3.665859222359338*^9, {3.6658595332618227`*^9, 3.665859535110145*^9}, {
   3.665859711964427*^9, 3.665859713110396*^9}, {3.665860496681065*^9, 
   3.6658605636404743`*^9}, {3.665860875037993*^9, 3.665860881549271*^9}, {
   3.665861046773204*^9, 3.665861049549117*^9}, {3.665861674569313*^9, 
   3.6658616967593813`*^9}, {3.6658620374299707`*^9, 3.665862049470551*^9}, {
   3.6658621101506977`*^9, 3.6658621268486853`*^9}, 3.665862225420937*^9, {
   3.665867355970107*^9, 3.6658674061107483`*^9}, {3.665867527086009*^9, 
   3.66586757559233*^9}, {3.66589959391077*^9, 3.6658996402035427`*^9}, {
   3.665903080783215*^9, 3.665903095503909*^9}, {3.6659037581561604`*^9, 
   3.6659037716046867`*^9}, {3.665950878727268*^9, 3.665950898750413*^9}, {
   3.6659626982887*^9, 3.6659626986943007`*^9}, {3.66597694337505*^9, 
   3.665976962309989*^9}, 3.66597700113936*^9, {3.665977122909917*^9, 
   3.665977139395653*^9}, {3.66597750994529*^9, 3.665977510178215*^9}, {
   3.668473587275729*^9, 3.668473587492366*^9}, {3.668969696310061*^9, 
   3.6689697550134187`*^9}, {3.669069099717738*^9, 3.669069172709477*^9}, {
   3.6690692763653517`*^9, 3.669069277780939*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Plus", "@@", 
   RowBox[{"Map", "[", 
    RowBox[{"Length", ",", 
     RowBox[{"Expand", "[", 
      RowBox[{"FindInvariance", "[", 
       RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
       "]"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.665860553384531*^9, 3.665860557223929*^9}, {
   3.665860738233917*^9, 3.665860740785784*^9}, {3.6658612774842663`*^9, 
   3.66586128001158*^9}, {3.665862134590067*^9, 3.6658621370127*^9}, {
   3.665863682232481*^9, 3.6658636923756037`*^9}, 3.668473579798011*^9, {
   3.668969718181312*^9, 3.6689697183813233`*^9}, 3.6690691964214773`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.006395`", ",", "10"}], "}"}]], "Output",
 CellChangeTimes->{
  3.665860568806402*^9, 3.665860699218162*^9, 3.665860749239545*^9, 
   3.665860819579459*^9, 3.6658609687318277`*^9, 3.6658610978311157`*^9, 
   3.665861176145685*^9, 3.665861281631703*^9, {3.665861323616026*^9, 
   3.6658613388447933`*^9}, 3.66586137306406*^9, 3.665861437934593*^9, 
   3.665861501300076*^9, 3.665861707960017*^9, 3.6658620570322323`*^9, 
   3.66586222951998*^9, 3.66586232498002*^9, 3.665863667447193*^9, 
   3.665863704429582*^9, 3.665864035012487*^9, 3.665867213835298*^9, 
   3.665867415896546*^9, 3.6658675788940573`*^9, 3.665876577588208*^9, 
   3.665882779043414*^9, {3.665883075700088*^9, 3.6658830991137543`*^9}, 
   3.665883332741406*^9, 3.6658836128544483`*^9, {3.665899649408271*^9, 
   3.6658996731491613`*^9}, 3.665899897463888*^9, 3.6659003582501183`*^9, 
   3.665903108062612*^9, 3.6659032261403837`*^9, {3.6659034131789093`*^9, 
   3.665903429433507*^9}, 3.6659037730712023`*^9, {3.665903968310936*^9, 
   3.6659039857972717`*^9}, 3.665904127080491*^9, 3.665904237173439*^9, 
   3.665950910436082*^9, 3.665962314933627*^9, 3.665962359393705*^9, 
   3.665962391358161*^9, {3.665962460996683*^9, 3.6659624839443235`*^9}, 
   3.66596263571699*^9, 3.6659626673226457`*^9, {3.6659627030155087`*^9, 
   3.6659627242159452`*^9}, {3.665976968024438*^9, 3.6659770025647297`*^9}, {
   3.665977132226129*^9, 3.665977147645976*^9}, 3.665977525109634*^9, 
   3.666062946799074*^9, 3.6684735997937307`*^9, 3.668637572685161*^9, 
   3.668663036106018*^9, 3.6686987045715313`*^9, 3.668969718806348*^9, 
   3.6689697640289345`*^9, 3.669069198808428*^9, 3.669069287023115*^9, 
   3.670041843465679*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.665883470602792*^9, 3.665883514147079*^9}, {
   3.6658835910581913`*^9, 3.665883603233927*^9}, {3.6660629604793663`*^9, 
   3.666062960711792*^9}, 3.668473579826964*^9, {3.668969723029589*^9, 
   3.6689697234536133`*^9}, 3.669069293501019*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.029883`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Xi]t", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "u"}], "]"}], "\[Equal]", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.665883474634829*^9, 3.665883516446656*^9}, {
   3.665883604370013*^9, 3.665883615183599*^9}, 3.665899682027528*^9, 
   3.665899906151244*^9, 3.6659003657925673`*^9, 3.6659031092468853`*^9, 
   3.665903226185507*^9, {3.6659034136957006`*^9, 3.665903429963566*^9}, 
   3.665903780304195*^9, {3.665903968378437*^9, 3.665903985864032*^9}, 
   3.665904127165639*^9, 3.665904237224958*^9, 3.6659627324215603`*^9, 
   3.66597701601101*^9, 3.665977158030308*^9, 3.665977529130266*^9, 
   3.666062961086212*^9, 3.668473600645906*^9, 3.668637572809565*^9, 
   3.668663036692471*^9, 3.6686987052050858`*^9, 3.6689697259557567`*^9, 
   3.6689697647179737`*^9, 3.6690692942345467`*^9, 3.6700418441089067`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t", "[", 
    RowBox[{"t_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]t1", "[", "t", "]"}], "+", 
    RowBox[{"u", "*", 
     RowBox[{"\[Xi]t2", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665903131697522*^9, 3.665903148784086*^9}, {
   3.6659628030740843`*^9, 3.6659628194229126`*^9}, {3.666062963761286*^9, 
   3.666062964048731*^9}, 3.6684735798529797`*^9, {3.6689697684141855`*^9, 
   3.6689697686301975`*^9}, 3.6690692970286427`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.023502`", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["\[Xi]t2", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
       RowBox[{
        SuperscriptBox["\[Phi]u", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "u"}], "]"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665903150988785*^9, 3.665903226249514*^9, {3.665903414175057*^9, 
   3.665903431672311*^9}, 3.6659037893053637`*^9, {3.6659039684324837`*^9, 
   3.665903985946793*^9}, 3.665904127276421*^9, 3.66590423740845*^9, {
   3.665962814914505*^9, 3.665962819610113*^9}, 3.665977163115954*^9, 
   3.6659775311830177`*^9, 3.666062964940455*^9, 3.6684736012614317`*^9, 
   3.6686375729368467`*^9, 3.668663037368849*^9, 3.6686987060364847`*^9, 
   3.6689697705953097`*^9, 3.669069297538211*^9, 3.6700418446381617`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{
      SuperscriptBox["\[Xi]t2", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{
     SuperscriptBox["\[Phi]u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "u"}], "]"}]}], ",", 
   RowBox[{"\[Phi]u", "[", 
    RowBox[{"t", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "u"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6659628324333353`*^9, 3.665962840108549*^9}, 
   3.66597717268396*^9, {3.665977536706489*^9, 3.665977536986401*^9}, {
   3.6689697779197288`*^9, 3.6689697805178776`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]u", "[", 
     RowBox[{"t", ",", "u"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", "t", "]"}], "+", 
     RowBox[{"u", " ", 
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], "[", "t", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["u", "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Xi]t2", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.6659628420897527`*^9, 3.665977173697392*^9, 3.665977539509547*^9, 
   3.666062967225588*^9, 3.668473601904887*^9, 3.6686375734813957`*^9, 
   3.668663039621458*^9, 3.668698706692327*^9, {3.66896977374149*^9, 
   3.6689697809229*^9}, 3.669069299678975*^9, 3.670041845186737*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u", "[", 
    RowBox[{"t_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u1", "[", "t", "]"}], "+", 
    RowBox[{"u", " ", 
     RowBox[{"\[Phi]u2", "[", "t", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["u", "2"], " ", 
     RowBox[{
      SuperscriptBox["\[Xi]t2", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6659628446793575`*^9, 3.665962872587806*^9}, {
   3.665977181141162*^9, 3.665977216772028*^9}, {3.665977548595306*^9, 
   3.665977548688869*^9}, {3.666062969409816*^9, 3.666062970904212*^9}, 
   3.668473579881982*^9, {3.668663042284313*^9, 3.668663044170381*^9}, {
   3.6689697861902018`*^9, 3.6689698217262344`*^9}, {3.6690693021408367`*^9, 
   3.669069309788651*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.018108`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t2", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Xi]t2", "[", "t", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]u1", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6659628658329945`*^9, 3.6659628728374066`*^9}, {
   3.665977189966773*^9, 3.665977217293881*^9}, 3.665977549873742*^9, 
   3.666062973278932*^9, 3.6684736026984243`*^9, 3.668637573606585*^9, 
   3.668663044669545*^9, 3.668698707331759*^9, {3.668969809463533*^9, 
   3.66896982497042*^9}, 3.669069310543458*^9, 3.670041845684663*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t2", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u1", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Phi]0", "+", 
    RowBox[{"t", "*", "\[Phi]3"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665962884334627*^9, 3.6659629365479183`*^9}, {
   3.6659772240678*^9, 3.665977268204125*^9}, {3.6660629764165087`*^9, 
   3.6660629778156137`*^9}, 3.6684735798919287`*^9, {3.668663047804284*^9, 
   3.668663049803933*^9}, {3.668969832733864*^9, 3.6689698429014454`*^9}, {
   3.669069313157155*^9, 3.66906931705269*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.011518`", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"\[Phi]u2", "[", "t", "]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]t1", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]u2", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]t1", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.665962936969119*^9, {3.665977266506507*^9, 3.6659772686812077`*^9}, 
   3.665977557293787*^9, 3.6660629890143347`*^9, 3.668473603361835*^9, 
   3.6686375737355547`*^9, 3.668663050288775*^9, 3.668698708059408*^9, 
   3.668969844958563*^9, 3.669069325912964*^9, 3.670041846194291*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u2", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    RowBox[{
     SuperscriptBox["\[Xi]t1", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665962966390771*^9, 3.6659629895880117`*^9}, {
   3.66597729825095*^9, 3.665977315243671*^9}, {3.6659773914040337`*^9, 
   3.6659773938512983`*^9}, {3.665977578843141*^9, 3.665977591986672*^9}, {
   3.6660629814089737`*^9, 3.666062984439827*^9}, 3.668473579894594*^9, {
   3.668663052043668*^9, 3.6686630536436787`*^9}, {3.668969848717778*^9, 
   3.6689698563182125`*^9}, {3.669069330748644*^9, 3.669069333875989*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.008129`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Xi]t1", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6659629832232003`*^9, 3.665962989978012*^9}, {
   3.6659773045623198`*^9, 3.665977315666871*^9}, 3.665977395765751*^9, {
   3.665977583769868*^9, 3.665977592184374*^9}, 3.666062993641005*^9, 
   3.668473604102964*^9, 3.66863757383022*^9, 3.66866305398473*^9, 
   3.668698708811016*^9, 3.668969857302269*^9, 3.66906934237002*^9, 
   3.6700418469721317`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t1", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Xi]t0", "+", 
    RowBox[{"t", "*", "\[Xi]t3"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6659630299764824`*^9, 3.665963081487773*^9}, {
   3.665977344867977*^9, 3.665977382692137*^9}, {3.665977604279336*^9, 
   3.665977621778479*^9}, {3.666062996775268*^9, 3.6660629980079527`*^9}, 
   3.668473579895864*^9, {3.668663056500266*^9, 3.6686630580039253`*^9}, {
   3.668969861901532*^9, 3.668969866141775*^9}, {3.669069345380556*^9, 
   3.669069348872951*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.005786`", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]0", "+", 
        RowBox[{"t", " ", "\[Phi]3"}]}], "\[Equal]", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.6659630609425373`*^9, 3.6659630817685738`*^9}, {
   3.6659773521458883`*^9, 3.665977401910606*^9}, {3.665977618264052*^9, 
   3.6659776219283257`*^9}, 3.666062998865354*^9, 3.6684736050779123`*^9, 
   3.668637573944968*^9, 3.66866305831033*^9, 3.66869870956535*^9, 
   3.6689698673298426`*^9, 3.669069352106544*^9, 3.670041847551001*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Symmetries", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Phi]0", ":=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Phi]3", ":=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"FindInvariance", "[", 
     RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
     "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Flatten", "[", "Q", "]"}], "[", 
        RowBox[{"[", "i", "]"}], "]"}], "@@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"var", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6659036503065033`*^9, 3.665903692261022*^9}, {
   3.665903977923088*^9, 3.665903978459127*^9}, {3.665904331160164*^9, 
   3.665904331666333*^9}, 3.665904362019681*^9, {3.6659630920801916`*^9, 
   3.665963100083006*^9}, {3.665977412689808*^9, 3.6659774420517282`*^9}, {
   3.665977628139505*^9, 3.665977631313292*^9}, 3.6684735798973637`*^9, {
   3.6689698707900405`*^9, 3.6689698763183565`*^9}, {3.669069354908434*^9, 
   3.6690693605322227`*^9}}],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{{3.665903684879056*^9, 3.665903693440545*^9}, {
   3.665903968806595*^9, 3.665903986352631*^9}, 3.665904127937907*^9, 
   3.665904238033609*^9, 3.665904270621902*^9, {3.665904334826468*^9, 
   3.665904362300152*^9}, {3.665963092813393*^9, 3.6659631004418063`*^9}, {
   3.665977437301602*^9, 3.6659774429015617`*^9}, 3.665977632008773*^9, 
   3.666063002523841*^9, 3.668473605916071*^9, 3.6686375743323803`*^9, 
   3.6686630604829597`*^9, 3.6686987102748537`*^9, {3.668969872496138*^9, 
   3.6689698766463757`*^9}, 3.6690693613178053`*^9, 3.67004184831185*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[Xi]t3", " ", 
    RowBox[{"u", "[", "t", "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Xi]t0", "+", 
      RowBox[{"t", " ", "\[Xi]t3"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.665903684879056*^9, 3.665903693440545*^9}, {
   3.665903968806595*^9, 3.665903986352631*^9}, 3.665904127937907*^9, 
   3.665904238033609*^9, 3.665904270621902*^9, {3.665904334826468*^9, 
   3.665904362300152*^9}, {3.665963092813393*^9, 3.6659631004418063`*^9}, {
   3.665977437301602*^9, 3.6659774429015617`*^9}, 3.665977632008773*^9, 
   3.666063002523841*^9, 3.668473605916071*^9, 3.6686375743323803`*^9, 
   3.6686630604829597`*^9, 3.6686987102748537`*^9, {3.668969872496138*^9, 
   3.6689698766463757`*^9}, 3.6690693613178053`*^9, 3.670041848313052*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Adjoint", " ", "symmetries"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]1", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]u", "[", 
       RowBox[{"t", ",", 
        RowBox[{"u", "[", "t", "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"t", ",", 
         RowBox[{"u", "[", "t", "]"}]}], "]"}], "*", 
       RowBox[{
        RowBox[{"u", "'"}], "[", "t", "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", "\[CapitalDelta]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{"{", "u", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "\[CapitalLambda]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", "2", "]"}], "[", "u", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.668663068235463*^9, 3.6686630772290707`*^9}, {
  3.6689698911672063`*^9, 3.66896991081433*^9}, {3.669069379726108*^9, 
  3.669069411572743*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
       RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{
          "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
           RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.668663090523974*^9, 3.668663092644093*^9}, {
   3.6689699137254963`*^9, 3.6689699192458124`*^9}, 3.669069429274365*^9}],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{3.668663095032797*^9, 3.668698712650622*^9, 
  3.668969919878848*^9, 3.669069430084798*^9, 3.670041849901368*^9}],

Cell[BoxData[
 RowBox[{"{", 
  SubscriptBox["u", 
   RowBox[{"{", "1", "}"}]], "}"}]], "Output",
 CellChangeTimes->{3.668663095032797*^9, 3.668698712650622*^9, 
  3.668969919878848*^9, 3.669069430084798*^9, 3.6700418499445257`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.668663103091988*^9, 3.668663105043798*^9}, {
  3.6689699238940783`*^9, 3.66896992568618*^9}, {3.6690694369959*^9, 
  3.669069441939753*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.024263`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Zeta]t", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "u"}], "]"}], "\[Equal]", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.66866310529119*^9, 3.668698714048772*^9, 
  3.6689699266172338`*^9, 3.669069443320463*^9, 3.670041850889666*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t", "[", 
    RowBox[{"t_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Zeta]t1", "[", "t", "]"}], "+", 
    RowBox[{"u", "*", 
     RowBox[{"\[Zeta]t2", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668663107481901*^9, 3.668663126980598*^9}, {
  3.668969929125377*^9, 3.6689699319105363`*^9}, {3.66906944661968*^9, 
  3.6690694498517113`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.019242`", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["\[Zeta]t2", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
       RowBox[{
        SuperscriptBox["\[Psi]u", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "u"}], "]"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6686631248598747`*^9, 3.6686631273623753`*^9}, 
   3.6686987149177237`*^9, 3.6689699343786774`*^9, 3.669069451954541*^9, 
   3.670041851461248*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u", "[", 
    RowBox[{"t_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]u1", "[", "t", "]"}], "+", 
    RowBox[{"u", "*", 
     RowBox[{"\[Psi]u2", "[", "t", "]"}]}], "+", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Zeta]t2", "'"}], "[", "t", "]"}], "*", 
     RowBox[{"u", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"\"\<extras\>\"", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6686631302603693`*^9, 3.668663184947949*^9}, {
  3.6689699371338353`*^9, 3.6689699583580494`*^9}, {3.6690694553878593`*^9, 
  3.669069458955708*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.017799`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t2", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t2", "[", "t", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]u1", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668663175832614*^9, 3.668663185404221*^9}, 
   3.668698715554749*^9, 3.6689699603221617`*^9, 3.669069460552957*^9, 
   3.670041852083458*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t2", "[", "t_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u1", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Psi]u0", "+", 
    RowBox[{"\[Psi]u3", "*", "t"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668663187851081*^9, 3.6686632182920713`*^9}, {
  3.6689699662935033`*^9, 3.6689699781821833`*^9}, {3.6690694633478403`*^9, 
  3.669069473649724*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.01203`", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"\[Psi]u2", "[", "t", "]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Zeta]t1", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]u2", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Zeta]t1", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.668663215598288*^9, 3.6686632187578497`*^9}, 
   3.668698716223362*^9, 3.668969980178297*^9, 3.669069474313107*^9, 
   3.670041852833027*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u2", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"\[Zeta]t1", "'"}], "[", "t", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6686632265497437`*^9, 3.668663243523693*^9}, {
  3.6689699846375523`*^9, 3.6689699935180607`*^9}, {3.669069477835507*^9, 
  3.6690694843633413`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.009206`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Zeta]t1", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668663240671248*^9, 3.668663243980441*^9}, 
   3.6686987169102507`*^9, 3.668969996420226*^9, 3.669069484869341*^9, 
   3.6700418535456667`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t1", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Zeta]t0", "+", 
    RowBox[{"\[Zeta]t3", "*", "t"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668663246205806*^9, 3.668663272763653*^9}, {
  3.668969999333393*^9, 3.6689700074538574`*^9}, {3.669069487859683*^9, 
  3.669069499436057*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.006816`", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Psi]u0", "+", 
        RowBox[{"t", " ", "\[Psi]u3"}]}], "\[Equal]", "0"}], "}"}]}], "}"}]}],
   "}"}]], "Output",
 CellChangeTimes->{{3.668663270951332*^9, 3.668663273256764*^9}, 
   3.6686987175961237`*^9, 3.6689700087159295`*^9, {3.669069492476869*^9, 
   3.669069500199201*^9}, 3.670041854302408*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Psi]u0", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]u3", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", " ", "solvefor", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Flatten", "[", "Q", "]"}], "[", 
     RowBox[{"[", "i", "]"}], "]"}], "@@", 
    RowBox[{"Flatten", "[", 
     RowBox[{"var", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"Length", "[", 
      RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.668663276101758*^9, 3.668663288777882*^9}, {
  3.6689700118301077`*^9, 3.668970021253647*^9}, {3.6690695040192537`*^9, 
  3.6690695132738867`*^9}}],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 CellChangeTimes->{3.668663290922057*^9, 3.6686987184037724`*^9, 
  3.6689700218836827`*^9, 3.66906951361178*^9, 3.6700418549080687`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[Zeta]t3", " ", 
    RowBox[{"u", "[", "t", "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Zeta]t0", "+", 
      RowBox[{"t", " ", "\[Zeta]t3"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.668663290922057*^9, 3.6686987184037724`*^9, 
  3.6689700218836827`*^9, 3.66906951361178*^9, 3.670041854909244*^9}]
}, Open  ]]
},
WindowSize->{755, 848},
WindowMargins->{{Automatic, 147}, {Automatic, -10}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 265, 4, 32, "Input"],
Cell[826, 26, 2664, 62, 165, "Input"],
Cell[CellGroupData[{
Cell[3515, 92, 676, 13, 55, "Input"],
Cell[4194, 107, 1723, 26, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5954, 138, 572, 13, 32, "Input"],
Cell[6529, 153, 1146, 25, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7712, 183, 832, 21, 55, "Input"],
Cell[8547, 206, 1096, 26, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9680, 237, 765, 22, 37, "Input"],
Cell[10448, 261, 820, 22, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11305, 288, 1201, 31, 79, "Input"],
Cell[12509, 321, 1101, 26, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13647, 352, 1001, 25, 99, "Input"],
Cell[14651, 379, 1058, 28, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15746, 412, 1080, 26, 77, "Input"],
Cell[16829, 440, 694, 16, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17560, 461, 941, 22, 77, "Input"],
Cell[18504, 485, 622, 14, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19163, 504, 1415, 33, 143, "Input"],
Cell[20581, 539, 629, 9, 32, "Output"],
Cell[21213, 550, 952, 20, 35, "Output"]
}, Open  ]],
Cell[22180, 573, 1344, 40, 143, "Input"],
Cell[CellGroupData[{
Cell[23549, 617, 1546, 39, 187, "Input"],
Cell[25098, 658, 162, 2, 32, "Output"],
Cell[25263, 662, 231, 5, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25531, 672, 522, 13, 55, "Input"],
Cell[26056, 687, 563, 17, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26656, 709, 786, 21, 77, "Input"],
Cell[27445, 732, 738, 21, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28220, 758, 994, 27, 99, "Input"],
Cell[29217, 787, 916, 24, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30170, 816, 888, 24, 121, "Input"],
Cell[31061, 842, 918, 26, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32016, 873, 821, 23, 99, "Input"],
Cell[32840, 898, 483, 13, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33360, 916, 775, 20, 99, "Input"],
Cell[34138, 938, 454, 12, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34629, 955, 978, 25, 99, "Input"],
Cell[35610, 982, 188, 3, 32, "Output"],
Cell[35801, 987, 514, 14, 35, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
