(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     90164,       2587]
NotebookOptionsPosition[     87168,       2483]
NotebookOutlinePosition[     87507,       2498]
CellTagsIndexPosition[     87464,       2495]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input",
 CellChangeTimes->{{3.665859232344759*^9, 3.665859236735454*^9}, {
  3.665863815026243*^9, 3.665863849178424*^9}, {3.665863882380316*^9, 
  3.665863929521386*^9}, {3.665899891044674*^9, 3.66589989242861*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"PDE", " ", "we", " ", "seek", " ", "symmetries", " ", 
     RowBox[{"of", ".", "  ", "Assume"}], " ", "Ca"}], "\[NotEqual]", 
    RowBox[{"0", " ", "and", " ", "Ma"}], "\[NotEqual]", 
    RowBox[{"0", " ", 
     RowBox[{"here", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}], "+", 
      RowBox[{"Div", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], "*", 
         RowBox[{
          RowBox[{"H", "[", 
           RowBox[{"t", ",", "x", ",", "y"}], "]"}], "^", "2"}], "*", 
         RowBox[{"Grad", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]2", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}], "+", 
      RowBox[{"Div", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"H", "[", 
           RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "*", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], "*", 
         RowBox[{"Grad", "[", 
          RowBox[{
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Q1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]H", "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", 
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Xi]y", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Q2", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]\[CapitalGamma]", "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", 
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Xi]y", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", 
      RowBox[{"\[CapitalDelta]1", ",", "\[CapitalDelta]2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", 
      RowBox[{"Q1", ",", "Q2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "H", "]"}], ",", 
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "\[CapitalGamma]", 
        "]"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665859055545368*^9, 3.665859056670993*^9}, 
   3.665859222359338*^9, {3.6658595332618227`*^9, 3.665859535110145*^9}, {
   3.665859711964427*^9, 3.665859713110396*^9}, {3.665860496681065*^9, 
   3.6658605636404743`*^9}, {3.665860875037993*^9, 3.665860881549271*^9}, {
   3.665861046773204*^9, 3.665861049549117*^9}, {3.665861674569313*^9, 
   3.6658616967593813`*^9}, {3.6658620374299707`*^9, 3.665862049470551*^9}, {
   3.6658621101506977`*^9, 3.6658621268486853`*^9}, 3.665862225420937*^9, {
   3.665867355970107*^9, 3.6658674061107483`*^9}, {3.665867527086009*^9, 
   3.66586757559233*^9}, {3.66589959391077*^9, 3.6658996402035427`*^9}, {
   3.665900866678487*^9, 3.665900893474559*^9}, {3.668473700675427*^9, 
   3.668473700883802*^9}, {3.6689714232037096`*^9, 3.6689714882246237`*^9}, {
   3.669049040430524*^9, 3.6690490559498787`*^9}, {3.669066088467435*^9, 
   3.6690662197219877`*^9}, 3.669066262203952*^9, {3.669067667729012*^9, 
   3.669067669110918*^9}, {3.669070680492408*^9, 3.669070693571849*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
          "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.665860553384531*^9, 3.665860557223929*^9}, {
   3.665860738233917*^9, 3.665860740785784*^9}, {3.6658612774842663`*^9, 
   3.66586128001158*^9}, {3.665862134590067*^9, 3.6658621370127*^9}, {
   3.665863682232481*^9, 3.6658636923756037`*^9}, 3.668473687600627*^9, {
   3.668971501640648*^9, 3.6689715018278475`*^9}, 3.668997117766181*^9, {
   3.668997152676838*^9, 3.66899717269352*^9}, {3.6689972549302807`*^9, 
   3.668997257579402*^9}, {3.669050490556617*^9, 3.669050490779749*^9}, 
   3.669066244873149*^9}],

Cell[BoxData["569"], "Output",
 CellChangeTimes->{3.6687027159055853`*^9, 3.668809492243649*^9, 
  3.668829984464417*^9, 3.668971504791853*^9, 3.668974528368083*^9, 
  3.668997122699918*^9, 3.668997175578434*^9, 3.669049077324554*^9, 
  3.669066247393751*^9, 3.669066293189682*^9, 3.6690677190628643`*^9, 
  3.669070703859942*^9, 3.669072809523644*^9, 3.669146170869063*^9, 
  3.6691464377253113`*^9, 3.669419465560524*^9, 3.669420340779929*^9, 
  3.669420414967161*^9, 3.670042513612939*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "0"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{3.6687027159055853`*^9, 3.668809492243649*^9, 
  3.668829984464417*^9, 3.668971504791853*^9, 3.668974528368083*^9, 
  3.668997122699918*^9, 3.668997175578434*^9, 3.669049077324554*^9, 
  3.669066247393751*^9, 3.669066293189682*^9, 3.6690677190628643`*^9, 
  3.669070703859942*^9, 3.669072809523644*^9, 3.669146170869063*^9, 
  3.6691464377253113`*^9, 3.669419465560524*^9, 3.669420340779929*^9, 
  3.669420414967161*^9, 3.670042514138811*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.665883470602792*^9, 3.665883514147079*^9}, {
   3.6658835910581913`*^9, 3.665883603233927*^9}, {3.6660619422554617`*^9, 
   3.666061942662516*^9}, 3.6684736876272383`*^9, {3.668971506554656*^9, 
   3.6689715067730565`*^9}, {3.668973663046589*^9, 3.6689736633186045`*^9}, {
   3.669067756015327*^9, 3.6690677604553347`*^9}, {3.669070725288024*^9, 
   3.6690707374006157`*^9}, {3.669070938842251*^9, 3.669070939281798*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.79411`", ",", 
   RowBox[{"{", 
    RowBox[{"112", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6687032038555098`*^9, 3.668809577256764*^9, 
  3.668830060435491*^9, 3.6689716089857492`*^9, 3.6689746819888697`*^9, 
  3.669049265175214*^9, 3.669067922362994*^9, 3.669070748277071*^9, 
  3.669070942551956*^9, 3.669072813008795*^9, 3.669146173321128*^9, 
  3.669146440328278*^9, 3.669419469582308*^9, 3.66942034406861*^9, 
  3.669420418243546*^9, 3.670042517153438*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{"\[Xi]t1", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"t", ",", "x", ",", "y", ",", "\[CapitalGamma]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{"\[Xi]y1", "[", 
    RowBox[{"t", ",", "x", ",", "y", ",", "\[CapitalGamma]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]\[CapitalGamma]", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{"\[Phi]\[CapitalGamma]1", "[", 
    RowBox[{"t", ",", "x", ",", "y", ",", "\[CapitalGamma]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6690709448335447`*^9, 3.669071072640605*^9}, {
  3.669071143128234*^9, 3.669071174154991*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.497902`", ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "\[CapitalGamma]"}], "]"}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "\[CapitalGamma]"}], "]"}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "\[CapitalGamma]"}], "]"}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "\[CapitalGamma]"}], "]"}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "\[CapitalGamma]"}], "]"}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "\[CapitalGamma]"}], "]"}], 
        "\[Equal]", "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.669071175234535*^9, 3.66907281853612*^9, 
  3.669146173894775*^9, 3.6691464409208593`*^9, 3.669419474708606*^9, 
  3.6694203448067408`*^9, 3.669420418906604*^9, 3.6700425268242702`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "\[CapitalGamma]_"}], "]"}], ":=", 
   RowBox[{"\[Xi]x2", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "\[CapitalGamma]_"}], "]"}], ":=", 
   RowBox[{"\[Xi]y2", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]\[CapitalGamma]1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "\[CapitalGamma]_"}], "]"}], ":=", 
   RowBox[{"\[Phi]\[CapitalGamma]2", "[", 
    RowBox[{"t", ",", "\[CapitalGamma]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6690711790165167`*^9, 3.669071234808312*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.349444`", ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.669071236136208*^9, 3.6690728330763187`*^9, 
  3.6691461742617817`*^9, 3.669146441290881*^9, 3.669419479724367*^9, 
  3.66942034518954*^9, 3.669420419267661*^9, 3.670042529002342*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]\[CapitalGamma]2", "[", 
    RowBox[{"t_", ",", "\[CapitalGamma]_"}], "]"}], ":=", 
   RowBox[{"\[Phi]\[CapitalGamma]3", "+", 
    RowBox[{"\[CapitalGamma]", "*", "\[Phi]\[CapitalGamma]4"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x2", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"\[Xi]x3", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y2", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"\[Xi]y3", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{"\[Phi]H1", "[", 
    RowBox[{"x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669071242982814*^9, 3.669071393399287*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.328729`", ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x3", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}], "+", 
        RowBox[{
         SuperscriptBox["\[Xi]y3", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.66907135204846*^9, 3.669071393885854*^9}, 
   3.6690728547517767`*^9, 3.6691461746053953`*^9, 3.669146441638317*^9, 
   3.669419501235414*^9, 3.6694203460623093`*^9, 3.669420420149557*^9, 
   3.6700425304106493`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.178905`", ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]y3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]y3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"2", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}]}], ")"}]}], "\[Equal]", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
          "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]x3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"2", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}]}], ")"}]}], "\[Equal]", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
          "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]y3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]y3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"2", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}]}], ")"}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Phi]H1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], "]"}]}], 
       ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]x3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"2", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}]}], ")"}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Phi]H1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], "]"}]}]}],
       "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.66907135204846*^9, 3.669071393885854*^9}, 
   3.6690728547517767`*^9, 3.6691461746053953`*^9, 3.669146441638317*^9, 
   3.669419501235414*^9, 3.6694203460623093`*^9, 3.669420420149557*^9, 
   3.670042530592415*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H1", "[", 
    RowBox[{"x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], "]"}], ":=", 
   RowBox[{"\[Phi]H2", "[", 
    RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "5", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669071413943808*^9, 3.669071465159025*^9}, {
  3.669071502941162*^9, 3.669071507382662*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.257159`", ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "H", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y"}], "]"}]}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]H2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"\[Phi]H2", "[", 
          RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}], "+", 
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"\[Phi]\[CapitalGamma]4", "+", 
            RowBox[{
             SuperscriptBox["\[Xi]t1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], ")"}]}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]H2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}], "+", 
         RowBox[{"2", " ", "H", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y"}], "]"}]}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"\[Phi]H2", "[", 
          RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}], "+", 
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"\[Phi]\[CapitalGamma]4", "+", 
            RowBox[{
             SuperscriptBox["\[Xi]t1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], ")"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Phi]\[CapitalGamma]3", "+", 
         RowBox[{"\[CapitalGamma]", " ", "\[Phi]\[CapitalGamma]4"}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]t1", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]H2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], "\[Equal]", 
        RowBox[{"2", " ", "\[CapitalGamma]", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Phi]\[CapitalGamma]3", "+", 
         RowBox[{"\[CapitalGamma]", " ", "\[Phi]\[CapitalGamma]4"}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]t1", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]H2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], "\[Equal]", 
        RowBox[{"2", " ", "\[CapitalGamma]", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", "\[Phi]\[CapitalGamma]4"}], "+", 
         RowBox[{"\[Phi]H2", "[", 
          RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}], "+", 
         RowBox[{"H", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]t1", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]H2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], "\[Equal]", 
        RowBox[{"2", " ", "H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{"\[Phi]H2", "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}], "+", 
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"\[Phi]\[CapitalGamma]3", "+", 
            RowBox[{"\[CapitalGamma]", " ", "\[Phi]\[CapitalGamma]4"}], "+", 
            RowBox[{"\[CapitalGamma]", " ", 
             RowBox[{
              SuperscriptBox["\[Xi]t1", "\[Prime]",
               MultilineFunction->None], "[", "t", "]"}]}], "-", 
            RowBox[{"2", " ", "\[CapitalGamma]", " ", 
             RowBox[{
              SuperscriptBox["\[Xi]y3", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"x", ",", "y"}], "]"}]}]}], ")"}]}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", "\[Phi]\[CapitalGamma]4"}], "+", 
         RowBox[{"\[Phi]H2", "[", 
          RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}], "+", 
         RowBox[{"H", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]t1", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]H2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], "\[Equal]", 
        RowBox[{"2", " ", "H", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{"\[Phi]H2", "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}], "+", 
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"\[Phi]\[CapitalGamma]3", "+", 
            RowBox[{"\[CapitalGamma]", " ", "\[Phi]\[CapitalGamma]4"}], "+", 
            RowBox[{"\[CapitalGamma]", " ", 
             RowBox[{
              SuperscriptBox["\[Xi]t1", "\[Prime]",
               MultilineFunction->None], "[", "t", "]"}]}], "-", 
            RowBox[{"2", " ", "\[CapitalGamma]", " ", 
             RowBox[{
              SuperscriptBox["\[Xi]x3", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"x", ",", "y"}], "]"}]}]}], ")"}]}]}], "\[Equal]", 
        "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.669071461385812*^9, 3.669071465562265*^9}, {
   3.669071503381669*^9, 3.66907150782835*^9}, 3.6690729972016373`*^9, 
   3.66914617513271*^9, 3.669146442170726*^9, 3.669419548670988*^9, 
   3.669420347545753*^9, 3.669420421752883*^9, 3.670042531901855*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t1", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Xi]t0", "+", 
    RowBox[{"\[Xi]t2", "*", "t"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x3", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x4", "[", "y", "]"}], "+", 
    RowBox[{"\[Xi]x5", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y3", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]y4", "[", "x", "]"}], "+", 
    RowBox[{"\[Xi]y5", "*", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669071670138207*^9, 3.669071749828835*^9}, {
   3.669071819739768*^9, 3.669071826597145*^9}, {3.6690730675877533`*^9, 
   3.6690731060201063`*^9}, {3.669419828450354*^9, 3.669419829650733*^9}, {
   3.6694199238338614`*^9, 3.6694199745286207`*^9}, 3.669420013001783*^9, {
   3.669420326447709*^9, 3.66942032663901*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.312329`", ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y4", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x4", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "y", "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.669071816874992*^9, 3.6690718272379513`*^9}, {
   3.6690730954612627`*^9, 3.669073106553499*^9}, 3.669146175470283*^9, 
   3.6691464425042887`*^9, {3.669420003110612*^9, 3.669420013479919*^9}, 
   3.669420348946657*^9, 3.669420422961774*^9, 3.670042533579953*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x4", "[", "y_", "]"}], ":=", 
   RowBox[{"\[Xi]x0", "+", 
    RowBox[{"\[Xi]x6", "*", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y4", "[", "x_", "]"}], ":=", 
   RowBox[{"\[Xi]y0", "+", 
    RowBox[{"\[Xi]y6", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669420017332078*^9, 3.669420085960155*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.206116`", ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Xi]x6", "+", "\[Xi]y6"}], "\[Equal]", "0"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6694200866409883`*^9, 3.669420350115206*^9, 
  3.669420424266474*^9, 3.670042534444146*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Xi]x6", ":=", "c"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]y6", ":=", 
   RowBox[{"-", "c"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "5", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669420088960174*^9, 3.669420126073326*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.174952`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]t2", "-", 
            RowBox[{"2", " ", "\[Xi]y5"}], "+", "\[Phi]\[CapitalGamma]4"}], 
           ")"}]}], "+", 
         RowBox[{"\[Phi]H2", "[", 
          RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}], "\[Equal]", 
        RowBox[{"\[CapitalGamma]", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]t2", "-", 
            RowBox[{"2", " ", "\[Xi]x5"}], "+", "\[Phi]\[CapitalGamma]4"}], 
           ")"}]}], "+", 
         RowBox[{"\[Phi]H2", "[", 
          RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}], "\[Equal]", 
        RowBox[{"\[CapitalGamma]", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Phi]\[CapitalGamma]3", "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]t2", "-", 
            RowBox[{"2", " ", "\[Xi]y5"}], "+", "\[Phi]\[CapitalGamma]4"}], 
           ")"}]}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]H2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"\[Phi]\[CapitalGamma]3", "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]t2", "-", 
            RowBox[{"2", " ", "\[Xi]x5"}], "+", "\[Phi]\[CapitalGamma]4"}], 
           ")"}]}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]H2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]t2", "-", 
            RowBox[{"2", " ", "\[Xi]y5"}], "+", "\[Phi]\[CapitalGamma]4"}], 
           ")"}]}], "+", 
         RowBox[{"\[Phi]H2", "[", 
          RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]H2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"\[Phi]\[CapitalGamma]3", "+", 
            RowBox[{"\[CapitalGamma]", " ", 
             RowBox[{"(", 
              RowBox[{"\[Xi]t2", "-", 
               RowBox[{"2", " ", "\[Xi]y5"}], "+", "\[Phi]\[CapitalGamma]4"}],
               ")"}]}]}], ")"}]}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{"\[Phi]H2", "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]t2", "-", 
            RowBox[{"2", " ", "\[Xi]x5"}], "+", "\[Phi]\[CapitalGamma]4"}], 
           ")"}]}], "+", 
         RowBox[{"\[Phi]H2", "[", 
          RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]H2", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H", " ", 
          RowBox[{"(", 
           RowBox[{"\[Phi]\[CapitalGamma]3", "+", 
            RowBox[{"\[CapitalGamma]", " ", 
             RowBox[{"(", 
              RowBox[{"\[Xi]t2", "-", 
               RowBox[{"2", " ", "\[Xi]x5"}], "+", "\[Phi]\[CapitalGamma]4"}],
               ")"}]}]}], ")"}]}], "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{"\[Phi]H2", "[", 
           RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], "\[Equal]", 
        "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.669420108317041*^9, 3.6694201265043917`*^9}, 
   3.669420251212179*^9, 3.669420351593483*^9, 3.66942042492774*^9, 
   3.67004253548244*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{"\[Phi]\[CapitalGamma]3", "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]t2", "-", 
            RowBox[{"2", " ", "\[Xi]x5"}], "+", "\[Phi]\[CapitalGamma]4"}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{"\[CapitalGamma]", " ", 
       RowBox[{"\[Phi]H2", "[", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}]}], "\[Equal]", "0"}], 
    ",", 
    RowBox[{"\[Phi]H2", "[", 
     RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.669420255027122*^9, 3.669420288527483*^9}, 
   3.669420367832554*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]H2", "[", 
     RowBox[{"H", ",", "\[CapitalGamma]"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"H", " ", 
       RowBox[{"(", 
        RowBox[{"\[Phi]\[CapitalGamma]3", "+", 
         RowBox[{"\[CapitalGamma]", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]t2", "-", 
            RowBox[{"2", " ", "\[Xi]x5"}], "+", "\[Phi]\[CapitalGamma]4"}], 
           ")"}]}]}], ")"}]}], "\[CapitalGamma]"]}]}], "}"}], "}"}]], "Output",\

 CellChangeTimes->{{3.669420270216022*^9, 3.6694202888293123`*^9}, {
   3.66942035301437*^9, 3.66942038100076*^9}, 3.6694204264323606`*^9, 
   3.6700425368615932`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H2", "[", 
    RowBox[{"H_", ",", "\[CapitalGamma]_"}], "]"}], ":=", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"H", " ", 
      RowBox[{"(", 
       RowBox[{"\[Phi]\[CapitalGamma]3", "+", 
        RowBox[{"\[CapitalGamma]", " ", 
         RowBox[{"(", 
          RowBox[{"\[Xi]t2", "-", 
           RowBox[{"2", " ", "\[Xi]x5"}], "+", "\[Phi]\[CapitalGamma]4"}], 
          ")"}]}]}], ")"}]}], "\[CapitalGamma]"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6694203020549383`*^9, 3.669420308022852*^9}, {
   3.66942038460039*^9, 3.66942038954294*^9}, 3.669420434007279*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.172623`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]\[CapitalGamma]3", "\[Equal]", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.669420391864539*^9, {3.669420428267273*^9, 3.6694204344452887`*^9}, 
   3.670042538139798*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Phi]\[CapitalGamma]3", ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Part", "[", 
  RowBox[{
   RowBox[{"FindEquations", "[", 
    RowBox[{
    "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"H", ">", "0"}], "&&", 
       RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6694204395258017`*^9, 3.669420474728441*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]x5", "\[Equal]", "\[Xi]y5"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.669420444583851*^9, 3.66942047535916*^9}, 
   3.6700425390201063`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Xi]x5", ":=", "b"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]y5", ":=", "b"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Flatten", "[", "Q", "]"}], "[", 
      RowBox[{"[", "i", "]"}], "]"}], "@@", 
     RowBox[{"Flatten", "[", 
      RowBox[{"var", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", 
       RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.669420477229166*^9, 3.669420555756755*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.669420499693315*^9, 3.6694205118417587`*^9}, {
   3.669420542324011*^9, 3.669420557487382*^9}, 3.670042539744431*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "b"}], "+", "\[Xi]t2", "+", 
        "\[Phi]\[CapitalGamma]4"}], ")"}]}], " ", 
     RowBox[{"H", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "x"}], "+", 
       RowBox[{"b", " ", "y"}], "+", "\[Xi]y0"}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["H", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", "y"}], "+", "\[Xi]x0"}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["H", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Xi]t0", "+", 
       RowBox[{"t", " ", "\[Xi]t2"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["H", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"\[Phi]\[CapitalGamma]4", " ", 
     RowBox[{"\[CapitalGamma]", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "x"}], "+", 
       RowBox[{"b", " ", "y"}], "+", "\[Xi]y0"}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["\[CapitalGamma]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", "y"}], "+", "\[Xi]x0"}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["\[CapitalGamma]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Xi]t0", "+", 
       RowBox[{"t", " ", "\[Xi]t2"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["\[CapitalGamma]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.669420499693315*^9, 3.6694205118417587`*^9}, {
   3.669420542324011*^9, 3.669420557487382*^9}, 3.6700425397661133`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Adjoint", " ", "symmetries"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]H", "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", 
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Zeta]y", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]2", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]\[CapitalGamma]", "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", 
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Zeta]y", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", 
      RowBox[{"\[CapitalLambda]1", ",", "\[CapitalLambda]2"}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "H", "]"}], ",", 
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "\[CapitalGamma]", 
        "]"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6686638019496117`*^9, 3.668663803101708*^9}, {
  3.668664733898097*^9, 3.6686647759376383`*^9}, {3.6689735580245824`*^9, 
  3.66897360239212*^9}, {3.669049568843058*^9, 3.669049585362678*^9}, {
  3.669068281160613*^9, 3.669068322444429*^9}, {3.669073572456519*^9, 
  3.669073656288074*^9}, {3.669146093751912*^9, 3.669146158710567*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
       RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{
          "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
           RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.669146210198576*^9, 3.6691462201662073`*^9}}],

Cell[BoxData["753"], "Output",
 CellChangeTimes->{3.669146221064579*^9, 3.669146444041361*^9, 
  3.669420802106896*^9, 3.670042541678369*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "4"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "0"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{3.669146221064579*^9, 3.669146444041361*^9, 
  3.669420802106896*^9, 3.670042542229443*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.669146237349506*^9, 3.669146241701874*^9}, {
  3.669420809795762*^9, 3.6694208113956413`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.521928`", ",", 
   RowBox[{"{", 
    RowBox[{"127", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Zeta]t", "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]x", "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]y", "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.669146248800577*^9, 3.669146447379387*^9, 
  3.669420814913774*^9, 3.6700425457350883`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]y", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6691462791492558`*^9, 3.6691463020221987`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.210018`", ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]\[CapitalGamma]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.669146284500834*^9, 3.669146302741593*^9}, 
   3.669146447627964*^9, 3.669420821761633*^9, 3.670042547021734*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]\[CapitalGamma]", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{"\[Psi]\[CapitalGamma]1", "[", 
    RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{"\[Psi]H1", "[", 
    RowBox[{"x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6691463082348747`*^9, 3.6691463653011723`*^9}, {
  3.669146418901265*^9, 3.6691464192690697`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.166085`", ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Psi]H1", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], "]"}], 
       "\[Equal]", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.669146354183002*^9, 3.6691463659391537`*^9}, {
   3.669146420024108*^9, 3.669146447823296*^9}, 3.669420830536174*^9, 
   3.670042547819043*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H1", "[", 
    RowBox[{"x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]H2", "[", 
     RowBox[{"x", ",", "y", ",", "H"}], "]"}], "+", 
    RowBox[{"\[CapitalGamma]", "*", 
     RowBox[{"\[Psi]H3", "[", 
      RowBox[{"x", ",", "y", ",", "H"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6691463572980633`*^9, 3.6691464227970867`*^9}, {
  3.669146470845303*^9, 3.6691464742926073`*^9}, {3.669420872644013*^9, 
  3.669420877492301*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.198278`", ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Psi]H3", "[", 
         RowBox[{"x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Psi]\[CapitalGamma]1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]H3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]\[CapitalGamma]1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Psi]H3", "[", 
          RowBox[{"x", ",", "y", ",", "H"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Psi]\[CapitalGamma]1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]H3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Psi]\[CapitalGamma]1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}]}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6691463947642736`*^9, 3.669146474830181*^9}, 
   3.66942083725309*^9, {3.669420872950301*^9, 3.6694208777908773`*^9}, 
   3.670042548657218*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]\[CapitalGamma]1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", 
   RowBox[{"\[Psi]\[CapitalGamma]2", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H3", "[", 
    RowBox[{"x_", ",", "y_", ",", "H_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6691464539356813`*^9, 3.669146495468609*^9}, {
  3.669146527588285*^9, 3.669146551739785*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.114329`", ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y", ",", "H"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]\[CapitalGamma]2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]\[CapitalGamma]2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.669146552491181*^9, 3.669420924145957*^9, 
  3.670042549523285*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H2", "[", 
    RowBox[{"x_", ",", "y_", ",", "H_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H4", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]\[CapitalGamma]2", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"\[Psi]\[CapitalGamma]3", "[", "t", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"H", ">", "0"}], "&&", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669146559603496*^9, 3.669146607948985*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.046622`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]\[CapitalGamma]3", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.669146589906537*^9, 3.669146608335966*^9}, 
   3.6694209351588707`*^9, 3.670042550264069*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]\[CapitalGamma]3", "[", "t_", "]"}], ":=", 
   "\[Psi]\[CapitalGamma]0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H4", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", "\[Psi]H0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
    RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Flatten", "[", "Q", "]"}], "[", 
      RowBox[{"[", "i", "]"}], "]"}], "@@", 
     RowBox[{"Flatten", "[", 
      RowBox[{"var", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", 
       RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6691466130539293`*^9, 3.6691466961472*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.669146642200356*^9, 3.669146696480401*^9}, 
   3.6694209459860353`*^9, 3.670042550819805*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Psi]H0", ",", "\[Psi]\[CapitalGamma]0"}], "}"}]], "Output",
 CellChangeTimes->{{3.669146642200356*^9, 3.669146696480401*^9}, 
   3.6694209459860353`*^9, 3.670042550821095*^9}]
}, Open  ]]
},
WindowSize->{755, 848},
WindowMargins->{{Automatic, 10}, {Automatic, -10}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 265, 4, 32, "Input"],
Cell[826, 26, 7700, 198, 429, "Input"],
Cell[CellGroupData[{
Cell[8551, 228, 1829, 43, 165, "Input"],
Cell[10383, 273, 492, 7, 32, "Output"],
Cell[10878, 282, 1957, 51, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12872, 338, 905, 19, 77, "Input"],
Cell[13780, 359, 3539, 92, 131, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17356, 456, 1664, 45, 165, "Input"],
Cell[19023, 503, 2507, 69, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21567, 577, 1285, 35, 143, "Input"],
Cell[22855, 614, 1998, 56, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24890, 675, 1944, 54, 231, "Input"],
Cell[26837, 731, 949, 28, 37, "Output"],
Cell[27789, 761, 4380, 128, 135, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32206, 894, 824, 22, 99, "Input"],
Cell[33033, 918, 8308, 218, 227, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41378, 1141, 1414, 37, 143, "Input"],
Cell[42795, 1180, 789, 19, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43621, 1204, 861, 24, 121, "Input"],
Cell[44485, 1230, 349, 10, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44871, 1245, 698, 19, 121, "Input"],
Cell[45572, 1266, 5320, 145, 198, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50929, 1416, 773, 21, 32, "Input"],
Cell[51705, 1439, 708, 19, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52450, 1463, 1124, 31, 146, "Input"],
Cell[53577, 1496, 333, 10, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53947, 1511, 563, 14, 77, "Input"],
Cell[54513, 1527, 234, 6, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54784, 1538, 869, 24, 121, "Input"],
Cell[55656, 1564, 213, 4, 32, "Output"],
Cell[55872, 1570, 3024, 96, 108, "Output"]
}, Open  ]],
Cell[58911, 1669, 4904, 128, 275, "Input"],
Cell[CellGroupData[{
Cell[63840, 1801, 1472, 38, 187, "Input"],
Cell[65315, 1841, 141, 2, 32, "Output"],
Cell[65459, 1845, 2306, 67, 82, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67802, 1917, 630, 16, 77, "Input"],
Cell[68435, 1935, 4890, 130, 177, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73362, 2070, 1137, 30, 143, "Input"],
Cell[74502, 2102, 1058, 28, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75597, 2135, 1212, 32, 121, "Input"],
Cell[76812, 2169, 655, 18, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77504, 2192, 1067, 28, 99, "Input"],
Cell[78574, 2222, 2594, 72, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81205, 2299, 1034, 28, 121, "Input"],
Cell[82242, 2329, 1214, 36, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83493, 2370, 1114, 30, 121, "Input"],
Cell[84610, 2402, 1037, 31, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85684, 2438, 1056, 30, 121, "Input"],
Cell[86743, 2470, 189, 4, 32, "Output"],
Cell[86935, 2476, 217, 4, 32, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
