(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    163392,       4744]
NotebookOptionsPosition[    159142,       4602]
NotebookOutlinePosition[    159479,       4617]
CellTagsIndexPosition[    159436,       4614]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input",
 CellChangeTimes->{{3.665859232344759*^9, 3.665859236735454*^9}, {
  3.665863815026243*^9, 3.665863849178424*^9}, {3.665863882380316*^9, 
  3.665863929521386*^9}, {3.665899891044674*^9, 3.66589989242861*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"PDE", " ", "we", " ", "seek", " ", "symmetries", " ", 
     RowBox[{"of", ".", "  ", "Assume"}], " ", "Ca"}], "\[NotEqual]", 
    RowBox[{"0", " ", "and", " ", "Ma"}], "\[NotEqual]", 
    RowBox[{"0", " ", 
     RowBox[{"here", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}], "+", 
      RowBox[{"Div", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Ca", "/", "3"}], "*", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}], "^", "3"}], "*", 
          RowBox[{"Grad", "[", 
           RowBox[{
            RowBox[{"Laplacian", "[", 
             RowBox[{
              RowBox[{"H", "[", 
               RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "-", 
         RowBox[{
          RowBox[{"Ma", "/", "2"}], "*", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}], "^", "2"}], "*", 
          RowBox[{"Grad", "[", 
           RowBox[{
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]2", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}], "+", 
      RowBox[{"Div", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Ca", "/", "2"}], "*", 
          RowBox[{
           RowBox[{"H", "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}], "^", "2"}], "*", 
          RowBox[{"\[CapitalGamma]", "[", 
           RowBox[{"t", ",", "x", ",", "y"}], "]"}], "*", 
          RowBox[{"Grad", "[", 
           RowBox[{
            RowBox[{"Laplacian", "[", 
             RowBox[{
              RowBox[{"H", "[", 
               RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "-", 
         RowBox[{"Ma", "*", 
          RowBox[{"H", "[", 
           RowBox[{"t", ",", "x", ",", "y"}], "]"}], "*", 
          RowBox[{"\[CapitalGamma]", "[", 
           RowBox[{"t", ",", "x", ",", "y"}], "]"}], "*", 
          RowBox[{"Grad", "[", 
           RowBox[{
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "-", 
         RowBox[{"Pe", "*", 
          RowBox[{"Grad", "[", 
           RowBox[{
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Q1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]H", "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", 
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Xi]y", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Q2", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]\[CapitalGamma]", "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", 
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Xi]y", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", 
      RowBox[{"\[CapitalDelta]1", ",", "\[CapitalDelta]2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", 
      RowBox[{"Q1", ",", "Q2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "H", "]"}], ",", 
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "\[CapitalGamma]", 
        "]"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665859055545368*^9, 3.665859056670993*^9}, 
   3.665859222359338*^9, {3.6658595332618227`*^9, 3.665859535110145*^9}, {
   3.665859711964427*^9, 3.665859713110396*^9}, {3.665860496681065*^9, 
   3.6658605636404743`*^9}, {3.665860875037993*^9, 3.665860881549271*^9}, {
   3.665861046773204*^9, 3.665861049549117*^9}, {3.665861674569313*^9, 
   3.6658616967593813`*^9}, {3.6658620374299707`*^9, 3.665862049470551*^9}, {
   3.6658621101506977`*^9, 3.6658621268486853`*^9}, 3.665862225420937*^9, {
   3.665867355970107*^9, 3.6658674061107483`*^9}, {3.665867527086009*^9, 
   3.66586757559233*^9}, {3.66589959391077*^9, 3.6658996402035427`*^9}, {
   3.665900866678487*^9, 3.665900893474559*^9}, {3.668473700675427*^9, 
   3.668473700883802*^9}, {3.6689714232037096`*^9, 3.6689714882246237`*^9}, {
   3.669049040430524*^9, 3.6690490559498787`*^9}, {3.669066088467435*^9, 
   3.6690662197219877`*^9}, 3.669066262203952*^9, {3.669067667729012*^9, 
   3.669067669110918*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
          "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.665860553384531*^9, 3.665860557223929*^9}, {
   3.665860738233917*^9, 3.665860740785784*^9}, {3.6658612774842663`*^9, 
   3.66586128001158*^9}, {3.665862134590067*^9, 3.6658621370127*^9}, {
   3.665863682232481*^9, 3.6658636923756037`*^9}, 3.668473687600627*^9, {
   3.668971501640648*^9, 3.6689715018278475`*^9}, 3.668997117766181*^9, {
   3.668997152676838*^9, 3.66899717269352*^9}, {3.6689972549302807`*^9, 
   3.668997257579402*^9}, {3.669050490556617*^9, 3.669050490779749*^9}, 
   3.669066244873149*^9}],

Cell[BoxData["18814"], "Output",
 CellChangeTimes->{
  3.6687027159055853`*^9, 3.668809492243649*^9, 3.668829984464417*^9, 
   3.668971504791853*^9, 3.668974528368083*^9, 3.668997122699918*^9, 
   3.668997175578434*^9, 3.669049077324554*^9, 3.669066247393751*^9, 
   3.669066293189682*^9, 3.6690677190628643`*^9, {3.669417331326315*^9, 
   3.669417352939662*^9}, 3.670041900312422*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "6"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "7"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "6"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "7", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "4"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "5"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "4"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "3"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "0"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6687027159055853`*^9, 3.668809492243649*^9, 3.668829984464417*^9, 
   3.668971504791853*^9, 3.668974528368083*^9, 3.668997122699918*^9, 
   3.668997175578434*^9, 3.669049077324554*^9, 3.669066247393751*^9, 
   3.669066293189682*^9, 3.6690677190628643`*^9, {3.669417331326315*^9, 
   3.669417352939662*^9}, 3.670041930041778*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.665883470602792*^9, 3.665883514147079*^9}, {
   3.6658835910581913`*^9, 3.665883603233927*^9}, {3.6660619422554617`*^9, 
   3.666061942662516*^9}, 3.6684736876272383`*^9, {3.668971506554656*^9, 
   3.6689715067730565`*^9}, {3.668973663046589*^9, 3.6689736633186045`*^9}, {
   3.669067756015327*^9, 3.6690677604553347`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"117.940048`", ",", 
   RowBox[{"{", 
    RowBox[{"1835", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "4"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "4"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "4"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6687032038555098`*^9, 3.668809577256764*^9, 
  3.668830060435491*^9, 3.6689716089857492`*^9, 3.6689746819888697`*^9, 
  3.669049265175214*^9, 3.669067922362994*^9, 3.669417509473*^9, 
  3.67004204809869*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{"\[Xi]t1", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x1", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
    RowBox[{"\[CapitalGamma]", "*", 
     RowBox[{"\[Xi]x2", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]y1", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
    RowBox[{"\[CapitalGamma]", "*", 
     RowBox[{"\[Xi]y2", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]H1", "[", 
     RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "+", 
    RowBox[{"\[CapitalGamma]", "*", 
     RowBox[{"\[Phi]H2", "[", 
      RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665900989236212*^9, 3.6659010338552322`*^9}, {
   3.6659011205266323`*^9, 3.665901199415797*^9}, {3.6660621013105392`*^9, 
   3.666062101542687*^9}, 3.6660621393867493`*^9, 3.668473687648332*^9, {
   3.668973359470226*^9, 3.6689733596302347`*^9}, {3.6689736673028326`*^9, 
   3.668973667533846*^9}, {3.669067991405895*^9, 3.669067996317183*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"13.184522`", ",", 
   RowBox[{"{", 
    RowBox[{"176", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Xi]y2", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Xi]x2", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"\[Phi]H2", "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668703250582779*^9, 3.6688097666896067`*^9, 
  3.668830120450753*^9, 3.668973379843391*^9, 3.668974695548645*^9, 
  3.66904943190738*^9, 3.669068020523118*^9, 3.66941766876939*^9, 
  3.670042074112019*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x2", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y2", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H2", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665901211748536*^9, 3.6659012586473627`*^9}, {
   3.66606210999121*^9, 3.666062110248188*^9}, 3.6684736876528177`*^9, {
   3.6689733959813137`*^9, 3.6689733961903257`*^9}, {3.668973670374008*^9, 
   3.6689736707260284`*^9}, {3.669068026709309*^9, 3.669068030654023*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.512556`", ",", 
   RowBox[{"{", 
    RowBox[{"89", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668703286782745*^9, 3.66880977677633*^9, 
  3.668830125367185*^9, 3.6689734003605647`*^9, 3.6689747005549316`*^9, 
  3.66904944905029*^9, 3.669068040419078*^9, 3.6694176917236013`*^9, 
  3.670042081301929*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]\[CapitalGamma]", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]\[CapitalGamma]1", "[", 
     RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "+", 
    RowBox[{"\[CapitalGamma]", "*", 
     RowBox[{"\[Phi]\[CapitalGamma]2", "[", 
      RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]H3", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
    RowBox[{"H", "*", 
     RowBox[{"\[Phi]H4", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "\[CapitalGamma]", "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665901265277761*^9, 3.665901359038404*^9}, 
   3.665901481807621*^9, {3.665901533263197*^9, 3.665901534277759*^9}, {
   3.666062113789454*^9, 3.6660621156459713`*^9}, 3.668473687655402*^9, {
   3.6687068831845217`*^9, 3.668706886855928*^9}, {3.668973398813476*^9, 
   3.6689734027497015`*^9}, {3.668973673078163*^9, 3.6689736732941756`*^9}, {
   3.669068037619609*^9, 3.6690680420935802`*^9}, 3.66914710420831*^9, {
   3.67004208196835*^9, 3.670042083809237*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.248093`", ",", 
   RowBox[{"{", 
    RowBox[{"83", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]\[CapitalGamma]1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]\[CapitalGamma]1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]\[CapitalGamma]1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]\[CapitalGamma]1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}]}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668703286870276*^9, 3.668809789071636*^9, 
  3.668830129871057*^9, 3.668973408835049*^9, 3.6689747052472*^9, 
  3.6690494714222593`*^9, 3.669068050592123*^9, 3.669417721730976*^9, 
  3.670042092799324*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]\[CapitalGamma]1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", 
   RowBox[{"\[Phi]\[CapitalGamma]3", "[", 
    RowBox[{"t", ",", "H"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]\[CapitalGamma]2", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", 
   RowBox[{"\[Phi]\[CapitalGamma]4", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "\[CapitalGamma]", "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665901376583066*^9, 3.66590138569154*^9}, {
   3.665901570467246*^9, 3.665901571012411*^9}, {3.6660622165245333`*^9, 
   3.666062219360395*^9}, 3.66847368765781*^9, 3.668706891600582*^9, {
   3.668973411262188*^9, 3.6689734142943616`*^9}, {3.668973676014331*^9, 
   3.6689736761583395`*^9}, {3.669068047259636*^9, 3.669068054701559*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.855225`", ",", 
   RowBox[{"{", 
    RowBox[{"67", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]\[CapitalGamma]3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "H"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]\[CapitalGamma]3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "H"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]3", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H"}], "]"}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668703286919984*^9, 3.668809818804954*^9, 
  3.668830133500209*^9, 3.668973420091693*^9, 3.668974709390437*^9, 
  3.669049482798348*^9, 3.669068061508851*^9, 3.669417758941711*^9, 
  3.6700421024556923`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]\[CapitalGamma]3", "[", 
    RowBox[{"t_", ",", "H_"}], "]"}], ":=", 
   RowBox[{"\[Phi]\[CapitalGamma]5", "[", "H", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]\[CapitalGamma]4", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"\[Phi]\[CapitalGamma]6", "[", "t", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "\[CapitalGamma]", "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665901585563367*^9, 3.665901648155126*^9}, {
   3.6659016807484217`*^9, 3.66590168114767*^9}, {3.666062230924429*^9, 
   3.666062232141211*^9}, 3.668473687659988*^9, 3.668706893856371*^9, {
   3.6689734194136543`*^9, 3.6689734222538166`*^9}, {3.6689736787824893`*^9, 
   3.6689736789905014`*^9}, {3.669068064141159*^9, 3.669068067406554*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.708093`", ",", 
   RowBox[{"{", 
    RowBox[{"63", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Phi]\[CapitalGamma]5", "[", "H", "]"}]}], "\[Equal]", 
        RowBox[{"H", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]\[CapitalGamma]5", "\[Prime]",
           MultilineFunction->None], "[", "H", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"\[Phi]\[CapitalGamma]5", "[", "H", "]"}]}], "\[Equal]", 
        RowBox[{"2", " ", "H", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]\[CapitalGamma]5", "\[Prime]",
           MultilineFunction->None], "[", "H", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]y1", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ")"}]}], "\[Equal]", 
        "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668703286966312*^9, 3.668809835715425*^9, 
  3.668830136563059*^9, 3.668973426365052*^9, 3.6689747135196733`*^9, 
  3.669049492431999*^9, 3.669068073975238*^9, 3.669417786316845*^9, 
  3.6700421108277683`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"\[Phi]\[CapitalGamma]5", "[", "H", "]"}]}], "\[Equal]", 
    RowBox[{"2", " ", "H", " ", 
     RowBox[{
      SuperscriptBox["\[Phi]\[CapitalGamma]5", "\[Prime]",
       MultilineFunction->None], "[", "H", "]"}]}]}], ",", 
   RowBox[{"\[Phi]\[CapitalGamma]5", "[", "H", "]"}], ",", "H"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"\[Phi]\[CapitalGamma]5", "[", "H", "]"}]}], "\[Equal]", 
    RowBox[{"H", " ", 
     RowBox[{
      SuperscriptBox["\[Phi]\[CapitalGamma]5", "\[Prime]",
       MultilineFunction->None], "[", "H", "]"}]}]}], ",", 
   RowBox[{"\[Phi]\[CapitalGamma]5", "[", "H", "]"}], ",", "H"}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.6659017143538446`*^9, {3.669417862008876*^9, 3.669417876017983*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]\[CapitalGamma]5", "[", "H", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["H", 
      RowBox[{"3", "/", "2"}]], " ", 
     RowBox[{"C", "[", "1", "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.668703287021124*^9, 3.668809847170341*^9, 
  3.6688301380883837`*^9, 3.6689734285051746`*^9, 3.6689747143497205`*^9, 
  3.6690494952440777`*^9, 3.669068074099*^9, 3.669417805049094*^9, 
  3.669417876916155*^9, 3.670042111808014*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Phi]\[CapitalGamma]5", "[", "H", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["H", "2"], " ", 
     RowBox[{"C", "[", "1", "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.668703287021124*^9, 3.668809847170341*^9, 
  3.6688301380883837`*^9, 3.6689734285051746`*^9, 3.6689747143497205`*^9, 
  3.6690494952440777`*^9, 3.669068074099*^9, 3.669417805049094*^9, 
  3.669417876916155*^9, 3.670042111823079*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]\[CapitalGamma]5", "[", "H_", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665901723960919*^9, 3.6659017335667887`*^9}, {
   3.666062253804071*^9, 3.666062255004204*^9}, 3.6684736876628227`*^9, 
   3.668706895976419*^9, {3.668973425878024*^9, 3.668973431998374*^9}, {
   3.6689736813346357`*^9, 3.668973681574649*^9}, {3.669068076278524*^9, 
   3.669068080813746*^9}, 3.669417915199458*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.010477`", ",", 
   RowBox[{"{", 
    RowBox[{"53", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H3", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Phi]H3", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H3", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H3", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]\[CapitalGamma]6", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668703287064546*^9, 3.668809852886627*^9, 
  3.6688301409706173`*^9, 3.668973440040834*^9, 3.6689747176319084`*^9, 
  3.6690495013002357`*^9, 3.6690680871439877`*^9, 3.669417947439411*^9, 
  3.670042119132042*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H3", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H4", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"\[Phi]H5", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"\[Xi]x3", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"\[Xi]y3", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]\[CapitalGamma]6", "[", "t_", "]"}], ":=", 
   "\[Phi]\[CapitalGamma]0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665902002007848*^9, 3.66590200778382*^9}, {
  3.666062266700845*^9, 3.666062271428656*^9}, {3.668473687665745*^9, 
  3.668473687666295*^9}, {3.668706897904416*^9, 3.668706899704126*^9}, {
  3.6689734426949863`*^9, 3.668973451765505*^9}, {3.668973684334807*^9, 
  3.6689736869659576`*^9}, {3.669068092253975*^9, 3.669068106860935*^9}, {
  3.669417952839353*^9, 3.669417953207275*^9}, {3.669418033270754*^9, 
  3.669418033790818*^9}, {3.669418158958638*^9, 3.6694181595020933`*^9}, {
  3.669418290612966*^9, 3.669418292821981*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.802389`", ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H5", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H5", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"3", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]y3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]y3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"2", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}]}], ")"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{"2", " ", "Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]x3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"2", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}]}], ")"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]y3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}]}], ")"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]t1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{"2", " ", "Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668703287109681*^9, 3.668809864036916*^9, 
  3.668830143807199*^9, 3.6689734567077875`*^9, 3.668974720703084*^9, 
  3.6690495080758457`*^9, 3.66906813111385*^9, 3.669418043037799*^9, 
  3.669418171552787*^9, 3.669418297778695*^9, 3.670042127185268*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.693432`", ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "4"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Phi]H5", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"2", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"4", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"7", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"6", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y"}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y"}], "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"\[Phi]H5", "[", 
           RowBox[{"x", ",", "y"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]t1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"7", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y"}], "]"}]}], "+", 
         RowBox[{"6", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y"}], "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"\[Phi]H5", "[", 
           RowBox[{"x", ",", "y"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]t1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}], "+", 
         RowBox[{"3", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x3", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"x", ",", "y"}], "]"}]}]}], "\[Equal]", 
        RowBox[{"3", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"3", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["\[Phi]H5", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H5", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]x3", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Phi]H5", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668703287109681*^9, 3.668809864036916*^9, 
  3.668830143807199*^9, 3.6689734567077875`*^9, 3.668974720703084*^9, 
  3.6690495080758457`*^9, 3.66906813111385*^9, 3.669418043037799*^9, 
  3.669418171552787*^9, 3.669418297778695*^9, 3.6700421318844213`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t1", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Xi]t0", "+", 
    RowBox[{"b", "*", "t"}]}]}], ";"}]], "Input",
 CellChangeTimes->{3.66590220162989*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Combining", " ", "a", " ", "few", " ", "equations"}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Phi]H5", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]y3", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"x", ",", "y"}], "]"}]}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"\[Phi]H5", "[", 
             RowBox[{"x", ",", "y"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]t1", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["\[Xi]y3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
         RowBox[{"\[Phi]H5", "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", "x"}], "]"}]}], "]"}],
    "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Phi]H5", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["\[Xi]x3", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"x", ",", "y"}], "]"}]}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"\[Phi]H5", "[", 
             RowBox[{"x", ",", "y"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]t1", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["\[Xi]x3", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
         RowBox[{"\[Phi]H5", "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", "y"}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.66941813767173*^9, 3.669418143797513*^9}, {
  3.669418200989368*^9, 3.66941825603163*^9}, {3.6694183226460857`*^9, 
  3.66941839781304*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Xi]y3", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.669418196278338*^9, 3.669418256535128*^9}, {
   3.669418323636223*^9, 3.66941834548427*^9}, {3.66941839160611*^9, 
   3.669418400849648*^9}, 3.6700421348265467`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Xi]x3", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.669418196278338*^9, 3.669418256535128*^9}, {
   3.669418323636223*^9, 3.66941834548427*^9}, {3.66941839160611*^9, 
   3.669418400849648*^9}, 3.670042134827586*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x3", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]x4", "[", "x", "]"}], "+", 
    RowBox[{"\[Xi]x5", "[", "y", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y3", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Xi]y4", "[", "y", "]"}], "+", 
    RowBox[{"\[Xi]y5", "[", "x", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665902073079668*^9, 3.6659020764400682`*^9}, {
   3.666062323445684*^9, 3.666062324708747*^9}, 3.6684736876741343`*^9, 
   3.668706904592183*^9, {3.668973467998433*^9, 3.6689734715576367`*^9}, {
   3.6689736910621915`*^9, 3.6689736912702036`*^9}, {3.669068142404953*^9, 
   3.669068147270432*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.668463`", ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H5", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Phi]H5", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668703287241346*^9, 3.668809882174942*^9, 
  3.6688301513545218`*^9, 3.6689734776579857`*^9, 3.668974726357407*^9, 
  3.669049522266802*^9, 3.6690681626149073`*^9, 3.669418419332149*^9, 
  3.67004214083214*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]H5", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", "\[Phi]H0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665902103118737*^9, 3.66590210534238*^9}, {
   3.6660623360031652`*^9, 3.6660623370834427`*^9}, 3.6684736876757917`*^9, 
   3.6687069067122297`*^9, {3.6689734786860447`*^9, 3.6689734824302588`*^9}, {
   3.668973693854351*^9, 3.6689736941663694`*^9}, {3.6690681658377647`*^9, 
   3.669068171268813*^9}, 3.669418423211603*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.436209`", ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y4", 
           TagBox[
            RowBox[{"(", "4", ")"}],
            Derivative],
           MultilineFunction->None], "[", "y", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y5", 
           TagBox[
            RowBox[{"(", "4", ")"}],
            Derivative],
           MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y4", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "y", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y5", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x4", 
           TagBox[
            RowBox[{"(", "4", ")"}],
            Derivative],
           MultilineFunction->None], "[", "x", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]x5", 
           TagBox[
            RowBox[{"(", "4", ")"}],
            Derivative],
           MultilineFunction->None], "[", "y", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x5", 
           TagBox[
            RowBox[{"(", "3", ")"}],
            Derivative],
           MultilineFunction->None], "[", "y", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y5", 
           TagBox[
            RowBox[{"(", "3", ")"}],
            Derivative],
           MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x4", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "x", "]"}], "+", 
         RowBox[{"3", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x5", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "y", "]"}]}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x5", "\[Prime]",
           MultilineFunction->None], "[", "y", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y5", "\[Prime]",
           MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y4", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "y", "]"}], "+", 
         RowBox[{"3", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]y5", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{
           SuperscriptBox["\[Xi]x4", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]x5", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "y", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]y4", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "y", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y5", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x4", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "x", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]x5", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "y", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]y4", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "y", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]y5", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "x", "]"}]}], ")"}]}], "\[Equal]",
         "0"}], ",", 
       RowBox[{
        RowBox[{"b", " ", "Pe"}], "\[Equal]", 
        RowBox[{"2", " ", "Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y4", "\[Prime]",
           MultilineFunction->None], "[", "y", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x4", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "x", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]x5", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "y", "]"}]}], ")"}]}], "\[Equal]",
         "0"}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[Xi]x5", "\[Prime]",
             MultilineFunction->None], "[", "y", "]"}], "+", 
           RowBox[{
            SuperscriptBox["\[Xi]y5", "\[Prime]",
             MultilineFunction->None], "[", "x", "]"}]}], ")"}]}], "\[Equal]",
         "0"}], ",", 
       RowBox[{
        RowBox[{"b", " ", "Pe"}], "\[Equal]", 
        RowBox[{"2", " ", "Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x4", "\[Prime]",
           MultilineFunction->None], "[", "x", "]"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668703287286015*^9, 3.668809890678405*^9, 
  3.668830156066839*^9, 3.6689734865704956`*^9, 3.668974728841549*^9, 
  3.669049532985174*^9, 3.669068178127555*^9, 3.6694184348461733`*^9, 
  3.670042147150261*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x5", "[", "y_", "]"}], ":=", 
   RowBox[{"\[Xi]x0", "+", 
    RowBox[{"c", "*", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y5", "[", "x_", "]"}], ":=", 
   RowBox[{"\[Xi]y0", "-", 
    RowBox[{"c", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6659021204358463`*^9, 3.66590212088463*^9}, {
   3.666062354051469*^9, 3.666062356756322*^9}, 3.668473687679165*^9, 
   3.6687069092000217`*^9, {3.6689734862614775`*^9, 3.668973490213704*^9}, {
   3.6689736972225437`*^9, 3.6689736973905535`*^9}, {3.669068181421442*^9, 
   3.669068183372538*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.27861`", ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y4", 
          TagBox[
           RowBox[{"(", "4", ")"}],
           Derivative],
          MultilineFunction->None], "[", "y", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y4", 
          TagBox[
           RowBox[{"(", "3", ")"}],
           Derivative],
          MultilineFunction->None], "[", "y", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y4", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "y", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x4", 
          TagBox[
           RowBox[{"(", "4", ")"}],
           Derivative],
          MultilineFunction->None], "[", "x", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x4", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x4", 
          TagBox[
           RowBox[{"(", "3", ")"}],
           Derivative],
          MultilineFunction->None], "[", "x", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]y4", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "y", "]"}]}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{
        RowBox[{"Pe", " ", 
         RowBox[{
          SuperscriptBox["\[Xi]x4", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", "0"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668703287327042*^9, 3.668809901143985*^9, 
  3.668830159386917*^9, 3.668973492819853*^9, 3.668974730920668*^9, 
  3.669049537045086*^9, 3.6690681883283367`*^9, 3.669418483928487*^9, 
  3.670042153319105*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x4", "[", "x_", "]"}], ":=", 
   RowBox[{"\[Xi]x6", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y4", "[", "y_", "]"}], ":=", 
   RowBox[{"\[Xi]y6", "*", "y"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6659021464198523`*^9, 3.665902148308042*^9}, {
   3.66606236387014*^9, 3.666062365002932*^9}, 3.6684736876812*^9, 
   3.668706911528117*^9, {3.668973493205875*^9, 3.6689734978301396`*^9}, {
   3.6689737006057377`*^9, 3.6689737007737474`*^9}, {3.669068187418972*^9, 
   3.669068189900269*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.126104`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"b", "+", 
         RowBox[{"3", " ", "\[Phi]H0"}]}], "\[Equal]", 
        RowBox[{"4", " ", "\[Xi]y6"}]}], ",", 
       RowBox[{
        RowBox[{"b", "+", 
         RowBox[{"3", " ", "\[Phi]H0"}]}], "\[Equal]", 
        RowBox[{"4", " ", "\[Xi]x6"}]}]}], "}"}]}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{
  3.6687032873683968`*^9, 3.668809906864757*^9, 3.6688301618415117`*^9, 
   3.6689734999322596`*^9, 3.6689747328597794`*^9, 3.6690495408957644`*^9, 
   3.669068194546378*^9, {3.669418503813862*^9, 3.669418524599353*^9}, 
   3.6700421596943083`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Xi]x6", ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"3", "*", "\[Phi]H0"}]}], ")"}], "/", "4"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]y6", ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"3", "*", "\[Phi]H0"}]}], ")"}], "/", "4"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "3", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665902172435547*^9, 3.665902172643914*^9}, {
   3.6660623802915773`*^9, 3.6660623816274033`*^9}, 3.668473687682715*^9, 
   3.668706913960113*^9, {3.668973501262336*^9, 3.6689735092787943`*^9}, {
   3.6689737032298875`*^9, 3.668973703989931*^9}, {3.669068193970871*^9, 
   3.669068199116946*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.989695`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "\[Phi]\[CapitalGamma]0"}]}], "\[Equal]", 
       "\[Phi]H0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.669068203288569*^9, 3.6694185366361923`*^9, 
  3.670042167185273*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Symmetries", " ", "when", " ", "Pe"}], "\[Equal]", "0"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"b", ":=", 
     RowBox[{"\[Phi]H0", "-", 
      RowBox[{"2", "\[Phi]\[CapitalGamma]0"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
      "]"}], "/.", 
     RowBox[{"Pe", "\[Rule]", "0"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Flatten", "[", "Q", "]"}], "[", 
       RowBox[{"[", "i", "]"}], "]"}], "@@", 
      RowBox[{"Flatten", "[", 
       RowBox[{"var", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", 
        RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.665902809668844*^9, 3.665902839329439*^9}, {
   3.6659028702413197`*^9, 3.665902878410914*^9}, 3.6684736876843357`*^9, {
   3.6689735157501645`*^9, 3.668973525310711*^9}, {3.6690682082686043`*^9, 
   3.669068210900385*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6687032887752*^9, 3.668809921848062*^9, 3.668830165880447*^9, {
   3.6689735218815155`*^9, 3.668973527482836*^9}, 3.6689747364689856`*^9, 
   3.6690495484279222`*^9, 3.669068218422822*^9, 3.669418566879653*^9, 
   3.670042172253601*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Phi]H0", " ", 
     RowBox[{"H", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "x"}], "+", "\[Xi]y0", "+", 
       RowBox[{
        FractionBox["1", "4"], " ", "y", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "\[Phi]H0"}], "-", 
          RowBox[{"2", " ", "\[Phi]\[CapitalGamma]0"}]}], ")"}]}]}], ")"}], 
     " ", 
     RowBox[{
      SuperscriptBox["H", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", " ", "y"}], "+", "\[Xi]x0", "+", 
       RowBox[{
        FractionBox["1", "4"], " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "\[Phi]H0"}], "-", 
          RowBox[{"2", " ", "\[Phi]\[CapitalGamma]0"}]}], ")"}]}]}], ")"}], 
     " ", 
     RowBox[{
      SuperscriptBox["H", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Xi]t0", "+", 
       RowBox[{"t", " ", 
        RowBox[{"(", 
         RowBox[{"\[Phi]H0", "-", 
          RowBox[{"2", " ", "\[Phi]\[CapitalGamma]0"}]}], ")"}]}]}], ")"}], 
     " ", 
     RowBox[{
      SuperscriptBox["H", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"\[Phi]\[CapitalGamma]0", " ", 
     RowBox[{"\[CapitalGamma]", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "x"}], "+", "\[Xi]y0", "+", 
       RowBox[{
        FractionBox["1", "4"], " ", "y", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "\[Phi]H0"}], "-", 
          RowBox[{"2", " ", "\[Phi]\[CapitalGamma]0"}]}], ")"}]}]}], ")"}], 
     " ", 
     RowBox[{
      SuperscriptBox["\[CapitalGamma]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", " ", "y"}], "+", "\[Xi]x0", "+", 
       RowBox[{
        FractionBox["1", "4"], " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "\[Phi]H0"}], "-", 
          RowBox[{"2", " ", "\[Phi]\[CapitalGamma]0"}]}], ")"}]}]}], ")"}], 
     " ", 
     RowBox[{
      SuperscriptBox["\[CapitalGamma]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Xi]t0", "+", 
       RowBox[{"t", " ", 
        RowBox[{"(", 
         RowBox[{"\[Phi]H0", "-", 
          RowBox[{"2", " ", "\[Phi]\[CapitalGamma]0"}]}], ")"}]}]}], ")"}], 
     " ", 
     RowBox[{
      SuperscriptBox["\[CapitalGamma]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6687032887752*^9, 3.668809921848062*^9, 3.668830165880447*^9, {
   3.6689735218815155`*^9, 3.668973527482836*^9}, 3.6689747364689856`*^9, 
   3.6690495484279222`*^9, 3.669068218422822*^9, 3.669418566879653*^9, 
   3.670042172265346*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Symmetries", " ", "when", " ", "Pe"}], "\[NotEqual]", "0"}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"FindInvariance", "[", 
     RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
     "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Phi]\[CapitalGamma]0", ":=", 
     RowBox[{"-", "\[Phi]H0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"FindInvariance", "[", 
     RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
     "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Flatten", "[", "Q", "]"}], "[", 
       RowBox[{"[", "i", "]"}], "]"}], "@@", 
      RowBox[{"Flatten", "[", 
       RowBox[{"var", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", 
        RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6659028842809553`*^9, 3.665902923330492*^9}, {
  3.668473687686264*^9, 3.66847368768675*^9}, {3.6689735304220037`*^9, 
  3.668973535446291*^9}, {3.6690682324198093`*^9, 3.6690682352519827`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"Pe", " ", 
    RowBox[{"(", 
     RowBox[{"\[Phi]H0", "+", "\[Phi]\[CapitalGamma]0"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[CapitalGamma]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2"}], "}"}]], "+", 
      SubscriptBox["\[CapitalGamma]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "0"}], "}"}]]}], ")"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.668703290219686*^9, 3.6688099257067957`*^9, 
  3.668830168278618*^9, 3.6689735378984313`*^9, 3.6689747382140856`*^9, 
  3.669049554913562*^9, 3.6690682533622103`*^9, 3.66941860060154*^9, 
  3.67004217766919*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.668703290219686*^9, 3.6688099257067957`*^9, 
  3.668830168278618*^9, 3.6689735378984313`*^9, 3.6689747382140856`*^9, 
  3.669049554913562*^9, 3.6690682533622103`*^9, 3.66941860060154*^9, 
  3.6700421816477413`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Phi]H0", " ", 
     RowBox[{"H", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "x"}], "+", "\[Xi]y0", "+", 
       FractionBox[
        RowBox[{"3", " ", "y", " ", "\[Phi]H0"}], "2"]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["H", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", " ", "y"}], "+", "\[Xi]x0", "+", 
       FractionBox[
        RowBox[{"3", " ", "x", " ", "\[Phi]H0"}], "2"]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["H", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Xi]t0", "+", 
       RowBox[{"3", " ", "t", " ", "\[Phi]H0"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["H", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Phi]H0"}], " ", 
     RowBox[{"\[CapitalGamma]", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "x"}], "+", "\[Xi]y0", "+", 
       FractionBox[
        RowBox[{"3", " ", "y", " ", "\[Phi]H0"}], "2"]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["\[CapitalGamma]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", " ", "y"}], "+", "\[Xi]x0", "+", 
       FractionBox[
        RowBox[{"3", " ", "x", " ", "\[Phi]H0"}], "2"]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["\[CapitalGamma]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Xi]t0", "+", 
       RowBox[{"3", " ", "t", " ", "\[Phi]H0"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["\[CapitalGamma]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.668703290219686*^9, 3.6688099257067957`*^9, 
  3.668830168278618*^9, 3.6689735378984313`*^9, 3.6689747382140856`*^9, 
  3.669049554913562*^9, 3.6690682533622103`*^9, 3.66941860060154*^9, 
  3.670042181685009*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Adjoint", " ", "symmetries"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]H", "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", 
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Zeta]y", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]2", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]\[CapitalGamma]", "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", 
        RowBox[{"H", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Zeta]y", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"H", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H", ",", "\[CapitalGamma]"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", 
      RowBox[{"\[CapitalLambda]1", ",", "\[CapitalLambda]2"}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "H", "]"}], ",", 
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "\[CapitalGamma]", 
        "]"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6686638019496117`*^9, 3.668663803101708*^9}, {
  3.668664733898097*^9, 3.6686647759376383`*^9}, {3.6689735580245824`*^9, 
  3.66897360239212*^9}, {3.669049568843058*^9, 3.669049585362678*^9}, {
  3.669068281160613*^9, 3.669068322444429*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
       RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{
          "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
           RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.66906836158613*^9, 3.669068371689352*^9}}],

Cell[BoxData["27193"], "Output",
 CellChangeTimes->{3.669068355427721*^9, 3.6690683926155033`*^9, 
  3.669418654992017*^9, 3.6700422014718103`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "6"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "7"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "8"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "6"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "5"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "6"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "3"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "4"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6", ",", "1"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6", ",", "2"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "7", ",", "0"}], "}"}]], ",", 
   SubscriptBox["H", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "3"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "4"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "5"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "6"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "4"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "3"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "4"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "1"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "2"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5", ",", "0"}], "}"}]], ",", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6", ",", "0"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{3.669068355427721*^9, 3.6690683926155033`*^9, 
  3.669418654992017*^9, 3.670042237101273*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.668664186394696*^9, 3.668664189301223*^9}, {
  3.668973615045844*^9, 3.6689736528300047`*^9}, {3.6690684086571836`*^9, 
  3.669068416577034*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"211.360229`", ",", 
   RowBox[{"{", 
    RowBox[{"1932", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t", "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6689739184511976`*^9, 3.668975000881109*^9, 
  3.669049824933257*^9, 3.669068663195732*^9, 3.6694188970512447`*^9, 
  3.6700424506607857`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{"\[Zeta]x1", "[", 
    RowBox[{"t", ",", "x", ",", "\[CapitalGamma]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]y", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{"\[Zeta]y1", "[", 
    RowBox[{"t", ",", "y", ",", "\[CapitalGamma]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668665608670375*^9, 3.6686656254674807`*^9}, {
  3.668665676290588*^9, 3.66866568642642*^9}, {3.6686657238503447`*^9, 
  3.668665758290773*^9}, {3.668702462863822*^9, 3.668702464654909*^9}, {
  3.668705064317883*^9, 3.668705085501093*^9}, {3.668973929717842*^9, 
  3.6689739355111732`*^9}, {3.66904996287189*^9, 3.669049994031355*^9}, {
  3.669068700210228*^9, 3.6690687034969473`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8.282401`", ",", 
   RowBox[{"{", 
    RowBox[{"240", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "y", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "y", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "y", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "4"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "y", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]x1", "[", 
         RowBox[{"t", ",", "x", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]y1", "[", 
         RowBox[{"t", ",", "y", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "4"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "y", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668705226489757*^9, 3.668830835608344*^9, 
  3.668973943774646*^9, 3.668975007400482*^9, 3.669050014367206*^9, 
  3.669068716398391*^9, 3.6694189599679527`*^9, 3.670042468567718*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]x1", "[", 
    RowBox[{"t_", ",", "x_", ",", "\[CapitalGamma]_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]y1", "[", 
    RowBox[{"t_", ",", "x_", ",", "\[CapitalGamma]_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.669050029855208*^9, 3.6690500443272552`*^9}, {
  3.669068725112638*^9, 3.6690687305605927`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.604621`", ",", 
   RowBox[{"{", 
    RowBox[{"74", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]\[CapitalGamma]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]\[CapitalGamma]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.669050054541644*^9, 3.669068736718938*^9, 
  3.6694189717645407`*^9, 3.670042482405217*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]\[CapitalGamma]", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{"\[Psi]\[CapitalGamma]1", "[", 
    RowBox[{"t", ",", "H", ",", "\[CapitalGamma]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668705243431328*^9, 3.668705284084651*^9}, {
  3.6689739395744057`*^9, 3.6689739425345755`*^9}, {3.669068812384326*^9, 
  3.6690688154891357`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.442248`", ",", 
   RowBox[{"{", 
    RowBox[{"70", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
         "]"}], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.668705376023964*^9, 3.668830851015555*^9, 
  3.6689739568373933`*^9, 3.668975012389767*^9, 3.669050068949526*^9, 
  3.669068824378025*^9, 3.669418984910083*^9, 3.670042485776362*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Psi]H", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
     "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"\[Psi]H", "[", 
    RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
    "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Psi]H", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
     "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"\[Psi]H", "[", 
    RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
    "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689740731580467`*^9, 3.668974099215537*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Psi]H", "[", 
     RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
     "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "[", 
       RowBox[{"t", ",", "x", ",", "H"}], "]"}], "[", "y", "]"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], "[", 
       RowBox[{"t", ",", "x", ",", "H"}], "]"}], "[", "\[CapitalGamma]", 
      "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.66897408896095*^9, 3.668974099569557*^9}, 
   3.668975012417769*^9, 3.669050071941812*^9, 3.6690688436223383`*^9, 
   3.669418992775106*^9, 3.670042485896216*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Psi]H", "[", 
     RowBox[{"t", ",", "x", ",", "y", ",", "H", ",", "\[CapitalGamma]"}], 
     "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "[", 
       RowBox[{"t", ",", "y", ",", "H"}], "]"}], "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], "[", 
       RowBox[{"t", ",", "y", ",", "H"}], "]"}], "[", "\[CapitalGamma]", 
      "]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.66897408896095*^9, 3.668974099569557*^9}, 
   3.668975012417769*^9, 3.669050071941812*^9, 3.6690688436223383`*^9, 
   3.669418992775106*^9, 3.670042485916667*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_", ",", "\[CapitalGamma]_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]H1", "[", 
     RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "+", 
    RowBox[{"\[Psi]H2", "[", 
     RowBox[{"t", ",", "H", ",", "\[CapitalGamma]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689740043611116`*^9, 3.6689740591902475`*^9}, {
  3.668974110478181*^9, 3.6689741240949597`*^9}, {3.6690688504166613`*^9, 
  3.669068853040123*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.920601`", ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]\[CapitalGamma]1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "H"}], "]"}], "\[Equal]", 
        "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6689741286172185`*^9, 3.6689750166940136`*^9, 
  3.6690500888792*^9, 3.669068857326479*^9, 3.669418998792286*^9, 
  3.6700424895708923`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]\[CapitalGamma]1", "[", 
    RowBox[{"t_", ",", "H_", ",", "\[CapitalGamma]_"}], "]"}], ":=", 
   RowBox[{"\[Psi]\[CapitalGamma]2", "[", 
    RowBox[{"t", ",", "H"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H1", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "H_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H3", "[", 
    RowBox[{"t", ",", "H"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6689741364816685`*^9, 3.668974202934469*^9}, {
  3.6690688619916697`*^9, 3.6690688648716173`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.918415`", ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "4"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "3"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H", ",", "\[CapitalGamma]"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]\[CapitalGamma]2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]\[CapitalGamma]2", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H"}], "]"}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.66897420609865*^9, 3.6689750196421824`*^9, 
  3.669050094894781*^9, 3.669068869775051*^9, 3.669419022806294*^9, 
  3.6700424914928503`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Choose", " ", "\[Psi]H2", " ", "to", " ", "combine", " ", "all", " ", 
    "dependence", " ", "in", " ", "it"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]\[CapitalGamma]2", "[", 
      RowBox[{"t_", ",", "H_"}], "]"}], ":=", "\[Psi]\[CapitalGamma]0"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]H2", "[", 
      RowBox[{"t_", ",", "H_", ",", "\[CapitalGamma]_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]H4", "[", 
       RowBox[{"t", ",", "H"}], "]"}], "-", 
      RowBox[{"\[Psi]H3", "[", 
       RowBox[{"t", ",", "H"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"AbsoluteTiming", "[", 
    RowBox[{"Part", "[", 
     RowBox[{
      RowBox[{"FindEquations", "[", 
       RowBox[{
       "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", 
        ",", 
        RowBox[{"Adjoint", "\[Rule]", "True"}], ",", " ", 
        RowBox[{"Assumptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Ca", ">", "0"}], "&&", 
           RowBox[{"Ma", ">", "0"}], "&&", 
           RowBox[{"H", ">", "0"}], "&&", 
           RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6689742135690775`*^9, 3.66897430470329*^9}, {
  3.668974337119144*^9, 3.6689743797505827`*^9}, {3.6690688740009947`*^9, 
  3.6690688789436483`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.20618`", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Psi]H4", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "H"}], "]"}], "\[Equal]", "0"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6689742890513945`*^9, 3.668974306769408*^9}, 
   3.6689743374081607`*^9, 3.6689743818037*^9, 3.66897502152829*^9, 
   3.669050100683506*^9, 3.66906887994979*^9, 3.669419072600222*^9, 
   3.670042492957179*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H4", "[", 
    RowBox[{"t_", ",", "H_"}], "]"}], ":=", 
   RowBox[{"\[Psi]H5", "[", "t", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "\[CapitalGamma]", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Ca", ">", "0"}], "&&", 
         RowBox[{"Ma", ">", "0"}], "&&", 
         RowBox[{"H", ">", "0"}], "&&", 
         RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.668974388952109*^9, 3.668974411318388*^9}, {
  3.669068888041795*^9, 3.669068899583351*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.123326`", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Psi]H5", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", "0"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668974398469653*^9, 3.6689744139875407`*^9}, 
   3.6689750233133917`*^9, 3.669050106789447*^9, 3.669068903058082*^9, 
   3.669419085334934*^9, 3.6700424940466003`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H5", "[", "t_", "]"}], ":=", "\[Psi]H0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindInvariance", "[", 
  RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
   RowBox[{"\"\<Adjoint\>\"", "\[Rule]", "True"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Flatten", "[", "Q", "]"}], "[", 
      RowBox[{"[", "i", "]"}], "]"}], "@@", 
     RowBox[{"Flatten", "[", 
      RowBox[{"var", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", 
       RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.66897441589565*^9, 3.668974453870822*^9}, {
  3.669068908366829*^9, 3.669068910951386*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.668974437180867*^9, 3.668974455843935*^9}, 
   3.6689750250794935`*^9, 3.669050108453573*^9, 3.669068912210453*^9, 
   3.669419087599914*^9, 3.6700424949452267`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Psi]H0", ",", "\[Psi]\[CapitalGamma]0"}], "}"}]], "Output",
 CellChangeTimes->{{3.668974437180867*^9, 3.668974455843935*^9}, 
   3.6689750250794935`*^9, 3.669050108453573*^9, 3.669068912210453*^9, 
   3.669419087599914*^9, 3.670042494946632*^9}]
}, Open  ]]
},
WindowSize->{755, 848},
WindowMargins->{{Automatic, 37}, {Automatic, 1}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 265, 4, 32, "Input"],
Cell[826, 26, 9186, 237, 517, "Input"],
Cell[CellGroupData[{
Cell[10037, 267, 1829, 43, 165, "Input"],
Cell[11869, 312, 385, 6, 32, "Output"],
Cell[12257, 320, 5856, 173, 174, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18150, 498, 922, 21, 77, "Input"],
Cell[19075, 521, 11157, 300, 384, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30269, 826, 2368, 63, 165, "Input"],
Cell[32640, 891, 2418, 68, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35095, 964, 1318, 35, 143, "Input"],
Cell[36416, 1001, 2133, 60, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38586, 1066, 1967, 48, 121, "Input"],
Cell[40556, 1116, 3007, 84, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43600, 1205, 1527, 36, 121, "Input"],
Cell[45130, 1243, 2029, 58, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47196, 1306, 1442, 35, 121, "Input"],
Cell[48641, 1343, 3546, 100, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52224, 1448, 900, 24, 59, "Input"],
Cell[53127, 1474, 518, 12, 37, "Output"],
Cell[53648, 1488, 491, 11, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54176, 1504, 1158, 28, 99, "Input"],
Cell[55337, 1534, 2557, 72, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57931, 1611, 2844, 73, 253, "Input"],
Cell[60778, 1686, 6285, 189, 158, "Output"],
Cell[67066, 1877, 11195, 346, 315, "Output"]
}, Open  ]],
Cell[78276, 2226, 200, 6, 32, "Input"],
Cell[CellGroupData[{
Cell[78501, 2236, 3142, 96, 133, "Input"],
Cell[81646, 2334, 471, 13, 37, "Output"],
Cell[82120, 2349, 469, 13, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82626, 2367, 1471, 38, 121, "Input"],
Cell[84100, 2407, 979, 29, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85116, 2441, 1186, 29, 99, "Input"],
Cell[86305, 2472, 5847, 168, 176, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92189, 2645, 1336, 34, 121, "Input"],
Cell[93528, 2681, 2037, 58, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95602, 2744, 1282, 32, 121, "Input"],
Cell[96887, 2778, 726, 20, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97650, 2803, 1389, 38, 121, "Input"],
Cell[99042, 2843, 374, 11, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99453, 2859, 1273, 35, 99, "Input"],
Cell[100729, 2896, 334, 7, 32, "Output"],
Cell[101066, 2905, 3978, 125, 225, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105081, 3035, 1336, 34, 121, "Input"],
Cell[106420, 3071, 688, 18, 35, "Output"],
Cell[107111, 3091, 309, 6, 32, "Output"],
Cell[107423, 3099, 3152, 97, 170, "Output"]
}, Open  ]],
Cell[110590, 3199, 4809, 127, 275, "Input"],
Cell[CellGroupData[{
Cell[115424, 3330, 1469, 38, 187, "Input"],
Cell[116896, 3370, 147, 2, 32, "Output"],
Cell[117046, 3374, 6518, 196, 197, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[123601, 3575, 801, 20, 77, "Input"],
Cell[124405, 3597, 5351, 143, 200, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[129793, 3745, 1774, 44, 143, "Input"],
Cell[131570, 3791, 3999, 117, 131, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135606, 3913, 1076, 29, 121, "Input"],
Cell[136685, 3944, 1049, 28, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137771, 3977, 1104, 28, 99, "Input"],
Cell[138878, 4007, 4460, 119, 177, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143375, 4131, 1313, 37, 86, "Input"],
Cell[144691, 4170, 714, 19, 32, "Output"],
Cell[145408, 4191, 714, 19, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[146159, 4215, 1187, 31, 99, "Input"],
Cell[147349, 4248, 1686, 49, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[149072, 4302, 1217, 31, 121, "Input"],
Cell[150292, 4335, 2928, 88, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[153257, 4428, 1559, 41, 143, "Input"],
Cell[154819, 4471, 1266, 38, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[156122, 4514, 1008, 26, 121, "Input"],
Cell[157133, 4542, 498, 13, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157668, 4560, 904, 25, 99, "Input"],
Cell[158575, 4587, 261, 5, 32, "Output"],
Cell[158839, 4594, 287, 5, 32, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
