(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    123353,       3319]
NotebookOptionsPosition[    120124,       3208]
NotebookOutlinePosition[    120461,       3223]
CellTagsIndexPosition[    120418,       3220]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input",
 CellChangeTimes->{{3.665859232344759*^9, 3.665859236735454*^9}, {
  3.665863815026243*^9, 3.665863849178424*^9}, {3.665863882380316*^9, 
  3.665863929521386*^9}, {3.665899891044674*^9, 3.66589989242861*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"PDE", " ", "we", " ", "seek", " ", "symmetries", " ", 
    RowBox[{"of", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "2"}], "}"}]}], "]"}], "-", 
      RowBox[{"Laplacian", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Q1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Phi]u", "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Xi]t", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Xi]x", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Xi]y", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "=", 
     RowBox[{"{", "\[CapitalDelta]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", "u", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "Q1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"2", ",", "0", ",", "0"}], "]"}], "[", "u", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665859055545368*^9, 3.665859056670993*^9}, 
   3.665859222359338*^9, {3.6658595332618227`*^9, 3.665859535110145*^9}, {
   3.665859711964427*^9, 3.665859713110396*^9}, {3.665860496681065*^9, 
   3.6658605636404743`*^9}, {3.665860875037993*^9, 3.665860881549271*^9}, {
   3.665861046773204*^9, 3.665861049549117*^9}, {3.665861674569313*^9, 
   3.6658616967593813`*^9}, {3.6658620374299707`*^9, 3.665862049470551*^9}, {
   3.6658621101506977`*^9, 3.6658621268486853`*^9}, 3.665862225420937*^9, {
   3.665867355970107*^9, 3.6658674061107483`*^9}, {3.665867527086009*^9, 
   3.66586757559233*^9}, {3.66589959391077*^9, 3.6658996402035427`*^9}, {
   3.665903080783215*^9, 3.665903095503909*^9}, {3.666051082513528*^9, 
   3.666051116936377*^9}, {3.666051537997942*^9, 3.6660515671099367`*^9}, {
   3.666051663348167*^9, 3.666051665691578*^9}, {3.6660517575892878`*^9, 
   3.66605180011744*^9}, 3.6660542102482758`*^9, {3.6684741067461348`*^9, 
   3.668474106993668*^9}, {3.668970045334024*^9, 3.6689701265576696`*^9}, {
   3.668970156782398*^9, 3.6689701568704033`*^9}, {3.669048568393511*^9, 
   3.669048587463704*^9}, {3.669063827298881*^9, 3.669063904145968*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
          "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.665860553384531*^9, 3.665860557223929*^9}, {
   3.665860738233917*^9, 3.665860740785784*^9}, {3.6658612774842663`*^9, 
   3.66586128001158*^9}, {3.665862134590067*^9, 3.6658621370127*^9}, {
   3.665863682232481*^9, 3.6658636923756037`*^9}, 3.668474096744751*^9, {
   3.668970141349516*^9, 3.668970141613531*^9}, 3.6689973428453903`*^9, 
   3.669063888314464*^9}],

Cell[BoxData["56"], "Output",
 CellChangeTimes->{
  3.665860568806402*^9, 3.665860699218162*^9, 3.665860749239545*^9, 
   3.665860819579459*^9, 3.6658609687318277`*^9, 3.6658610978311157`*^9, 
   3.665861176145685*^9, 3.665861281631703*^9, {3.665861323616026*^9, 
   3.6658613388447933`*^9}, 3.66586137306406*^9, 3.665861437934593*^9, 
   3.665861501300076*^9, 3.665861707960017*^9, 3.6658620570322323`*^9, 
   3.66586222951998*^9, 3.66586232498002*^9, 3.665863667447193*^9, 
   3.665863704429582*^9, 3.665864035012487*^9, 3.665867213835298*^9, 
   3.665867415896546*^9, 3.6658675788940573`*^9, 3.665876577588208*^9, 
   3.665882779043414*^9, {3.665883075700088*^9, 3.6658830991137543`*^9}, 
   3.665883332741406*^9, 3.6658836128544483`*^9, {3.665899649408271*^9, 
   3.6658996731491613`*^9}, 3.665899897463888*^9, 3.6659003582501183`*^9, 
   3.665903108062612*^9, 3.6659032261403837`*^9, {3.6659034131789093`*^9, 
   3.665903429433507*^9}, 3.6660501274578743`*^9, {3.666050163169466*^9, 
   3.6660501927679987`*^9}, {3.666050270589601*^9, 3.666050292672769*^9}, {
   3.66605034593267*^9, 3.6660503889818687`*^9}, 3.6660511260065804`*^9, 
   3.666051843524271*^9, 3.666051878750062*^9, 3.6660526708308487`*^9, {
   3.666053546166959*^9, 3.666053566616982*^9}, 3.666054216966113*^9, {
   3.666055567733122*^9, 3.666055584858246*^9}, 3.666055690742146*^9, 
   3.666063382573461*^9, 3.666064479608412*^9, 3.668474113629106*^9, 
   3.668635405854439*^9, 3.6686376124157763`*^9, 3.668662612212986*^9, 
   3.668662995646778*^9, 3.668698736715485*^9, {3.668970143891661*^9, 
   3.6689701591455336`*^9}, 3.668997343747733*^9, {3.669048575741145*^9, 
   3.669048601230073*^9}, {3.669063889374271*^9, 3.669063906946978*^9}, 
   3.669063937301057*^9, 3.669064040464409*^9, 3.6694210252935553`*^9, 
   3.670042584107891*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665860568806402*^9, 3.665860699218162*^9, 3.665860749239545*^9, 
   3.665860819579459*^9, 3.6658609687318277`*^9, 3.6658610978311157`*^9, 
   3.665861176145685*^9, 3.665861281631703*^9, {3.665861323616026*^9, 
   3.6658613388447933`*^9}, 3.66586137306406*^9, 3.665861437934593*^9, 
   3.665861501300076*^9, 3.665861707960017*^9, 3.6658620570322323`*^9, 
   3.66586222951998*^9, 3.66586232498002*^9, 3.665863667447193*^9, 
   3.665863704429582*^9, 3.665864035012487*^9, 3.665867213835298*^9, 
   3.665867415896546*^9, 3.6658675788940573`*^9, 3.665876577588208*^9, 
   3.665882779043414*^9, {3.665883075700088*^9, 3.6658830991137543`*^9}, 
   3.665883332741406*^9, 3.6658836128544483`*^9, {3.665899649408271*^9, 
   3.6658996731491613`*^9}, 3.665899897463888*^9, 3.6659003582501183`*^9, 
   3.665903108062612*^9, 3.6659032261403837`*^9, {3.6659034131789093`*^9, 
   3.665903429433507*^9}, 3.6660501274578743`*^9, {3.666050163169466*^9, 
   3.6660501927679987`*^9}, {3.666050270589601*^9, 3.666050292672769*^9}, {
   3.66605034593267*^9, 3.6660503889818687`*^9}, 3.6660511260065804`*^9, 
   3.666051843524271*^9, 3.666051878750062*^9, 3.6660526708308487`*^9, {
   3.666053546166959*^9, 3.666053566616982*^9}, 3.666054216966113*^9, {
   3.666055567733122*^9, 3.666055584858246*^9}, 3.666055690742146*^9, 
   3.666063382573461*^9, 3.666064479608412*^9, 3.668474113629106*^9, 
   3.668635405854439*^9, 3.6686376124157763`*^9, 3.668662612212986*^9, 
   3.668662995646778*^9, 3.668698736715485*^9, {3.668970143891661*^9, 
   3.6689701591455336`*^9}, 3.668997343747733*^9, {3.669048575741145*^9, 
   3.669048601230073*^9}, {3.669063889374271*^9, 3.669063906946978*^9}, 
   3.669063937301057*^9, 3.669064040464409*^9, 3.6694210252935553`*^9, 
   3.670042584136569*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.665883470602792*^9, 3.665883514147079*^9}, {
   3.6658835910581913`*^9, 3.665883603233927*^9}, {3.666050394037593*^9, 
   3.666050394444675*^9}, 3.668474096801796*^9, {3.6689701455337553`*^9, 
   3.668970145717766*^9}, 3.6690639495939198`*^9, 3.669064046336811*^9, 
   3.6694210501617737`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.091049`", ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "u"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "u"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "u"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "u"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "u"}], "]"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y", ",", "u"}], "]"}], "\[Equal]", 
        "0"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.665883474634829*^9, 3.665883516446656*^9}, {
   3.665883604370013*^9, 3.665883615183599*^9}, 3.665899682027528*^9, 
   3.665899906151244*^9, 3.6659003657925673`*^9, 3.6659031092468853`*^9, 
   3.665903226185507*^9, {3.6659034136957006`*^9, 3.665903429963566*^9}, {
   3.666050390563136*^9, 3.666050395297736*^9}, 3.666052678141993*^9, 
   3.666053569939171*^9, 3.666054217611203*^9, {3.666055568083535*^9, 
   3.6660555856798*^9}, 3.666055691385332*^9, 3.666063384628459*^9, 
   3.6660644802749653`*^9, 3.668474113744527*^9, 3.6686354071562433`*^9, 
   3.66863761266616*^9, 3.6686626144062557`*^9, 3.668662996004278*^9, 
   3.668698737196673*^9, {3.6689701469548364`*^9, 3.668970159875575*^9}, 
   3.6690486091919613`*^9, {3.669063923473628*^9, 3.669063949983749*^9}, 
   3.6690640469219007`*^9, {3.669421026913378*^9, 3.6694210504974737`*^9}, 
   3.670042584732991*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Xi]t1", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Xi]x1", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]y", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Xi]y1", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665903131697522*^9, 3.665903148784086*^9}, {
   3.666050398837236*^9, 3.666050399279338*^9}, {3.666053593082354*^9, 
   3.6660536157305317`*^9}, 3.668474096856954*^9, {3.6689701658699183`*^9, 
   3.6689701661179323`*^9}, 3.6690640502078733`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.041433`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Phi]u", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "u"}], "]"}], "\[Equal]", "0"}],
       "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665903150988785*^9, 3.665903226249514*^9, {3.665903414175057*^9, 
   3.665903431672311*^9}, 3.6660504022907867`*^9, 3.6660536166341248`*^9, 
   3.6660542181675243`*^9, {3.666055568465992*^9, 3.666055587407392*^9}, 
   3.6660556917456837`*^9, 3.6660633868527317`*^9, 3.666064480853383*^9, 
   3.668474113877866*^9, 3.668635408523217*^9, 3.668637612824785*^9, 
   3.668662616333633*^9, 3.668662996140284*^9, 3.668698737423613*^9, 
   3.6689701666579633`*^9, 3.669048610583363*^9, 3.66906405518696*^9, 
   3.669421068333777*^9, 3.670042585307691*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Phi]u1", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
    RowBox[{"u", "*", 
     RowBox[{"\[Phi]u2", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6659031545559464`*^9, 3.665903175848455*^9}, 
   3.665903219153366*^9, {3.666050404949828*^9, 3.666050405197604*^9}, {
   3.666053623057884*^9, 3.666053709834135*^9}, {3.666053749449257*^9, 
   3.666053784856822*^9}, {3.666054142695901*^9, 3.666054142951754*^9}, 
   3.6684740968947363`*^9, {3.668662621287641*^9, 3.668662623527041*^9}, {
   3.668970171029213*^9, 3.668970179341689*^9}, {3.669064057503805*^9, 
   3.669064061456297*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.048639`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.665903176142964*^9, {3.665903219619857*^9, 3.665903226302685*^9}, {
   3.665903414615954*^9, 3.6659034326001472`*^9}, 3.6660504066048326`*^9, {
   3.66605364557957*^9, 3.666053710330862*^9}, {3.666053751651816*^9, 
   3.666053785545227*^9}, 3.666054143691185*^9, 3.6660542187833433`*^9, {
   3.6660555694761667`*^9, 3.666055588588277*^9}, 3.666055692273541*^9, 
   3.666063388634656*^9, 3.666064481641279*^9, 3.668474113930626*^9, 
   3.668635409914447*^9, 3.668637613561523*^9, {3.6686626171139393`*^9, 
   3.6686626240246143`*^9}, 3.668662996273666*^9, 3.6686987378412952`*^9, 
   3.668970180363747*^9, 3.66904861233189*^9, 3.669064077902336*^9, 
   3.6694210707717743`*^9, 3.6700425859607277`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Taking", " ", "derivatives", " ", "of", " ", "each", " ", "of", " ", 
    "these", " ", "implies", " ", "the", " ", "third", " ", "derivatives", 
    " ", "all", " ", "vanish"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"eqns", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Xi]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Xi]y1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Xi]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Xi]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{"DeleteDuplicates", "[", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "x"}], "]"}], ",", "y"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "x"}], "]"}], ",", "t"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "y"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "y"}], "]"}], ",", "y"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "y"}], "]"}], ",", "t"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "t"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "t"}], "]"}], ",", "y"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "t"}], "]"}], ",", "t"}], "]"}]}], "]"}], 
     "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.666066470078071*^9, 3.666066525970261*^9}, {
  3.666066568273726*^9, 3.6660665801444693`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "3"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "3"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "3"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "3", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "3", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "3", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "1", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "1", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "1", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"3", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"3", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Xi]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"3", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6660664796232357`*^9, 3.666066528508996*^9, 
  3.6660665824013357`*^9, 3.668474114141438*^9, 3.668635413314988*^9, 
  3.668637613765718*^9, 3.668662627447624*^9, 3.668662996472438*^9, 
  3.668698738324284*^9, 3.668970192611448*^9, 3.669048613928124*^9, 
  3.669064081932493*^9, 3.669421081846735*^9, 3.670042586587213*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "So", " ", "the", " ", "functions", " ", "are", " ", "at", " ", "most", 
    " ", "quadratic", " ", "in", " ", 
    RowBox[{"(", 
     RowBox[{"t", ",", "x", ",", "y"}], ")"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]x1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{"\[Xi]x0", "+", 
      RowBox[{"\[Xi]x100", "*", "t"}], "+", 
      RowBox[{"\[Xi]x010", "*", "x"}], "+", 
      RowBox[{"\[Xi]x001", "*", "y"}], "+", 
      RowBox[{"\[Xi]x200", "*", 
       RowBox[{"t", "^", "2"}]}], "+", 
      RowBox[{"\[Xi]x110", "*", "t", "*", "x"}], "+", 
      RowBox[{"\[Xi]x101", "*", "t", "*", "y"}], "+", 
      RowBox[{"\[Xi]x020", "*", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"\[Xi]x011", "*", "x", "*", "y"}], "+", 
      RowBox[{"\[Xi]x002", "*", 
       RowBox[{"y", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]y1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{"\[Xi]y0", "+", 
      RowBox[{"\[Xi]y100", "*", "t"}], "+", 
      RowBox[{"\[Xi]y010", "*", "x"}], "+", 
      RowBox[{"\[Xi]y001", "*", "y"}], "+", 
      RowBox[{"\[Xi]y200", "*", 
       RowBox[{"t", "^", "2"}]}], "+", 
      RowBox[{"\[Xi]y110", "*", "t", "*", "x"}], "+", 
      RowBox[{"\[Xi]y101", "*", "t", "*", "y"}], "+", 
      RowBox[{"\[Xi]y020", "*", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"\[Xi]y011", "*", "x", "*", "y"}], "+", 
      RowBox[{"\[Xi]y002", "*", 
       RowBox[{"y", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]t1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{"\[Xi]t0", "+", 
      RowBox[{"\[Xi]t100", "*", "t"}], "+", 
      RowBox[{"\[Xi]t010", "*", "x"}], "+", 
      RowBox[{"\[Xi]t001", "*", "y"}], "+", 
      RowBox[{"\[Xi]t200", "*", 
       RowBox[{"t", "^", "2"}]}], "+", 
      RowBox[{"\[Xi]t110", "*", "t", "*", "x"}], "+", 
      RowBox[{"\[Xi]t101", "*", "t", "*", "y"}], "+", 
      RowBox[{"\[Xi]t020", "*", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"\[Xi]t011", "*", "x", "*", "y"}], "+", 
      RowBox[{"\[Xi]t002", "*", 
       RowBox[{"y", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"AbsoluteTiming", "[", 
    RowBox[{"Part", "[", 
     RowBox[{
      RowBox[{"FindEquations", "[", 
       RowBox[{
       "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "4", 
        ",", 
        RowBox[{"extras", "\[Rule]", 
         RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.666054726019513*^9, 3.666054789289844*^9}, {
   3.666054852337228*^9, 3.666055022417686*^9}, 3.6660659771262407`*^9, 
   3.666066536975575*^9, {3.6660665995527983`*^9, 3.666066625833684*^9}, 
   3.668474096917963*^9, {3.668662630767215*^9, 3.668662632575151*^9}, {
   3.668970199661851*^9, 3.6689702012779436`*^9}, {3.669064085656315*^9, 
   3.669064089168346*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.110281`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Xi]y002", "+", "\[Xi]y020"}], "\[Equal]", 
        RowBox[{"\[Xi]y200", "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Xi]x002", "+", "\[Xi]x020"}], "\[Equal]", 
        RowBox[{"\[Xi]x200", "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Xi]t002", "+", "\[Xi]t020", "+", 
         RowBox[{
          SuperscriptBox["\[Phi]u2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "\[Equal]", 
        "\[Xi]t200"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6660550156247787`*^9, 3.666055022967764*^9}, {
   3.6660555705167313`*^9, 3.666055595501204*^9}, 3.666055692848688*^9, 
   3.666063444357768*^9, 3.6660666274344187`*^9, 3.666066700556127*^9, 
   3.6684741142863703`*^9, 3.66863541493521*^9, 3.668637614192024*^9, 
   3.668662633104026*^9, 3.668662996582778*^9, 3.668698738738036*^9, 
   3.6689702085673604`*^9, 3.669048616088735*^9, 3.6690640921886797`*^9, 
   3.6694210858867283`*^9, 3.670042587845459*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]u2", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"\[Phi]u0", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Xi]y002", "+", "\[Xi]y020", "-", "\[Xi]y200"}], ")"}], "*", 
     "y"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Xi]x002", "+", "\[Xi]x020", "-", "\[Xi]x200"}], ")"}], "*", 
     "x"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Xi]t002", "+", "\[Xi]t020", "-", "\[Xi]t200"}], ")"}], "*", 
     "t"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "8", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6660550471082077`*^9, 3.666055149279943*^9}, 
   3.668474096921899*^9, {3.66866263585487*^9, 3.66866263754296*^9}, {
   3.668970214061675*^9, 3.6689702267894025`*^9}, {3.669064097361515*^9, 
   3.6690640991679707`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.04606`", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Xi]t100", "+", 
         RowBox[{"y", " ", "\[Xi]t101"}], "+", 
         RowBox[{"x", " ", "\[Xi]t110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]t200"}]}], "\[Equal]", 
        RowBox[{"\[Xi]y001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Xi]y002"}], "+", 
         RowBox[{"x", " ", "\[Xi]y011"}], "+", 
         RowBox[{"t", " ", "\[Xi]y101"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Xi]x001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Xi]x002"}], "+", 
         RowBox[{"x", " ", "\[Xi]x011"}], "+", 
         RowBox[{"t", " ", "\[Xi]x101"}], "+", "\[Xi]y010", "+", 
         RowBox[{"y", " ", "\[Xi]y011"}], "+", 
         RowBox[{"2", " ", "x", " ", "\[Xi]y020"}], "+", 
         RowBox[{"t", " ", "\[Xi]y110"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Xi]t100", "+", 
         RowBox[{"y", " ", "\[Xi]t101"}], "+", 
         RowBox[{"x", " ", "\[Xi]t110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]t200"}]}], "\[Equal]", 
        RowBox[{"\[Xi]x010", "+", 
         RowBox[{"y", " ", "\[Xi]x011"}], "+", 
         RowBox[{"2", " ", "x", " ", "\[Xi]x020"}], "+", 
         RowBox[{"t", " ", "\[Xi]x110"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Xi]t001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Xi]t002"}], "+", 
         RowBox[{"x", " ", "\[Xi]t011"}], "+", 
         RowBox[{"t", " ", "\[Xi]t101"}]}], "\[Equal]", 
        RowBox[{"\[Xi]y100", "+", 
         RowBox[{"y", " ", "\[Xi]y101"}], "+", 
         RowBox[{"x", " ", "\[Xi]y110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]y200"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Xi]t010", "+", 
         RowBox[{"y", " ", "\[Xi]t011"}], "+", 
         RowBox[{"2", " ", "x", " ", "\[Xi]t020"}], "+", 
         RowBox[{"t", " ", "\[Xi]t110"}]}], "\[Equal]", 
        RowBox[{"\[Xi]x100", "+", 
         RowBox[{"y", " ", "\[Xi]x101"}], "+", 
         RowBox[{"x", " ", "\[Xi]x110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]x200"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.666055116136882*^9, 3.666055149883089*^9}, 
   3.6660555974825*^9, 3.666055693640238*^9, 3.666063463067082*^9, 
   3.666066701595522*^9, 3.668474114379634*^9, 3.668635416318454*^9, 
   3.668637615404524*^9, 3.6686626379432583`*^9, 3.668662996706298*^9, 
   3.6686987417894583`*^9, 3.6689702296515665`*^9, 3.669048619032323*^9, 
   3.669064100595693*^9, 3.669421088907117*^9, 3.670042588924706*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Xi]t100", ":=", "\[Xi]y001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]t101", ":=", 
   RowBox[{"2", "*", "\[Xi]y002"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]t110", ":=", "\[Xi]y011"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]t200", ":=", 
   RowBox[{"\[Xi]y101", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "8", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.666055159981778*^9, 3.666055256368299*^9}, {
   3.6660553260398397`*^9, 3.666055326375011*^9}, 3.66847409692445*^9, {
   3.668662640271125*^9, 3.6686626423432837`*^9}, {3.6689702378380346`*^9, 
   3.668970239638138*^9}, {3.669064102567995*^9, 3.669064104480085*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.07377`", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Xi]x001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Xi]x002"}], "+", 
         RowBox[{"x", " ", "\[Xi]x011"}], "+", 
         RowBox[{"t", " ", "\[Xi]x101"}], "+", "\[Xi]y010", "+", 
         RowBox[{"y", " ", "\[Xi]y011"}], "+", 
         RowBox[{"2", " ", "x", " ", "\[Xi]y020"}], "+", 
         RowBox[{"t", " ", "\[Xi]y110"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Xi]x010", "+", 
         RowBox[{"y", " ", "\[Xi]x011"}], "+", 
         RowBox[{"2", " ", "x", " ", "\[Xi]x020"}], "+", 
         RowBox[{"t", " ", "\[Xi]x110"}]}], "\[Equal]", 
        RowBox[{"\[Xi]y001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Xi]y002"}], "+", 
         RowBox[{"x", " ", "\[Xi]y011"}], "+", 
         RowBox[{"t", " ", "\[Xi]y101"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Xi]t001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Xi]t002"}], "+", 
         RowBox[{"x", " ", "\[Xi]t011"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]y002"}]}], "\[Equal]", 
        RowBox[{"\[Xi]y100", "+", 
         RowBox[{"y", " ", "\[Xi]y101"}], "+", 
         RowBox[{"x", " ", "\[Xi]y110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]y200"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Xi]t010", "+", 
         RowBox[{"y", " ", "\[Xi]t011"}], "+", 
         RowBox[{"2", " ", "x", " ", "\[Xi]t020"}], "+", 
         RowBox[{"t", " ", "\[Xi]y011"}]}], "\[Equal]", 
        RowBox[{"\[Xi]x100", "+", 
         RowBox[{"y", " ", "\[Xi]x101"}], "+", 
         RowBox[{"x", " ", "\[Xi]x110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]x200"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.666055224408532*^9, 3.666055256760015*^9}, 
   3.6660553288592873`*^9, 3.666055601135396*^9, 3.666055694760935*^9, 
   3.6660634962873783`*^9, 3.666066704029127*^9, 3.66847411448763*^9, 
   3.668635418014326*^9, 3.668637615539815*^9, 3.668662642806551*^9, 
   3.668662996883582*^9, 3.668698742702355*^9, 3.6689702412492294`*^9, 
   3.669048620221628*^9, 3.6690641049862833`*^9, 3.669421092143795*^9, 
   3.670042589913081*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Xi]x001", ":=", 
   RowBox[{"-", "\[Xi]y010"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]x002", ":=", 
   RowBox[{
    RowBox[{"-", "\[Xi]y011"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]x011", ":=", 
   RowBox[{
    RowBox[{"-", "2"}], "*", "\[Xi]y020"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]x101", ":=", 
   RowBox[{"-", "\[Xi]y110"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "8", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.666055232224422*^9, 3.666055331613624*^9}, 
   3.666055517470454*^9, {3.6660635202293997`*^9, 3.666063522699864*^9}, {
   3.666063572444113*^9, 3.666063572556229*^9}, 3.668474096926559*^9, {
   3.668662644838756*^9, 3.6686626465110893`*^9}, {3.6689702444454126`*^9, 
   3.668970245989501*^9}, {3.66906410723254*^9, 3.66906410947185*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.058251`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Xi]x010", "+", 
         RowBox[{"2", " ", "x", " ", "\[Xi]x020"}], "+", 
         RowBox[{"t", " ", "\[Xi]x110"}]}], "\[Equal]", 
        RowBox[{"\[Xi]y001", "+", 
         RowBox[{"x", " ", "\[Xi]y011"}], "+", 
         RowBox[{"2", " ", "y", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]y002", "+", "\[Xi]y020"}], ")"}]}], "+", 
         RowBox[{"t", " ", "\[Xi]y101"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Xi]t001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Xi]t002"}], "+", 
         RowBox[{"x", " ", "\[Xi]t011"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]y002"}]}], "\[Equal]", 
        RowBox[{"\[Xi]y100", "+", 
         RowBox[{"y", " ", "\[Xi]y101"}], "+", 
         RowBox[{"x", " ", "\[Xi]y110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]y200"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Xi]t010", "+", 
         RowBox[{"2", " ", "x", " ", "\[Xi]t020"}], "+", 
         RowBox[{"t", " ", "\[Xi]y011"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]t011", "+", "\[Xi]y110"}], ")"}]}]}], "\[Equal]", 
        RowBox[{"\[Xi]x100", "+", 
         RowBox[{"x", " ", "\[Xi]x110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]x200"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6660553320509987`*^9, 3.666055524620995*^9, 
  3.666055605041008*^9, 3.666055695669901*^9, 3.666063598650186*^9, 
  3.666066704859415*^9, 3.668474114577697*^9, 3.668635419263146*^9, 
  3.668637615696096*^9, 3.668662646926715*^9, 3.668662997019202*^9, 
  3.6686987434107523`*^9, 3.6689702845367055`*^9, 3.669048621309525*^9, 
  3.669064109924795*^9, 3.669421093090431*^9, 3.670042590996208*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Xi]x010", ":=", "\[Xi]y001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]x020", ":=", 
   RowBox[{"\[Xi]y011", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]x110", ":=", "\[Xi]y101"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]y002", ":=", 
   RowBox[{"-", "\[Xi]y020"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "8", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6660553592096243`*^9, 3.6660554054607964`*^9}, {
   3.6660636222992764`*^9, 3.666063645764427*^9}, 3.6684740969284773`*^9, {
   3.668662650102881*^9, 3.668662651998755*^9}, {3.6689702869338427`*^9, 
   3.6689702886939435`*^9}, {3.669064112727399*^9, 3.669064114688052*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.059174`", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Xi]t001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Xi]t002"}], "+", 
         RowBox[{"x", " ", "\[Xi]t011"}]}], "\[Equal]", 
        RowBox[{"\[Xi]y100", "+", 
         RowBox[{"y", " ", "\[Xi]y101"}], "+", 
         RowBox[{"x", " ", "\[Xi]y110"}], "+", 
         RowBox[{"2", " ", "t", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]y020", "+", "\[Xi]y200"}], ")"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Xi]t010", "+", 
         RowBox[{"2", " ", "x", " ", "\[Xi]t020"}], "+", 
         RowBox[{"t", " ", "\[Xi]y011"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"\[Xi]t011", "+", "\[Xi]y110"}], ")"}]}]}], "\[Equal]", 
        RowBox[{"\[Xi]x100", "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]x200"}], "+", 
         RowBox[{"x", " ", "\[Xi]y101"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.666055405885563*^9, 3.666055607329339*^9, 
  3.666055696803537*^9, 3.666063669119101*^9, 3.666066705393224*^9, 
  3.668474114661376*^9, 3.668635420509329*^9, 3.668637615888607*^9, 
  3.668662652473236*^9, 3.6686629971472483`*^9, 3.6686987442302217`*^9, 
  3.6689702897950068`*^9, 3.669048622326468*^9, 3.669064116228733*^9, 
  3.66942109391847*^9, 3.670042591835487*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Xi]t001", ":=", "\[Xi]y100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]t002", ":=", 
   RowBox[{"\[Xi]y101", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]t011", ":=", "\[Xi]y110"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]y200", ":=", 
   RowBox[{"-", "\[Xi]y020"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "7", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.666055424436131*^9, 3.6660554722283497`*^9}, {
   3.66606372768232*^9, 3.6660637354340887`*^9}, 3.6684740969301167`*^9, {
   3.668662654902094*^9, 3.668662657151016*^9}, {3.6689702919731307`*^9, 
   3.6689702940302486`*^9}, {3.669064118328287*^9, 3.669064120903982*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.034818`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Xi]t010", "+", 
        RowBox[{"2", " ", "x", " ", "\[Xi]t020"}], "+", 
        RowBox[{"t", " ", "\[Xi]y011"}], "+", 
        RowBox[{"2", " ", "y", " ", "\[Xi]y110"}]}], "\[Equal]", 
       RowBox[{"\[Xi]x100", "+", 
        RowBox[{"2", " ", "t", " ", "\[Xi]x200"}], "+", 
        RowBox[{"x", " ", "\[Xi]y101"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.666055466548276*^9, 3.666055472766152*^9}, 
   3.666055610089542*^9, 3.66605569832584*^9, {3.666063723812573*^9, 
   3.666063735657466*^9}, 3.666066705947562*^9, 3.668474114732051*^9, 
   3.668635422373028*^9, 3.6686376161007433`*^9, 3.6686626576473618`*^9, 
   3.6686629972601423`*^9, 3.668698744888081*^9, 3.6689702952023153`*^9, 
   3.6690486232159967`*^9, 3.6690641214160643`*^9, 3.669421094796715*^9, 
   3.670042592563031*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Xi]t010", ":=", "\[Xi]x100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]t020", ":=", 
   RowBox[{"\[Xi]y101", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]y011", ":=", 
   RowBox[{"2", "*", "\[Xi]x200"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]y110", ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Flatten", "[", "Q", "]"}], "[", 
      RowBox[{"[", "i", "]"}], "]"}], "@@", 
     RowBox[{"Flatten", "[", 
      RowBox[{"var", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", 
       RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6660557331511593`*^9, 3.6660558769625673`*^9}, {
   3.666063752609592*^9, 3.6660637528986673`*^9}, {3.666063793145479*^9, 
   3.666063811572357*^9}, 3.6684740969315434`*^9, {3.668662660766488*^9, 
   3.668662662678835*^9}, {3.6689702979974756`*^9, 3.668970320750777*^9}, {
   3.6690641253198833`*^9, 3.669064128351996*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["\[Phi]u1", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["\[Phi]u1", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
   RowBox[{
    SuperscriptBox["\[Phi]u1", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6660558742088537`*^9, 3.666055877496743*^9}, 
   3.66606381919473*^9, 3.6660667064749937`*^9, 3.668474114793344*^9, 
   3.668635423446528*^9, 3.668637616238883*^9, 3.66866266307717*^9, 
   3.668662997360663*^9, 3.668698745665975*^9, {3.668970304313837*^9, 
   3.6689703233869276`*^9}, 3.66904862427417*^9, 3.6690641321792173`*^9, 
   3.669421095544426*^9, 3.6700425932821283`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "x"}], " ", "\[Xi]x200"}], "+", 
      RowBox[{"y", " ", "\[Xi]y020"}], "-", 
      FractionBox[
       RowBox[{"t", " ", "\[Xi]y101"}], "2"], "+", "\[Phi]u0"}], ")"}], " ", 
    RowBox[{"u", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
   RowBox[{"\[Phi]u1", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Xi]y0", "+", 
      RowBox[{"y", " ", "\[Xi]y001"}], "+", 
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "y", " ", "\[Xi]x200"}], "+", "\[Xi]y010"}], 
        ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["t", "2"], " ", "\[Xi]y020"}], "+", 
      RowBox[{
       SuperscriptBox["x", "2"], " ", "\[Xi]y020"}], "-", 
      RowBox[{
       SuperscriptBox["y", "2"], " ", "\[Xi]y020"}], "+", 
      RowBox[{"t", " ", "\[Xi]y100"}], "+", 
      RowBox[{"t", " ", "y", " ", "\[Xi]y101"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Xi]x0", "+", 
      RowBox[{
       SuperscriptBox["t", "2"], " ", "\[Xi]x200"}], "+", 
      RowBox[{
       SuperscriptBox["x", "2"], " ", "\[Xi]x200"}], "-", 
      RowBox[{
       SuperscriptBox["y", "2"], " ", "\[Xi]x200"}], "+", 
      RowBox[{"x", " ", "\[Xi]y001"}], "-", 
      RowBox[{"y", " ", "\[Xi]y010"}], "-", 
      RowBox[{"2", " ", "x", " ", "y", " ", "\[Xi]y020"}], "+", 
      RowBox[{"t", " ", 
       RowBox[{"(", 
        RowBox[{"\[Xi]x100", "+", 
         RowBox[{"x", " ", "\[Xi]y101"}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "\[Xi]t0"}], "+", 
      RowBox[{"2", " ", "x", " ", 
       RowBox[{"(", 
        RowBox[{"\[Xi]x100", "+", 
         RowBox[{"2", " ", "t", " ", "\[Xi]x200"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "t", " ", "\[Xi]y001"}], "-", 
      RowBox[{"4", " ", "t", " ", "y", " ", "\[Xi]y020"}], "+", 
      RowBox[{"2", " ", "y", " ", "\[Xi]y100"}], "+", 
      RowBox[{
       SuperscriptBox["t", "2"], " ", "\[Xi]y101"}], "+", 
      RowBox[{
       SuperscriptBox["x", "2"], " ", "\[Xi]y101"}], "+", 
      RowBox[{
       SuperscriptBox["y", "2"], " ", "\[Xi]y101"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6660558742088537`*^9, 3.666055877496743*^9}, 
   3.66606381919473*^9, 3.6660667064749937`*^9, 3.668474114793344*^9, 
   3.668635423446528*^9, 3.668637616238883*^9, 3.66866266307717*^9, 
   3.668662997360663*^9, 3.668698745665975*^9, {3.668970304313837*^9, 
   3.6689703233869276`*^9}, 3.66904862427417*^9, 3.6690641321792173`*^9, 
   3.669421095544426*^9, 3.670042593340399*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Adjoint", " ", "symmetries"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalLambda]1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Psi]u", "[", 
       RowBox[{"t", ",", "x", ",", "y", ",", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"\[Zeta]t", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "t"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Zeta]x", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "-", 
      
      RowBox[{
       RowBox[{"\[Zeta]y", "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"var", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", "u", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q", "=", 
     RowBox[{"{", "\[CapitalLambda]1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"solvefor", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"2", ",", "0", ",", "0"}], "]"}], "[", "u", "]"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665859055545368*^9, 3.665859056670993*^9}, 
   3.665859222359338*^9, {3.6658595332618227`*^9, 3.665859535110145*^9}, {
   3.665859711964427*^9, 3.665859713110396*^9}, {3.665860496681065*^9, 
   3.6658605636404743`*^9}, {3.665860875037993*^9, 3.665860881549271*^9}, {
   3.665861046773204*^9, 3.665861049549117*^9}, {3.665861674569313*^9, 
   3.6658616967593813`*^9}, {3.6658620374299707`*^9, 3.665862049470551*^9}, {
   3.6658621101506977`*^9, 3.6658621268486853`*^9}, 3.665862225420937*^9, {
   3.665867355970107*^9, 3.6658674061107483`*^9}, {3.665867527086009*^9, 
   3.66586757559233*^9}, {3.66589959391077*^9, 3.6658996402035427`*^9}, {
   3.665903080783215*^9, 3.665903095503909*^9}, {3.666051082513528*^9, 
   3.666051116936377*^9}, {3.666051537997942*^9, 3.6660515671099367`*^9}, {
   3.666051663348167*^9, 3.666051665691578*^9}, {3.6660517575892878`*^9, 
   3.66605180011744*^9}, 3.6660542102482758`*^9, {3.6684741067461348`*^9, 
   3.668474106993668*^9}, {3.668970045334024*^9, 3.6689701265576696`*^9}, {
   3.668970156782398*^9, 3.6689701568704033`*^9}, {3.668970361207091*^9, 
   3.668970389501709*^9}, {3.6689705660468073`*^9, 3.6689705713821125`*^9}, {
   3.669048630072814*^9, 3.6690486345443087`*^9}, 3.669048674496648*^9, {
   3.6690641531385593`*^9, 3.669064178455735*^9}, {3.669064219311534*^9, 
   3.669064222535207*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Number", " ", "of", " ", "terms", " ", "in", " ", "invariance", " ", 
    "condition", " ", "and", " ", "the", " ", "derivatives", " ", "that", " ",
     "appear", " ", "in", " ", 
    RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plus", "@@", 
    RowBox[{"Length", "/@", 
     RowBox[{"FindInvariance", "[", 
      RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"Variables", "[", 
         RowBox[{"FindInvariance", "[", 
          RowBox[{
          "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", 
           RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"var", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "a_"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"var", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.665860553384531*^9, 3.665860557223929*^9}, {
   3.665860738233917*^9, 3.665860740785784*^9}, {3.6658612774842663`*^9, 
   3.66586128001158*^9}, {3.665862134590067*^9, 3.6658621370127*^9}, {
   3.665863682232481*^9, 3.6658636923756037`*^9}, 3.668474096744751*^9, {
   3.668970141349516*^9, 3.668970141613531*^9}, {3.669064201833414*^9, 
   3.669064207159317*^9}}],

Cell[BoxData["56"], "Output",
 CellChangeTimes->{
  3.665860568806402*^9, 3.665860699218162*^9, 3.665860749239545*^9, 
   3.665860819579459*^9, 3.6658609687318277`*^9, 3.6658610978311157`*^9, 
   3.665861176145685*^9, 3.665861281631703*^9, {3.665861323616026*^9, 
   3.6658613388447933`*^9}, 3.66586137306406*^9, 3.665861437934593*^9, 
   3.665861501300076*^9, 3.665861707960017*^9, 3.6658620570322323`*^9, 
   3.66586222951998*^9, 3.66586232498002*^9, 3.665863667447193*^9, 
   3.665863704429582*^9, 3.665864035012487*^9, 3.665867213835298*^9, 
   3.665867415896546*^9, 3.6658675788940573`*^9, 3.665876577588208*^9, 
   3.665882779043414*^9, {3.665883075700088*^9, 3.6658830991137543`*^9}, 
   3.665883332741406*^9, 3.6658836128544483`*^9, {3.665899649408271*^9, 
   3.6658996731491613`*^9}, 3.665899897463888*^9, 3.6659003582501183`*^9, 
   3.665903108062612*^9, 3.6659032261403837`*^9, {3.6659034131789093`*^9, 
   3.665903429433507*^9}, 3.6660501274578743`*^9, {3.666050163169466*^9, 
   3.6660501927679987`*^9}, {3.666050270589601*^9, 3.666050292672769*^9}, {
   3.66605034593267*^9, 3.6660503889818687`*^9}, 3.6660511260065804`*^9, 
   3.666051843524271*^9, 3.666051878750062*^9, 3.6660526708308487`*^9, {
   3.666053546166959*^9, 3.666053566616982*^9}, 3.666054216966113*^9, {
   3.666055567733122*^9, 3.666055584858246*^9}, 3.666055690742146*^9, 
   3.666063382573461*^9, 3.666064479608412*^9, 3.668474113629106*^9, 
   3.668635405854439*^9, 3.6686376124157763`*^9, 3.668662612212986*^9, 
   3.668662995646778*^9, 3.668698736715485*^9, {3.668970143891661*^9, 
   3.6689701591455336`*^9}, 3.6689705749863186`*^9, {3.669048649363625*^9, 
   3.6690486759927588`*^9}, {3.6690642080397663`*^9, 3.669064227223381*^9}, 
   3.669421097724646*^9, 3.6700425955678787`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "1"}], "}"}]], ",", 
   SubscriptBox["u", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0"}], "}"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665860568806402*^9, 3.665860699218162*^9, 3.665860749239545*^9, 
   3.665860819579459*^9, 3.6658609687318277`*^9, 3.6658610978311157`*^9, 
   3.665861176145685*^9, 3.665861281631703*^9, {3.665861323616026*^9, 
   3.6658613388447933`*^9}, 3.66586137306406*^9, 3.665861437934593*^9, 
   3.665861501300076*^9, 3.665861707960017*^9, 3.6658620570322323`*^9, 
   3.66586222951998*^9, 3.66586232498002*^9, 3.665863667447193*^9, 
   3.665863704429582*^9, 3.665864035012487*^9, 3.665867213835298*^9, 
   3.665867415896546*^9, 3.6658675788940573`*^9, 3.665876577588208*^9, 
   3.665882779043414*^9, {3.665883075700088*^9, 3.6658830991137543`*^9}, 
   3.665883332741406*^9, 3.6658836128544483`*^9, {3.665899649408271*^9, 
   3.6658996731491613`*^9}, 3.665899897463888*^9, 3.6659003582501183`*^9, 
   3.665903108062612*^9, 3.6659032261403837`*^9, {3.6659034131789093`*^9, 
   3.665903429433507*^9}, 3.6660501274578743`*^9, {3.666050163169466*^9, 
   3.6660501927679987`*^9}, {3.666050270589601*^9, 3.666050292672769*^9}, {
   3.66605034593267*^9, 3.6660503889818687`*^9}, 3.6660511260065804`*^9, 
   3.666051843524271*^9, 3.666051878750062*^9, 3.6660526708308487`*^9, {
   3.666053546166959*^9, 3.666053566616982*^9}, 3.666054216966113*^9, {
   3.666055567733122*^9, 3.666055584858246*^9}, 3.666055690742146*^9, 
   3.666063382573461*^9, 3.666064479608412*^9, 3.668474113629106*^9, 
   3.668635405854439*^9, 3.6686376124157763`*^9, 3.668662612212986*^9, 
   3.668662995646778*^9, 3.668698736715485*^9, {3.668970143891661*^9, 
   3.6689701591455336`*^9}, 3.6689705749863186`*^9, {3.669048649363625*^9, 
   3.6690486759927588`*^9}, {3.6690642080397663`*^9, 3.669064227223381*^9}, 
   3.669421097724646*^9, 3.6700425956108227`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]t", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Zeta]t1", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]x", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Zeta]x1", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Zeta]y", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "u_"}], "]"}], ":=", 
   RowBox[{"\[Zeta]y1", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "1", ",", 
      
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.665903131697522*^9, 3.665903148784086*^9}, {
   3.666050398837236*^9, 3.666050399279338*^9}, {3.666053593082354*^9, 
   3.6660536157305317`*^9}, 3.668474096856954*^9, {3.6689701658699183`*^9, 
   3.6689701661179323`*^9}, {3.6689703949270196`*^9, 
   3.6689703996782913`*^9}, {3.669064235718875*^9, 3.6690642400154963`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.050963`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Psi]u", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"t", ",", "x", ",", "y", ",", "u"}], "]"}], "\[Equal]", "0"}],
       "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665903150988785*^9, 3.665903226249514*^9, {3.665903414175057*^9, 
   3.665903431672311*^9}, 3.6660504022907867`*^9, 3.6660536166341248`*^9, 
   3.6660542181675243`*^9, {3.666055568465992*^9, 3.666055587407392*^9}, 
   3.6660556917456837`*^9, 3.6660633868527317`*^9, 3.666064480853383*^9, 
   3.668474113877866*^9, 3.668635408523217*^9, 3.668637612824785*^9, 
   3.668662616333633*^9, 3.668662996140284*^9, 3.668698737423613*^9, 
   3.6689701666579633`*^9, 3.6689705796345844`*^9, 3.669048680590583*^9, 
   3.669064242009198*^9, 3.669421098455885*^9, 3.670042596428512*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_", ",", "u_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Psi]u1", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
    RowBox[{"u", "*", 
     RowBox[{"\[Psi]u2", "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "2", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6659031545559464`*^9, 3.665903175848455*^9}, 
   3.665903219153366*^9, {3.666050404949828*^9, 3.666050405197604*^9}, {
   3.666053623057884*^9, 3.666053709834135*^9}, {3.666053749449257*^9, 
   3.666053784856822*^9}, {3.666054142695901*^9, 3.666054142951754*^9}, 
   3.6684740968947363`*^9, {3.668662621287641*^9, 3.668662623527041*^9}, {
   3.668970171029213*^9, 3.668970179341689*^9}, {3.6689705815586944`*^9, 
   3.668970585661929*^9}, {3.669064246006549*^9, 3.669064253503892*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.055954`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Zeta]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Zeta]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Zeta]y1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "\[Equal]", "0"}], ",", 
       
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Zeta]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Zeta]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Zeta]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.665903176142964*^9, {3.665903219619857*^9, 3.665903226302685*^9}, {
   3.665903414615954*^9, 3.6659034326001472`*^9}, 3.6660504066048326`*^9, {
   3.66605364557957*^9, 3.666053710330862*^9}, {3.666053751651816*^9, 
   3.666053785545227*^9}, 3.666054143691185*^9, 3.6660542187833433`*^9, {
   3.6660555694761667`*^9, 3.666055588588277*^9}, 3.666055692273541*^9, 
   3.666063388634656*^9, 3.666064481641279*^9, 3.668474113930626*^9, 
   3.668635409914447*^9, 3.668637613561523*^9, {3.6686626171139393`*^9, 
   3.6686626240246143`*^9}, 3.668662996273666*^9, 3.6686987378412952`*^9, 
   3.668970180363747*^9, 3.668970586477976*^9, 3.669048681834814*^9, {
   3.669064254545123*^9, 3.669064261572648*^9}, 3.66942109907867*^9, 
   3.670042597302122*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Taking", " ", "derivatives", " ", "of", " ", "each", " ", "of", " ", 
    "these", " ", "implies", " ", "the", " ", "third", " ", "derivatives", 
    " ", "all", " ", "vanish"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"eqns", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Zeta]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]y1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Zeta]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Zeta]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Zeta]x1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Zeta]t1", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Zeta]x1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Zeta]y1", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "\[Equal]", "0"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{"DeleteDuplicates", "[", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "x"}], "]"}], ",", "y"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "x"}], "]"}], ",", "t"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "y"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "y"}], "]"}], ",", "y"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "y"}], "]"}], ",", "t"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "t"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "t"}], "]"}], ",", "y"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"eqns", ",", "t"}], "]"}], ",", "t"}], "]"}]}], "]"}], 
     "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.666066470078071*^9, 3.666066525970261*^9}, {
   3.666066568273726*^9, 3.6660665801444693`*^9}, {3.668970553192072*^9, 
   3.6689705533520813`*^9}, 3.6689705901811876`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "3"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "3"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "3"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "3", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "3", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "3", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "1", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "1", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "1", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]t1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"3", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]x1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"3", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Zeta]y1", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"3", ",", "0", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"t", ",", "x", ",", "y"}], "]"}], "\[Rule]", "0"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6660664796232357`*^9, 3.666066528508996*^9, 
  3.6660665824013357`*^9, 3.668474114141438*^9, 3.668635413314988*^9, 
  3.668637613765718*^9, 3.668662627447624*^9, 3.668662996472438*^9, 
  3.668698738324284*^9, 3.668970192611448*^9, 3.668970591205246*^9, 
  3.669048683244643*^9, 3.669064264975379*^9, 3.6694210996734457`*^9, 
  3.6700425978897657`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "So", " ", "the", " ", "functions", " ", "are", " ", "at", " ", "most", 
    " ", "quadratic", " ", "in", " ", 
    RowBox[{"(", 
     RowBox[{"t", ",", "x", ",", "y"}], ")"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Zeta]x1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{"\[Zeta]x0", "+", 
      RowBox[{"\[Zeta]x100", "*", "t"}], "+", 
      RowBox[{"\[Zeta]x010", "*", "x"}], "+", 
      RowBox[{"\[Zeta]x001", "*", "y"}], "+", 
      RowBox[{"\[Zeta]x200", "*", 
       RowBox[{"t", "^", "2"}]}], "+", 
      RowBox[{"\[Zeta]x110", "*", "t", "*", "x"}], "+", 
      RowBox[{"\[Zeta]x101", "*", "t", "*", "y"}], "+", 
      RowBox[{"\[Zeta]x020", "*", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"\[Zeta]x011", "*", "x", "*", "y"}], "+", 
      RowBox[{"\[Zeta]x002", "*", 
       RowBox[{"y", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Zeta]y1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{"\[Zeta]y0", "+", 
      RowBox[{"\[Zeta]y100", "*", "t"}], "+", 
      RowBox[{"\[Zeta]y010", "*", "x"}], "+", 
      RowBox[{"\[Zeta]y001", "*", "y"}], "+", 
      RowBox[{"\[Zeta]y200", "*", 
       RowBox[{"t", "^", "2"}]}], "+", 
      RowBox[{"\[Zeta]y110", "*", "t", "*", "x"}], "+", 
      RowBox[{"\[Zeta]y101", "*", "t", "*", "y"}], "+", 
      RowBox[{"\[Zeta]y020", "*", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"\[Zeta]y011", "*", "x", "*", "y"}], "+", 
      RowBox[{"\[Zeta]y002", "*", 
       RowBox[{"y", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Zeta]t1", "[", 
      RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{"\[Zeta]t0", "+", 
      RowBox[{"\[Zeta]t100", "*", "t"}], "+", 
      RowBox[{"\[Zeta]t010", "*", "x"}], "+", 
      RowBox[{"\[Zeta]t001", "*", "y"}], "+", 
      RowBox[{"\[Zeta]t200", "*", 
       RowBox[{"t", "^", "2"}]}], "+", 
      RowBox[{"\[Zeta]t110", "*", "t", "*", "x"}], "+", 
      RowBox[{"\[Zeta]t101", "*", "t", "*", "y"}], "+", 
      RowBox[{"\[Zeta]t020", "*", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"\[Zeta]t011", "*", "x", "*", "y"}], "+", 
      RowBox[{"\[Zeta]t002", "*", 
       RowBox[{"y", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"AbsoluteTiming", "[", 
    RowBox[{"Part", "[", 
     RowBox[{
      RowBox[{"FindEquations", "[", 
       RowBox[{
       "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "4", 
        ",", 
        RowBox[{"extras", "\[Rule]", 
         RowBox[{"{", "u", "}"}]}], ",", 
        RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.666054726019513*^9, 3.666054789289844*^9}, {
   3.666054852337228*^9, 3.666055022417686*^9}, 3.6660659771262407`*^9, 
   3.666066536975575*^9, {3.6660665995527983`*^9, 3.666066625833684*^9}, 
   3.668474096917963*^9, {3.668662630767215*^9, 3.668662632575151*^9}, {
   3.668970199661851*^9, 3.6689702012779436`*^9}, {3.6689704107679253`*^9, 
   3.6689704678711915`*^9}, {3.669064269200918*^9, 3.669064271559094*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.12359`", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Zeta]y002", "+", "\[Zeta]y020"}], "\[Equal]", 
        RowBox[{"\[Zeta]y200", "+", 
         RowBox[{
          SuperscriptBox["\[Psi]u2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]x002", "+", "\[Zeta]x020"}], "\[Equal]", 
        RowBox[{"\[Zeta]x200", "+", 
         RowBox[{
          SuperscriptBox["\[Psi]u2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t002", "+", "\[Zeta]t020", "+", 
         RowBox[{
          SuperscriptBox["\[Psi]u2", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "\[Equal]", 
        "\[Zeta]t200"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6660550156247787`*^9, 3.666055022967764*^9}, {
   3.6660555705167313`*^9, 3.666055595501204*^9}, 3.666055692848688*^9, 
   3.666063444357768*^9, 3.6660666274344187`*^9, 3.666066700556127*^9, 
   3.6684741142863703`*^9, 3.66863541493521*^9, 3.668637614192024*^9, 
   3.668662633104026*^9, 3.668662996582778*^9, 3.668698738738036*^9, 
   3.6689702085673604`*^9, 3.6689705946234417`*^9, 3.669048684941476*^9, 
   3.669064272479754*^9, 3.669421100479862*^9, 3.6700425991641617`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]u2", "[", 
    RowBox[{"t_", ",", "x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"\[Psi]u0", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Zeta]y002", "+", "\[Zeta]y020", "-", "\[Zeta]y200"}], ")"}], 
     "*", "y"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Zeta]x002", "+", "\[Zeta]x020", "-", "\[Zeta]x200"}], ")"}], 
     "*", "x"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Zeta]t002", "+", "\[Zeta]t020", "-", "\[Zeta]t200"}], ")"}], 
     "*", "t"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "8", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6660550471082077`*^9, 3.666055149279943*^9}, 
   3.668474096921899*^9, {3.66866263585487*^9, 3.66866263754296*^9}, {
   3.668970214061675*^9, 3.6689702267894025`*^9}, {3.6689704724784555`*^9, 
   3.6689704871822968`*^9}, {3.6689705983416543`*^9, 
   3.6689706070701537`*^9}, {3.669064275599593*^9, 3.669064277902748*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.048614`", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Zeta]t100", "+", 
         RowBox[{"y", " ", "\[Zeta]t101"}], "+", 
         RowBox[{"x", " ", "\[Zeta]t110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Zeta]t200"}]}], "\[Equal]", 
        RowBox[{"\[Zeta]y001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Zeta]y002"}], "+", 
         RowBox[{"x", " ", "\[Zeta]y011"}], "+", 
         RowBox[{"t", " ", "\[Zeta]y101"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]x001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Zeta]x002"}], "+", 
         RowBox[{"x", " ", "\[Zeta]x011"}], "+", 
         RowBox[{"t", " ", "\[Zeta]x101"}], "+", "\[Zeta]y010", "+", 
         RowBox[{"y", " ", "\[Zeta]y011"}], "+", 
         RowBox[{"2", " ", "x", " ", "\[Zeta]y020"}], "+", 
         RowBox[{"t", " ", "\[Zeta]y110"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t100", "+", 
         RowBox[{"y", " ", "\[Zeta]t101"}], "+", 
         RowBox[{"x", " ", "\[Zeta]t110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Zeta]t200"}]}], "\[Equal]", 
        RowBox[{"\[Zeta]x010", "+", 
         RowBox[{"y", " ", "\[Zeta]x011"}], "+", 
         RowBox[{"2", " ", "x", " ", "\[Zeta]x020"}], "+", 
         RowBox[{"t", " ", "\[Zeta]x110"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Zeta]t002"}], "+", 
         RowBox[{"x", " ", "\[Zeta]t011"}], "+", 
         RowBox[{"t", " ", "\[Zeta]t101"}]}], "\[Equal]", 
        RowBox[{"\[Zeta]y100", "+", 
         RowBox[{"y", " ", "\[Zeta]y101"}], "+", 
         RowBox[{"x", " ", "\[Zeta]y110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Zeta]y200"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t010", "+", 
         RowBox[{"y", " ", "\[Zeta]t011"}], "+", 
         RowBox[{"2", " ", "x", " ", "\[Zeta]t020"}], "+", 
         RowBox[{"t", " ", "\[Zeta]t110"}]}], "\[Equal]", 
        RowBox[{"\[Zeta]x100", "+", 
         RowBox[{"y", " ", "\[Zeta]x101"}], "+", 
         RowBox[{"x", " ", "\[Zeta]x110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Zeta]x200"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.666055116136882*^9, 3.666055149883089*^9}, 
   3.6660555974825*^9, 3.666055693640238*^9, 3.666063463067082*^9, 
   3.666066701595522*^9, 3.668474114379634*^9, 3.668635416318454*^9, 
   3.668637615404524*^9, 3.6686626379432583`*^9, 3.668662996706298*^9, 
   3.6686987417894583`*^9, 3.6689702296515665`*^9, 3.668970610892372*^9, 
   3.669048686623578*^9, 3.669064278381962*^9, 3.6694211010848503`*^9, 
   3.670042600013877*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Zeta]t100", ":=", "\[Zeta]y001"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]t101", ":=", 
   RowBox[{"2", "*", "\[Zeta]y002"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]t110", ":=", "\[Zeta]y011"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]t200", ":=", 
   RowBox[{"\[Zeta]y101", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "8", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.666055159981778*^9, 3.666055256368299*^9}, {
   3.6660553260398397`*^9, 3.666055326375011*^9}, 3.66847409692445*^9, {
   3.668662640271125*^9, 3.6686626423432837`*^9}, {3.6689702378380346`*^9, 
   3.668970239638138*^9}, {3.6689704932856455`*^9, 3.6689704999100246`*^9}, {
   3.6690642809594727`*^9, 3.669064283006822*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.081777`", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Zeta]x001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Zeta]x002"}], "+", 
         RowBox[{"x", " ", "\[Zeta]x011"}], "+", 
         RowBox[{"t", " ", "\[Zeta]x101"}], "+", "\[Zeta]y010", "+", 
         RowBox[{"y", " ", "\[Zeta]y011"}], "+", 
         RowBox[{"2", " ", "x", " ", "\[Zeta]y020"}], "+", 
         RowBox[{"t", " ", "\[Zeta]y110"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]x010", "+", 
         RowBox[{"y", " ", "\[Zeta]x011"}], "+", 
         RowBox[{"2", " ", "x", " ", "\[Zeta]x020"}], "+", 
         RowBox[{"t", " ", "\[Zeta]x110"}]}], "\[Equal]", 
        RowBox[{"\[Zeta]y001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Zeta]y002"}], "+", 
         RowBox[{"x", " ", "\[Zeta]y011"}], "+", 
         RowBox[{"t", " ", "\[Zeta]y101"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Zeta]t002"}], "+", 
         RowBox[{"x", " ", "\[Zeta]t011"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Zeta]y002"}]}], "\[Equal]", 
        RowBox[{"\[Zeta]y100", "+", 
         RowBox[{"y", " ", "\[Zeta]y101"}], "+", 
         RowBox[{"x", " ", "\[Zeta]y110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Zeta]y200"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t010", "+", 
         RowBox[{"y", " ", "\[Zeta]t011"}], "+", 
         RowBox[{"2", " ", "x", " ", "\[Zeta]t020"}], "+", 
         RowBox[{"t", " ", "\[Zeta]y011"}]}], "\[Equal]", 
        RowBox[{"\[Zeta]x100", "+", 
         RowBox[{"y", " ", "\[Zeta]x101"}], "+", 
         RowBox[{"x", " ", "\[Zeta]x110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Zeta]x200"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.666055224408532*^9, 3.666055256760015*^9}, 
   3.6660553288592873`*^9, 3.666055601135396*^9, 3.666055694760935*^9, 
   3.6660634962873783`*^9, 3.666066704029127*^9, 3.66847411448763*^9, 
   3.668635418014326*^9, 3.668637615539815*^9, 3.668662642806551*^9, 
   3.668662996883582*^9, 3.668698742702355*^9, 3.6689702412492294`*^9, 
   3.668970612705476*^9, 3.669048687723939*^9, 3.669064283646122*^9, 
   3.6694211018434553`*^9, 3.670042600977887*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Zeta]x001", ":=", 
   RowBox[{"-", "\[Zeta]y010"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]x002", ":=", 
   RowBox[{
    RowBox[{"-", "\[Zeta]y011"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]x011", ":=", 
   RowBox[{
    RowBox[{"-", "2"}], "*", "\[Zeta]y020"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]x101", ":=", 
   RowBox[{"-", "\[Zeta]y110"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "8", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.666055232224422*^9, 3.666055331613624*^9}, 
   3.666055517470454*^9, {3.6660635202293997`*^9, 3.666063522699864*^9}, {
   3.666063572444113*^9, 3.666063572556229*^9}, 3.668474096926559*^9, {
   3.668662644838756*^9, 3.6686626465110893`*^9}, {3.6689702444454126`*^9, 
   3.668970245989501*^9}, {3.6689705027821884`*^9, 3.6689705095105734`*^9}, {
   3.669064286119432*^9, 3.669064288038859*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.060282`", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Zeta]x010", "+", 
         RowBox[{"2", " ", "x", " ", "\[Zeta]x020"}], "+", 
         RowBox[{"t", " ", "\[Zeta]x110"}]}], "\[Equal]", 
        RowBox[{"\[Zeta]y001", "+", 
         RowBox[{"x", " ", "\[Zeta]y011"}], "+", 
         RowBox[{"2", " ", "y", " ", 
          RowBox[{"(", 
           RowBox[{"\[Zeta]y002", "+", "\[Zeta]y020"}], ")"}]}], "+", 
         RowBox[{"t", " ", "\[Zeta]y101"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Zeta]t002"}], "+", 
         RowBox[{"x", " ", "\[Zeta]t011"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Zeta]y002"}]}], "\[Equal]", 
        RowBox[{"\[Zeta]y100", "+", 
         RowBox[{"y", " ", "\[Zeta]y101"}], "+", 
         RowBox[{"x", " ", "\[Zeta]y110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Zeta]y200"}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t010", "+", 
         RowBox[{"2", " ", "x", " ", "\[Zeta]t020"}], "+", 
         RowBox[{"t", " ", "\[Zeta]y011"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"\[Zeta]t011", "+", "\[Zeta]y110"}], ")"}]}]}], "\[Equal]", 
        RowBox[{"\[Zeta]x100", "+", 
         RowBox[{"x", " ", "\[Zeta]x110"}], "+", 
         RowBox[{"2", " ", "t", " ", "\[Zeta]x200"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6660553320509987`*^9, 3.666055524620995*^9, 
  3.666055605041008*^9, 3.666055695669901*^9, 3.666063598650186*^9, 
  3.666066704859415*^9, 3.668474114577697*^9, 3.668635419263146*^9, 
  3.668637615696096*^9, 3.668662646926715*^9, 3.668662997019202*^9, 
  3.6686987434107523`*^9, 3.6689702845367055`*^9, 3.668970614088555*^9, 
  3.6690486887470293`*^9, 3.6690642888213043`*^9, 3.669421102588119*^9, 
  3.670042601754517*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Zeta]x010", ":=", "\[Zeta]y001"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]x020", ":=", 
   RowBox[{"\[Zeta]y011", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]x110", ":=", "\[Zeta]y101"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]y002", ":=", 
   RowBox[{"-", "\[Zeta]y020"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "8", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6660553592096243`*^9, 3.6660554054607964`*^9}, {
   3.6660636222992764`*^9, 3.666063645764427*^9}, 3.6684740969284773`*^9, {
   3.668662650102881*^9, 3.668662651998755*^9}, {3.6689702869338427`*^9, 
   3.6689702886939435`*^9}, {3.6689705123977385`*^9, 3.668970519206128*^9}, {
   3.6690642911910067`*^9, 3.669064293223402*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.064094`", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Zeta]t001", "+", 
         RowBox[{"2", " ", "y", " ", "\[Zeta]t002"}], "+", 
         RowBox[{"x", " ", "\[Zeta]t011"}]}], "\[Equal]", 
        RowBox[{"\[Zeta]y100", "+", 
         RowBox[{"y", " ", "\[Zeta]y101"}], "+", 
         RowBox[{"x", " ", "\[Zeta]y110"}], "+", 
         RowBox[{"2", " ", "t", " ", 
          RowBox[{"(", 
           RowBox[{"\[Zeta]y020", "+", "\[Zeta]y200"}], ")"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"\[Zeta]t010", "+", 
         RowBox[{"2", " ", "x", " ", "\[Zeta]t020"}], "+", 
         RowBox[{"t", " ", "\[Zeta]y011"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"\[Zeta]t011", "+", "\[Zeta]y110"}], ")"}]}]}], "\[Equal]", 
        RowBox[{"\[Zeta]x100", "+", 
         RowBox[{"2", " ", "t", " ", "\[Zeta]x200"}], "+", 
         RowBox[{"x", " ", "\[Zeta]y101"}]}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.666055405885563*^9, 3.666055607329339*^9, 
  3.666055696803537*^9, 3.666063669119101*^9, 3.666066705393224*^9, 
  3.668474114661376*^9, 3.668635420509329*^9, 3.668637615888607*^9, 
  3.668662652473236*^9, 3.6686629971472483`*^9, 3.6686987442302217`*^9, 
  3.6689702897950068`*^9, 3.668970615884658*^9, 3.6690486895805492`*^9, 
  3.669064293915196*^9, 3.66942110340793*^9, 3.670042602461754*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Zeta]t001", ":=", "\[Zeta]y100"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]t002", ":=", 
   RowBox[{"\[Zeta]y101", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]t011", ":=", "\[Zeta]y110"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]y200", ":=", 
   RowBox[{"-", "\[Zeta]y020"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"Part", "[", 
   RowBox[{
    RowBox[{"FindEquations", "[", 
     RowBox[{
     "\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor", ",", "7", ",", 
      
      RowBox[{"extras", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}], ",", 
      RowBox[{"Adjoint", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.666055424436131*^9, 3.6660554722283497`*^9}, {
   3.66606372768232*^9, 3.6660637354340887`*^9}, 3.6684740969301167`*^9, {
   3.668662654902094*^9, 3.668662657151016*^9}, {3.6689702919731307`*^9, 
   3.6689702940302486`*^9}, {3.6689705218782806`*^9, 3.668970528718672*^9}, {
   3.669064296055175*^9, 3.669064298126793*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.039138`", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Zeta]t010", "+", 
        RowBox[{"2", " ", "x", " ", "\[Zeta]t020"}], "+", 
        RowBox[{"t", " ", "\[Zeta]y011"}], "+", 
        RowBox[{"2", " ", "y", " ", "\[Zeta]y110"}]}], "\[Equal]", 
       RowBox[{"\[Zeta]x100", "+", 
        RowBox[{"2", " ", "t", " ", "\[Zeta]x200"}], "+", 
        RowBox[{"x", " ", "\[Zeta]y101"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.666055466548276*^9, 3.666055472766152*^9}, 
   3.666055610089542*^9, 3.66605569832584*^9, {3.666063723812573*^9, 
   3.666063735657466*^9}, 3.666066705947562*^9, 3.668474114732051*^9, 
   3.668635422373028*^9, 3.6686376161007433`*^9, 3.6686626576473618`*^9, 
   3.6686629972601423`*^9, 3.668698744888081*^9, 3.6689702952023153`*^9, 
   3.6689706172277346`*^9, 3.669048690293544*^9, 3.669064299424285*^9, 
   3.669421104261396*^9, 3.670042603142415*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Zeta]t010", ":=", "\[Zeta]x100"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]t020", ":=", 
   RowBox[{"\[Zeta]y101", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]y011", ":=", 
   RowBox[{"2", "*", "\[Zeta]x200"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Zeta]y110", ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"FindInvariance", "[", 
   RowBox[{"\[CapitalDelta]", ",", "var", ",", "Q", ",", "solvefor"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Flatten", "[", "Q", "]"}], "[", 
      RowBox[{"[", "i", "]"}], "]"}], "@@", 
     RowBox[{"Flatten", "[", 
      RowBox[{"var", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", 
       RowBox[{"Flatten", "[", "Q", "]"}], "]"}]}], "}"}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6660557331511593`*^9, 3.6660558769625673`*^9}, {
   3.666063752609592*^9, 3.6660637528986673`*^9}, {3.666063793145479*^9, 
   3.666063811572357*^9}, 3.6684740969315434`*^9, {3.668662660766488*^9, 
   3.668662662678835*^9}, {3.6689702979974756`*^9, 3.668970320750777*^9}, {
   3.6689705316858416`*^9, 3.6689705387102437`*^9}, {3.669064303518046*^9, 
   3.669064305950079*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["\[Psi]u1", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["\[Psi]u1", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}], "+", 
   RowBox[{
    SuperscriptBox["\[Psi]u1", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6660558742088537`*^9, 3.666055877496743*^9}, 
   3.66606381919473*^9, 3.6660667064749937`*^9, 3.668474114793344*^9, 
   3.668635423446528*^9, 3.668637616238883*^9, 3.66866266307717*^9, 
   3.668662997360663*^9, 3.668698745665975*^9, {3.668970304313837*^9, 
   3.6689703233869276`*^9}, 3.668970619127843*^9, 3.669048691168351*^9, 
   3.669064307641079*^9, 3.6694211050863647`*^9, 3.670042603695112*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "x"}], " ", "\[Zeta]x200"}], "+", 
      RowBox[{"y", " ", "\[Zeta]y020"}], "-", 
      FractionBox[
       RowBox[{"t", " ", "\[Zeta]y101"}], "2"], "+", "\[Psi]u0"}], ")"}], " ", 
    RowBox[{"u", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "+", 
   RowBox[{"\[Psi]u1", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Zeta]y0", "+", 
      RowBox[{"y", " ", "\[Zeta]y001"}], "+", 
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "y", " ", "\[Zeta]x200"}], "+", "\[Zeta]y010"}], 
        ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["t", "2"], " ", "\[Zeta]y020"}], "+", 
      RowBox[{
       SuperscriptBox["x", "2"], " ", "\[Zeta]y020"}], "-", 
      RowBox[{
       SuperscriptBox["y", "2"], " ", "\[Zeta]y020"}], "+", 
      RowBox[{"t", " ", "\[Zeta]y100"}], "+", 
      RowBox[{"t", " ", "y", " ", "\[Zeta]y101"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Zeta]x0", "+", 
      RowBox[{
       SuperscriptBox["t", "2"], " ", "\[Zeta]x200"}], "+", 
      RowBox[{
       SuperscriptBox["x", "2"], " ", "\[Zeta]x200"}], "-", 
      RowBox[{
       SuperscriptBox["y", "2"], " ", "\[Zeta]x200"}], "+", 
      RowBox[{"x", " ", "\[Zeta]y001"}], "-", 
      RowBox[{"y", " ", "\[Zeta]y010"}], "-", 
      RowBox[{"2", " ", "x", " ", "y", " ", "\[Zeta]y020"}], "+", 
      RowBox[{"t", " ", 
       RowBox[{"(", 
        RowBox[{"\[Zeta]x100", "+", 
         RowBox[{"x", " ", "\[Zeta]y101"}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "\[Zeta]t0"}], "+", 
      RowBox[{"2", " ", "x", " ", 
       RowBox[{"(", 
        RowBox[{"\[Zeta]x100", "+", 
         RowBox[{"2", " ", "t", " ", "\[Zeta]x200"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "t", " ", "\[Zeta]y001"}], "-", 
      RowBox[{"4", " ", "t", " ", "y", " ", "\[Zeta]y020"}], "+", 
      RowBox[{"2", " ", "y", " ", "\[Zeta]y100"}], "+", 
      RowBox[{
       SuperscriptBox["t", "2"], " ", "\[Zeta]y101"}], "+", 
      RowBox[{
       SuperscriptBox["x", "2"], " ", "\[Zeta]y101"}], "+", 
      RowBox[{
       SuperscriptBox["y", "2"], " ", "\[Zeta]y101"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6660558742088537`*^9, 3.666055877496743*^9}, 
   3.66606381919473*^9, 3.6660667064749937`*^9, 3.668474114793344*^9, 
   3.668635423446528*^9, 3.668637616238883*^9, 3.66866266307717*^9, 
   3.668662997360663*^9, 3.668698745665975*^9, {3.668970304313837*^9, 
   3.6689703233869276`*^9}, 3.668970619127843*^9, 3.669048691168351*^9, 
   3.669064307641079*^9, 3.6694211050863647`*^9, 3.67004260374889*^9}]
}, Open  ]]
},
WindowSize->{755, 814},
WindowMargins->{{Automatic, 55}, {Automatic, 3}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 265, 4, 32, "Input"],
Cell[826, 26, 3947, 97, 231, "Input"],
Cell[CellGroupData[{
Cell[4798, 127, 1682, 41, 165, "Input"],
Cell[6483, 170, 1812, 26, 32, "Output"],
Cell[8298, 198, 2588, 52, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10923, 255, 622, 14, 32, "Input"],
Cell[11548, 271, 3073, 79, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14658, 355, 1251, 34, 99, "Input"],
Cell[15912, 391, 1045, 24, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16994, 420, 1198, 29, 77, "Input"],
Cell[18195, 451, 3800, 105, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22032, 561, 4837, 142, 262, "Input"],
Cell[26872, 705, 8824, 279, 246, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35733, 989, 3142, 77, 209, "Input"],
Cell[38878, 1068, 1830, 46, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40745, 1119, 1175, 32, 99, "Input"],
Cell[41923, 1153, 2611, 57, 187, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44571, 1215, 1062, 25, 143, "Input"],
Cell[45636, 1242, 2243, 49, 143, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47916, 1296, 1211, 30, 143, "Input"],
Cell[49130, 1328, 1858, 42, 121, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51025, 1375, 1064, 25, 143, "Input"],
Cell[52092, 1402, 1418, 33, 99, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53547, 1440, 1061, 25, 143, "Input"],
Cell[54611, 1467, 965, 21, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55613, 1493, 1379, 34, 165, "Input"],
Cell[56995, 1529, 1185, 33, 37, "Output"],
Cell[58183, 1564, 3445, 95, 222, "Output"]
}, Open  ]],
Cell[61643, 1662, 3427, 80, 187, "Input"],
Cell[CellGroupData[{
Cell[65095, 1746, 1739, 42, 187, "Input"],
Cell[66837, 1790, 1770, 25, 32, "Output"],
Cell[68610, 1817, 2546, 51, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71193, 1873, 1394, 36, 121, "Input"],
Cell[72590, 1911, 1070, 24, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73697, 1940, 1298, 30, 99, "Input"],
Cell[74998, 1972, 3866, 106, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78901, 2083, 4929, 142, 262, "Input"],
Cell[83833, 2227, 8913, 280, 246, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92783, 2512, 3312, 78, 231, "Input"],
Cell[96098, 2592, 1869, 46, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98004, 2643, 1347, 34, 121, "Input"],
Cell[99354, 2679, 2720, 58, 187, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102111, 2742, 1192, 29, 165, "Input"],
Cell[103306, 2773, 2330, 49, 165, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105673, 2827, 1341, 34, 165, "Input"],
Cell[107017, 2863, 1935, 43, 121, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108989, 2911, 1192, 29, 165, "Input"],
Cell[110184, 2942, 1474, 33, 99, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111695, 2980, 1187, 29, 165, "Input"],
Cell[112885, 3011, 999, 21, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113921, 3037, 1448, 36, 165, "Input"],
Cell[115372, 3075, 1206, 33, 37, "Output"],
Cell[116581, 3110, 3527, 95, 222, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
