(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      6087,        155]
NotebookOptionsPosition[      5159,        120]
NotebookOutlinePosition[      5820,        145]
CellTagsIndexPosition[      5736,        140]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Run", " ", "this", " ", "to", " ", "copy", " ", "the", " ", "zgnsymmetry",
     " ", "package", " ", "to", " ", "the", " ", "users", " ", "Application", 
    " ", "folder"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"file", "=", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "$UserBaseDirectory", ",", "\"\<Applications\>\"", ",", 
        "\"\<zgnsymmetry.m\>\""}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"FileExistsQ", "[", "file", "]"}], ",", 
      RowBox[{"DeleteFile", "[", "file", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CopyFile", "[", 
     RowBox[{
      RowBox[{"FileNameJoin", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", 
         "\"\<zgnsymmetry.m\>\""}], "}"}], "]"}], ",", "file"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.665867003172731*^9, 3.665867028300831*^9}, {
   3.665875226102306*^9, 3.6658752272245502`*^9}, {3.668877515723652*^9, 
   3.668877515996009*^9}, {3.668894827530658*^9, 3.668894827795227*^9}, {
   3.670000262838501*^9, 3.670000311077991*^9}, {3.6700902472162457`*^9, 
   3.670090250191416*^9}, 3.6700902904477186`*^9, {3.6700905225589943`*^9, 
   3.670090523287036*^9}, 3.670090673647636*^9}],

Cell[BoxData[
 RowBox[{"<<", "zgnsymmetry`"}]], "Input",
 CellChangeTimes->{{3.666057393249763*^9, 3.666057404614176*^9}, {
   3.666057867033637*^9, 3.6660578705533247`*^9}, {3.666058013257916*^9, 
   3.666058015809767*^9}, {3.669414976283463*^9, 3.669414977395287*^9}, 
   3.670007451703908*^9, {3.6700904833437514`*^9, 3.6700905354707327`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"?", "FindInvariance"}], "\[IndentingNewLine]", 
 RowBox[{"?", "FindAllEquations"}], "\[IndentingNewLine]", 
 RowBox[{"?", "FindEquations"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"FindInvariance[Delta,var,Q,solvefor] gives the invariance \
criteria for the list of differential equations Delta==0, where \
var={indep,dep} is a list of lists of the independent and dependent \
variables, Q the characters of the symmetry. The equation Delta==0 is solved \
for the variables in solvefor.  The symbols in Delta, Q, and solvefor should \
be functions of the independent variables, so that e.g. \
Apply[Delta[[1]],var[[1]]] gives the first equations. The option \
Adjoint->True can be added to search for adjoing symmetries.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.670090681185067*^9},
 CellTags->"Info3670065481-9714572"],

Cell[BoxData[
 StyleBox["\<\"FindAllEquations[Delta,var,vec,solvefor] gives the all the \
equations from the coefficients of derivatives in the symmetry criteria for \
the given system. Arguments are as in FindInvariance. The option \
Adjoint->True can be added to search for adjoint symmetries.  The options \
extras->extralist and excluded->excludedlist can be aded to add or exclude \
monomial terms in the expansion.  The option Assumptions->assumptions can be \
added to include assumptions in the simplification.  Lastly, the option \
SuppressArgs->True can be added to suppress arguments and use a more compact \
notation for derivatives.  FindAllEquations returns {numeqns, \
independenteqns, monomials, eqns}, where numeqns is the number of independent \
equations, independenteqns is a list of the independent equations, monomials \
is a list of the monomials whose coefficients are the equations for each \
equation in FindInvariance, and eqns is a list of the equations corresponding \
to monomials for each equation in FindInvariance.\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellChangeTimes->{3.6700906812480707`*^9},
 CellTags->"Info3670065481-9714572"],

Cell[BoxData[
 StyleBox["\<\"FindEquations[Delta,var,vec,solvefor,numterms] gives the the \
equations with only numterms terms appearing  from the coefficients of \
derivatives in the symmetry criteria for the given system. Arguments are as \
in FindInvariance, and options are as in FindAllEquations. FindEquations \
returns {eqnsnum, eqns, monomials} where  eqnsnum is the total number of \
equations from FindAllEquations, eqns is a list of equations with terms \
terms, and monomials is a list specifying which equation and which monomial \
each equation in eqns comes from. \"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.6700906813100743`*^9},
 CellTags->"Info3670065481-9714572"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{749, 683},
WindowMargins->{{64, Automatic}, {-10, Automatic}},
FrontEndVersion->"10.0 for Microsoft Windows (64-bit) (September 9, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3670065481-9714572"->{
  Cell[2571, 74, 688, 11, 109, "Print",
   CellTags->"Info3670065481-9714572"],
  Cell[3262, 87, 1168, 17, 194, "Print",
   CellTags->"Info3670065481-9714572"],
  Cell[4433, 106, 698, 10, 109, "Print",
   CellTags->"Info3670065481-9714572"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3670065481-9714572", 5470, 130}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1438, 36, 92, "Input"],
Cell[1999, 58, 346, 5, 31, "Input"],
Cell[CellGroupData[{
Cell[2370, 67, 176, 3, 72, "Input"],
Cell[CellGroupData[{
Cell[2571, 74, 688, 11, 109, "Print",
 CellTags->"Info3670065481-9714572"],
Cell[3262, 87, 1168, 17, 194, "Print",
 CellTags->"Info3670065481-9714572"],
Cell[4433, 106, 698, 10, 109, "Print",
 CellTags->"Info3670065481-9714572"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
