(* ::Package:: *)

BeginPackage["zgnsymmetry`"]
FindInvariance::usage = "FindInvariance[Delta,var,Q,solvefor] gives the \
invariance criteria for the list of differential equations Delta==0, where \
var={indep,dep} is a list of lists of the independent and dependent variables, Q \
the characters of the symmetry. The equation Delta==0 is solved for the \
variables in solvefor.  The symbols in Delta, Q, and solvefor should be \
functions of the independent variables, so that e.g. Apply[Delta[[1]],var[[1]]] \
gives the first equations. The option Adjoint->True can be added to search for \
adjoing symmetries."
FindAllEquations::usage = "FindAllEquations[Delta,var,vec,solvefor] gives the \
all the equations from the coefficients of derivatives in the symmetry criteria \
for the given system. Arguments are as in FindInvariance. The option \
Adjoint->True can be added to search for adjoint symmetries.  The options \
extras->extralist and excluded->excludedlist can be aded to add or exclude \
monomial terms in the expansion.  The option Assumptions->assumptions can be \
added to include assumptions in the simplification.  Lastly, the option \
SuppressArgs->True can be added to suppress arguments and use a more compact \
notation for derivatives.  FindAllEquations returns {numeqns, independenteqns, \
monomials, eqns}, where numeqns is the number of independent equations, \
independenteqns is a list of the independent equations, monomials is a list of \
the monomials whose coefficients are the equations for each equation in \
FindInvariance, and eqns is a list of the equations corresponding to monomials \
for each equation in FindInvariance."; 
FindEquations::usage = "FindEquations[Delta,var,vec,solvefor,numterms] gives the \
the equations with only numterms terms appearing  from the coefficients of \
derivatives in the symmetry criteria for the given system. Arguments are as in \
FindInvariance, and options are as in FindAllEquations. FindEquations returns \
{eqnsnum, eqns, monomials} where  eqnsnum is the total number of equations from \
FindAllEquations, eqns is a list of equations with terms terms, and monomials is \
a list specifying which equation and which monomial each equation in eqns comes \
from. "; 
Options[FindInvariance] = {"Adjoint" -> False}; 
Options[FindAllEquations] = {"Adjoint" -> False, "extras" -> {}, 
    "excluded" -> {}, "Assumptions" -> {}, "SuppressArgs" -> False}; 
Options[FindEquations] = {"Adjoint" -> False, "extras" -> {}, "excluded" -> {}, 
    "Assumptions" -> {}, "SuppressArgs" -> False}; 
Begin["`Private`"]
FindInvariance[Delta_, var_, Q_, solvefor_, OptionsPattern[]] := 
   Module[{simpl, derivs, derivs2, sol, Qp, G, Gp, cases, vars, ret, F, 
     Compare}, simpl = Join[Table[var[[2]][[j]][l__] -> var[[2]][[j]], 
        {j, 1, Length[var[[2]]]}], Table[Derivative[l__][var[[2]][[j]]] @@ 
          var[[1]] -> Subscript[var[[2]][[j]], {l}], {j, 1, Length[var[[2]]]}]]; 
     derivs = Flatten[Table[Cases[Variables[Through[Delta @@ var[[1]]] /. 
           simpl], Subscript[var[[2]][[i]], j__]], {i, 1, Length[var[[2]]]}]]; 
     derivs2 = Table[Last[derivs[[i]]], {i, 1, Length[derivs]}]; 
     F[args__] := Solve[Through[Delta @@ {args}] == 0, 
        Through[solvefor @@ {args}]][[1]]; sol = F @@ var[[1]]; 
     Compare[i_, j_] := First[i] == First[j] && 
       And @@ Table[Last[i][[k]] >= Last[j][[k]], {k, 1, Length[var[[1]]]}]; 
     G[n_, k_][args__] := D[Delta[[n]] @@ {args}, 
       (Derivative @@ derivs2[[k]])[derivs[[k]][[1]]] @@ {args}]; 
     Gp[n_, k_] := (Derivative @@ derivs2[[k]])[G[n, k]] @@ var[[1]]; 
     Qp[n_, k_] := (Derivative @@ derivs2[[k]])[Q[[n]]] @@ var[[1]]; 
     If[OptionValue["Adjoint"], 
      ret = Expand[Table[Expand[Sum[Q[[n]] @@ var[[1]]*D[Delta[[n]] @@ var[[1]], 
                 var[[2]][[m]] @@ var[[1]]], {n, 1, Length[Delta]}]], 
             {m, 1, Length[var[[2]]]}] + Sum[Product[(-1)^derivs2[[k]][[j]], {j, 
                1, Length[var[[1]]]}]*UnitVector[Length[var[[2]]], First[
                Flatten[Position[var[[2]], First[derivs[[k]]]]]]]*Gp[n, k]*
              Q[[n]] @@ var[[1]], {k, 1, Length[derivs]}, 
             {n, 1, Length[Delta]}] + Sum[Product[(-1)^derivs2[[k]][[j]], {j, 1, 
                Length[var[[1]]]}]*UnitVector[Length[var[[2]]], First[
                Flatten[Position[var[[2]], First[derivs[[k]]]]]]]*
              G[n, k] @@ var[[1]]*Qp[n, k], {k, 1, Length[derivs]}, 
             {n, 1, Length[Delta]}] /. sol /. simpl]; , 
      ret = Expand[Sum[Q[[m]] @@ var[[1]]*D[Through[Delta @@ var[[1]]], 
               var[[2]][[m]] @@ var[[1]]], {m, 1, Length[var[[2]]]}] + 
            Sum[D[Through[Delta @@ var[[1]]] /. simpl, derivs[[k]]]*
              Qp[First[Flatten[Position[var[[2]], First[derivs[[k]]]]]], k], 
             {k, 1, Length[derivs]}] /. sol /. simpl]; ]; 
     vars = Table[Cases[Variables[ret], Subscript[var[[2]][[j]], l_]], 
       {j, 1, Length[var[[2]]]}]; 
     cases = Table[Last /@ Cases[vars[[j]], i__ /; Compare[i, 
           solvefor[[j]] @@ var[[1]] /. simpl]], {j, 1, Length[solvefor]}]; 
     cases = DeleteDuplicates[Flatten[Table[cases[[j]][[i]] - 
          Last[solvefor[[j]] @@ var[[1]] /. simpl], {j, 1, Length[var[[2]]]}, 
         {i, 1, Length[cases[[j]]]}], 1]]; While[cases != {}, 
      sol = Flatten[Join[sol, Flatten[Through[Through[(Apply[Derivative, cases, 
                 {1}])[F]] @@ var[[1]]] /. sol]]]; 
       While[True, If[TrueQ[Expand[Last /@ sol - Last /@ (sol /. sol)] == 
            Table[0, {i, 1, Length[sol]}]], Break[]; , 
          sol = Table[First[sol[[i]]] -> Last[(sol /. sol)[[i]]], 
             {i, 1, Length[sol]}]; ]; ]; If[OptionValue["Adjoint"], 
        ret = Expand[Table[Expand[Sum[Q[[n]] @@ var[[1]]*D[Delta[[n]] @@ 
                    var[[1]], var[[2]][[m]] @@ var[[1]]], {n, 1, Length[
                   Delta]}]], {m, 1, Length[var[[2]]]}] + 
              Sum[Product[(-1)^derivs2[[k]][[j]], {j, 1, Length[var[[1]]]}]*
                UnitVector[Length[var[[2]]], First[Flatten[Position[var[[2]], 
                    First[derivs[[k]]]]]]]*Gp[n, k]*Q[[n]] @@ var[[1]], {k, 1, 
                Length[derivs]}, {n, 1, Length[Delta]}] + 
              Sum[Product[(-1)^derivs2[[k]][[j]], {j, 1, Length[var[[1]]]}]*
                UnitVector[Length[var[[2]]], First[Flatten[Position[var[[2]], 
                    First[derivs[[k]]]]]]]*G[n, k] @@ var[[1]]*Qp[n, k], {k, 1, 
                Length[derivs]}, {n, 1, Length[Delta]}] /. sol /. simpl]; , 
        ret = Expand[Sum[Q[[m]] @@ var[[1]]*D[Through[Delta @@ var[[1]]], 
                 var[[2]][[m]] @@ var[[1]]], {m, 1, Length[var[[2]]]}] + 
              Sum[D[Through[Delta @@ var[[1]]] /. simpl, derivs[[k]]]*
                Qp[First[Flatten[Position[var[[2]], First[derivs[[k]]]]]], k], {
                k, 1, Length[derivs]}] /. sol /. simpl]; ]; 
       vars = Table[Cases[Variables[ret], Subscript[var[[2]][[j]], l_]], 
         {j, 1, Length[var[[2]]]}]; cases = 
        Table[Last /@ Cases[vars[[j]], i__ /; Compare[i, 
             solvefor[[j]] @@ var[[1]] /. simpl]], {j, 1, Length[solvefor]}]; 
       cases = DeleteDuplicates[Flatten[Table[cases[[j]][[i]] - 
            Last[solvefor[[j]] @@ var[[1]] /. simpl], {j, 1, Length[var[[2]]]}, 
           {i, 1, Length[cases[[j]]]}], 1]]; ]; ret]; 
FindAllEquations[Delta_, var_, Q_, solvefor_, OptionsPattern[]] := 
   Module[{f, coeffs, eqns, eqns2, monomialrules, monomials, crules, simpl}, 
    f = FindInvariance[Delta, var, Q, solvefor, "Adjoint" -> 
        OptionValue["Adjoint"]]; coeffs = Join[OptionValue["extras"], 
       Flatten[Table[Cases[Variables[f], Subscript[var[[2]][[k]], l__]], 
         {k, 1, Length[var[[2]]]}]]]; 
     simpl = Join[Table[var[[2]][[j]][l__] -> var[[2]][[j]], 
        {j, 1, Length[var[[2]]]}], Table[Derivative[l__][var[[2]][[j]]] @@ 
          var[[1]] -> Subscript[var[[2]][[j]], {l}], {j, 1, Length[var[[2]]]}]]; 
     coeffs = Complement[coeffs, OptionValue["excluded"] /. simpl]; 
     If[TrueQ[coeffs == {}], eqns = Table[{f[[i]]}, {i, 1, Length[f]}]; 
       monomials = Table[{1}, {i, 1, Length[f]}]; , 
      crules = Table[CoefficientRules[If[TrueQ[OptionValue["extras"] == {}], 
           f[[i]], Numerator[Together[f[[i]]]]], coeffs], {i, 1, Length[f]}]; 
       eqns = Table[Last /@ crules[[i]], {i, 1, Length[f]}]; 
       monomialrules = Table[First /@ crules[[i]], {i, 1, Length[f]}]; 
       monomials = Table[FromCoefficientRules[{monomialrules[[i]][[j]] -> 1}, 
          coeffs], {i, 1, Length[f]}, {j, 1, Length[monomialrules[[i]]]}]; ]; 
     eqns2 = Table[Simplify[eqns[[j]][[i]] == 0, Assumptions -> 
         OptionValue["Assumptions"]], {j, 1, Length[eqns]}, 
       {i, 1, Length[eqns[[j]]]}]; If[OptionValue["SuppressArgs"], 
      {Length[DeleteDuplicates[Flatten[eqns2]]], DeleteDuplicates[
          Flatten[eqns2]], monomials, eqns2} /. Subscript[a_, l__] :> 
         Subscript[a, Times @@ (var[[1]]^l)] /. Derivative[l__][a_][l2__] :> 
        Subscript[a, Times @@ ({l2}^{l})], 
      {Length[DeleteDuplicates[Flatten[eqns2]]], DeleteDuplicates[
        Flatten[eqns2]], monomials, eqns2}]]; 
FindEquations[Delta_, var_, Q_, solvefor_, terms_, OptionsPattern[]] := 
   Module[{numeqns, eqns, eqns4, eqns3, monomialrules, monomials, monomialterms, 
     crules, part}, {numeqns, monomials, eqns} = 
      FindAllEquations[Delta, var, Q, solvefor, "Adjoint" -> 
         OptionValue["Adjoint"], "extras" -> OptionValue["extras"], 
        "excluded" -> OptionValue["excluded"], "Assumptions" -> 
         OptionValue["Assumptions"], "SuppressArgs" -> 
         OptionValue["SuppressArgs"]][[{1, 3, 4}]]; 
     part[i_] := Flatten[Position[Length /@ CoefficientRules /@ 
          Expand /@ Numerator /@ Together /@ (First /@ eqns[[i]] - 
              Last /@ eqns[[i]]), terms]]; monomialterms = 
      Table[monomials[[i]][[part[i]]], {i, 1, Length[monomials]}]; 
     eqns4 = Table[eqns[[i]][[part[i]]], {i, 1, Length[eqns]}]; 
     eqns3 = DeleteDuplicates[Flatten[eqns4]]; {numeqns, eqns3, 
      Table[Inner[List, First /@ Position[eqns4, eqns3[[i]]], 
        Extract[monomialterms, Position[eqns4, eqns3[[i]]]], List], 
       {i, 1, Length[eqns3]}]}]; 
End[]
EndPackage[]
